/*# ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la Sant�)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */

#include "comboBox.h"

namespace creaButtonContainer
{
	namespace view
	{
		// ----------------------------------------------------------------------------------

	ComboBox::ComboBox(wxWindow* parent, wxWindowID id, ItemsVector iVector,
				TFunctor* functor)
				: wxPanel(parent, id)
		{

			this->m_Functor = functor;

			wxBoxSizer* sizer = new wxBoxSizer(wxHORIZONTAL);

			this->SetSizer(sizer);

			this->m_ComboBox = new wxComboBox(this, -1);
			this->m_FunctorEnabled = true;

			this->Connect(wxEVT_COMMAND_COMBOBOX_SELECTED,
					wxCommandEventHandler(ComboBox::OnComboBoxEvent));

			if (!iVector.empty())
			{
				for (ItemsVector::iterator it = iVector.begin(); it != iVector.end();
						++it)
				{
					std::string key = it->first;
					this->m_ComboBox->Append(wxString(key.c_str(), wxConvUTF8));
				}
			}

			sizer->Add(this->m_ComboBox, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL);

		}
		// ----------------------------------------------------------------------------------

	ComboBox::ComboBox(wxWindow* parent, wxWindowID id, TFunctor* functor)
				: wxPanel(parent, id)
		{
			this->m_Functor = functor;

			wxBoxSizer* sizer = new wxBoxSizer(wxHORIZONTAL);

			this->SetSizer(sizer);

			this->m_ComboBox = new wxComboBox(this, -1);
			this->m_FunctorEnabled = true;

			this->Connect(wxEVT_COMMAND_COMBOBOX_SELECTED,
					wxCommandEventHandler(ComboBox::OnComboBoxEvent));

			sizer->Add(this->m_ComboBox, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL);

		}
		// ----------------------------------------------------------------------------------

	ComboBox::~ComboBox()
		{

		}

		// ----------------------------------------------------------------------------------

		void ComboBox::OnComboBoxEvent(wxCommandEvent& event)
		{
			if (!this->IsFunctorEnabled())
				return;
			else
			{
				try
				{
					std::cout << "MLER | ComboBox::OnComboBoxEvent( wxCommandEvent& event )"
							<< std::endl;

					int iSelection;
					iSelection = this->m_ComboBox->GetSelection();

					wxString itemNom = this->m_ComboBox->GetString(iSelection);
					std::string itemNomC = std::string(itemNom.mb_str());

					this->m_Functor->Call(itemNomC);

				} //yrt
				catch (const std::exception& e)
				{
					std::cerr
							<< "ButtonContainerController::OnComboBoxEvent( wxCommandEvent& event ) exception: "
							<< e.what() << std::endl;
				} //hctac
			}
		}
		// ----------------------------------------------------------------------------------

		void ComboBox::SetFunctorEnabled(const bool& enabled)
		{
			this->m_FunctorEnabled = enabled;
		}
		// ----------------------------------------------------------------------------------
		bool ComboBox::IsFunctorEnabled() const
		{
			return this->m_FunctorEnabled;
		}

		// ----------------------------------------------------------------------------------
		wxComboBox*
		ComboBox::GetComboBox() const
		{
			return this->m_ComboBox;
		}

	} //ecapseman
} //ecapseman

