/*# ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la Sant�)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */

/*!
 * @file listWx.h
 * @brief This contains the ListWx class.
 * @author Monica ESPINOSA (espinosa[AT]creatis.insa-lyon.fr)
 * @date  2015-01-02
 */

#ifndef COMBOBOX_H
#define COMBOBOX_H

//#include <wx/bmpbuttn.h>
#include <wx/panel.h>
#include <wx/string.h>
#include <wx/combobox.h>
#include <wx/wx.h>
#include <wx/event.h>

#include <string>
#include <vector>
#include <utility>

#include "functor.h"
#include "system.h"

/*!	@namespace <creaButtonContainer>
 *	@brief Contains the creaButtonContainer library included in creaMaracasVisu.
 */
namespace creaButtonContainer
{
	/*! @namespace <creaButtonContainer::view>
	 *	@brief Contains the implementation of the view in creaButtonContainer library.
	 *	@see <a href="http://en.wikipedia.org/wiki/Model-view-controller">MVC Software Architecture</a>
	 */
	namespace view
	{
		/*! @class ListWx listWx.h "listWx.h"
		 *	@brief This class contains the list in the panel.
		 *  @details This class contains the information of a list, it derives from wxPanel.
		 *  @see <a href="http://docs.wxwidgets.org/stable/wx_wxpanel.html">wxPanel</a>
		 */
		class ComboBox: public wxPanel
		{
			public:
				//typedef definition.
				// ----------------------------------------------------------------------------------
				/*!	typedef creaButtonContainer::model::TFunctor TFunctor;
				 *	@brief Defines the TFunctor type.
				 */
				typedef creaButtonContainer::model::TFunctor TFunctor;
				// ----------------------------------------------------------------------------------
				/*!	@typedef std::pair<std::string, wxPanel*> ListAction;
				 *	@brief Defines the ListAction type.
				 *	First is the button name(item list), Second FunctionEventType
				 */
				typedef std::pair<std::string, wxPanel*> ListAction;
				// ----------------------------------------------------------------------------------
				/*!	@typedef std::vector<ListAction> ItemsVector;
				 *	@brief Defines the Items Vector type.
				 */
				typedef std::vector<ListAction> ItemsVector;
				// ----------------------------------------------------------------------------------
				//end of typedef definition.

			public:
				// ----------------------------------------------------------------------------------
				/*! @fn ListWx( wxWindow* parent, wxWindowID id, ItemsVector iVector,
				 TFunctor* functor );
				 *	@brief This is the parameterized constructor.
				 * 	@param parent The wxWindow pointer to parent.
				 * 	@param id The wxID of the button.
				 * 	@param ItemsVector //The items Vector (name, wxPanel).
				 * 	@param TFunctor //The functor of items list.
				 */
				ComboBox(wxWindow* parent, wxWindowID id, ItemsVector iVector,
						TFunctor* functor);
				// ----------------------------------------------------------------------------------
				/*! @fn ListWx( wxWindow* parent, wxWindowID id, TFunctor* functor );
				 *	@brief This is the parameterized constructor.
				 * 	@param parent The wxWindow pointer to parent.
				 * 	@param id The wxID of the button.
				 * 	@param TFunctor //The functor of items list.
				 */
				ComboBox(wxWindow* parent, wxWindowID id, TFunctor* functor);
				// ----------------------------------------------------------------------------------
				/*! @fn virtual ~Button( );
				 *	@brief This is the destructor.
				 */
				virtual
				~ComboBox();
				// ----------------------------------------------------------------------------------
				/*! @fn void OnListEvent( wxCommandEvent& event );
				 *  @brief This method calls the functor when
				 *  an item of list is clicked.
				 * 	@param event
				 */
				void
				OnComboBoxEvent(wxCommandEvent& event);
				// ----------------------------------------------------------------------------------
				/*! @fn void SetFunctorEnabled( wxCommandEvent& event );
				 *  @brief This method set the state of Functor (enable or disable)
				 * 	@param enabled
				 */
				void
				SetFunctorEnabled(const bool& enabled);
				// ----------------------------------------------------------------------------------
				/*! @fn bool OnListEvent( wxCommandEvent& event );
				 *  @brief This method ask the state of functor.
				 * 	@return
				 */
				bool
				IsFunctorEnabled() const;
				// ----------------------------------------------------------------------------------
				/*! @fn wxListBox* GetListBox() const;
				 * 	@brief This method returns the wxlistBox.
				 * 	@exception std::bad_alloc
				 * 	@return wxListBox
				 */
				wxComboBox*
				GetComboBox() const;
				// ----------------------------------------------------------------------------------

			private:

				wxComboBox* m_ComboBox;				//!< This is the Items List.
				TFunctor* m_Functor;				//!< This is the functor.
				bool m_FunctorEnabled;				//!< Disable or Enable Functor.

		};
	} //ecapseman
} //ecapseman

#endif // COMBOBOX_H
