/*# ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la Sant�)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */

/*!
 * @file groupManager.cxx
 * @brief Implements the GroupManager class.
 * @author Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date  2011-06-02
 */

#include "groupManager.h"

namespace creaButtonContainer
{
	namespace view
	{
		// ----------------------------------------------------------------------------------
		GroupManager::GroupManager(wxWindow* parent, ButtonGroup* buttonGroup)
				: wxFlexGridSizer(1, 0, 0, 0)
		{
//EED 20/01/2012  flag 02			
			this->m_IDExpButton = wxNewId();
			this->m_ExpansionButton = new ExpansionButton(parent, this->m_IDExpButton,
					_("-"), wxDefaultPosition, wxSize(20, 20), 0, wxDefaultValidator,
					_T("EXPBUTTON"));
			this->Add(m_ExpansionButton, 1, wxALL | wxALIGN_LEFT | wxALIGN_TOP, 5);
			this->m_ButtonManager = new ButtonManager(buttonGroup);
			this->Add(this->m_ButtonManager, 1, wxALL | wxALIGN_LEFT | wxALIGN_TOP,
					5);
		}

		// ----------------------------------------------------------------------------------
		GroupManager::~GroupManager()
		{
		}

		// ----------------------------------------------------------------------------------
		long GroupManager::GetButtonID()
		{
			return (this->m_IDExpButton);
		}

		// ----------------------------------------------------------------------------------
		GroupManager::ExpansionButton*
		GroupManager::GetButton()
		{
			return (this->m_ExpansionButton);
		}

		// ----------------------------------------------------------------------------------
		ButtonManager*
		GroupManager::GetButtonManager()
		{
			return (this->m_ButtonManager);
		}

		// ----------------------------------------------------------------------------------
		void GroupManager::SetButtonID(long id)
		{
			this->m_IDExpButton = id;
		}

		// ----------------------------------------------------------------------------------
		void GroupManager::SetButton(ExpansionButton* button)
		{
			this->m_ExpansionButton = button;
		}

		// ----------------------------------------------------------------------------------
		void GroupManager::SetButtonManager(ButtonManager* container)
		{
			this->m_ButtonManager = container;
		}

		// ----------------------------------------------------------------------------------
		void GroupManager::HideSubPanel(bool hide)
		{
			if (hide == true)
			{
				this->m_ButtonManager->HideButtonManager();
			} //fi
			else
			{
				this->m_ButtonManager->ShowButtonManager();
			} //esle
		}
	// ----------------------------------------------------------------------------------
	}//ecapseman
} //ecapseman
