/*# ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la Sant�)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */

#include "listConfigDialog.h"

namespace creaButtonContainer
{

	namespace view
	{
		ListConfigDialog::ListConfigDialog(wxWindow* parent, wxWindowID id,
				const wxString& title, ListWx* modelList, ListWx* currentList) :
				wxDialog(parent, id, title, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE|wxRESIZE_BORDER|wxFULL_REPAINT_ON_RESIZE)
		{
			this->m_OriginalListWx = modelList;
			this->m_OriginalListWx->Reparent(this);
			this->m_OriginalListWx->Show(true);
			this->m_OriginalListWx->SetFunctorEnabled(false);

			this->m_CurrentListWx = currentList;
			this->m_CurrentListWx->Reparent(this);
			this->m_CurrentListWx->SetFunctorEnabled(false);
			this->m_CurrentListWx->Show(true);
			this->m_LastStatus = this->m_CurrentListWx->GetListBox()->GetStrings();

			wxGridBagSizer* dialogSizer = new wxGridBagSizer(0, 0);
			dialogSizer->AddGrowableCol(0);
			dialogSizer->AddGrowableRow(0);

			//Top Sizer
			wxGridBagSizer* topSizer = new wxGridBagSizer(0, 0);
			topSizer->AddGrowableCol(0);
			topSizer->AddGrowableCol(2);
			topSizer->AddGrowableRow(0);
			topSizer->Add(this->m_OriginalListWx, wxGBPosition(0, 0), wxDefaultSpan,
					wxALL | wxEXPAND | wxALIGN_CENTER_HORIZONTAL
							| wxALIGN_CENTER_VERTICAL, 5);
			wxBoxSizer* boxSizer1 = new wxBoxSizer(wxVERTICAL);

			wxBitmap AddIcon(ArrowNextG_xpm); //Icon of button

			this->m_AddButton = new wxBitmapButton(this, 1, AddIcon,
					wxDefaultPosition, wxDefaultSize, wxBU_AUTODRAW, wxDefaultValidator,
					_T(">"));

			boxSizer1->Add(this->m_AddButton, 1,
					wxALL | wxALIGN_CENTER_HORIZONTAL | wxALIGN_CENTER_VERTICAL, 5);

			wxBitmap DeleteIcon(ArrowBackG_xpm); //Icon of button

			this->m_RemoveButton = new wxBitmapButton(this, 2, DeleteIcon,
					wxDefaultPosition, wxDefaultSize, wxBU_AUTODRAW, wxDefaultValidator,
					_T("<"));
			boxSizer1->Add(this->m_RemoveButton, 1,
					wxALL | wxALIGN_CENTER_HORIZONTAL | wxALIGN_CENTER_VERTICAL, 5);
			topSizer->Add(boxSizer1, wxGBPosition(0, 1), wxDefaultSpan,
					wxALL | wxALIGN_CENTER_HORIZONTAL | wxALIGN_CENTER_VERTICAL, 5);

			topSizer->Add(this->m_CurrentListWx, wxGBPosition(0, 2), wxDefaultSpan,
					wxALL | wxEXPAND | wxALIGN_CENTER_HORIZONTAL
							| wxALIGN_CENTER_VERTICAL, 5);
			wxBoxSizer* boxSizer2 = new wxBoxSizer(wxVERTICAL);

			wxBitmap TopIcon(ArrowTopG_xpm); //Icon of button

			this->m_UpButton = new wxBitmapButton(this, 3, TopIcon,
					wxDefaultPosition, wxDefaultSize, wxBU_AUTODRAW, wxDefaultValidator,
					_T("+"));
			boxSizer2->Add(this->m_UpButton, 1,
					wxALL | wxALIGN_CENTER_HORIZONTAL | wxALIGN_CENTER_VERTICAL, 5);


			wxBitmap DownIcon(ArrowDownG_xpm); //Icon of button

			this->m_DownButton = new wxBitmapButton(this, 4, DownIcon,
					wxDefaultPosition, wxDefaultSize, wxBU_AUTODRAW, wxDefaultValidator,
					_T("-"));
			boxSizer2->Add(this->m_DownButton, 1,
					wxALL | wxALIGN_CENTER_HORIZONTAL | wxALIGN_CENTER_VERTICAL, 5);
			topSizer->Add(boxSizer2, wxGBPosition(0, 3), wxDefaultSpan,
					wxALL | wxALIGN_CENTER_HORIZONTAL | wxALIGN_CENTER_VERTICAL, 5);
			dialogSizer->Add(topSizer, wxGBPosition(0, 0), wxDefaultSpan,
					wxALL | wxEXPAND | wxALIGN_CENTER_HORIZONTAL
							| wxALIGN_CENTER_VERTICAL, 5);

			//Bottom Sizer

			wxBoxSizer* bottomSizer = new wxBoxSizer(wxHORIZONTAL);
			bottomSizer->Add(0, 0, 1,
					wxALL | wxALIGN_CENTER_HORIZONTAL | wxALIGN_CENTER_VERTICAL, 5);
			this->m_CancelButton = new wxButton(this, 5, _("Cancel"),
					wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator,
					_T("Cancel"));
			bottomSizer->Add(this->m_CancelButton, 1,
					wxALL | wxALIGN_CENTER_HORIZONTAL | wxALIGN_CENTER_VERTICAL, 5);
			this->m_OkButton = new wxButton(this, 6, _("Ok"), wxDefaultPosition,
					wxDefaultSize, 0, wxDefaultValidator, _T("Ok"));
			bottomSizer->Add(this->m_OkButton, 1,
					wxALL | wxALIGN_CENTER_HORIZONTAL | wxALIGN_CENTER_VERTICAL, 5);
			bottomSizer->Add(0, 0, 1,
					wxALL | wxALIGN_CENTER_HORIZONTAL | wxALIGN_CENTER_VERTICAL, 5);
			dialogSizer->Add(bottomSizer, wxGBPosition(1, 0), wxDefaultSpan,
					wxALL | wxALIGN_CENTER_HORIZONTAL | wxALIGN_CENTER_VERTICAL, 5);
			this->SetSizer(dialogSizer);
			dialogSizer->Fit(this);
			dialogSizer->SetSizeHints(this);


			//---------------------------------------------------------------------------------------------
			// Events
			//Add
			Connect(1, wxEVT_COMMAND_BUTTON_CLICKED,
					(wxObjectEventFunction) &ListConfigDialog::OnAdd);

			//Remove
			Connect(2, wxEVT_COMMAND_BUTTON_CLICKED,
					(wxObjectEventFunction) &ListConfigDialog::OnDelete);

			//Up
			Connect(3, wxEVT_COMMAND_BUTTON_CLICKED,
					(wxObjectEventFunction) &ListConfigDialog::OnMoveUp);

			//Down
			Connect(4, wxEVT_COMMAND_BUTTON_CLICKED,
					(wxObjectEventFunction) &ListConfigDialog::OnMoveDown);

			//Cancel
			Connect(5, wxEVT_COMMAND_BUTTON_CLICKED,
					(wxObjectEventFunction) &ListConfigDialog::OnCancel);

			//Ok
			Connect(6, wxEVT_COMMAND_BUTTON_CLICKED,
					(wxObjectEventFunction) &ListConfigDialog::OnOk);

		}

		ListConfigDialog::~ListConfigDialog()
		{

		}

		void ListConfigDialog::OnAdd(wxCommandEvent& event)
		{
			wxString itSelect = m_OriginalListWx->GetListBox()->GetStringSelection();
			std::cout << "Count = " << this->m_CurrentListWx->GetListBox()->GetCount()
					<< std::endl;
			if (!itSelect.IsEmpty())
			{
				int v = this->m_CurrentListWx->GetListBox()->FindString(itSelect);
				if (v == -1)
				{
					this->m_CurrentListWx->GetListBox()->Append(itSelect);
					this->m_CurrentListWx->GetListBox()->Update();
				}
			}

		}
		void ListConfigDialog::OnDelete(wxCommandEvent& event)
		{
			wxString itSelect = m_CurrentListWx->GetListBox()->GetStringSelection();

			if (!itSelect.IsEmpty())
			{
				int v = this->m_CurrentListWx->GetListBox()->FindString(itSelect);
				if (v != -1)
				{
					this->m_CurrentListWx->GetListBox()->Delete(v);
					this->m_CurrentListWx->GetListBox()->Update();
				}
			}
		}
		void ListConfigDialog::OnMoveUp(wxCommandEvent& event)
		{
			wxString itSelect = m_CurrentListWx->GetListBox()->GetStringSelection();

			if (!itSelect.IsEmpty())
			{
				int v = this->m_CurrentListWx->GetListBox()->FindString(itSelect);
				if (v > 0)
				{
					this->m_CurrentListWx->GetListBox()->Delete(v);
					this->m_CurrentListWx->GetListBox()->Insert(itSelect, v - 1);
					this->m_CurrentListWx->GetListBox()->Update();
				}
			}

		}
		void ListConfigDialog::OnMoveDown(wxCommandEvent& event)
		{
			wxString itSelect = m_CurrentListWx->GetListBox()->GetStringSelection();

			if (!itSelect.IsEmpty())
			{
				int v = this->m_CurrentListWx->GetListBox()->FindString(itSelect);
				std::cout << "Count = "
						<< this->m_CurrentListWx->GetListBox()->GetCount() << std::endl;
				if ((v < this->m_CurrentListWx->GetListBox()->GetCount() - 1)
						&& (v != -1))
				{
					this->m_CurrentListWx->GetListBox()->Delete(v);
					this->m_CurrentListWx->GetListBox()->Insert(itSelect, v + 1);
					this->m_CurrentListWx->GetListBox()->Update();
				}
			}

		}
		void ListConfigDialog::OnOk(wxCommandEvent& event)
		{

			this->EndModal(1);
		}
		void ListConfigDialog::OnCancel(wxCommandEvent& event)
		{

			this->m_CurrentListWx->GetListBox()->Clear();
			this->m_CurrentListWx->GetListBox()->Append(this->m_LastStatus);
			this->Close();
		}
	}
}
