/*# ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la Sant�)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */

/*!
 * @file buttonContainerSettings.cxx
 * @brief Implements the ButtonContainerSettings class.
 * @author Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date  2011-06-02
 */

#include "buttonContainerSettings.h"

namespace creaPanelButtonContainer
{
	// ----------------------------------------------------------------------------------
	ButtonContainerSettings::ButtonContainerSettings()
	{

	}
	// ----------------------------------------------------------------------------------
	ButtonContainerSettings::~ButtonContainerSettings()
	{
	}

	// ----------------------------------------------------------------------------------
	ButtonContainerSettings::ButtonGroupMap ButtonContainerSettings::GetButtonGroupContainer()
	{
		return m_ButtonGroupContainer;
	}
	// ----------------------------------------------------------------------------------
	ButtonContainerSettings::KeyMapList ButtonContainerSettings::GetGroupNameList()
	{
		return m_GroupNameList;
	}
	// ----------------------------------------------------------------------------------
	//GetButtonPanel returns the panel associated to the buttonAction
	ButtonContainerSettings::PanelButton ButtonContainerSettings::GetPanelButton(
			const StringType &buttonName)
	{
		try
		{
			for (KeyMapList::iterator it = this->m_GroupNameList.begin();
					it != this->m_GroupNameList.end(); ++it)
			{
				ButtonList list = this->m_ButtonGroupContainer[(*it)];
				for (ButtonList::iterator it1 = list.begin(); it1 != list.end(); ++it1)
				{
					if ((*it1)->first->first.compare(buttonName) == 0)
						return ((*it1)->second->second);
				}	//rof
			}	//rof
		}	//yrt
		catch (std::exception& e)
		{
			std::cerr
					<< "ButtonContainerSettings::GetPanelButton( const StringType &buttonName ) "
					<< "exception: " << e.what() << std::endl;
		}	//hctac
		return (NULL);
	}

	// ----------------------------------------------------------------------------------
	ButtonContainerSettings::ButtonGroupSettings*
	ButtonContainerSettings::GetButtonGroupSettings(TFunctor* functor)
	{
		ButtonGroupSettings* settings = NULL;
		try
		{

			settings = new ButtonGroupSettings();

			for (KeyMapList::iterator it = this->m_GroupNameList.begin();
					it != this->m_GroupNameList.end(); ++it)
			{
				ButtonList list = this->m_ButtonGroupContainer[(*it)];

				for (ButtonList::iterator it1 = list.begin(); it1 != list.end(); ++it1)
				{

					settings->AddButton((*it), (*it1)->first->first,
							(*it1)->first->second, (*it1)->second->first, functor);
				}	//rof
			}	//rof
		}	//yrt
		catch (std::exception& e)
		{
			std::cerr
					<< "ButtonContainerSettings::GetPanelButton( const StringType &buttonName ) "
					<< "exception: " << e.what() << std::endl;
		}	//hctac
		return (settings);
	}
	// ----------------------------------------------------------------------------------
	void ButtonContainerSettings::SetButtonGroupContainer(
			ButtonGroupMap m_ButtonGroupContainer)
	{
		this->m_ButtonGroupContainer = m_ButtonGroupContainer;
	}
	// ----------------------------------------------------------------------------------
	void ButtonContainerSettings::SetGroupNameList(KeyMapList m_GroupNameList)
	{
		this->m_GroupNameList = m_GroupNameList;
	}

	// ----------------------------------------------------------------------------------
	void ButtonContainerSettings::AddButton(const StringType & groupName,
			const StringType &buttonName, const wxBitmap &icon,
			const StringType &buttonDescription, PanelButton panel)
	{
		try
		{
			//builds the button information
			//I don't know the try catch doesn't work!!
			if (panel == NULL)
			{
				std::cerr << "ButtonContainerSettings::AddButton"
						<< "exception: NULL Pointer in panel " << std::endl;
				exit(1);
			}

			panel->Show(false);

			ButtonPair* pair = new ButtonPair(new ButtonInfo(buttonName, icon),
					new ActionButton(buttonDescription, panel));

			for (KeyMapList::iterator it = this->m_GroupNameList.begin();
					it != this->m_GroupNameList.end(); ++it)
			{
				if ((*it).compare(groupName) == 0)
				{
					this->m_ButtonGroupContainer[groupName].push_back(pair);
					return;
				}			//fi
			}			//rof
			this->m_GroupNameList.push_back(groupName);
			this->m_ButtonGroupContainer[groupName].push_back(pair);
		}			//yrt
		catch (const std::exception& e)
		{
			std::cerr
					<< "ButtonContainerSettings::AddButton( const StringType & groupName,"
					<< "const StringType &buttonName, const StringType &iconpath,"
					<< "const StringType &buttonDescription, PanelButton panel ) "
					<< "exception: " << e.what() << std::endl;
		}			//hctac
	}

	// ----------------------------------------------------------------------------------
	void ButtonContainerSettings::AddButton(BCPSettingsStruct* info)
	{
		try
		{
			//builds the button information
			//I don't know the try catch doesn't work!!
			if (info->panel == NULL)
			{
				std::cerr << "ButtonContainerSettings::AddButton"
						<< "exception: NULL Pointer in panel " << std::endl;
				exit(1);
			}
			info->panel->Show(false);
			ButtonPair* pair = new ButtonPair(
					new ButtonInfo(info->buttonName, info->icon),
					new ActionButton(info->buttonDescription, info->panel));
			for (KeyMapList::iterator it = this->m_GroupNameList.begin();
					it != this->m_GroupNameList.end(); ++it)
			{
				if ((*it).compare(info->groupName) == 0)
				{
					this->m_ButtonGroupContainer[info->groupName].push_back(pair);
					return;
				}			//fi
			}			//rof
			this->m_GroupNameList.push_back(info->groupName);
			this->m_ButtonGroupContainer[info->groupName].push_back(pair);
		}			//yrt
		catch (const std::exception& e)
		{
			std::cerr
					<< "ButtonContainerSettings::AddButton( BCPSettingsStruct* info )"
					<< "exception: " << e.what() << std::endl;
			exit(1);
		}			//hctac
	}

	// ----------------------------------------------------------------------------------
	void ButtonContainerSettings::InitModel(BCStructVectorType infoList, int type)
	{
		try
		{
			for (BCStructVectorType::iterator it = infoList.begin();
					it != infoList.end(); ++it)
			{
				if (type == 0)
					this->AddButton(*it);
				else if (type == 1 || type == 2 || type == 3)
					this->AddItems(*it);


			}					//rof
		}					//yrt
		catch (std::exception& e)
		{
			std::cerr
					<< "ButtonContainerSettings::AddButtons( BCStructVectorType infoList )"
					<< "exception: " << e.what() << std::endl;
		}					//hctac
	}

	// ----------------------------------------------------------------------------------
	//MLER
	void ButtonContainerSettings::AddItems(BCPSettingsStruct* info)
	{
		try
		{
			//build the button information
			//I don't know the try catch doesn't work!!
			if (info->panel == NULL)
			{
				std::cerr << "ButtonContainerSettings::AddItems"
						<< "exception: NULL Pointer in panel " << std::endl;
				exit(1);
			}
			info->panel->Show(false);
			std::string key = info->groupName + ":" + info->buttonName;
			m_ItemsVector.push_back(ListAction(key, info->panel));

		}					//yrt
		catch (const std::exception& e)
		{
			std::cerr
					<< "ButtonContainerSettings::AddButton( BCPSettingsStruct* info )"
					<< "exception: " << e.what() << std::endl;
			exit(1);
		}					//hctac
	}
	// ----------------------------------------------------------------------------------
	ButtonContainerSettings::ItemsVector ButtonContainerSettings::GetItemsVector()
	{
		return this->m_ItemsVector;
	}

	// ----------------------------------------------------------------------------------
	wxPanel*
	ButtonContainerSettings::GetPanelList(const StringType &buttonName)
	{
		try
		{
			for (ItemsVector::iterator it = this->m_ItemsVector.begin();
					it != this->m_ItemsVector.end(); ++it)
			{
				if ((*it).first.compare(buttonName) == 0)
					return ((*it).second);

			}

		} catch (std::exception& e)
		{
			std::cerr
					<< "ButtonContainerSettings::GetPanelButton( const StringType &buttonName ) "
					<< "exception: " << e.what() << std::endl;
		}					//hctac
		return (NULL);

	}

//MLER
// ----------------------------------------------------------------------------------
}//ecapseman
