/*# ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la Sant�)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */

/*!
 * @file creaPanelButtonContainer.h
 * @brief implements PanelButtonContainer class
 * @author Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date  2011-06-02
 */

#include "creaPanelButtonContainer.h"

namespace creaPanelButtonContainer
{
	BEGIN_EVENT_TABLE(PanelButtonContainer,wxPanel)
//EVT_LIST_ITEM_SELECTED(-1, ListWx::ListEvent)

//(*EventTable(ButtonContainerPanel)
//*)
	END_EVENT_TABLE ()
// ----------------------------------------------------------------------------------
	typedef creaButtonContainer::model::TConcreteFunctor<PanelButtonContainer> TConcreteFunctor;
// ----------------------------------------------------------------------------------
	PanelButtonContainer::PanelButtonContainer(wxWindow* parent,
			ButtonContainerSettings* bcSettings, int type)
			: wxPanel(parent, -1, wxDefaultPosition, wxDefaultSize,
					wxDEFAULT_FRAME_STYLE, _T("creaPanelButtonContainer"))
	{
		this->m_ButtonContainerSettings = bcSettings;

		//Using AuiManager to Manage the Panels
		this->m_AuiManager = new wxAuiManager(this,
				wxAUI_MGR_DEFAULT | wxFULL_REPAINT_ON_RESIZE);

		if (type == 0)
		{
			//Class that manages the event!!!
			//EED 20/01/2012
			TConcreteFunctor* functor = new TConcreteFunctor(this,
					&PanelButtonContainer::GenericButtonEvent);
			//end of the event definition
			this->m_EventPanel = new wxPanel(this);
			this->m_ButtonContainerPanel = new ButtonContainerPanel(this,
					this->m_ButtonContainerSettings->GetButtonGroupSettings(functor));
			//Bottom Panel
			this->m_AuiManager->AddPane(this->m_EventPanel,
					wxAuiPaneInfo().Name(_T("EventPanel")).Caption(_("EventPanel")).CaptionVisible(
							true).MinimizeButton().MaximizeButton().CloseButton(false).Center().Resizable(
							true));
			//Top Panel
			this->m_AuiManager->AddPane(this->m_ButtonContainerPanel,
					wxAuiPaneInfo().Name(_T("ButtonContainerPanel")).DefaultPane().Caption(
							_("ButtonContainerPanel")).PinButton().CaptionVisible(true).CloseButton(
							false).Center().Resizable(true));
		}
		else if (type == 1)
		{
			//MLER
			TConcreteFunctor* lFunctor = new TConcreteFunctor(this,
					&PanelButtonContainer::GenericListEvent);

			this->m_EventPanel = new wxPanel(this);
			std::cout << "tipo 1; new LIstWx" << std::endl;

			this->m_ListWxPanel = new ListWx(this, -1,
					this->m_ButtonContainerSettings->GetItemsVector(), lFunctor);

			//Bottom Panel
			this->m_AuiManager->AddPane(this->m_EventPanel,
					wxAuiPaneInfo().Name(_T("EventPanel")).Caption(_("EventPanel")).CaptionVisible(
							true).MinimizeButton().MaximizeButton().CloseButton(false).Center().Resizable(
							true));
			//Top Panel
			this->m_AuiManager->AddPane(this->m_ListWxPanel,
					wxAuiPaneInfo().Name(_T("ListContainerPanel")).DefaultPane().Caption(
							_("ListContainerPanel")).PinButton().CaptionVisible(true).CloseButton(
							false).Center().Resizable(true));
		}
		else if (type == 2)
		{
			TConcreteFunctor* lFunctor = new TConcreteFunctor(this,
					&PanelButtonContainer::GenericListEvent);

			this->m_EmptyPanel = new wxPanel(this);
			this->m_EventPanel = this->m_EmptyPanel;

			this->m_PanelUp = new wxPanel(this, -1, wxDefaultPosition, wxDefaultSize,
					wxTAB_TRAVERSAL, _T("ListConfigContainerPanel"));
			wxGridBagSizer* mainSizer = new wxGridBagSizer(0, 0);
			mainSizer->AddGrowableCol(1);
			mainSizer->AddGrowableRow(0);

			//=======
			//Original List
			this->m_ListWxPanel = new ListWx(this->m_PanelUp, -1,
					this->m_ButtonContainerSettings->GetItemsVector(), lFunctor);
			this->m_ListWxPanel->Show(false);
			//Configurable list
			this->m_CurrentWxPanel = new ListWx(this->m_PanelUp, -1, lFunctor);

			mainSizer->Add(this->m_ListWxPanel, wxGBPosition(0, 0), wxDefaultSpan,
					wxALL | wxEXPAND | wxALIGN_CENTER_HORIZONTAL
							| wxALIGN_CENTER_VERTICAL, 5);
			mainSizer->Add(this->m_CurrentWxPanel, wxGBPosition(0, 1), wxDefaultSpan,
					wxALL | wxEXPAND | wxALIGN_CENTER_HORIZONTAL
							| wxALIGN_CENTER_VERTICAL, 5);

			wxBitmap btmSettings(Settings_xpm); //Icon of Button

			this->m_ConfigButton = new wxBitmapButton(this->m_PanelUp, -1,
					btmSettings, wxDefaultPosition, wxDefaultSize, wxBU_AUTODRAW,
					wxDefaultValidator, _T("Config"));

			mainSizer->Add(this->m_ConfigButton, wxGBPosition(1, 2), wxDefaultSpan,
					wxALL | wxALIGN_CENTER_HORIZONTAL | wxALIGN_CENTER_VERTICAL, 5);

			//=======

			this->m_PanelUp->SetSizer(mainSizer);
			mainSizer->Fit(this->m_PanelUp);
			mainSizer->SetSizeHints(this->m_PanelUp);

			//Bottom Panel
			this->m_AuiManager->AddPane(this->m_EventPanel,
					wxAuiPaneInfo().Name(_T("EventPanel")).Caption(_("EventPanel")).CaptionVisible(
							true).MinimizeButton().MaximizeButton().CloseButton(false).Center().Resizable(
							true));
			//Top Panel
			this->m_AuiManager->AddPane(this->m_PanelUp,
					wxAuiPaneInfo().Name(_T("ListContainerPanel")).DefaultPane().Caption(
							_("ListContainerPanel")).PinButton().CaptionVisible(true).CloseButton(
							false).Center().Resizable(true));

			this->Connect(wxEVT_COMMAND_BUTTON_CLICKED,
					wxCommandEventHandler(PanelButtonContainer::OnConfigButton));

		}
		else if (type == 3)
		{
			//MLER
			TConcreteFunctor* lFunctor = new TConcreteFunctor(this,
			&PanelButtonContainer::GenericListEvent);

			this->m_EventPanel = new wxPanel(this);
			std::cout << "MLER Type 3; new ComboBox" << std::endl;

			this->m_ComboBoxPanel = new ComboBox(this, -1,
			this->m_ButtonContainerSettings->GetItemsVector(), lFunctor);

			//Bottom Panel
			this->m_AuiManager->AddPane(this->m_EventPanel,
				wxAuiPaneInfo().Name(_T("EventPanel")).Caption(_("EventPanel")).CaptionVisible(
				true).MinimizeButton().MaximizeButton().CloseButton(false).Center().Resizable(
				true));
			//Top Panel
			this->m_AuiManager->AddPane(this->m_ComboBoxPanel,
				wxAuiPaneInfo().Name(_T("ComboBoxContainerPanel")).DefaultPane().Caption(
				_("ComboBoxContainerPanel")).PinButton().CaptionVisible(true).CloseButton(
				false).Center().Resizable(true));
		}
		//End MLER

		this->m_AuiManager->Update();
	}
// ----------------------------------------------------------------------------------
	PanelButtonContainer::~PanelButtonContainer()
	{
	}
// ----------------------------------------------------------------------------------
	void PanelButtonContainer::UpdatePanel(const std::string &buttonName)
	{
		try
		{
			//Hiding the last CartoSettingsPanel
			this->m_EventPanel->Show(false);
			//Finding the CartoSettingsPanel of the ButtonClicket
			this->m_EventPanel = this->m_ButtonContainerSettings->GetPanelButton(
					buttonName);
			//changing the parent of the panel!
			if (this->m_EventPanel->GetParent() != this)
			{
				this->m_EventPanel->Reparent(this);
			}	//fi
				//Panel Management
			this->m_AuiManager->GetPane(_T("EventPanel")).window = this->m_EventPanel;
			//Updating the manager
			this->m_AuiManager->Update();
		}			//yrt
		catch (const std::exception& e)
		{
			std::cerr
					<< "PanelButtonContainer::UpdatePanel( const std::string &buttonName )"
					<< "exception: " << e.what() << std::endl;
			std::cout << "Maybe the panel of the button is NULL" << std::endl;
			exit(1);
		}			//hctac
	}
// ----------------------------------------------------------------------------------
	void PanelButtonContainer::GenericButtonEvent(const std::string &buttonName)
	{
		this->UpdatePanel(buttonName);
	}

	// ----------------------------------------------------------------------------------
	//MLER
	void PanelButtonContainer::GenericListEvent(const std::string &buttonName)
	{
		this->UpdateListPanel(buttonName);
	}

	// ----------------------------------------------------------------------------------
	void PanelButtonContainer::UpdateListPanel(const std::string &buttonName)
	{
		try
		{
			this->m_EventPanel->Show(false);
			this->m_EventPanel = this->m_ButtonContainerSettings->GetPanelList(
					buttonName);

			if (this->m_EventPanel->GetParent() != this)
			{
				this->m_EventPanel->Reparent(this);
			}	//fi
				//Panel Management
			this->m_AuiManager->GetPane(_T("EventPanel")).window = this->m_EventPanel;
			//Updating the manager
			this->m_AuiManager->Update();

		} catch (const std::exception& e)
		{
			std::cerr
					<< "PanelButtonContainer::UpdatePanel( const std::string &buttonName )"
					<< "exception: " << e.what() << std::endl;
			std::cout << "Maybe the panel of the list is NULL" << std::endl;
			exit(1);
		}							//hctac
	}

// ----------------------------------------------------------------------------------
	void PanelButtonContainer::OnConfigButton(wxCommandEvent& event)
	{

		this->m_ListConfigDialog = new ListConfigDialog(this, -1, _("Settings"),
				this->m_ListWxPanel, this->m_CurrentWxPanel);

		std::cout << "Button Event" << std::endl;

		this->m_EventPanel->Show(false);

		this->m_ListConfigDialog->ShowModal();							//Show Dialog
		this->m_CurrentWxPanel->Reparent(this->m_PanelUp);
		this->m_CurrentWxPanel->Show(true);
		this->m_CurrentWxPanel->SetFunctorEnabled(true);

		this->m_CurrentWxPanel->GetListBox()->Deselect(
				this->m_CurrentWxPanel->GetListBox()->GetSelection()); //Deselected item
		this->m_CurrentWxPanel->Update();
		this->m_ListWxPanel->Show(false);
		this->m_EventPanel->Show(false);
		this->m_EventPanel = this->m_EmptyPanel; //Management Empty Panel

		this->m_AuiManager->GetPane(_T("EventPanel")).window = this->m_EventPanel;
		this->m_AuiManager->Update();

	}
	//End MLER
// ----------------------------------------------------------------------------------

}//ecapseman

