/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#include "figureCuttingModel.h"

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
figureCuttingModel::figureCuttingModel()
{
	_inversModel	= vtkTransform::New();
	_matrixModel	= vtkTransform::New();
	_matrixVisual	= vtkTransform::New();

	_spcX=1;
	_spcY=1;
	_spcZ=1;
}
//----------------------------------------------------------------------------
figureCuttingModel::~figureCuttingModel() // virtual
{
	_inversModel->Delete();
}
//----------------------------------------------------------------------------
void figureCuttingModel::SetPosition(double x,double y, double z)
{
	_px=x;
	_py=y;
	_pz=z;
}
//----------------------------------------------------------------------------
void figureCuttingModel::SetScale(double sx,double sy, double sz)
{
	_sx=sx;
	_sy=sy;
	_sz=sz;
}
//----------------------------------------------------------------------------
void figureCuttingModel::SetRotation(double alfa,double beta, double teta)
{
	_alfa=alfa;
	_beta=beta;
	_teta=teta;
}

//----------------------------------------------------------------------------
void figureCuttingModel::CalculeMatrix()
{
	_matrixModel->Identity();
	_matrixModel->Translate(_px,_py,_pz);
	_matrixModel->RotateY(_beta);
	_matrixModel->RotateX(_alfa);
	_matrixModel->RotateY(_teta);
	_matrixModel->Scale(_sx,_sy,_sz);

	_matrixVisual->Identity();
	_matrixVisual->Translate( _px*_spcX  ,  _py*_spcY  ,  _pz*_spcZ  );
	_matrixVisual->RotateY(_beta);
	_matrixVisual->RotateX(_alfa);
	_matrixVisual->RotateY(_teta);
	_matrixVisual->Scale( _sx*_spcX  ,  _sy*_spcY  ,  _sz*_spcZ  );

}


//----------------------------------------------------------------------------
void figureCuttingModel::CalculeInversMatrix()
{
	_inversModel->Identity ();
	_inversModel->Concatenate ( _matrixModel );
	_inversModel->Inverse();
}
//----------------------------------------------------------------------------
bool figureCuttingModel::IfPointInside(double x, double y, double z) // virtual
{
	return true;
}

//----------------------------------------------------------------------------
vtkTransform *figureCuttingModel::GetVtkTransform()
{
	return _matrixVisual;
}

//----------------------------------------------------------------------------
//void figureCuttingModel::SetVtkTransform(vtkTransform *matrix)
//{
//	_matrixModel = matrix;
//}

//----------------------------------------------------------------------------
double figureCuttingModel::GetTheoricVolume() // virtual
{
	return 0;
}

//----------------------------------------------------------------------------
double figureCuttingModel::GetPositionX()
{
	return _px;
}
//----------------------------------------------------------------------------
double figureCuttingModel::GetPositionY()
{
	return _py;
}
//----------------------------------------------------------------------------
double figureCuttingModel::GetPositionZ()
{
	return _pz;
}
//----------------------------------------------------------------------------
double figureCuttingModel::GetScaleX()
{
	return _sx;
}
//----------------------------------------------------------------------------
double figureCuttingModel::GetScaleY()
{
	return _sy;
}
//----------------------------------------------------------------------------
double figureCuttingModel::GetScaleZ()
{
	return _sz;
}
//----------------------------------------------------------------------------
double figureCuttingModel::GetAngleAlfa()
{
	return _alfa;
}
//----------------------------------------------------------------------------
double figureCuttingModel::GetAngleBeta()
{
	return _beta;
}
//----------------------------------------------------------------------------
double figureCuttingModel::GetAngleTeta()
{
	return _teta;
}
//----------------------------------------------------------------------------
const char *figureCuttingModel::GetName() // virtual
{
	return "--";
}

//----------------------------------------------------------------------------
void figureCuttingModel::SetSpacing(double spcX,double spcY, double spcZ)
{
	_spcX = spcX;
	_spcY = spcY;
	_spcZ = spcZ;
}

