/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef FIGURECUTTINGMODEL_H_
#define FIGURECUTTINGMODEL_H_

#include "vtkTransform.h"

class figureCuttingModel
{
public:
	figureCuttingModel();
	virtual ~figureCuttingModel();

	void			SetPosition(double x,double y, double z);
	double			GetPositionX();
	double			GetPositionY();
	double			GetPositionZ();

	void			SetScale(double sx,double sy, double sz);
	double			GetScaleX();
	double			GetScaleY();
	double			GetScaleZ();

	void			SetRotation(double alfa,double beta, double teta);
	double			GetAngleAlfa();
	double			GetAngleBeta();
	double			GetAngleTeta();

	void			SetSpacing(double spcX,double spcY, double spcZ);

	void			CalculeMatrix();
	void			CalculeInversMatrix();
	virtual bool	IfPointInside(double x, double y, double z);
	vtkTransform	*GetVtkTransform();
//	void			SetVtkTransform(vtkTransform *matrix);
	virtual double	GetTheoricVolume();
	virtual			const char *GetName();

private:
	double			_px;
	double			_py;
	double			_pz;
	double			_alfa;
	double			_beta;
	double			_teta;
	double			_spcX;
	double			_spcY;
	double			_spcZ;
protected:
	double			_sx;
	double			_sy;
	double			_sz;
	vtkTransform	*_inversModel;
	vtkTransform	*_matrixModel;
	vtkTransform	*_matrixVisual;

};

#endif /*FIGURECUTTINGMODEL_H_*/
