/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "figureCuttingSphereModel.h"
#include <math.h>

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
figureCuttingSphereModel::figureCuttingSphereModel()
{
}
//----------------------------------------------------------------------------
figureCuttingSphereModel::~figureCuttingSphereModel() // virtual
{
}
//----------------------------------------------------------------------------
bool figureCuttingSphereModel::IfPointInside(double x, double y, double z) // virtual
{
	double in[4],out[4];
	in[0]=x;
	in[1]=y;
	in[2]=z;
	in[3]=1;
	_inversModel->MultiplyPoint (in, out);

	bool result=false;
	if (sqrt( out[0]*out[0] + out[1]*out[1] + out[2]*out[2] )<0.5 )
	{
		result=true;
	}
	return result;
}
//----------------------------------------------------------------------------
double figureCuttingSphereModel::GetTheoricVolume() // virtual
{
	double piTMP=3.14159265;
	return (4.0/3.0) * piTMP * (_sx/2)*(_sy/2)*(_sz/2);
}
//----------------------------------------------------------------------------
const char *figureCuttingSphereModel::GetName() // virtual
{
	return "Sphere";
}
