/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*!
 * @file	image3DDequeUR.cxx
 * @brief	This file contains the implementation of the Image3DDequeUR class.
 * @author 	Info-Dev
 * @author	Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date 	2011-11-15
 */

#include "image3DDequeUR.h"
#include <iostream>
#include <sstream>
#include <ctime>

// ----------------------------------------------------------------------------------
Image3DDequeUR::Image3DDequeUR( )
{
	const void * address = static_cast<const void*>(this);
	std::stringstream ss;
	ss << address;  
	m_PrivateID = ss.str(); 

#ifdef _WIN32
	this->m_GlobalPath = std::getenv("TEMP");
#endif
    
#ifdef _WIN64
	this->m_GlobalPath = std::getenv("TEMP");
#endif
    
#ifdef LINUX
	this->m_GlobalPath = "/tmp/";
#endif
    
#ifdef MACOSX
    this->m_GlobalPath = "/tmp/";
#endif
    
	this->m_CurrentURPos = -1;
}

// ----------------------------------------------------------------------------------
//virtual
Image3DDequeUR::~Image3DDequeUR( )
{
	this->CleanHardDisk( );
}

// ----------------------------------------------------------------------------------
//virtual
void Image3DDequeUR::AddImagesToURContainer( VTKImageDataPointerType imgUndo,
	VTKImageDataPointerType imgRedo, ImageMManager* imMManager )
{
	this->CleanURContainerFromIndex( this->m_CurrentURPos + 1 );
	//Adding image
	ImageInfoUR* imageInfo = new ImageInfoUR( );
	imageInfo->SetImageName( this->GetImageName( this->m_ImgURDeque.size( ) ) );
	imageInfo->SetImages( imgUndo, imgRedo );
	imageInfo->SetImageMManager( imMManager );
	
	//Adding to deque
	this->m_ImgURDeque.push_back( imageInfo );
	this->m_CurrentURPos = this->m_ImgURDeque.size( ) - 1;
	//Managing memory
	this->ManageMemory( );
}

// ----------------------------------------------------------------------------------
//virtual
ImageInfoUR* Image3DDequeUR::Undo( )
{
	ImageInfoUR* imgRet = NULL;
	int imgURDequeSize = this->m_ImgURDeque.size( );
	if( ( this->m_ImgURDeque.size( ) > 0 ) && ( this->m_CurrentURPos != -1 )
		&& ( this->m_CurrentURPos < imgURDequeSize ) )
	{
		imgRet = this->m_ImgURDeque[ m_CurrentURPos ];
		this->m_CurrentURPos--;
	} //fi
	return ( imgRet );
}

// ----------------------------------------------------------------------------------
//virtual
ImageInfoUR* Image3DDequeUR::Redo( )
{
	ImageInfoUR* imgRet = NULL;
	this->m_CurrentURPos++;
	int imgURDequeSize = this->m_ImgURDeque.size( );
	if( ( this->m_ImgURDeque.size( ) > 0 ) && ( this->m_CurrentURPos != -1 )
		&& ( this->m_CurrentURPos < imgURDequeSize ) )
	{
		imgRet = this->m_ImgURDeque[ m_CurrentURPos ];
	} else {
		this->m_CurrentURPos--;
	}
	return ( imgRet );
}

// ----------------------------------------------------------------------------------
//virtual
void Image3DDequeUR::CleanURContainerFromIndex( const int& index )
{
	int count = 0;
	for( unsigned int i = index; i < this->m_ImgURDeque.size( ); i++ )
	{
		this->m_ImgURDeque[ i ]->RemoveImagesFromMemory( this->m_GlobalPath );
		this->m_ImgURDeque[ i ]->RemoveImagesFromDisk( this->m_GlobalPath );
		count++;
	}
	for( int i = 0; i < count; i++ )
	{
		this->m_ImgURDeque.pop_back( );
	} //rof
}

// ----------------------------------------------------------------------------------
//virtual
void Image3DDequeUR::ManageMemory( )
{
	int imgURDequeSize = this->m_ImgURDeque.size( );
	int i;
	for( i = 0; i < imgURDequeSize; i++ )
	{
		if( this->m_ImgURDeque[ i ]->GetStatus( ) )
		{
			this->m_ImgURDeque[ i ]->RemoveImagesFromMemory( this->m_GlobalPath );
		} // if Status
	} // for i
	  //Adding CurrentUndoPos to memory
	if( ( this->m_CurrentURPos != -1 ) && !( this->m_ImgURDeque[ this->m_CurrentURPos ]->GetStatus( ) ) )
	{
		this->m_ImgURDeque[ this->m_CurrentURPos ]->LoadImagesToMemory( this->m_GlobalPath );
	}
    
    int currentRedoPos = this->m_CurrentURPos + 1;
    
	if( ( currentRedoPos < imgURDequeSize ) && !( this->m_ImgURDeque[ currentRedoPos ]->GetStatus( ) ) )
	{
		this->m_ImgURDeque[ currentRedoPos ]->LoadImagesToMemory( this->m_GlobalPath );
	}
}

// ----------------------------------------------------------------------------------
void Image3DDequeUR::SetGlobalPath( const StringType& globalPath )
{
	this->m_GlobalPath = globalPath;
}

// ----------------------------------------------------------------------------------
void Image3DDequeUR::CleanHardDisk( )
{
	for( unsigned int i = 0; i < this->m_ImgURDeque.size( ); i++ )
	{
		this->m_ImgURDeque[ i ]->RemoveImagesFromDisk( this->m_GlobalPath );
	}
}

// ----------------------------------------------------------------------------------
Image3DDequeUR::StringType Image3DDequeUR::GetGlobalPath( )
{
	return ( this->m_GlobalPath );
}

// ----------------------------------------------------------------------------------
Image3DDequeUR::StringType Image3DDequeUR::GetImageName( const int & pos )
{
//Giving a name to an image using the date and time
	if( this->m_IDImages.empty( ) )
	{
		time_t 		rawtime;
		struct tm 	*timeinfo;
		char 		buffer[ 80 ];
		time( &rawtime );
		timeinfo = localtime( &rawtime );
		strftime( buffer, 80, "%H%M%S_%a_%d_%b_%y_", timeinfo );
		StringType date( buffer );
		StringType aux( buffer );
		this->m_IDImages = "img_" + aux;
	}
	std::stringstream ss; //create a stringstream
	ss << pos; //add number to the stream
	StringType imageName = this->m_IDImages + ss.str( )+ "_"+m_PrivateID;
	return ( imageName );
}

// ----------------------------------------------------------------------------------
