/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*!
 * @file	imageInfoUR.cxx
 * @brief	This file contains the implementation of the ImageInfoUR class.
 * @author 	Info-Dev
 * @author	Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date 	2011-11-15
 */

#include "imageInfoUR.h"

// ----------------------------------------------------------------------------------
ImageInfoUR::ImageInfoUR() 
{
	this->m_OnMemory 	= false;
	this->m_OnDisk 		= false;
}

// ----------------------------------------------------------------------------------
ImageInfoUR::~ImageInfoUR() 
{
}

// ----------------------------------------------------------------------------------
void ImageInfoUR::SetImageName(const StringType &imgName) 
{
	this->m_ImageName 		= imgName;
}

// ----------------------------------------------------------------------------------
void ImageInfoUR::SetImageMManager(ImageMManagerType* imMManager) 
{
	this->m_ImageMManager 	= imMManager;
}

// ----------------------------------------------------------------------------------
void ImageInfoUR::SetStatus(const bool& onMemory) 
{
	this->m_OnMemory 		= onMemory;
}

// ----------------------------------------------------------------------------------
ImageInfoUR::StringType ImageInfoUR::GetImageName() 
{
	return (this->m_ImageName);
}

// ----------------------------------------------------------------------------------
ImageInfoUR::VTKImageDataPointerType ImageInfoUR::GetUndoImage() 
{
	return (this->m_UndoImage);
}

// ----------------------------------------------------------------------------------
ImageInfoUR::VTKImageDataPointerType ImageInfoUR::GetRedoImage() 
{
	return (this->m_RedoImage);
}

// ----------------------------------------------------------------------------------
ImageInfoUR::ImageMManagerType* ImageInfoUR::GetImageMManager() 
{
	return (this->m_ImageMManager);
}

// ----------------------------------------------------------------------------------
bool ImageInfoUR::GetStatus() 
{
	return (this->m_OnMemory);
}

// ----------------------------------------------------------------------------------
void ImageInfoUR::SetImages(VTKImageDataPointerType imgUndo, VTKImageDataPointerType imgRedo) 
{
	this->m_UndoImage = imgUndo;
	this->m_RedoImage = imgRedo;
	this->SetStatus(true);
}

// ----------------------------------------------------------------------------------
void ImageInfoUR::LoadImagesToMemory(const StringType& gPath) 
{
	//setting paths
	StringType filename 		= gPath + this->m_ImageName;
	StringType undoImagePath 	= filename + "_Undo.mhd";
	StringType redoImagePath 	= filename + "_Redo.mhd";
	//Loading Undo Image
	VTKMetaImageReaderPointerType readerUndo = VTKMetaImageReaderPointerType::New();
	readerUndo->SetFileName(undoImagePath.c_str());
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	// ..
#else
	readerUndo->Update();
#endif

	this->m_UndoImage = readerUndo->GetOutput();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	this->m_UndoImage->Update();
#else
	this->m_UndoImage->Modified();
#endif
	//Loading Redo Image
	VTKMetaImageReaderPointerType readerRedo = VTKMetaImageReaderPointerType::New();
	readerRedo->SetFileName(redoImagePath.c_str());
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	// ..
#else
	readerRedo->Update();
#endif

	this->m_RedoImage = readerRedo->GetOutput();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	this->m_RedoImage->Update();
#else
	this->m_RedoImage->Modified();
#endif
	//Updating status
	this->m_OnMemory = true;
}

// ----------------------------------------------------------------------------------
void ImageInfoUR::RemoveImagesFromMemory(const StringType& gPath) 
{
	if (!this->m_OnDisk) 
	{
        printf("EED ImageInfoUR::RemoveImagesFromMemory  >>>>  %s \n", gPath.c_str() );
		this->SaveImagesOnDisk(gPath);
	}
	this->m_UndoImage = NULL;
	this->m_RedoImage = NULL;
	this->SetStatus(false);
}

// ----------------------------------------------------------------------------------
void ImageInfoUR::SaveImagesOnDisk(const StringType& gPath) 
{
	printf("EED ImageInfoUR::SaveImagesOnDisk Start  \n");
	this->m_OnDisk 				= true;
	StringType filename 		= gPath + this->m_ImageName;
	StringType undoImagePath 	= filename + "_Undo.mhd";
	StringType redoImagePath 	= filename + "_Redo.mhd";
	this->SaveImageAsMHD(undoImagePath, this->m_UndoImage);
	this->SaveImageAsMHD(redoImagePath, this->m_RedoImage);
	printf("EED ImageInfoUR::SaveImagesOnDisk %s \n", undoImagePath.c_str() );
}

// ----------------------------------------------------------------------------------
void ImageInfoUR::RemoveImagesFromDisk(const StringType& gPath) 
{
	StringType filename 		= gPath + this->m_ImageName;
	StringType undoImagePathMHD = filename + "_Undo.mhd";
	StringType redoImagePathMHD = filename + "_Redo.mhd";
	StringType undoImagePathRAW = filename + "_Undo.raw";
	StringType redoImagePathRAW = filename + "_Redo.raw";
	remove(undoImagePathMHD.c_str());
	remove(redoImagePathMHD.c_str());
	remove(undoImagePathRAW.c_str());
	remove(redoImagePathRAW.c_str());
}

// ----------------------------------------------------------------------------------
void ImageInfoUR::SaveImageAsMHD(const StringType& filename, VTKImageDataPointerType image) 
{
	VTKMetaImageWriterPointerType w = VTKMetaImageWriterPointerType::New();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	w->SetInput(image);
#else
	w->SetInputData(image);
#endif
	w->SetCompression(false);
	w->SetFileDimensionality(image->GetDataDimension());
	w->SetFileName(filename.c_str());
	w->Write();
}
// ----------------------------------------------------------------------------------
