/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*!
 * @file	imageMManager.cxx
 * @brief	This file contains the implementation of the ImageMManager class.
 * @author 	Info-Dev
 * @author	Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date 	2011-11-15
 */

#include "imageModificationManager.h"

// ----------------------------------------------------------------------------------
ImageMManager::ImageMManager() 
{
	baseInitialPointX=-9999;
	baseInitialPointY=-9999;
	baseInitialPointZ=-9999;
}

// ----------------------------------------------------------------------------------
ImageMManager::ImageMManager(ImageMManager* manager) 
{
	this->m_RegionStruct 	= manager->GetModifiedRegion();
	this->m_ValidRegion  	= manager->ValidateRegion();
	this->baseInitialPointX = manager->GetBaseInitialPointX();
	this->baseInitialPointY = manager->GetBaseInitialPointY();
	this->baseInitialPointZ = manager->GetBaseInitialPointZ();
}
// ----------------------------------------------------------------------------------
ImageMManager::~ImageMManager() 
{
}

// ----------------------------------------------------------------------------------
void ImageMManager::CleanModifiedRegion() 
{
	int min 					= std::numeric_limits<int>::min();
	int max 					= std::numeric_limits<int>::max();
	this->m_RegionStruct.minX 	= max;
	this->m_RegionStruct.maxX 	= min;
	this->m_RegionStruct.minY 	= max;
	this->m_RegionStruct.maxY 	= min;
	this->m_RegionStruct.minZ 	= max;
	this->m_RegionStruct.maxZ 	= min;
	this->m_ValidRegion 		= false;
}

// ----------------------------------------------------------------------------------
void ImageMManager::CalculateMinMaxRegion(const int& i, const int& j, const int& k) 
{
	if (i >= 0 && j >= 0 && k >= 0)
	{
		if (i <= this->m_RegionStruct.minX) { this->m_RegionStruct.minX = i; } //fi
		if (i > this->m_RegionStruct.maxX)  { this->m_RegionStruct.maxX = i; } //esle
		if (j <= this->m_RegionStruct.minY) { this->m_RegionStruct.minY = j; } //fi
		if (j > this->m_RegionStruct.maxY)  { this->m_RegionStruct.maxY = j; } //esle
		if (k <= this->m_RegionStruct.minZ) { this->m_RegionStruct.minZ = k; } //fi
		if (k > this->m_RegionStruct.maxZ)  { this->m_RegionStruct.maxZ = k; } //esle
		this->m_ValidRegion = true;
	}else {
		this->m_ValidRegion = false;
	} // if i j k

	//if (m_ValidRegion )  printf("EED  ImageMManager::CalculateMinMaxRegion true \n");
	//if (!m_ValidRegion ) printf("EED   ImageMManager::CalculateMinMaxRegion false \n");
}

// ----------------------------------------------------------------------------------
void ImageMManager::AddModifiedPixel(const int& i, const int& j, const int& k) 
{
	this->CalculateMinMaxRegion(i, j, k);
}
// ----------------------------------------------------------------------------------
bool ImageMManager::ValidateRegion() 
{
	return (m_ValidRegion);
}
// ----------------------------------------------------------------------------------
RegionStructUR ImageMManager::GetModifiedRegion() 
{
	return (this->m_RegionStruct);
}
// ----------------------------------------------------------------------------------

void ImageMManager::BaseInitialPoint(int x, int y, int z)
{
	baseInitialPointX = x;	
	baseInitialPointY = y;	
	baseInitialPointZ = z;	
}

int ImageMManager::GetBaseInitialPointX()
{
	return baseInitialPointX;
}

int ImageMManager::GetBaseInitialPointY()
{
	return baseInitialPointY;
}

int ImageMManager::GetBaseInitialPointZ()
{
	return baseInitialPointZ;
}

