/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*!
 * @file	imageUndoRedo.cxx
 * @brief	This file contains the implementation of the ImageUndoRedo class.
 * @author 	Info-Dev
 * @author	Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date 	2011-11-15
 */

#include "imageUndoRedo.h"

// ----------------------------------------------------------------------------------
ImageUndoRedo::ImageUndoRedo()
{
	this->m_ImagesDeque = new IDequeType( );
}

// ----------------------------------------------------------------------------------
//virtual
ImageUndoRedo::~ImageUndoRedo( )
{
}

// ----------------------------------------------------------------------------------
//virtual
void ImageUndoRedo::Undo( )
{
	ImageInfoUR* imageInfo = this->m_ImagesDeque->Undo( );
	if( imageInfo != NULL)
	{
		this->DrawUR( imageInfo, true );
		this->UpdateUndoImage( );
	} //if  imageInfo
}
// ----------------------------------------------------------------------------------
//virtual
void ImageUndoRedo::Redo( )
{
	ImageInfoUR* imageInfo = this->m_ImagesDeque->Redo( );
	if( imageInfo != NULL)
	{
		this->DrawUR( imageInfo, false );
		this->UpdateUndoImage( );
	}
}
// ----------------------------------------------------------------------------------
void ImageUndoRedo::SetImage( VTKImageDataPointerType image )
{
	this->m_CurrentImage = image;
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	this->m_CurrentImage->Update( );
#else
	this->m_CurrentImage->Modified( );
#endif

	this->UpdateUndoImage( );
}

// ----------------------------------------------------------------------------------
//virtual
void ImageUndoRedo::SetURImages( ImageMManagerType* imMManager )
{
	ImageMManagerType* newImageManager = new ImageMManagerType( imMManager );
	if( newImageManager->ValidateRegion() )
	{
		RegionSType             region  = newImageManager->GetModifiedRegion( );
		VTKImageDataPointerType imgUndo = this->GetImageRegion( region,this->m_UndoImage );
		VTKImageDataPointerType imgRedo = this->GetImageRegion( region,this->m_CurrentImage );
		this->m_ImagesDeque->AddImagesToURContainer( imgUndo, imgRedo,newImageManager );
		this->UpdateUndoImage( );
	} else {
		std::cerr << "INVALID REGION" << std::endl;
	}
}

// ----------------------------------------------------------------------------------
void ImageUndoRedo::UpdateUndoImage( )
{
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	this->m_CurrentImage->Update( );
#else
	this->m_CurrentImage->Modified( );
#endif
	this->m_UndoImage = VTKImageDataPointerType::New( );
	this->m_UndoImage->DeepCopy( m_CurrentImage );
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	this->m_UndoImage->Update( );
#else
	this->m_UndoImage->Modified( );
#endif
}

// ----------------------------------------------------------------------------------
ImageUndoRedo::VTKImageDataPointerType ImageUndoRedo::GetImageRegion( const RegionSType& region, VTKImageDataPointerType img )
{
	VTKExtractVOIPointerType extract = VTKExtractVOIPointerType::New( );
	extract->SetVOI( region.minX, region.maxX, region.minY, region.maxY,region.minZ, region.maxZ );
	extract->SetSampleRate( 1, 1, 1 );
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	extract->SetInput( img );
#else
	extract->SetInputData( img );
	extract->Update();
#endif
	VTKImageDataPointerType imgResult = extract->GetOutput( );
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	imgResult->Update( );
#else
	imgResult->Modified( );
#endif
	return ( imgResult );
}
// ----------------------------------------------------------------------------------
void ImageUndoRedo::SetCurrentImage( VTKImageDataPointerType img )
{
	this->m_CurrentImage = img;
}
// ----------------------------------------------------------------------------------
//virtual
void ImageUndoRedo::DrawUR( ImageInfoUR* imageInfo, const bool& undo )
{
	VTKImageDataPointerType img;
	if( undo )
	{
		img = imageInfo->GetUndoImage( );
	} else {
		img = imageInfo->GetRedoImage( );
	} //else
	RegionSType region 			= imageInfo->GetImageMManager()->GetModifiedRegion();
	m_RestorBaseInitialPointX 	= imageInfo->GetImageMManager()->GetBaseInitialPointX();
	m_RestorBaseInitialPointY 	= imageInfo->GetImageMManager()->GetBaseInitialPointY();
	m_RestorBaseInitialPointZ 	= imageInfo->GetImageMManager()->GetBaseInitialPointZ();

    printf("EED ImageUndoRedo::DrawUR  %d - %d    %d - %d    %d - %d\n", region.minX, region.maxX, region.minY, region.maxY,region.minZ,region.maxZ);
    
	if( img != NULL)
	{
		int *dim 			= img->GetDimensions( );	
		int sizeXImageIn 	= dim[ 0 ];
//EED 2022-02-11
//      size_t linesize     = sizeXImageIn * sizeof(unsigned short);
        size_t linesize     = sizeXImageIn * img->GetScalarSize();
        int j,k;
        int y,z;
		for( j = region.minY, y = 0; j <= region.maxY; j++, y++ )
		{
			for( k = region.minZ, z = 0; k <= region.maxZ; k++, z++ )
			{
				void* ptrsrc 	= img->GetScalarPointer( 0, y, z );
				void* ptrdest 	= this->m_CurrentImage->GetScalarPointer( region.minX, j, k );
				memcpy( ptrdest, ptrsrc, linesize );
			} // for k
		} // for j
		this->m_CurrentImage->Modified( );
	} // if img
	this->m_ImagesDeque->ManageMemory( );
}
// ----------------------------------------------------------------------------------

int ImageUndoRedo::GetRestorBaseInitialPointX() 
{
	return 	m_RestorBaseInitialPointX;
}

int ImageUndoRedo::GetRestorBaseInitialPointY() 
{
	return  m_RestorBaseInitialPointY;
}

int ImageUndoRedo::GetRestorBaseInitialPointZ() 
{
	return 	m_RestorBaseInitialPointZ;
}

