/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*!
 * @file	managerUR.h
 * @brief	This file contains the ManagerUR class. -- Abstract class
 * @author 	Info-Dev
 * @author	Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date 	2011-11-15
 */

#ifndef MANAGERUR_H_
#define MANAGERUR_H_

#include <iostream>
#include <string>
#include <vtkImageData.h>
#include <vtkSmartPointer.h>
#include <vtkExtractVOI.h>

#include "image3DDequeUR.h"
#include "imageModificationManager.h"
#include "regionStructUR.h"
#include "imageInfoUR.h"

/*! @class ManagerUR managerUR.h "managerUR.cxx"
 *	@brief This class manages the Undo/Redo -- Abstract Class.
 *	@details This class allows the communication between others libraries who wants to use it.
 */
class ManagerUR {
public:
	//typedef definition
	// ----------------------------------------------------------------------------------
	/*!	@typedef RegionStructUR RegionSType;
	 *	@brief Redefines the ImageMManagerType.
	 */
	typedef RegionStructUR RegionSType;
	// ----------------------------------------------------------------------------------
	/*!	@typedef ImageMManager ImageMManagerType;
	 *	@brief Redefines the ImageMManager type.
	 */
	typedef ImageMManager ImageMManagerType;
	// ----------------------------------------------------------------------------------
	/*!	@typedef vtkSmartPointer<vtkImageData> VTKImageDataPointerType;
	 *	@brief Defines the pointer of vtkImageDate type.
	 */
	typedef vtkSmartPointer<vtkImageData> VTKImageDataPointerType;
	// ----------------------------------------------------------------------------------
	/*!	@typedef vtkSmartPointer<vtkExtractVOI> VTKExtractVOIPointerType;
	 *	@brief Defines the pointer of vtkExtractVOI type.
	 */
	typedef vtkSmartPointer<vtkExtractVOI> VTKExtractVOIPointerType;
	// ----------------------------------------------------------------------------------
	/*!	@typedef std::string StringType;
	 *	@brief Redefinition of the string type
	 */
	typedef std::string StringType;
	// ----------------------------------------------------------------------------------
public:
	// ----------------------------------------------------------------------------------
	/*! @fn ManagerUR();
	 * @brief This is the default constructor.
	 */
	ManagerUR();
	// ----------------------------------------------------------------------------------
	/*! @fn virtual ~ManagerUR();
	 * @brief This is the destructor.
	 */
	virtual ~ManagerUR();
	// ----------------------------------------------------------------------------------
	/*! @fn virtual void Undo();
	 * @brief This method manages the undo action.
	 */
	virtual void Undo();
	// ----------------------------------------------------------------------------------
	/*! @fn virtual void Redo();
	 * @brief This method manages the redo action.
	 */
	virtual void Redo();
	// ----------------------------------------------------------------------------------
	/*! @fn virtual void SetImage(VTKImageDataPointerType image);
	 * @brief This method sets the modification image (The image which will be modified an manipulated)
	 */
	virtual void SetImage(VTKImageDataPointerType image);
	// ----------------------------------------------------------------------------------
	/*! @fn virtual void SetURImages(ImageMManagerType* imMManager);
	 * @brief This methods adds a new image Undo/Redo.
	 */
	virtual void SetURImages(ImageMManagerType* imMManager);
	// ----------------------------------------------------------------------------------
protected:
	// ----------------------------------------------------------------------------------
	/*! @fn virtual void DrawUR(ImageInfoUR* imageInfo, const bool& undo);
	 * @brief This method writes in the visualized image the changes of the undo/redo.
	 */
	virtual void DrawUR(ImageInfoUR* imageInfo, const bool& undo);
	// ----------------------------------------------------------------------------------
};

#endif /* MANAGERUR_H_ */
