/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*!
 * @file	regionStructUR.h
 * @brief	This file contains the RegionStructUR struct.
 * @author 	Info-Dev
 * @author	Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date 	2011-11-15
 */

#ifndef REGIONSTRUCT_H_
#define REGIONSTRUCT_H_

/*! @class RegionStructUR reegionStructUR.h "managerUR.cxx"
 *	@brief This class manages the Undo/Redo -- Abstract Class.
 *	@details This class allows the communication between others libraries who wants to use it.
 */
struct RegionStructUR {
	int minX; //!< This is the minimum X
	int maxX; //!< This is the Maximum X
	int minY; //!< This is the minimum Y
	int maxY; //!< This is the Maximum Y
	int minZ; //!< This is the minimum Z
	int maxZ; //!< This is the Maximum Z
};

#endif /* REGIONSTRUCT_H_ */
