/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef wx_chart_h
#define wx_chart_h


//-----------------------------------------------------------------
#ifdef __GNUG__
    #pragma interface "chart.h"
#endif

#ifdef __BORLANDC__
	#pragma hdrstop
#endif

//---------------------------------------------------------------------
#include "wx/wxprec.h"
#ifndef WX_PRECOMP
	#include "wx/wx.h"
#endif


//---------------------------------------------------------------------
#define MAX_DATASET   10
#define MAX_ITEM      50 
#define MARGE		   5
#define MINOR_STEP    10
#define MAJOR_STEP     5
#define MAX_PER      200 
#define MINOR_PER     25
#define MAJOR_PER     50
	
enum 
{
  wxArea              = 0,
  wxPerimeter         = 1,
  wxDiameterArea      = 2, 
  wxDiameterPerimeter = 3,
  wxMinimumDiameter   = 4,
  wxMaximumDiameter   = 5,
  wxAverageDiameter   = 6,
  wxStenosis          = 7
};


//-------------------------------------------------------------------
class wxDataSet: public wxObject
{
 protected:
   wxBrush  *m_dataStyle;
   wxPen    *m_lineStyle;
   wxString *m_text;
   int       m_dataWidth;     // Scaled|Fixed
   int       m_lineWidth;
   int       m_pointMark;
   int       m_displayValues; // def=NONE |IN | OUT 
   bool      m_display;

 public:
   wxList *m_rowsList;
 
 public :
   // Constructor & Destructor
   wxDataSet(wxPen *lStype, wxBrush *dStyle,
             int dWidth, int lWidth, int dGap, int pMark,
             int disValues);
   wxDataSet(wxPen *lStype, wxBrush *dStyle,
             wxString *lText, bool lDisplay=false);
   wxDataSet();
   ~wxDataSet();
 
    // Set
   void SetDataStyle(wxBrush* brush)  { m_dataStyle = brush;}
   void SetDataWidth(int width)       { m_dataWidth = width;}
   void SetLineStyle(wxPen* style)    { m_lineStyle = style;}
   void SetPointMark(int mark)        { m_pointMark = mark; }
   void SetText(wxString* string)     { m_text = string;    }
   void Show(bool show)               { m_display=show;     }
   
   // Get
   bool      GetShow()      { return m_display;   }
   wxBrush*  GetDataStyle() { return m_dataStyle; }
   int       GetDataWidth() { return m_dataWidth; }
   wxPen*    GetLineStyle() { return m_lineStyle; }
   int       GetPointMark() { return m_pointMark; }
   wxString* GetText()      { return m_text;      }
   
};
//---------------------------------------------------------------


class Table
{
  public :
    double x,y;
	bool   empty;
};

//----------------------------------------------------------------------
class wxChart: public wxWindow
{
private:
	
    int         m_NumDataSet;
	int         m_NumItem;
	Table       m_table[MAX_DATASET][MAX_ITEM];
    wxDataSet  *m_dataSetArray[MAX_DATASET]; 
 
    double  m_MinX, m_MaxX;
    double  m_InfX, m_SupX, m_SupY;
	
	double  m_StepSizeX, m_StepSizeY, m_StepSizePer;
    double  m_MaxValue; 
    
	int     m_ValueCol;	 
    bool    m_ShowPer;

	int     m_MaxHauteur, m_MaxLargeur;
    int     m_CenterX, m_CenterY;
	int     m_EdgeTop, m_EdgeBottom, m_EdgeLeft, m_EdgeRight;
    int     m_Top,m_Bottom, m_Left, m_Right;
	    
    int     m_EdgeTopLegend, m_EdgeBottomLegend, m_EdgeLeftLegend, m_EdgeRightLegend;
    int     m_TopLegend, m_BottomLegend, m_LeftLegend, m_RightLegend;
	
   	double  m_MinorIncX, m_MajorIncX;
    double  m_MinorIncY, m_MajorIncY;

	void    DrawLine(wxDC &dc, int a);
	void    DrawFond(wxDC& dc);
    void    DrawAxe(wxDC& dc);
    void    DrawAxePer(wxDC& dc);
	void    DrawLegend(wxDC& dc, int nbr);
	void    DrawGrille(wxDC& dc);
	void    SetInitEdge();
    void    SetChartBounds();
	void    SetChartBoundsLegend();
	void    SetCadreLegend(int nbr, int* bottom);
    void    InitDataSet();
    void    InitData();
	double  MaxValue();
	double  MinCol(double inf);
    double  MaxCol(double sup);
    void    SetInfX(double sup);
 	void    SetSupX(double sup);
	void    SetSupY(double sup);
    void    InitChart();
    int     GetShow();

public:
	// Constructor et Destructor
	wxChart(wxFrame *parent, wxWindowID id, const wxPoint& pos = wxDefaultPosition,
		const wxSize& size = wxDefaultSize, long  style = wxDEFAULT_FRAME_STYLE,
		const wxString& name = wxPanelNameStr);
    ~wxChart();
	
	void    OnPaint(wxPaintEvent& event);
	void    OnLeftClick(wxDC &dc, double x, double y, int keys);
	void    OnRightClick(wxDC &dc, double x, double y, int keys);
 	
	void    Draw(wxDC& dc);
	bool    IsEmpty(int a, int item);
	double  GetDataX(int a, int item);
	double  GetDataY(int a, int item);
    void    SetData(int a, int item, double x, double y);
    
    void    SetMinX(double MinX);
	void    SetMaxX(double MaxX);
	void    SetMaxWidthHeight(int x,int y); 
	void    SetCenterChart(int x, int y);
	void    SetShowPer(bool per);
 	void    SetMaxValue(double max);
	void    SetStepSizeX(double sizeX);
    void    SetStepSizeY(double sizeY);
    void    SetStepSizePer(double sizePer);
    void    SetNumDataSet(int NumDataSet);
	void    SetNumItem(int NumItem);
	void    SetIncAxisX(double minor, double major);
    void    SetIncAxisY(double minor, double major);
    void    SetEdgeTop(int top);
	void    SetEdgeBottom(int bottom);
	void    SetEdgeLeft(int left);
	void    SetEdgeRight(int right);
    void    SetEdgeTopLegend(int top);
	void    SetEdgeBottomLegend(int bottom);
	void    SetEdgeLeftLegend(int left);
	void    SetEdgeRightLegend(int right);
	void    ShowDataSet(bool show,int dataset);
	
	double  GetMinX()          { return m_MinX;       }
    double  GetMaxX()          { return m_MaxX;       }
	int     GetMaxValue()      { return m_MaxValue;   }
	double  GetStepSizeX()     { return m_StepSizeX;  }
    double  GetStepSizeY()     { return m_StepSizeY;  }
    double  GetStepSizePer()   { return m_StepSizePer;}
    int     GetValueCol()      { return m_ValueCol;   }
    int     GetNumDataSet()    { return m_NumDataSet; }
	int     GetNumItem()       { return m_NumItem;    }
	bool    GetShowPer()       { return m_ShowPer;    }
	int     GetLargeur()       { return m_MaxLargeur; }
    int     GetHauteur()       { return m_MaxHauteur; }
	int     GetEdgeTop()       { return m_EdgeTop;    }
    int     GetEdgeBottom()    { return m_EdgeBottom; }
    int     GetEdgeLeft()      { return m_EdgeLeft;   }
    int     GetEdgeRight()     { return m_EdgeRight;  }
	int     GetEdgeTopLegend()    { return m_EdgeTopLegend;    }
    int     GetEdgeBottomLegend() { return m_EdgeBottomLegend; }
    int     GetEdgeLeftLegend()   { return m_EdgeLeftLegend;   }
    int     GetEdgeRightLegend()  { return m_EdgeRightLegend;  }
	bool    GetShowDataSet(int dataset);
  
   DECLARE_EVENT_TABLE()
};

#endif // wx_chart_h
