/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: vtk2DQuantSliceWidget.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:18 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#include "vtk2DQuantSliceWidget.h"
#include <vtkProperty.h>
#include <vtkRenderer.h>

/**
 * Again wxVTK is an hybrid class, double click was done using wxWindows, simply
 * because VTK doesn't provide such facility (as opposed to wheel support that is
 * supposed to be merged in VTK trunk sooner or later:
 *
 * http://public.kitware.com/pipermail/vtkusers/2003-August/019548.html
 * http://www.creatis.insa-lyon.fr/~malaterre/vtk/wheel.patch
 */

vtk2DQuantSliceWidget::vtk2DQuantSliceWidget( wxWindow* parent, wxWindowID id,
                                             const wxPoint& pos, const wxSize& size,
                                             long style, const wxString& name)
                                             : wxImageViewerWidget( parent, id, pos, size, style, name)
{
	// Contour
	_cntActor						= NULL;
	_cntMapper						= NULL;

	// Diameter Min
	_diameterMinvtkActor			= NULL;
	_diameterMinvtkPolyLine			= NULL;
	_diameterMinvtkDataSetMapper	= NULL;
	_diameterMinvtkUnstructuredGrid	= NULL;

	// Diameter Max
	_diameterMaxvtkActor			= NULL;
	_diameterMaxvtkPolyLine			= NULL;
	_diameterMaxvtkDataSetMapper	= NULL;
	_diameterMaxvtkUnstructuredGrid	= NULL;
}


vtk2DQuantSliceWidget::~vtk2DQuantSliceWidget( )
{
	// Contour
	if( _cntActor )							_cntActor->Delete();
	if( _cntMapper )						_cntMapper->Delete();

	// Diameter Min
	if( _diameterMinvtkActor )				_diameterMinvtkActor->Delete();
	if( _diameterMinvtkPolyLine )			_diameterMinvtkPolyLine->Delete();
	if( _diameterMinvtkDataSetMapper )		_diameterMinvtkDataSetMapper->Delete();
	if( _diameterMinvtkUnstructuredGrid )	_diameterMinvtkUnstructuredGrid->Delete();

	// Diameter Max
	if( _diameterMaxvtkActor )				_diameterMaxvtkActor->Delete();
	if( _diameterMaxvtkPolyLine )			_diameterMaxvtkPolyLine->Delete();
	if( _diameterMaxvtkDataSetMapper )		_diameterMaxvtkDataSetMapper->Delete();
	if( _diameterMaxvtkUnstructuredGrid )	_diameterMaxvtkUnstructuredGrid->Delete();
}

//----------------------------------------------------------------------------

//void vtk2DQuantSliceWidget::SetContour( vtkUnstructuredGrid *cnt )
void vtk2DQuantSliceWidget::SetContour( vtkPolyData *cnt )
{
//  _cntMapper = vtkDataSetMapper::New( ); 
//  _cntMapper = vtkDataSetMapper::New( );
  
  _cnt = cnt;

  if( !_cntMapper ) {
    _cntMapper = vtkPolyDataMapper::New( );
    _cntMapper->ScalarVisibilityOff( );
    _cntMapper->ImmediateModeRenderingOn();
  }
  _cntMapper->SetInput( _cnt );
//  _cntMapper->SetInput( _cnt->GetOutput( ) );

  if( !_cntActor ) {
    _cntActor = vtkActor::New( );
    _cntActor->SetMapper( _cntMapper );
    (_cntActor->GetProperty( ))->SetColor( 0 , 1 , 0 );
    (_cntActor->GetProperty( ))->SetLineWidth( 2 );
    (_cntActor->GetProperty( ))->BackfaceCullingOff( );
  }
  else{
    _imageViewer->GetRenderer()->RemoveActor( _cntActor );
  }

  _cntActor->SetPosition(0,0,100);
  _imageViewer->GetRenderer()->AddActor( _cntActor );
  _imageViewer->Render( );

}


//----------------------------------------------------------------------------
void vtk2DQuantSliceWidget::SetDiameterMin(vtkPoints *diameterMin, bool showActor){
	if (_diameterMinvtkActor!=NULL)				_imageViewer->GetRenderer()->RemoveActor( _diameterMinvtkActor );
	if (_diameterMinvtkActor!=NULL)				_diameterMinvtkActor->Delete();
	if (_diameterMinvtkPolyLine!=NULL)			_diameterMinvtkPolyLine->Delete();
	if (_diameterMinvtkDataSetMapper!=NULL)		_diameterMinvtkDataSetMapper->Delete();
	if (_diameterMinvtkUnstructuredGrid!=NULL)	_diameterMinvtkUnstructuredGrid->Delete();

	_diameterMinvtkActor			=	vtkActor::New();
	_diameterMinvtkPolyLine			=	vtkPolyLine::New();
	_diameterMinvtkDataSetMapper	=	vtkDataSetMapper::New();
	_diameterMinvtkUnstructuredGrid	=	vtkUnstructuredGrid::New();

	// generate new actor
	(_diameterMinvtkPolyLine->GetPointIds() )->SetNumberOfIds(2);
	( _diameterMinvtkPolyLine->GetPointIds() )->SetId(0,0);
	( _diameterMinvtkPolyLine->GetPointIds() )->SetId(1,1);
	_diameterMinvtkUnstructuredGrid->Allocate(1,1);
	_diameterMinvtkUnstructuredGrid->InsertNextCell(_diameterMinvtkPolyLine->GetCellType() , 
							 _diameterMinvtkPolyLine->GetPointIds() );
	_diameterMinvtkUnstructuredGrid->SetPoints( diameterMin );
	_diameterMinvtkDataSetMapper->SetInput(_diameterMinvtkUnstructuredGrid);
	_diameterMinvtkDataSetMapper->ImmediateModeRenderingOn();
	_diameterMinvtkActor->SetMapper(_diameterMinvtkDataSetMapper);
	_diameterMinvtkActor->GetProperty()->BackfaceCullingOn();
	_diameterMinvtkActor->GetProperty()->SetDiffuseColor(1,0,0);
	// add new actor
	if (showActor==true) _imageViewer->GetRenderer()->AddActor( _diameterMinvtkActor );
	// Refresh Widget
	_imageViewer->Render( );
}
//----------------------------------------------------------------------------
void vtk2DQuantSliceWidget::SetDiameterMax(vtkPoints *diameterMax, bool showActor){
	if (_diameterMaxvtkActor!=NULL)				_imageViewer->GetRenderer()->RemoveActor( _diameterMaxvtkActor );
	if (_diameterMaxvtkActor!=NULL)				_diameterMaxvtkActor->Delete();
	if (_diameterMaxvtkPolyLine!=NULL)			_diameterMaxvtkPolyLine->Delete();
	if (_diameterMaxvtkDataSetMapper!=NULL)		_diameterMaxvtkDataSetMapper->Delete();
	if (_diameterMaxvtkUnstructuredGrid!=NULL)	_diameterMaxvtkUnstructuredGrid->Delete();

	_diameterMaxvtkActor			=	vtkActor::New();
	_diameterMaxvtkPolyLine			=	vtkPolyLine::New();
	_diameterMaxvtkDataSetMapper	=	vtkDataSetMapper::New();
	_diameterMaxvtkUnstructuredGrid	=	vtkUnstructuredGrid::New();

	// generate new actor
	(_diameterMaxvtkPolyLine->GetPointIds() )->SetNumberOfIds(2);
	( _diameterMaxvtkPolyLine->GetPointIds() )->SetId(0,0);
	( _diameterMaxvtkPolyLine->GetPointIds() )->SetId(1,1);
	_diameterMaxvtkUnstructuredGrid->Allocate(1,1);
	_diameterMaxvtkUnstructuredGrid->InsertNextCell(_diameterMaxvtkPolyLine->GetCellType() , 
															 _diameterMaxvtkPolyLine->GetPointIds() );
	_diameterMaxvtkUnstructuredGrid->SetPoints( diameterMax );
	_diameterMaxvtkDataSetMapper->SetInput(_diameterMaxvtkUnstructuredGrid);
	_diameterMaxvtkDataSetMapper->ImmediateModeRenderingOn();
	_diameterMaxvtkActor->SetMapper(_diameterMaxvtkDataSetMapper);
	_diameterMaxvtkActor->GetProperty()->BackfaceCullingOn();
	_diameterMaxvtkActor->GetProperty()->SetDiffuseColor(0,0,1);
	// add new actor
	if (showActor==true) _imageViewer->GetRenderer()->AddActor( _diameterMaxvtkActor );
	// Refresh Widget
	_imageViewer->Render( );
}
//----------------------------------------------------------------------------
void vtk2DQuantSliceWidget::Show2DContourDiameters( ){
  if (_cntActor!=NULL)				_imageViewer->GetRenderer()->AddActor( _cntActor );
  if (_diameterMinvtkActor!=NULL)	_imageViewer->GetRenderer()->AddActor( _diameterMinvtkActor );
  if (_diameterMaxvtkActor!=NULL)	_imageViewer->GetRenderer()->AddActor( _diameterMaxvtkActor );
  _imageViewer->Render( );
}
//----------------------------------------------------------------------------
void vtk2DQuantSliceWidget::Hide2DContourDiameters( ){
	if ( _cntActor				!= NULL ) { _imageViewer->GetRenderer()->RemoveActor( _cntActor );            }
	if ( _diameterMinvtkActor	!= NULL ) { _imageViewer->GetRenderer()->RemoveActor( _diameterMinvtkActor ); }
	if ( _diameterMaxvtkActor	!= NULL ) { _imageViewer->GetRenderer()->RemoveActor( _diameterMaxvtkActor ); }
  _imageViewer->Render( );
}

//----------------------------------------------------------------------------
/*BEGIN_EVENT_TABLE( vtk2DQuantSliceWidget, wxVTKRenderWindowInteractor )
    EVT_LEFT_DCLICK( vtk2DQuantSliceWidget::OnLeftDClick )
END_EVENT_TABLE( );
*/
