/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: vtk2DQuantSliceWidget.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:18 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#ifndef __VTK2DQUANTSLICEWIDGET__
#define __VTK2DQUANTSLICEWIDGET__

#include "wxImageViewerWidget.h"

#include <vtkActor.h>
#include <vtkPolyLine.h>
#include <vtkDataSetMapper.h>
#include <vtkPolyDataMapper.h>
#include <vtkUnstructuredGrid.h>


/**
 * \brief Class that brigde to VTK, override double click...
 */
class vtk2DQuantSliceWidget : public wxImageViewerWidget
{
public:

    vtk2DQuantSliceWidget( wxWindow* parent,
        wxWindowID id,
        const wxPoint& pos = wxDefaultPosition,
        const wxSize& size = wxDefaultSize,
        long style = wxSUNKEN_BORDER, //wxTAB_TRAVERSAL,
        const wxString& name = wxPanelNameStr
        );
    ~vtk2DQuantSliceWidget( );

    //void SetContour( vtkUnstructuredGrid *cnt );
    void SetContour( vtkPolyData *cnt );
	void SetDiameterMin(vtkPoints *diameterMin, bool showActor);
	void SetDiameterMax(vtkPoints *diameterMax, bool showActor);
	void Show2DContourDiameters();
	void Hide2DContourDiameters();

protected:

private:

	// Contour
	vtkPolyData			*_cnt; 
	vtkPolyDataMapper	*_cntMapper;
	vtkActor			*_cntActor;

	// Diameter Min
	vtkActor			*_diameterMinvtkActor;
	vtkPolyLine			*_diameterMinvtkPolyLine;
	vtkDataSetMapper	*_diameterMinvtkDataSetMapper;
	vtkUnstructuredGrid *_diameterMinvtkUnstructuredGrid;

	// Diameter Max
	vtkActor			*_diameterMaxvtkActor;
	vtkPolyLine			*_diameterMaxvtkPolyLine;
	vtkDataSetMapper	*_diameterMaxvtkDataSetMapper;
	vtkUnstructuredGrid *_diameterMaxvtkUnstructuredGrid;


//  DECLARE_EVENT_TABLE( );

};

#endif //__VTK2DQUANTSLICEWIDGET__
