/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: vtk3DQuantSurfaceWidget.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:17 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#include "vtk3DQuantSurfaceWidget.h"
#include <vtkPointPicker.h>
#include <vtkCamera.h>
#include <vtkWindowLevelLookupTable.h>
// EED
#include <vtkPolyLine.h> 
#include <vtkPlaneSource.h> 



//----------------------------------------------------------------------------
RectangleGuideVtk::RectangleGuideVtk(){
  _showActor	= false;
  _grid			= NULL; 
  _actor		= NULL;
  _points		= NULL;
  _mapper		= NULL;
  _poly_line	= NULL;
  _iSlice		= -1;
}
//----------------------------------------------------------------------------
RectangleGuideVtk::~RectangleGuideVtk(){
  if( _grid		 )	_grid->Delete();
  if( _actor	 )	_actor->Delete();
  if( _points	 )	_points->Delete();
  if( _mapper	 )	_mapper->Delete();
  if( _poly_line )	_poly_line->Delete();
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
listContourVTK::listContourVTK(vtk3DQuantSurfaceWidget *quantSurfaceWidget){
	_r=1;
	_g=1;
	_b=1;
	_vtk3DQuantSurfaceWidget=quantSurfaceWidget;
}
//----------------------------------------------------------------------------
listContourVTK::~listContourVTK(){
	EraseListContourActor();
}
//----------------------------------------------------------------------------
void listContourVTK::SetColour(int r,int g,int b){
	_r=r;
	_g=g;
	_b=b;
}
//----------------------------------------------------------------------------
void listContourVTK::InitListContourActor(int nos){
  EraseListContourActor();
  int i;
  for (i=0;i<nos;i++){
    _lst3DContoursVtkActor.push_back( NULL );
    _lst3DContoursVtkUnstructuredGrid.push_back( NULL );
    _lst3DContoursVtkDataSetMapper.push_back( NULL );
    _lst3DContoursVtkPolyLine.push_back( NULL );
  }

  // Refresh 3DWidget
// EED 31 mai 2007 
//  vtkRenderWindow* pRenderWindow = _vtk3DQuantSurfaceWidget->QuantSurfaceWidget_GetRenderWindow();
//  pRenderWindow->Render( );
}
//----------------------------------------------------------------------------
void listContourVTK::EraseListContourActor(){
	int i;
	for (i=0;i<_lst3DContoursVtkActor.size();i++){
		EraseSliceContourActor(i,false);
	 }
	_lst3DContoursVtkActor.clear();
	_lst3DContoursVtkUnstructuredGrid.clear();
	_lst3DContoursVtkDataSetMapper.clear();
	_lst3DContoursVtkPolyLine.clear();
}
//----------------------------------------------------------------------------
void listContourVTK::EraseSliceContourActor(int slice, bool refresh){
	if (_lst3DContoursVtkActor[slice]!=NULL){
		vtkRenderer *pRenderer = _vtk3DQuantSurfaceWidget->QuantSurfaceWidget_GetRenderer();
		if (_lst3DContoursVtkActor[slice])					pRenderer->RemoveActor(_lst3DContoursVtkActor[slice]);
		if (_lst3DContoursVtkUnstructuredGrid[slice])		_lst3DContoursVtkUnstructuredGrid[slice]->Delete();
		if (_lst3DContoursVtkDataSetMapper[slice])			_lst3DContoursVtkDataSetMapper[slice]->Delete();
		if (_lst3DContoursVtkPolyLine[slice])				_lst3DContoursVtkPolyLine[slice]->Delete();
		if (_lst3DContoursVtkActor[slice])					_lst3DContoursVtkActor[slice]->Delete();
		_lst3DContoursVtkUnstructuredGrid[slice]=NULL;
		_lst3DContoursVtkDataSetMapper[slice]=NULL;
		_lst3DContoursVtkPolyLine[slice]=NULL;
		_lst3DContoursVtkActor[slice]=NULL;
	}
	if (refresh==true){
		// Refresh 3DWidget
		vtkRenderWindow* pRenderWindow = _vtk3DQuantSurfaceWidget->QuantSurfaceWidget_GetRenderWindow();
		pRenderWindow->Render( );
	}
}
//----------------------------------------------------------------------------
void listContourVTK::Set3DContourActor( int slice, vtkPoints* contour3D, bool showActor){
	// Erase old actor
	EraseSliceContourActor(slice);
	// generate new actor
	int id,numberOfPoints;
	numberOfPoints=contour3D->GetNumberOfPoints ();
	_lst3DContoursVtkPolyLine[slice]	= vtkPolyLine::New();

	( _lst3DContoursVtkPolyLine[slice]->GetPointIds() )->SetNumberOfIds(numberOfPoints);
	for (id=0;id<numberOfPoints;id++){
		( _lst3DContoursVtkPolyLine[slice]->GetPointIds() )->SetId(id,id);
	}
	_lst3DContoursVtkUnstructuredGrid[slice]=vtkUnstructuredGrid::New();
	_lst3DContoursVtkUnstructuredGrid[slice]->Allocate(1,1);
	_lst3DContoursVtkUnstructuredGrid[slice]->InsertNextCell(   _lst3DContoursVtkPolyLine[slice]->GetCellType() , 
																_lst3DContoursVtkPolyLine[slice]->GetPointIds() );
	_lst3DContoursVtkUnstructuredGrid[slice]->SetPoints( contour3D );
	_lst3DContoursVtkDataSetMapper[slice] = vtkDataSetMapper::New();
	_lst3DContoursVtkDataSetMapper[slice]->SetInput(_lst3DContoursVtkUnstructuredGrid[slice]);
	_lst3DContoursVtkDataSetMapper[slice]->ImmediateModeRenderingOn();
	_lst3DContoursVtkActor[slice]=vtkActor::New();
	_lst3DContoursVtkActor[slice]->SetMapper(_lst3DContoursVtkDataSetMapper[slice]);
	_lst3DContoursVtkActor[slice]->GetProperty()->BackfaceCullingOn();
	_lst3DContoursVtkActor[slice]->GetProperty()->SetDiffuseColor(_r,_g,_b);
	_lst3DContoursVtkActor[slice]->PickableOff( );
	// add new actor
	vtkRenderer *pRenderer			= _vtk3DQuantSurfaceWidget->QuantSurfaceWidget_GetRenderer();
	vtkRenderWindow* pRenderWindow	= _vtk3DQuantSurfaceWidget->QuantSurfaceWidget_GetRenderWindow();

	if (showActor==true){ 
		pRenderer->AddActor( _lst3DContoursVtkActor[slice] );
	}
	// Refresh 3DWidget
	pRenderWindow->Render( );


}
//----------------------------------------------------------------------------
void listContourVTK::Show3DContourActor( ){
	vtkRenderer *pRenderer			= _vtk3DQuantSurfaceWidget->QuantSurfaceWidget_GetRenderer();
	vtkRenderWindow* pRenderWindow	= _vtk3DQuantSurfaceWidget->QuantSurfaceWidget_GetRenderWindow();
	int i;
	for (i=0;i<_lst3DContoursVtkActor.size();i++){
		if (_lst3DContoursVtkActor[i]!=NULL) pRenderer->AddActor( _lst3DContoursVtkActor[i] );	
	 }
	// Refresh 3DWidget
	pRenderWindow->Render( );
}
//----------------------------------------------------------------------------
void listContourVTK::Hide3DContourActor( ){
	vtkRenderer *pRenderer			= _vtk3DQuantSurfaceWidget->QuantSurfaceWidget_GetRenderer();
	vtkRenderWindow* pRenderWindow	= _vtk3DQuantSurfaceWidget->QuantSurfaceWidget_GetRenderWindow();
	int i;
	for (i=0;i<_lst3DContoursVtkActor.size();i++){
		if (_lst3DContoursVtkActor[i]!=NULL) pRenderer->RemoveActor( _lst3DContoursVtkActor[i] );	
	 }
	// Refresh 3DWidget
	pRenderWindow->Render( );
}


//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
//----------------------------------------------------------------------------





/**
 * Again wxVTK is an hybrid class, double click was done using wxWindows, simply
 * because VTK doesn't provide such facility (as opposed to wheel support that is
 * supposed to be merged in VTK trunk sooner or later:
 *
 * http://public.kitware.com/pipermail/vtkusers/2003-August/019548.html
 * http://www.creatis.insa-lyon.fr/~malaterre/vtk/wheel.patch
 */

//----------------------------------------------------------------------------
/*
BEGIN_EVENT_TABLE( vtk3DQuantSurfaceWidget, vtk3DSurfaceWidget )
  //  EVT_LEFT_DCLICK( vtk3DQuantSurfaceWidget::OnLeftDClick )
  // EVT_MOUSEWHEEL( vtk3DQuantSurfaceWidget::OnMouseWheel )
END_EVENT_TABLE( );
*/
//----------------------------------------------------------------------------
vtk3DQuantSurfaceWidget::vtk3DQuantSurfaceWidget(
        wxWindow* parent,
        wxWindowID id,
        const wxPoint& pos,
        const wxSize& size,
        long style,
        const wxString& name)
        : vtk3DSurfaceWidget( parent, id, pos, size, style, name ){
  _3DSliceMapper		= NULL;
  _3DSliceActor			= NULL;
  _bwlookup				= NULL;
  _collookup			= NULL;
  _hs_rectGuide			= new RectangleGuideVtk();
  _s1_rectGuide			= new RectangleGuideVtk();
  _s2_rectGuide			= new RectangleGuideVtk();
  _sA_rectGuide			= new RectangleGuideVtk();
  _sB_rectGuide			= new RectangleGuideVtk();

  _lstContVtk			= new listContourVTK(this);
  _lstContHealtyVtk		= new listContourVTK(this);
  _lstContVtk->SetColour(1,1,0);
  _lstContHealtyVtk->SetColour(0,0,1);

}

vtk3DQuantSurfaceWidget::~vtk3DQuantSurfaceWidget()
{
  if( _3DSliceActor )	_3DSliceActor	->Delete();
  if( _3DSliceMapper)	_3DSliceMapper	->Delete();
  if( _bwlookup		)	_bwlookup		->Delete();
  if( _collookup	)	_collookup		->Delete();

  delete _hs_rectGuide;
  delete _s1_rectGuide;
  delete _s2_rectGuide;
  delete _sA_rectGuide;
  delete _sB_rectGuide;

  delete _lstContVtk;
  delete _lstContHealtyVtk;
}


//----------------------------------------------------------------------------
void vtk3DQuantSurfaceWidget::ShowMARACASDataAndAxe( marInterface* mar )
{
  marAxis			*temp;
  vtkPolyData		*allData;
  int nos;
  vtkProbeFilter	*pFilter;

  this->ShowMARACASData( mar );
  this->ConfigureVTK();

  _pRenderer->SetBackground( 0.35, 0.35, 0.35 );

  // Axis
  _mar->_experiment->setAxis( 0 );
  temp		= _mar->_experiment->getAxis( );  // ??? getActualAxis ??
  allData	= temp->Draw( );

  nos		= _mar->_experiment->getNumberOfSlices( );
  pFilter	= _mar->_experiment->get3DSlice( (int) (nos-1)/2 );

  _bwlookup = vtkWindowLevelLookupTable::New( );
  _bwlookup->SetHueRange( 0 , 1 );
  _bwlookup->SetNumberOfColors( (int)(_range[1] - _range[0] + 1) );
  _bwlookup->SetTableRange( _range[0] , _range[1] );
  _bwlookup->SetSaturationRange( 0 , 0 );
  _bwlookup->SetValueRange( 0 , 1 );
  _bwlookup->SetAlphaRange( 1 , 1 );
  _bwlookup->Build( );

  _collookup = vtkLookupTable::New( );
  _collookup->SetNumberOfColors( 256 );
  _collookup->SetTableRange( 0 , 255 );
  _collookup->Build( );
  _collookup->SetTableValue( 0  , 1 , 0 , 0 , 1 );
  _collookup->SetTableValue(128 , 0 , 0 , 1 , 1 );
  _collookup->SetTableValue(255 , 0 , 1 , 0 , 1 );

  _3DSliceMapper = vtkDataSetMapper::New( );
  _3DSliceMapper->SetInput(pFilter->GetOutput( ) );
  _3DSliceMapper->SetLookupTable( _bwlookup );
  _3DSliceMapper->SetScalarRange( _range );
  _3DSliceMapper->ImmediateModeRenderingOn( );

  _3DSliceActor = vtkActor::New( );
  _3DSliceActor->SetMapper( _3DSliceMapper );
  _pRenderer->AddActor( _3DSliceActor);

  _lstContVtk->InitListContourActor(nos);
  _lstContHealtyVtk->InitListContourActor(nos);
  
  this->SetAxis( allData );
}

//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
void vtk3DQuantSurfaceWidget::ShowMARACASDataAndAxeCT( marInterfaceCT* mar )
{
  marAxis			*temp;
  vtkPolyData		*allData;
  int nos;
  vtkProbeFilter	*pFilter;

  this->ShowMARACASDataCT( mar );
  this->ConfigureVTK();

  _pRenderer->SetBackground( 0.75, 0.75, 0.75 );

  // Axis
  _marCT->setAxis( 0 );
  temp		= _marCT->getAxis( );  // ??? getActualAxis ??
  allData	= temp->Draw( );

  nos		= _marCT->getNumberOfSlices( );
  pFilter	= _marCT->get3DSlice( (int) (nos-1)/2 );

  _bwlookup = vtkWindowLevelLookupTable::New( );
  _bwlookup->SetHueRange( 0 , 1 );
  _bwlookup->SetNumberOfColors( (int)(_range[1] - _range[0] + 1) );
  _bwlookup->SetTableRange( _range[0] , _range[1] );
  _bwlookup->SetSaturationRange( 0 , 0 );
  _bwlookup->SetValueRange( 0 , 1 );
  _bwlookup->SetAlphaRange( 1 , 1 );
  _bwlookup->Build( );

  _collookup = vtkLookupTable::New( );
  _collookup->SetNumberOfColors( 256 );
  _collookup->SetTableRange( 0 , 255 );
  _collookup->Build( );
  _collookup->SetTableValue( 0  , 1 , 0 , 0 , 1 );
  _collookup->SetTableValue(128 , 0 , 0 , 1 , 1 );
  _collookup->SetTableValue(255 , 0 , 1 , 0 , 1 );

  _3DSliceMapper = vtkDataSetMapper::New( );
  _3DSliceMapper->SetInput(pFilter->GetOutput( ) );
  _3DSliceMapper->SetLookupTable( _bwlookup );
  _3DSliceMapper->SetScalarRange( _range );
  _3DSliceMapper->ImmediateModeRenderingOn( );

  _3DSliceActor = vtkActor::New( );
  _3DSliceActor->SetMapper( _3DSliceMapper );
  _pRenderer->AddActor( _3DSliceActor);

  _lstContVtk->InitListContourActor(nos);
  _lstContHealtyVtk->InitListContourActor(nos);
  
  this->SetAxis( allData );
}

//----------------------------------------------------------------------------

void vtk3DQuantSurfaceWidget::SetBWLookUp(){
  _3DSliceMapper->SetLookupTable( _bwlookup );
  _pRenderWindow->Render( );
}    
//----------------------------------------------------------------------------
void vtk3DQuantSurfaceWidget::SetColorLookUp(){
  _3DSliceMapper->SetLookupTable( _collookup );
  _pRenderWindow->Render( );
}
//----------------------------------------------------------------------------
void vtk3DQuantSurfaceWidget::SetImage( vtkProbeFilter* pFilter )
{
  _3DSliceMapper->SetInput(pFilter->GetOutput( ) );
}
//----------------------------------------------------------------------------
void vtk3DQuantSurfaceWidget::Show3DSliceActor( )
{
  _pRenderer->AddActor( _3DSliceActor );
  _pRenderWindow->Render( );
}
//----------------------------------------------------------------------------
void vtk3DQuantSurfaceWidget::Hide3DSliceActor( )
{
  _pRenderer->RemoveActor( _3DSliceActor );
  _pRenderWindow->Render( );
}
//----------------------------------------------------------------------------
void vtk3DQuantSurfaceWidget::InitListContourActor(int type, int nos){
	if ((type==0) || (type==-1)){ _lstContVtk->InitListContourActor(nos); }
	if ((type==1) || (type==-1)){ _lstContHealtyVtk->InitListContourActor(nos); }
}
//----------------------------------------------------------------------------
void vtk3DQuantSurfaceWidget::Show3DContourActor( int type ){
	if (type==0){ _lstContVtk->Show3DContourActor(); }
	if (type==1){ _lstContHealtyVtk->Show3DContourActor(); }
}
//----------------------------------------------------------------------------
void vtk3DQuantSurfaceWidget::Hide3DContourActor( int type ){
	if (type==0){ _lstContVtk->Hide3DContourActor(); }
	if (type==1){ _lstContHealtyVtk->Hide3DContourActor(); }
}
//----------------------------------------------------------------------------
void vtk3DQuantSurfaceWidget::Set3DContourActor( int slice, vtkPoints* contour3D, bool showActor , int type){
	if (type==0) { _lstContVtk->Set3DContourActor(slice,contour3D,showActor);       }
	if (type==1) { _lstContHealtyVtk->Set3DContourActor(slice,contour3D,showActor); }
}
//----------------------------------------------------------------------------
void vtk3DQuantSurfaceWidget::Erase3DContourActor( int slice){
	_lstContVtk->EraseSliceContourActor(slice);
}
//----------------------------------------------------------------------------
void vtk3DQuantSurfaceWidget::Show3DHealthySliceActor( )
{
  _pRenderer->AddActor( _hs_rectGuide->_actor );
  _pRenderWindow->Render( );
}
//----------------------------------------------------------------------------
void vtk3DQuantSurfaceWidget::Hide3DHealthySliceActor( )
{
  _pRenderer->RemoveActor( _hs_rectGuide->_actor );
  _pRenderWindow->Render( );
}
//----------------------------------------------------------------------------
void vtk3DQuantSurfaceWidget::Set3DSliceActor( RectangleGuideVtk *_rectGuide ,float scale, int k,int r,int g,int b){
	int		sizeIma;
	double	dimIma;
	double	*o;  // Origen
	double	*c;  // Center
	double	*n;  // Normal

	double	ori[3];
	double	p1[3];
	double	p2[3];

	sizeIma = _mar->_experiment->getAxis( )->getParameters( )->getSizeIma( );
	dimIma	= _mar->_experiment->getAxis( )->getParameters( )->getDimIma( );
    o		= _mar->_experiment->getAxis( )->getSplinePoint(k);  
    c		= _mar->_experiment->getAxis( )->getSplinePoint(k);  
    n		= _mar->_experiment->getAxis( )->getNormal(k);  

    vtkPlaneSource* pSource = vtkPlaneSource::New( );
    pSource->SetOrigin( o[0]				, o[1], o[2]				);
    pSource->SetPoint1( o[0]+dimIma*scale - 1.0	, o[1], o[2]				);
    pSource->SetPoint2( o[0]				, o[1], o[2]+dimIma*scale - 1.0	);
    pSource->SetResolution( sizeIma - 1	, sizeIma - 1	);
    pSource->Update( );
    pSource->SetCenter( c[ 0 ], c[ 1 ], c[ 2 ] );
    pSource->SetNormal( n[ 0 ], n[ 1 ], n[ 2 ] );
    pSource->Update( );
	pSource->GetOrigin( ori	);
    pSource->GetPoint1( p1	);
    pSource->GetPoint2( p2	);

	if (_rectGuide->_actor)		_pRenderer->RemoveActor(_rectGuide->_actor);
	if (_rectGuide->_grid)		_rectGuide->_grid->Delete();
	if (_rectGuide->_actor)		_rectGuide->_actor->Delete();
	if (_rectGuide->_points)	_rectGuide->_points->Delete();
	if (_rectGuide->_mapper)	_rectGuide->_mapper->Delete();
	if (_rectGuide->_poly_line)	_rectGuide->_poly_line->Delete();

	_rectGuide->_poly_line = vtkPolyLine::New();
	( _rectGuide->_poly_line->GetPointIds() )->SetNumberOfIds(8);
	( _rectGuide->_poly_line->GetPointIds() )->SetId(0,0);
	( _rectGuide->_poly_line->GetPointIds() )->SetId(1,1);
	( _rectGuide->_poly_line->GetPointIds() )->SetId(2,2);
	( _rectGuide->_poly_line->GetPointIds() )->SetId(3,3);
	( _rectGuide->_poly_line->GetPointIds() )->SetId(4,4);
	( _rectGuide->_poly_line->GetPointIds() )->SetId(5,5);
	( _rectGuide->_poly_line->GetPointIds() )->SetId(6,6);
	( _rectGuide->_poly_line->GetPointIds() )->SetId(7,7);

	_rectGuide->_points=vtkPoints::New();
	_rectGuide->_points->InsertNextPoint( ori[0]			, ori[1]					, ori[2]			);
	_rectGuide->_points->InsertNextPoint( p1[0]				, p1[1]						, p1[2]				);
	_rectGuide->_points->InsertNextPoint( p2[0]+p1[0]-ori[0], p2[1]+p1[1]-ori[1]		, p2[2]+p1[2]-ori[2]);
	_rectGuide->_points->InsertNextPoint( p2[0]				, p2[1]						, p2[2]				);
	_rectGuide->_points->InsertNextPoint( ori[0]			, ori[1]					, ori[2]			);
	_rectGuide->_points->InsertNextPoint( p2[0]+p1[0]-ori[0], p2[1]+p1[1]-ori[1]		, p2[2]+p1[2]-ori[2]);
	_rectGuide->_points->InsertNextPoint( p1[0]				, p1[1]						, p1[2]				);
	_rectGuide->_points->InsertNextPoint( p2[0]				, p2[1]						, p2[2]				);

	_rectGuide->_grid=vtkUnstructuredGrid::New();
	_rectGuide->_grid->Allocate(1,1);
	_rectGuide->_grid->InsertNextCell( _rectGuide->_poly_line->GetCellType() , _rectGuide->_poly_line->GetPointIds() );
	_rectGuide->_grid->SetPoints( _rectGuide->_points );

	_rectGuide->_mapper = vtkDataSetMapper::New();
	_rectGuide->_mapper->SetInput(_rectGuide->_grid);
	_rectGuide->_mapper->ImmediateModeRenderingOn();

	_rectGuide->_actor=vtkActor::New();
	_rectGuide->_actor->SetMapper(_rectGuide->_mapper);
	_rectGuide->_actor->GetProperty()->BackfaceCullingOn();
	_rectGuide->_actor->GetProperty()->SetDiffuseColor(r,g,b);
	_rectGuide->_actor->PickableOff( );
	_rectGuide->_iSlice = k;
}
//----------------------------------------------------------------------------
void vtk3DQuantSurfaceWidget::Set3DHealthySliceActor(  ){
	int k = _mar->_experiment->getAxis( )->getHealthySlice();
	Set3DSliceActor( _hs_rectGuide , 1.0 , k ,0,0,1);
}

//----------------------------------------------------------------------------
void vtk3DQuantSurfaceWidget::Set3DRegionSliceActor( int type , int k1, int k2 ){
	Set3DStartRegionSliceActor(type, k1);
	Set3DEndRegionSliceActor(type, k2);
}
//----------------------------------------------------------------------------
void vtk3DQuantSurfaceWidget::Set3DStartRegionSliceActor( int type , int k ){
	if (type==0){
		Set3DSliceActor( _s1_rectGuide , 0.3 , k ,1,0,0);
		_mar->_experiment->getAxis()->setStartQuant(k);
	}
	if (type==1){
		Set3DSliceActor( _sA_rectGuide , 0.3 , k ,1,1,0);
	}
}
//----------------------------------------------------------------------------
void vtk3DQuantSurfaceWidget::Set3DEndRegionSliceActor( int type , int k ){
	if (type==0){
		Set3DSliceActor( _s2_rectGuide , 0.3 , k ,1,0,0);
		_mar->_experiment->getAxis()->setFinishQuant(k);
	}
	if (type==1){
		Set3DSliceActor( _sB_rectGuide , 0.3 , k ,1,1,0);
	}
}
//----------------------------------------------------------------------------
void vtk3DQuantSurfaceWidget::Show3DRegionSliceActor( int type ){
	Show3DStartRegionSliceActor(type);
	Show3DEndRegionSliceActor(type);
}
//----------------------------------------------------------------------------
void vtk3DQuantSurfaceWidget::Show3DStartRegionSliceActor( int type ){
	if ((type==0) && (_s1_rectGuide->_iSlice!=-1)){
		_pRenderer->AddActor( _s1_rectGuide->_actor );
		_s1_rectGuide->_showActor=true;
	}
	if ((type==1) && (_sA_rectGuide->_iSlice!=-1)){
		_pRenderer->AddActor( _sA_rectGuide->_actor );
		_sA_rectGuide->_showActor=true;
	}
  _pRenderWindow->Render( );
}
//----------------------------------------------------------------------------
void vtk3DQuantSurfaceWidget::Show3DEndRegionSliceActor( int type ){
	if ((type==0) && (_s2_rectGuide->_iSlice!=-1)){
		_pRenderer->AddActor( _s2_rectGuide->_actor );
		_s2_rectGuide->_showActor=true;
	}
	if ((type==1) && (_sB_rectGuide->_iSlice!=-1)){
		_pRenderer->AddActor( _sB_rectGuide->_actor );
		_sB_rectGuide->_showActor=true;
	}
  _pRenderWindow->Render( );
}
//----------------------------------------------------------------------------
void vtk3DQuantSurfaceWidget::Hide3DRegionSliceActor( int type ){
	Hide3DStartRegionSliceActor(type );
	Hide3DEndRegionSliceActor(type );
}
//----------------------------------------------------------------------------
void vtk3DQuantSurfaceWidget::Hide3DStartRegionSliceActor( int type ){
	if (type==0){
		if (_s1_rectGuide->_showActor==true){
			_pRenderer->RemoveActor( _s1_rectGuide->_actor );
			_s1_rectGuide->_showActor=false;
		}
	}
	if (type==1){
		if (_sA_rectGuide->_showActor==true){
			_pRenderer->RemoveActor( _sA_rectGuide->_actor );
			_sA_rectGuide->_showActor=false;
		}
	}
	_pRenderWindow->Render( );
}
//----------------------------------------------------------------------------
void vtk3DQuantSurfaceWidget::Hide3DEndRegionSliceActor( int type ){
	if (type==0){
		if (_s2_rectGuide->_showActor==true){
			_pRenderer->RemoveActor( _s2_rectGuide->_actor );
  			_s2_rectGuide->_showActor=false;
		}
	}
	if (type==1){
		if (_sB_rectGuide->_showActor==true){
			_pRenderer->RemoveActor( _sB_rectGuide->_actor );
  			_sB_rectGuide->_showActor=false;
		}
	}
	_pRenderWindow->Render( );
}
//----------------------------------------------------------------------------
void vtk3DQuantSurfaceWidget::GetSliceLimites(int type, int &sliceStart,int &sliceEnd){
	if (type==0){
		sliceStart	= _s1_rectGuide->_iSlice;
		sliceEnd	= _s2_rectGuide->_iSlice;
	}
	if (type==1){
		sliceStart	= _sA_rectGuide->_iSlice;
		sliceEnd	= _sB_rectGuide->_iSlice;
	}
}
//--------------------------------------------------------------------
int vtk3DQuantSurfaceWidget::GetAnalysisTypeStenosis(){
	return _analysisTypeStenosis;
}
//--------------------------------------------------------------------
void vtk3DQuantSurfaceWidget::SetAnalysisTypeStenosis(int analysisTypeStenosis){
	_analysisTypeStenosis=analysisTypeStenosis;
}



