/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: vtk3DQuantSurfaceWidget.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:18 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#ifndef __VTK3DQUANTSURFACEWIDGET__
#define __VTK3DQUANTSURFACEWIDGET__





#include "vtk3DSurfaceWidget.h"
#include "kernel/marInterface.h"
#include "kernel/marInterfaceCT.h"
#include <vtkDataSetMapper.h>
#include <vtkActor.h>
#include <vtkProbeFilter.h>
#include <vtkWindowLevelLookupTable.h>
#include <vtkLookupTable.h>

#include <vtkPolyLine.h>

//----------------------------------------------------------------------------

class RectangleGuideVtk{
public:
	RectangleGuideVtk();
	~RectangleGuideVtk();
	bool					_showActor;
	vtkActor*				_actor;
	vtkPoints*				_points;
	vtkPolyLine*			_poly_line;
    vtkDataSetMapper*		_mapper;
	vtkUnstructuredGrid*	_grid; 
	int						_iSlice;
};

//----------------------------------------------------------------------------

class vtk3DQuantSurfaceWidget;

class listContourVTK {
public:
	listContourVTK(vtk3DQuantSurfaceWidget *quantSurfaceWidget);
	~listContourVTK();
	void EraseListContourActor();
	void EraseSliceContourActor(int slice, bool refresh=true);
	void InitListContourActor(int nos);
	void Set3DContourActor( int slice, vtkPoints* contour3D, bool showActor);
	void Show3DContourActor();
	void Hide3DContourActor();
	void SetColour(int r,int g,int b);

private:
	int _r,_g,_b;
	vtk3DQuantSurfaceWidget *_vtk3DQuantSurfaceWidget;
	std::vector< vtkActor* >			_lst3DContoursVtkActor;
	std::vector< vtkUnstructuredGrid* >	_lst3DContoursVtkUnstructuredGrid;
	std::vector< vtkDataSetMapper* >	_lst3DContoursVtkDataSetMapper;
	std::vector< vtkPolyLine* >			_lst3DContoursVtkPolyLine;
};
//----------------------------------------------------------------------------


/**
 * \brief Class that brigde to VTK, override double click...
 */
class vtk3DQuantSurfaceWidget : public vtk3DSurfaceWidget
{
public:

    vtk3DQuantSurfaceWidget(
        wxWindow* parent,
        wxWindowID id,
        const	wxPoint& pos	= wxDefaultPosition,
        const	wxSize& size	= wxDefaultSize,
        long	style			= 0,
        const	wxString& name	= wxPanelNameStr
        );
    ~vtk3DQuantSurfaceWidget();
    void ShowMARACASDataAndAxe( marInterface* mar );
	void ShowMARACASDataAndAxeCT( marInterfaceCT* mar);

    void SetImage( vtkProbeFilter* pFilter );


	void InitListContourActor( int type, int nos);
    void Show3DContourActor( int type=0 );
    void Hide3DContourActor( int type=0 );
	void Set3DContourActor( int slice, vtkPoints* contour3D, bool showActor, int type=0 );
	void Erase3DContourActor( int slice);

    void Show3DSliceActor( );
    void Hide3DSliceActor( );

    void SetColorLookUp( );
    void SetBWLookUp( );

	void Show3DHealthySliceActor();
	void Hide3DHealthySliceActor();
	void Set3DHealthySliceActor( );

	void Set3DRegionSliceActor( int type, int k1,int k2 );
	void Set3DStartRegionSliceActor( int type, int k );
	void Set3DEndRegionSliceActor( int type, int k );

	void Show3DRegionSliceActor(int type );
	void Show3DStartRegionSliceActor(int type );
	void Show3DEndRegionSliceActor(int type );

	void Hide3DRegionSliceActor(int type );
	void Hide3DStartRegionSliceActor(int type );
	void Hide3DEndRegionSliceActor(int type );
   
	void GetSliceLimites(int type, int &sliceStart,int &sliceEnd);

	int  GetAnalysisTypeStenosis();
	void SetAnalysisTypeStenosis(int analysisTypeStenosis);


	vtkRenderer*		QuantSurfaceWidget_GetRenderer() {return _pRenderer; };
	vtkRenderWindow*	QuantSurfaceWidget_GetRenderWindow() {return _pRenderWindow; };

protected:

    vtkDataSetMapper					*_3DSliceMapper;
    vtkActor							*_3DSliceActor;

	RectangleGuideVtk					*_hs_rectGuide;
	RectangleGuideVtk					*_s1_rectGuide;
	RectangleGuideVtk					*_s2_rectGuide;
	RectangleGuideVtk					*_sA_rectGuide;
	RectangleGuideVtk					*_sB_rectGuide;

    vtkWindowLevelLookupTable*			_bwlookup;
    vtkLookupTable*						_collookup;


private:

	int				_analysisTypeStenosis;
	listContourVTK  *_lstContVtk;
	listContourVTK  *_lstContHealtyVtk;

//    DECLARE_EVENT_TABLE( );
	void Set3DSliceActor( RectangleGuideVtk *_rectGuide ,float scale, int k,int r,int g,int b);
};

#endif //__VTK3DQUANTSURFACEWIDGET__
