/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: vtk3DSurfaceSTLWidget.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:18 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#ifndef __VTK3DSURFACESTLWIDGET__
#define __VTK3DSURFACESTLWIDGET__

#include "wxVTKRenderWindowInteractorEditContour.h"

#include "vtkImagePolyDataSeedConnectivity.h"
#include "vtkInteractorStyleCutter.h"
#include "kernel/marInterface.h"

#include <vtkImageData.h>
#include <vtkProperty2D.h>
#include <vtkPolyData.h>
#include <vtkActor.h>
#include <vtkMarchingCubes.h>
#include <vtkPolyDataMapper.h>
#include <vtkRenderer.h>
#include <vtkRenderWindow.h>
#include <vtkSphereSource.h>
#include <vtkOutlineFilter.h>
#include <vtkProperty.h>

/**
 * \brief Class that brigde to VTK, override double click...
 */
class vtk3DSurfaceSTLWidget : public wxVTKRenderWindowInteractor
{
public:

    vtk3DSurfaceSTLWidget(
        wxWindow* parent,
        wxWindowID id,
        const wxPoint& pos = wxDefaultPosition,
        const wxSize& size = wxDefaultSize,
        long style = 0,
        const wxString& name = wxPanelNameStr
        );
    ~vtk3DSurfaceSTLWidget();

//EED Borrame
//    void OnLeftDClick( wxMouseEvent& event );

    void ConfigureVTK( );

    bool IntersectPlaneWithLine( double* p, double* x1, double* x2, double* x3, double* x4, double* x5 );
    bool FindCubePointsFromPoints( double* pO, double* pF, double* pickPoint, double* cameraPos );
    bool GetPointAndNormalIntersection( double* p, double* n, double* pO, double* pF );
    
    void ShowMARACASData( marInterface* mar );
	void ShowMARACASDataAndAxe( marInterface* mar );
    void SetSurfaceColor(float red, float green, float blue );
    void SetSurfaceVisibility( bool visible );
    void SetSTLSurfaceVisibility( bool intvisible , bool extvisible);
    void SetSurfaceIsoValue( int isoval );
    void SetSurfaceOpacity( int opaval );

    void GetSphereCenter( double center[3] );
    void SetAxis( vtkPolyData *axis );
    void RemoveAxis( );

    void ConstructVessel();
    void SetCuttingMode( bool mode );
    void ExportSurfaceAsSTL( const char* fileprefix );

    ///\todo remove
    vtkImageData	*_marImageData;
    vtkPolyData		*_marPolyData;

    void SetSTLThresholdRatio(double ratio);
    float GetSTLThreshold();
    vtkGetMacro(InitialSphere, int);
    
protected:

    void SetInitialPoint( double* pickPoint, double* cameraPos );
    void SetInitialPoint( double* point );
    vtkPolyData* ConvertMarAxisToPolyData();
    
    vtkImagePolyDataSeedConnectivity *_psc;

    marInterface		*_mar;
    vtkRenderer			*_pRenderer;
    vtkRenderWindow		*_pRenderWindow;
    vtkOutlineFilter	*_outLine;
    vtkPolyDataMapper	*_outMapper;
    vtkActor			*_outActor;
    vtkMarchingCubes	*_mCubes;
    vtkPolyDataMapper	*_surfMapper;
    vtkActor			*_surfActor;

    vtkPolyData			*_centralLine;
    vtkPolyDataMapper	*_centralLineMapper;
    vtkActor			*_centralLineActor;

    vtkSphereSource		*_spheres[ 4 ];
    vtkPolyDataMapper	*_spheresMapper[ 4 ];
    vtkActor			*_spheresActor[ 4 ];

    vtkPolyDataMapper	*_axesMapper;
    vtkActor			*_axesActor;

    vtkActor			*_actorVessel;
    vtkActor			*_actorExternalVessel;
    //We should keep internal and external as different mesh to be able
    //to save them in difference files at the end of process:
    vtkPolyData			*_stlInternalVessel;
    vtkPolyData			*_stlExternalVessel;
    vtkInteractorStyleCutter *_iasc;

private:

    int _width;
    int _height;
    int _depth;
    int InitialSphere;

    DECLARE_EVENT_TABLE( );

};

#endif //__VTK3DSURFACESTLWIDGET__
