/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: vtk3DSurfaceWidget.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:18 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#ifndef __VTK3DSURFACEWIDGET__
#define __VTK3DSURFACEWIDGET__

#include "wxVTKRenderWindowInteractorEditContour.h"

#include "vtkImagePolyDataSeedConnectivity.h"
#include "vtkInteractorStyleCutter.h"
#include "marInterface.h"
#include "kernel/marInterfaceCT.h"
#include "InterfaceVtkPanelWidgets.h"

#include <vtkImageData.h>
#include <vtkProperty2D.h>
#include <vtkPolyData.h>
#include <vtkActor.h>
#include <vtkMarchingCubes.h>
#include <vtkPolyDataMapper.h>
#include <vtkRenderer.h>
#include <vtkRenderWindow.h>
#include <vtkSphereSource.h>
#include <vtkOutlineFilter.h>
#include <vtkProperty.h>


//------------------------------------------------------------------
//------------------------------------------------------------------
//------------------------------------------------------------------

/**
 * \brief Class that brigde to VTK, override double click...
 */
class vtk3DSurfaceWidget : public wxVTKRenderWindowInteractor
{
public:

    vtk3DSurfaceWidget(
        wxWindow* parent,
        wxWindowID id,
        const wxPoint& pos = wxDefaultPosition,
        const wxSize& size = wxDefaultSize,
        long style = 0,
        const wxString& name = wxPanelNameStr
        );
    ~vtk3DSurfaceWidget();
    void OnLeftDClick( wxMouseEvent& event );	
	virtual void OnMouseWheel( wxMouseEvent& event );
    void Render( );

    void ConfigureVTK( );

    void ShowMARACASData( marInterface* mar );
	void ShowMARACASDataCT( marInterfaceCT* mar );
    void SetSurfaceColor(float red, float green, float blue );
    void SetSurfaceVisibility( bool visible );
    void SetSurfaceIsoValue( int isoval );
    void SetSurfaceOpacity( int opaval );

    void GetSphereCenter( double center[3] );
    void SetAxis( vtkPolyData *axis );
    void RemoveAxis( );

    ///\todo remove
    vtkImageData* _marImageData;
    vtkPolyData* _marPolyData;

    vtkGetMacro(InitialSphere, int);

    void SetInterfaceVtkPanelWidgets(InterfaceVtkPanelWidgets * intVtkPanWid) {_intVtkPanWid=intVtkPanWid;};
    void SetInitialPoint();
	void GetLast3DClickPoint( double *pp, double *cp );
	void InitCameraReset( );
	vtkRenderer *GetRenderer();

protected:

    void SetInitialPoint( float* pickPoint, float* cameraPos );
	void SetLast3DClickPoint( double *pp, double *cp );

    marInterface				*_mar;
	marInterfaceCT				*_marCT;
    vtkRenderer					*_pRenderer;
    vtkRenderWindow				*_pRenderWindow;
    vtkOutlineFilter			*_outLine;
    vtkPolyDataMapper			*_outMapper;
    vtkActor					*_outActor;
    vtkMarchingCubes			*_mCubes;
    vtkPolyDataMapper			*_surfMapper;
    vtkActor					*_surfActor;

    vtkPolyData					*_centralLine;
    vtkPolyDataMapper			*_centralLineMapper;
    vtkActor					*_centralLineActor;

    vtkSphereSource				*_spheres[ 4 ];
    vtkPolyDataMapper			*_spheresMapper[ 4 ];
    vtkActor					*_spheresActor[ 4 ];

    vtkPolyDataMapper			*_axesMapper;
    vtkActor					*_axesActor;

    double						_range[2];

	InterfaceVtkPanelWidgets	*_intVtkPanWid;

private:

    int		_width;
    int		_height;
    int		_depth;
    int		InitialSphere;
	float	_lastPickPoint[3];
	float	_lastCameraPos[3];

    DECLARE_EVENT_TABLE( );

};

#endif //__VTK3DSURFACEWIDGET__
