/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: vtkImagePolyDataSeedConnectivity.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:18 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// .NAME vtkImagePolyDataSeedConnectivity - create 
// .SECTION Description
//

#ifndef __vtkImagePolyDataSeedConnectivity_h
#define __vtkImagePolyDataSeedConnectivity_h

#include <vtkStructuredPointsToPolyDataFilter.h>

class vtkPolyData;

class vtkImagePolyDataSeedConnectivity : public vtkStructuredPointsToPolyDataFilter
{
public:
  static vtkImagePolyDataSeedConnectivity *New();
  vtkTypeRevisionMacro(vtkImagePolyDataSeedConnectivity,vtkStructuredPointsToPolyDataFilter);
  void PrintSelf(ostream& os, vtkIndent indent);

  // Description:
  // Set axis
  virtual void SetAxis(vtkPolyData*);
  vtkGetObjectMacro(Axis,vtkPolyData);

  // Description:
  // Set threshold ratio, by default .45
  vtkSetMacro(ThresholdRatio,double);
  vtkGetMacro(ThresholdRatio,double);

  // Description:
  // Get outer mold
  vtkGetObjectMacro(OuterMold,vtkPolyData);

protected:
  vtkImagePolyDataSeedConnectivity();
  ~vtkImagePolyDataSeedConnectivity();

  void Execute();
  void ClipImageWithAxis();

  double ThresholdRatio;

  vtkPolyData *Axis;
  //image data that has been clip with polydata
  vtkImageData *ClipImageData;
  vtkPolyData *OuterMold;
private:
  vtkImagePolyDataSeedConnectivity(const vtkImagePolyDataSeedConnectivity&);  // Not implemented.
  void operator=(const vtkImagePolyDataSeedConnectivity&);  // Not implemented.
};

#endif


