/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   Visualization Toolkit
  Module:    $RCSfile: vtkInteractorStyleCutter.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:18 $
  Version:   $Revision: 1.2 $

  Copyright (c) 1993-2002 Ken Martin, Will Schroeder, Bill Lorensen 
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// .NAME vtkInteractorStyleCutter - 
// .SECTION Description
// This interactor style allows the user to draw a rectangle in the render
// window using the left mouse button.  

#ifndef __vtkInteractorStyleCutter_h
#define __vtkInteractorStyleCutter_h

#include <vtkVersionMacros.h>
#include <vtkInteractorStyle.h>

class vtkPoints;
class vtkActor2D;
class vtkCellArray;

class vtkInteractorStyleCutter : public vtkInteractorStyle
{
public:
  // Description:
  // Instantiate the object.
  static vtkInteractorStyleCutter *New();
  vtkTypeRevisionMacro(vtkInteractorStyleCutter, vtkInteractorStyle);
  void PrintSelf(ostream& os, vtkIndent indent);
  
  // Description:
  // Event bindings controlling the effects of pressing mouse buttons
  // or moving the mouse.
  virtual void OnMouseMove();
  virtual void OnLeftButtonDown();
  virtual void OnRightButtonDown();
  void VisibilityOff();
  
  vtkGetObjectMacro(LoopPoints,vtkPoints);
  vtkGetVector3Macro(Direction,double);
  
protected:
  vtkInteractorStyleCutter();
  ~vtkInteractorStyleCutter();

  //This method is designed for vtkImplicitSelectionLoop where the loop
  //should not be closed, the function is virtual to override this behavior
  virtual void EndLoop();
  void Initialize();

  int CurrentPosition[2];
  double Direction[3];

  //Points selected by the user
  vtkPoints *Points;

  //Current point id:
  vtkIdType PointID;

  //bool which determine if user has press the left button first
  int Moving;
  
  vtkActor2D	*BboxActor;
  vtkCellArray	*Lines;
  vtkPoints		*LoopPoints;
  
private:
  vtkInteractorStyleCutter(const vtkInteractorStyleCutter&);  // Not implemented
  void operator=(const vtkInteractorStyleCutter&);  // Not implemented
};

#endif
