/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "vtkActor.h"
#include "vtkCylinderSource.h"
#include "vtkPolyDataMapper.h"
#include "vtkRenderer.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkProperty.h"
#include "vtkCamera.h"
#include "vtkPoints.h"
#include "vtkCellArray.h"
#include "vtkPolyData.h"
#include "vtkPolyDataMapper.h"
#include "vtkPolyDataWriter.h"
#include "vtkPolyDataReader.h"
#include "vtkImageReader.h"
#include "vtkImageViewer.h"
#include "vtkImageViewer2.h"
#include "vtkImageToStructuredPoints.h"


#include "vtkExtractVOI.h"
#include "vtkImageClip.h"
#include "vtkImageResample.h"
#include "vtkImageThreshold.h"
#include "vtkImageCast.h"
#include "vtkImageSeedConnectivity.h"
#include "vtkImageData.h"
#include "vtkMarchingCubes.h"
#include "vtkImageReslice.h"
#include "vtkTransform.h"
#include "vtkSphereSource.h"
#include "vtkDoubleArray.h"
#include "vtkPointData.h"
#include "vtkCommand.h"
#include "vtkCallbackCommand.h"
#include "vtkImageResample.h"
#include "vtkMath.h"
#include "vtkStripper.h"


#include "wxEmptyPanelWidget.h"

#include <wx/splitter.h>

//-------------------------------------------------------------------
//-------------------------------------------------------------------
//-------------------------------------------------------------------
wxEmptyPanelWidget::wxEmptyPanelWidget(wxWindow *parent)
: wxPanel( parent, -1) 
{
	wxBoxSizer			*sizer			= new wxBoxSizer(wxVERTICAL  );
    wxSplitterWindow	*pnlSplitter	= new wxSplitterWindow( this , -1);
	wxPanel				*viewPanel		= CreateViewPanel(pnlSplitter);
	wxPanel				*controlPanel	= CreateControlPanel(pnlSplitter);

	sizer		-> Add( pnlSplitter ,1,wxGROW  ,0);
	pnlSplitter	-> SetMinimumPaneSize( 150 );
    pnlSplitter	-> SplitVertically( viewPanel, controlPanel, 600 );
	this		-> SetSizer(sizer);

	// Original Volule
	_mCubes			= NULL;
	_surfMapper		= NULL;
	_surfActor		= NULL;

	// Result: Volume + Axis
	_prgov			= NULL;
	_mapfinal		= NULL;
	_stripfinal		= NULL;
	_isoMapperMC6	= NULL;
	_isoActorMC6	= NULL;
	_isoMC6			= NULL;
}
//-------------------------------------------------------------------
wxEmptyPanelWidget::~wxEmptyPanelWidget(){

	// Original Volule
	_mCubes			-> Delete();
	_surfMapper		-> Delete();
	_surfActor		-> Delete();

	// Result: Volume + Axis
	_prgov			-> Delete();
	_mapfinal		-> Delete();
	_stripfinal		-> Delete();
	_isoMapperMC6	-> Delete();
	_isoActorMC6	-> Delete();
	_isoMC6			-> Delete();
}
//-------------------------------------------------------------------
wxPanel* wxEmptyPanelWidget::CreateViewPanel(wxWindow *parent)
{
	wxPanel *panel		=	new wxPanel(parent,-1);
    wxBoxSizer *sizer	=	new wxBoxSizer(wxVERTICAL);

	_imageviewer3D = new wxVtk3DBaseView(panel);
	wxVTKRenderWindowInteractor *iren = _imageviewer3D->GetWxVTKRenderWindowInteractor();	
	sizer->Add(iren , 1, wxEXPAND, 0);

	panel->SetSizer(sizer);
	panel->SetAutoLayout(true);
	panel->SetSize(400,400);
	panel->Layout();
	return panel;
}
//-------------------------------------------------------------------
wxPanel* wxEmptyPanelWidget::CreateControlPanel(wxWindow *parent)
{
	wxPanel *panel	= new wxPanel(parent,-1);
	_opacity1		= new wxSlider( panel, -1, 50, 0, 100 , wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );
	_isoValue		= new wxSlider( panel, -1, 0 , 0, 3000, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );
	_opacity2		= new wxSlider( panel, -1, 50, 0, 100 , wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );
	_opacity1->SetSize(250,20);  // Original Volume
	_isoValue->SetSize(250,20);
	_opacity2->SetSize(250,20);  // Result Volume
    wxFlexGridSizer *sizer = new wxFlexGridSizer(1);
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("Isovalue - Original Volume")));	
	sizer->Add(_isoValue);
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("Opacity - Original Volume")));
	sizer->Add(_opacity1);
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("Opacity - Result Volume")));
	sizer->Add(_opacity2);

	panel->SetSizer(sizer);
	panel->SetAutoLayout(true);
	panel->SetSize(400,400);
	panel->Layout();
	Connect(_opacity1->GetId()  , wxEVT_COMMAND_SLIDER_UPDATED  , (wxObjectEventFunction) &wxEmptyPanelWidget::OnOpacity1 ); 
	Connect(_isoValue->GetId()  , wxEVT_SCROLL_THUMBRELEASE		, (wxObjectEventFunction) &wxEmptyPanelWidget::OnIsoValue ); 
	Connect(_opacity2->GetId()  , wxEVT_COMMAND_SLIDER_UPDATED  , (wxObjectEventFunction) &wxEmptyPanelWidget::OnOpacity2 ); 
	return panel;
}
//------------------------------------------------------------------------
void wxEmptyPanelWidget::Refresh()
{
	_imageviewer3D->Refresh();
}
//------------------------------------------------------------------------

void wxEmptyPanelWidget::ConfigureVTK(vtkImageData *imagedata, int x, int y, int z)
{
    wxBusyCursor wait;
	_imageviewer3D->Configure();
	
	double puntoactualprov[3];
	puntoactualprov[0]=x;
	puntoactualprov[1]=y;
	puntoactualprov[2]=z;

	double espprin[3];
	int extprin[6];				
	
	imagedata->GetSpacing(espprin);
	imagedata->GetExtent(extprin);

	puntoactualprov[0]=puntoactualprov[0]*espprin[0];
	puntoactualprov[1]=puntoactualprov[1]*espprin[1];
	puntoactualprov[2]=puntoactualprov[2]*espprin[2];
	
	/* Old
	// Juan Francisco Carrillo Filter 
	_prgov= axisExtractor::New();
	_prgov->SetHumbral(0.45);
	_prgov->SetInput(imagedata);
	_prgov->SetPoint(puntoactualprov);
	_prgov->Update();
	*/

	// Juan Francisco Carrillo Filter 
	_prgov= axisExtractor02::New();
	_prgov->SetParam(1);
	_prgov->SetParam2(1);
	_prgov->SetParam3(0.5);
	_prgov->SetMaxant(20);
	_prgov->SetMinant(5);
	_prgov->SetInput(imagedata);
	_prgov->SetPoint(puntoactualprov);
	_prgov->Update();


	vtkPolyDataWriter *writer = vtkPolyDataWriter::New();
	writer->SetInput(_prgov->GetOutput());
    writer->SetFileName("c:/temp/salida_JF.vtk");
    writer->SetFileTypeToASCII();
    writer->Write();


	// Visualisation - result vascular tree
	_mapfinal = vtkPolyDataMapper::New();
	_mapfinal->SetInput(_prgov->GetOutput());

	_stripfinal = vtkActor::New();
	_stripfinal->SetMapper(_mapfinal);
	_stripfinal->GetProperty()->SetColor(1, 1, 1);
	_stripfinal->GetProperty()->SetLineWidth(2);

	_stripfinal->GetProperty()->BackfaceCullingOff();

	// Visualisation - result volume
	vtkImageData *imageOut = _prgov->GetVolumen();
	imageOut->Update();

    _isoMC6 = vtkMarchingCubes::New();
    _isoMC6->SetInput(imageOut);
    _isoMC6->SetValue(0, 1);
	_isoMC6->Update();

	_isoMapperMC6 = vtkPolyDataMapper::New();
    _isoMapperMC6->SetInput(_isoMC6->GetOutput());
    _isoMapperMC6->ScalarVisibilityOff();
    _isoMapperMC6->ImmediateModeRenderingOn();

	_isoActorMC6 = vtkActor::New();
    _isoActorMC6->SetMapper(_isoMapperMC6);
    _isoActorMC6->GetProperty()->SetColor( 0, 1, 0);
    _isoActorMC6->GetProperty()->SetOpacity(0.25);
 
	// Visualisation - original volume
    double range[2];
    imagedata->GetScalarRange( range );

    _mCubes = vtkMarchingCubes::New( );
    _mCubes->SetInput( imagedata );
    _mCubes->SetValue( 0, range[1] / 4 );

    vtkStripper *stripper = vtkStripper::New();
    stripper->SetInput( _mCubes->GetOutput( ) );

    _surfMapper = vtkPolyDataMapper::New( );
	_surfMapper->SetInput( stripper->GetOutput() );
    _surfMapper->ScalarVisibilityOff( );
    stripper->Delete();

    _surfActor = vtkActor::New( );
    _surfActor->SetMapper( _surfMapper );
    _surfActor->PickableOff( );
    _surfActor->GetProperty( )->SetColor( 0.9803, 0.9215, 0.8392 );
    _surfActor->GetProperty( )->SetOpacity( 0.3 );
		

	// Update Controls
	_isoValue->SetRange( (int)(range[0]), (int)(range[1]) );
	_isoValue->SetValue( (int)(range[1]/4) );
	_opacity1->SetValue( (int)(_surfActor->GetProperty( )->GetOpacity( )*100) );
	_opacity2->SetValue( (int)(_isoActorMC6->GetProperty( )->GetOpacity( )*100));
    
	// Interface Update
	vtkRenderer *ren = _imageviewer3D->GetRenderer();
	ren->AddActor(_surfActor);
	ren->AddActor(_isoActorMC6);
	ren->AddActor(_stripfinal);

}



//------------------------------------------------------------------------
void wxEmptyPanelWidget::OnOpacity1(wxScrollEvent& event){
	double value = ((double)_opacity1->GetValue())/100;
    _surfActor->GetProperty( )->SetOpacity( value );
	Refresh();
}
//------------------------------------------------------------------------
void wxEmptyPanelWidget::OnOpacity2(wxScrollEvent& event){
	double value = ((double)_opacity2->GetValue())/100;
    _isoActorMC6->GetProperty( )->SetOpacity( value );
	Refresh();
}
//------------------------------------------------------------------------
void wxEmptyPanelWidget::OnIsoValue(wxScrollEvent& event){
    wxBusyCursor wait;
	_mCubes->SetValue(0, _isoValue->GetValue());
	Refresh();
}
