/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef EMPTY_PANEL_WIDGET_H
#define EMPTY_PANEL_WIDGET_H



#include <vtkActor.h>
#include <vtkMarchingCubes.h>
#include <vtkPolyDataMapper.h>
#include <vtkImageData.h>



#include "wxVtkBaseView.h"
#include "wxVTKRenderWindowInteractor.h"
#include <kernel/axisExtractor02.h>

#include <wx/wx.h>
#include <wx/panel.h>

//------------------------------------------------------------------
//------------------------------------------------------------------
//------------------------------------------------------------------

class wxEmptyPanelWidget: public wxPanel{
public:
	wxEmptyPanelWidget(wxWindow *parent);
	~wxEmptyPanelWidget();
	void ConfigureVTK(vtkImageData *imagedata, int x, int y, int z);
	void Refresh();
	void OnOpacity1(wxScrollEvent& event); // Original Volume
	void OnOpacity2(wxScrollEvent& event); // Result Volume
	void OnIsoValue(wxScrollEvent& event);
private:

	// Original Volume
	vtkMarchingCubes	*_mCubes;
	vtkPolyDataMapper	*_surfMapper;
	vtkActor			*_surfActor;

	// Result volume + Axis
	axisExtractor02		*_prgov;
	vtkPolyDataMapper	*_mapfinal;
	vtkActor			*_stripfinal;
	vtkPolyDataMapper	*_isoMapperMC6;
	vtkActor			*_isoActorMC6;
	vtkMarchingCubes	*_isoMC6;


	wxSlider			*_opacity1;
	wxSlider			*_opacity2;
	wxSlider			*_isoValue;
	wxVtk3DBaseView		*_imageviewer3D;
	wxPanel				*CreateControlPanel(wxWindow *parent);
	wxPanel				*CreateViewPanel(wxWindow *parent);
};

#endif // EMPTY_PANEL_WIDGET_H




