/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef EMPTY_PANEL_WIDGET_2_H
#define EMPTY_PANEL_WIDGET_2_H

#include <vector>

#include <vtkImageData.h>
#include <vtkActor.h>
#include <vtkMarchingCubes.h>
#include <vtkPolyDataMapper.h>

#include "wxVTKRenderWindowInteractor.h"
#include "wxSurfaceWidget.h"
#include "wxVtkBaseView.h"
#include <kernel/marInterface.h>
#include <kernel/axisExtractor.h>
#include <kernel/axisExtractor02.h>
#include <kernel/carotidaBifurcacion.h>

//------------------------------------------------------------------
//------------------------------------------------------------------
//------------------------------------------------------------------

class  TreeExtraction_MH_JFC : public vtkObject
{
public:
	static TreeExtraction_MH_JFC *New();
	virtual void SetInput(marExperiment *input);
	void SetBranchLevel(int branchLevel);
	marExperiment *GetInput();
	vtkImageData  *GetVolume();
	void Update();
	void SetCleanTreeLevel( int cleanLevel );
  
protected:  
	TreeExtraction_MH_JFC();	
	~TreeExtraction_MH_JFC();
	void Execute( int count , int sens=1 , double *vit=NULL , int cleanLevel=0);

private:
	double					_cleanLevel;
	int						_branchLevel;
	carotidaBifurcacion		*_prgov;
	vtkImageData			*_imagedataResult;
	marExperiment			*_marExperiment;
	void Reset();
	void InitImagaDataResult();
	void BruleVolume( vtkImageData *imagedata, int x,int y,int z,int r,int value );
	void BruleVolume( vtkImageData *imagedata, vtkPolyData *inputAxisRadio,int value );
	void FindVit( marExperiment *newExperiment , int actualAxis , double *pointBif , double *vit );
};

//------------------------------------------------------------------
//------------------------------------------------------------------
//------------------------------------------------------------------

class wxEmptyPanelWidget_2: public wxPanel{
public:
	wxEmptyPanelWidget_2(wxWindow *parentmar,marInterface *mar);
	~wxEmptyPanelWidget_2();
	void ConfigureVTK();
	void Refresh();
	void OnOpacity_OrigVol(wxScrollEvent& event);		// Original Volume
	void OnOpacity_Res1VolJF(wxScrollEvent& event);		// Result 1 Volume JF
	void OnOpacity_Res2VolJF(wxScrollEvent& event);		// Result 2 Volume JF
	void OnIsoValue(wxScrollEvent& event);
	void OnBtnExtractTree1_JF(wxCommandEvent& event);
	void OnBtnExtractTree2_JF(wxCommandEvent& event);
	void OnBtnEraseTree1_JF(wxCommandEvent& event);
	void OnBtnEraseTree2_JF(wxCommandEvent& event);
	void OnBtnExtractTree_MH_JFC(wxCommandEvent& event);
	void OnBtnEraseTree_MH_JFC(wxCommandEvent& event);
	void OnOpacity_ResVolMHJF(wxScrollEvent& event);	// Result Volume MH+JFC
	void OnBranchLevel(wxScrollEvent& event);			// MH+JFC
	void OnIsoValue_MH_JFC(wxScrollEvent& event);
	void OnCleanTree_MH_JFC(wxScrollEvent& event);
	void OnSensibility(wxScrollEvent& event);

private:

	TreeExtraction_MH_JFC *_treeExtraction;

	// Original Volume
	vtkMarchingCubes	*_mCubes;
	vtkPolyDataMapper	*_surfMapper;
	vtkActor			*_surfActor;

	// Result 1 volume + Axis   
	axisExtractor		*_1_prgov;
	vtkPolyDataMapper	*_1_mapfinal;
	vtkActor			*_1_stripfinal;
	vtkPolyDataMapper	*_1_isoMapperMC6;
	vtkActor			*_1_isoActorMC6;
	vtkMarchingCubes	*_1_isoMC6;

	// Result 2 volume + Axis   
	axisExtractor02		*_2_prgov;
	vtkPolyDataMapper	*_2_mapfinal;
	vtkActor			*_2_stripfinal;
	vtkPolyDataMapper	*_2_isoMapperMC6;
	vtkActor			*_2_isoActorMC6;
	vtkMarchingCubes	*_2_isoMC6;
	double				_sensibility_JF;


	//	Result tree MH_JFC
	vtkPolyDataMapper	*_isoMapperMC1;
	vtkActor			*_isoActorMC1;
	vtkMarchingCubes	*_isoMC1;
	vtkImageThreshold	*_imageThresholdMC1;

	std::vector< vtkActor* >			_lstBranchActor;
	std::vector< vtkPolyData* >			_lstAxisVtk;
	std::vector< vtkPolyDataMapper* >	_lstBranchMapper;

	wxSlider			*_opacity_OrigVol;
	wxSlider			*_opacity_Res1VolJF;
	wxSlider			*_opacity_Res2VolJF;
	wxSlider			*_sl_sensibility_JF;
	wxSlider			*_isoValue;
	wxSlider			*_branchLevel;
	wxSlider			*_opacity_ResVolMHJF;
	wxSlider			*_isoValue_MH_JFC;
	wxSlider			*_cleanTree_MH_JFC;
	
	wxVtk3DBaseView		*_imageviewer3D;
	wxPanel				*CreateControlPanel(wxWindow *parent);
	wxPanel				*CreateViewPanel(wxWindow *parent);

	//Maracas
	marInterface		*_mar;
	wxSurfaceWidget		*_maracasSurfaceWidget;

	void ResetTree1_JF();
	void ResetTree2_JF();
	void ExtractTree1_JF(int x, int y, int z);
	void ExtractTree2_JF(int x, int y, int z);

	void ResetTree_MH_JFC();
	void PaintVascularTree_MH_JFC(marExperiment * newExperiment);
	void PaintVascularVolume_MH_JFC(vtkImageData * image);
	void WriteSignals(marExperiment *newExperiment);
};

#endif // EMPTY_PANEL_WIDGET_2_H




