/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

//EED 29Dic2006 Borrame prueba mara Michael

#include <vtkMetaImageReader.h>
#include <vtkMetaImageWriter.h>
#include <vtkPlaneSource.h>
#include <vtkProbeFilter.h>
#include <vtkDataSet.h>
#include <vtkStructuredPoints.h>
#include <vtkPointData.h>
#include <vtkImageResample.h>
#include <vtkJPEGWriter.h>
#include <vtkBMPWriter.h>
 


#include "vtkActor.h"
#include "vtkSphereSource.h"
#include "vtkPolyDataMapper.h"
#include "vtkImageData.h"
#include "vtkImageCast.h"

#include "wxEmptyPanel_3_Widget.h"



#include <wx/splitter.h>

//-------------------------------------------------------------------
//-------------------------------------------------------------------
//-------------------------------------------------------------------
BEGIN_EVENT_TABLE( wxEmptyPanel_3_Widget, wxPanel )
	EVT_MENU( 12121, wxEmptyPanel_3_Widget::OnRefreshView )
END_EVENT_TABLE( );
//-------------------------------------------------------------------
wxEmptyPanel_3_Widget::wxEmptyPanel_3_Widget(wxWindow *parent)
: wxPanel( parent, -1) 
{
	wxBoxSizer			*sizer			= new wxBoxSizer(wxVERTICAL  );
    wxSplitterWindow	*pnlSplitter	= new wxSplitterWindow( this , -1);
	wxPanel				*viewPanel		= CreateViewPanel(pnlSplitter);
	wxPanel				*controlPanel	= CreateControlPanel(pnlSplitter);

	sizer		-> Add( pnlSplitter ,1,wxGROW  ,0);
	pnlSplitter	-> SetMinimumPaneSize( 50 );
    pnlSplitter	-> SplitVertically( viewPanel, controlPanel );
	this		-> SetSizer(sizer);
//EEDxx2.4
//	FitInside();
}
//-------------------------------------------------------------------
wxEmptyPanel_3_Widget::~wxEmptyPanel_3_Widget(){
	delete _imageviewer2D_1;
}
//-------------------------------------------------------------------
wxPanel* wxEmptyPanel_3_Widget::CreateViewPanel(wxWindow *parent)
{
	wxPanel *panel		=	new wxPanel(parent,-1);
    wxBoxSizer *sizer	=	new wxBoxSizer(wxVERTICAL);

	_imageviewer2D_1	= new wxVtk2DBaseView(panel);
	wxVTKRenderWindowInteractor *iren   = _imageviewer2D_1->GetWxVTKRenderWindowInteractor();
	sizer->Add(iren , 1, wxEXPAND, 0);


	panel->SetSizer(sizer);
	panel->SetAutoLayout(true);
	panel->SetSize(400,400);
	panel->Layout();
	return panel;
}
//-------------------------------------------------------------------
wxPanel* wxEmptyPanel_3_Widget::CreateControlPanel(wxWindow *parent)
{
	_parent=parent;
	wxPanel *panel	= new wxPanel(parent,-1);

	wxButton *btnContourA	= new wxButton( panel, -1, _T("Active Contour A"));
	wxButton *btnContourB	= new wxButton( panel, -1, _T("Active Contour B"));
	wxButton *btnContourAB	= new wxButton( panel, -1, _T("Active Contour AB"));


    wxFlexGridSizer *sizer = new wxFlexGridSizer(1);
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(btnContourA);
	sizer->Add(btnContourB);
	sizer->Add(btnContourAB);

	panel->SetSizer(sizer);
	panel->SetAutoLayout(true);
	panel->SetSize(400,400);
	panel->Layout();
	Connect(btnContourA->GetId()		, wxEVT_COMMAND_BUTTON_CLICKED	, (wxObjectEventFunction) &wxEmptyPanel_3_Widget::OnContourA  );
	Connect(btnContourB->GetId()		, wxEVT_COMMAND_BUTTON_CLICKED	, (wxObjectEventFunction) &wxEmptyPanel_3_Widget::OnContourB  );
	Connect(btnContourAB->GetId()		, wxEVT_COMMAND_BUTTON_CLICKED	, (wxObjectEventFunction) &wxEmptyPanel_3_Widget::OnContourAB );
	return panel;
}
//------------------------------------------------------------------------
void wxEmptyPanel_3_Widget::Refresh()
{
	_imageviewer2D_1->Refresh();
}
//----------------------------------------------------------------------------
void wxEmptyPanel_3_Widget::OnRefreshView(wxCommandEvent & event)
{
	Refresh();
}


//------------------------------------------------------------------------

void wxEmptyPanel_3_Widget::ConfigureVTK(marImageData *marimagedata)
{
    wxBusyCursor wait;
	double spc[3];
	
	vtkImageData *vtkimagedata = marimagedata->GetImageData(); // image t=0
	vtkimagedata->UpdateInformation();
	vtkimagedata->SetUpdateExtent(vtkimagedata->GetWholeExtent());
	vtkimagedata->Update();
	_data = vtkimagedata;
	_data->GetSpacing(spc);
	_vtkbasedata_1 = new vtkBaseData();
	_vtkbasedata_1->SetMarImageData(marimagedata);	
	_imageviewer2D_1->SetVtkBaseData( _vtkbasedata_1 );
	_imageviewer2D_1->Configure();

//	vtkImageViewer2 *_imageViewer=_imageviewer2D_1->_imageViewer2XYZ->GetVtkImageViewer2();

	// Contorno 1
	_manContourControl_1	= new manualContourControler();
	_mContourModel_1		= new manualContourModel();
	_mViewContour_1			= new manualViewContour();
	_mViewContour_1->SetModel( _mContourModel_1 );
	_mViewContour_1->SetWxVtkBaseView( _imageviewer2D_1 );
	_mViewContour_1->SetRange( 2 );
	_mViewContour_1->SetZ( 1000 );


//EED 3 oct 2006
	_mViewContour_1->SetSpacing(spc);


//EED 3 oct 2006
	_mViewContour_1->SetColorNormalContour(0, 0, 1);
	_mViewContour_1->SetColorEditContour(0, 0.5, 0.5);


	_manContourControl_1->SetModelView( _mContourModel_1 , _mViewContour_1 );
	_imageviewer2D_1->GetInteractorStyleBaseView()->AddInteractorStyleMaracas( _manContourControl_1 );
	_manContourControl_1->CreateNewManualContour();
	_manContourControl_1->SetActive(false);
	_mViewContour_1->RefreshContour();

	// Rectangulo
	_manRoiControl  = new manualRoiControler();
	_mContourModel  = new manualContourModel();
	_mViewRoi		= new manualViewRoi();
	_mViewRoi->SetModel( _mContourModel );
	_mViewRoi->SetWxVtkBaseView( _imageviewer2D_1 );
	_mViewRoi->SetRange( 2 );
	_mViewRoi->SetZ( 1000 );

//EED 3 oct 2006
	_mViewRoi->SetSpacing(spc);

	_manRoiControl->SetModelView( _mContourModel , _mViewRoi );
	_imageviewer2D_1->GetInteractorStyleBaseView()->AddInteractorStyleMaracas( _manRoiControl );
	_manRoiControl->CreateNewManualContour();
	_manRoiControl->SetActive(true);
	_mViewRoi->RefreshContour();

	// Contorno 2
	_manContourControl_2	= new manualContourControler();
	_mContourModel_2		= new manualContourModel();
	_mViewContour_2			= new manualViewContour();
	_mViewContour_2->SetModel( _mContourModel_2 );
	_mViewContour_2->SetWxVtkBaseView( _imageviewer2D_1 );
	_mViewContour_2->SetRange( 2 );
	_mViewContour_2->SetZ( 1000 );

//EED 3 oct 2006
	_mViewContour_2->SetSpacing(spc);

//EED 3 oct 2006
	_mViewContour_2->SetColorNormalContour(1, 1, 1);
	_mViewContour_2->SetColorEditContour(0.5, 0.5, 0.5);


	_manContourControl_2->SetModelView( _mContourModel_2 , _mViewContour_2 );
	_imageviewer2D_1->GetInteractorStyleBaseView()->AddInteractorStyleMaracas( _manContourControl_2 );
	_manContourControl_2->CreateNewManualContour();
	_manContourControl_2->SetActive(false);
	_mViewContour_2->RefreshContour();

CreateNewPoint( 0,0);

	Refresh();	
}


//----------------------------------------------------------------------------
//eedx21
void wxEmptyPanel_3_Widget::CreateNewPoint(double x, double y)
{
/*

		vtkSphereSource* aSphere =vtkSphereSource::New();
        aSphere->SetRadius(0.2);
        aSphere->SetCenter(x,y,0.5);

        point_mapped.push_back(vtkPolyDataMapper::New());
        point_mapped.back()->ImmediateModeRenderingOn();
        //point_mapped.back()->ScalarVisibilityOff( );
        point_mapped.back()->SetInput(aSphere->GetOutput());

        point_actor.push_back(vtkActor::New());
        point_actor.back()->SetMapper(point_mapped.back());
        point_actor.back()->GetProperty()->BackfaceCullingOff();
        point_actor.back()->GetProperty()->SetColor(0, 1, 0);

        point_actor.back()->ApplyProperties();

        _wxvtkbaseview->GetRenderer()->AddActor(point_actor.back());
        _wxvtkbaseview->GetRenWin()->Render();
*/

/*
		vtkActor			*spheresActor	= vtkActor::New( );
        vtkSphereSource		*spheres		= vtkSphereSource::New( );
        vtkPolyDataMapper	*spheresMapper	= vtkPolyDataMapper::New( );
        spheresMapper	-> SetInput( spheres->GetOutput( ) );
        spheresActor	-> SetMapper( spheresMapper );
		_imageviewer2D_1 -> GetRenderer() -> AddActor( spheresActor );
		spheres->SetCenter( x,y,0 );
		spheres->SetRadius( 10 );
*/

        vtkSphereSource		*spheres		= vtkSphereSource::New( );
		spheres->SetCenter( x,y,0 );
		spheres->SetRadius( 5 );
        vtkPolyDataMapper	*spheresMapper	= vtkPolyDataMapper::New( );
		spheresMapper	->ImmediateModeRenderingOn();
        spheresMapper	-> SetInput( spheres->GetOutput( ) );
        vtkActor			*spheresActor	= vtkActor::New( );
        spheresActor	-> SetMapper( spheresMapper );
        spheresActor	->GetProperty()->BackfaceCullingOff();
        spheresActor	->GetProperty()->SetColor(0, 1, 0);
        spheresActor	->ApplyProperties();
		_imageviewer2D_1 -> GetRenderer() -> AddActor( spheresActor );


}




//------------------------------------------------------------------------
void wxEmptyPanel_3_Widget::OnContourA(wxCommandEvent& event)
{
	_manRoiControl		 -> SetActive(false);
	_manContourControl_1 -> SetActive(true);
	_manContourControl_2 -> SetActive(false);
}
//------------------------------------------------------------------------
void wxEmptyPanel_3_Widget::OnContourB(wxCommandEvent& event)
{
	_manRoiControl		 -> SetActive(false);
	_manContourControl_1 -> SetActive(false);
	_manContourControl_2 -> SetActive(true);
}
//------------------------------------------------------------------------
void wxEmptyPanel_3_Widget::OnContourAB(wxCommandEvent& event)
{
	_manRoiControl		 -> SetActive(false);
	_manContourControl_1 -> SetActive(true);
	_manContourControl_2 -> SetActive(true);
}
//------------------------------------------------------------------------

