/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __WX__EMPTY__PANEL__3__WIDGET
#define __WX__EMPTY__PANEL__3__WIDGET



#include <vtkImageData.h>
#include "../manualContour.h"
#include "wxMPRWidget.h"


#include <wx/wx.h>
#include <wx/panel.h>

//------------------------------------------------------------------
//------------------------------------------------------------------
//------------------------------------------------------------------

class wxEmptyPanel_3_Widget: public wxPanel{
public:
	wxEmptyPanel_3_Widget(wxWindow *parent);
	~wxEmptyPanel_3_Widget();
	void ConfigureVTK(marImageData *marimagedata);
	void OnContourA(wxCommandEvent& event);
	void OnContourB(wxCommandEvent& event);
	void OnContourAB(wxCommandEvent& event);
	void Refresh();
	void OnRefreshView(wxCommandEvent & event);
void CreateNewPoint(double x, double y);

private:
	wxWindow				*_parent;
	vtkImageData			*_data;
	wxVtk2DBaseView			*_imageviewer2D_1;
	vtkBaseData				*_vtkbasedata_1;
	wxPanel					*CreateControlPanel(wxWindow *parent);
	wxPanel					*CreateViewPanel(wxWindow *parent);

	manualRoiControler		*_manRoiControl;
	manualContourModel		*_mContourModel;
	manualViewRoi			*_mViewRoi;

	manualContourControler	*_manContourControl_1;
	manualContourModel		*_mContourModel_1;
	manualViewContour		*_mViewContour_1;

	manualContourControler	*_manContourControl_2;
	manualContourModel		*_mContourModel_2;
	manualViewContour		*_mViewContour_2;

	DECLARE_EVENT_TABLE( );
};

#endif // __WX__EMPTY__PANEL__3__WIDGET




