/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "wxImageBrowserWdg.h"

#include <math.h>
//#include <gtmlib/math/mathdefs.h>
#include <mathdefs.h>

BEGIN_EVENT_TABLE( wxImageBrowserWdg, wxScrolledWindow )
    EVT_LEFT_UP( wxImageBrowserWdg::OnMouseLeftClick )
    EVT_RIGHT_UP( wxImageBrowserWdg::OnMouseRightClick )
    EVT_SIZE( wxImageBrowserWdg::OnSize )
    END_EVENT_TABLE( );

wxImageBrowserWdg::wxImageBrowserWdg(
    wxWindow* parent,
    wxWindowID id,
    int sx,
    int sy,
    int gap,
    const wxPoint& pos,
    const wxSize& size,
    long style,
    const wxString& name
    )
    : wxScrolledWindow( parent, id, pos, size, style, name )
{
    _sx = sx;
    _sy = sy;
    _gap = gap;
    _first_selected = -1;
    _last_selected = -1;
    _ima_list.RemoveAll( );
    _ima_list.Create( _sx, _sy );
    _nrs_list.Clear( );

}

void wxImageBrowserWdg::SetVolume(
                                   unsigned short*** volume,
                                   wxArrayString& names,
                                   int width,
                                   int height,
                                   int depth,
                                   int min,
                                   int max
                                   )
{
    wxImage tmpI;
    unsigned char value;
    unsigned char* data;  //pointeur sur mon image
//    int i, j, k;

    tmpI.Create( width, height );
    _nrs_list = names;

    // Canvas creation
    _ima_list.RemoveAll( );
    _ima_list.Create( _sx, _sy );

    for( int k = 0; k < depth; k++ )
    {

      data = tmpI.GetData();
      data += 3*width*height;
//      unsigned short** voltemp = volume[k];
      for ( int i = 0; i < width; i++ )
      {
        for ( int j = 0; j < height; j++ )
        {
          value = ( unsigned char )( 0x00ff*( volume[ k ][ i ][ height - j - 1] - min) / (max - min));
          data -= 3;
          data[0] = value;
          data[1] = value;
          data[2] = value;
          //memset( data, value, 3);
        } //rof
      } //rof

      //image is set, add it to the list
      //another image is created so allocation is not a problem
      _ima_list.Add( wxBitmap( tmpI.Scale( _sx, _sy ) ) );
    } // rof

//FIXME:
#ifdef __WXMSW__
    this->OnSize( wxSizeEvent( ) );
#else
  wxSizeEvent myevent(wxSize(-1, -1), this->GetId());
  this->OnSize(myevent);
  this->Show(true);
#endif
}



void wxImageBrowserWdg::SetScaleX( int sx )
{
    _sx = sx;

}

void wxImageBrowserWdg::SetScaleY( int sy )
{
    _sy = sy;

}

void wxImageBrowserWdg::SetGap( int gap )
{
    _gap = gap;

}

int wxImageBrowserWdg::GetScaleX( )
{
    return( _sx );

}

int wxImageBrowserWdg::GetScaleY( )
{
    return( _sy );

}

int wxImageBrowserWdg::GetGap( )
{
    return( _gap );

}

int wxImageBrowserWdg::GetFirst( )
{
    return( GTM_MIN( _first_selected, _last_selected ) );

}

int wxImageBrowserWdg::GetLast( )
{
    return( GTM_MAX( _first_selected, _last_selected ) );

}

void wxImageBrowserWdg::GetSizeParameters( int* n, int* c, int* r )
{
    wxSize sz = this->GetClientSize( );

    *n = _ima_list.GetImageCount( );
    *c = ( int )floor( ( double )( sz.GetWidth( ) ) / ( double )( _gap + _sx ) );
    *c = ( *c <= 0 )? 1: *c;
    *r = ( int )ceil( ( double )( *n ) / ( double )( *c ) );

}

void wxImageBrowserWdg::OnDraw( wxDC& dc )
{
    int r, c, i, x, y, n, rt;
    wxSize sz = this->GetClientSize( );

    dc.SetTextForeground( wxColour( 255, 255, 0 ) );
    dc.SetBrush( *wxTRANSPARENT_BRUSH );

    this->GetSizeParameters( &n, &c, &r );
    for( i = 0; i < n; i++ )
    {
        rt = ( int )floor( ( double )i / ( double )c );
        x = ( _sx * ( i % c ) ) + ( ( ( i % c ) + 1 ) * _gap );
        y = ( _sy * ( rt % r ) ) + ( ( ( rt % r ) + 1 ) * _gap );
        _ima_list.Draw( i, dc, x, y, wxIMAGELIST_DRAW_NORMAL, true );
        dc.DrawText( _nrs_list[ i ], x, y );
        if( _first_selected == i && _last_selected != i )
        {
            dc.SetPen( *wxRED_PEN );
            dc.DrawRectangle( x - ( _gap / 2 ), y - ( _gap / 2 ), _sx + _gap, _sy + _gap );

        }
        else if( _first_selected != i && _last_selected == i )
        {
            dc.SetPen( *wxGREEN_PEN );
            dc.DrawRectangle( x - ( _gap / 2 ), y - ( _gap / 2 ), _sx + _gap, _sy + _gap );

        }
        else if( _first_selected == i && _last_selected == i )
        {
            dc.SetPen( *wxCYAN_PEN );
            dc.DrawRectangle( x - ( _gap / 2 ), y - ( _gap / 2 ), _sx + _gap, _sy + _gap );

        } // fi

    } // rof

}

void wxImageBrowserWdg::OnSize( wxSizeEvent& event )
{
    int r, c, n;
    wxSize sz = this->GetClientSize( );

    this->GetSizeParameters( &n, &c, &r );

    // Scroll bars
    this->SetScrollbars( _sx + _gap, _sy + ( _gap * 2 ), c, r );

}

int wxImageBrowserWdg::GetIndexClicked( wxMouseEvent& event )
{
    double re;
    int x, y, n, c, r, i;
    wxClientDC dc( this );
    this->PrepareDC( dc );
    wxPoint pos = event.GetLogicalPosition( dc );

    this->GetSizeParameters( &n, &c, &r );

    // Image index calculation (Help!!, Mr. wizard!)
    x = -1;
    re = ( double )( pos.x ) / ( double )( _gap + _sx );
    if( ( re - floor( re ) ) >= ( ( double )( _gap ) / ( double )( _gap + _sx ) ) ) x = ( int )floor( re );
    x = ( x >= 0 && x < c )? x: -1;
    y = -1;
    re = ( double )( pos.y ) / ( double )( _gap + _sy );
    if( ( re - floor( re ) ) >= ( ( double )( _gap ) / ( double )( _gap + _sy ) ) ) y = ( int )floor( re );
    y = ( y >= 0 && y < r )? y: -1;
    i = ( x != -1 && y != -1 )? x + ( y * c ): -1;
    return( ( i < n )? i: -1 );

}

void wxImageBrowserWdg::OnMouseLeftClick( wxMouseEvent& event )
{
    // Select!
    _first_selected = this->GetIndexClicked( event );

    // Drawing
    this->Refresh( );

}

void wxImageBrowserWdg::OnMouseRightClick( wxMouseEvent& event )
{
    // Select!
    _last_selected = this->GetIndexClicked( event );

    // Drawing
    this->Refresh( );

}

/*
void wxImageBrowserWdg::Add( const wxImage& ima, const wxString& nrs )
{
_ima_list.Add( wxBitmap( ima.Scale( _sx, _sy ) ) );
_nrs_list.Add( nrs );
this->OnSize( wxSizeEvent( ) );
}
*/
