/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __WX__IMAGE__BROWSER__WDG__
#define __WX__IMAGE__BROWSER__WDG__

#include <wx/wx.h>
#include <wx/image.h>
#include <wx/imaglist.h>
#include <wx/list.h>
#include <wx/scrolwin.h>

/**
 * \brief Widget class that shows thumbnails images
 */
class wxImageBrowserWdg : public wxScrolledWindow
{
public:
    wxImageBrowserWdg(
	wxWindow* parent,
	wxWindowID id = -1,
	int sx = 100,
	int sy = 100,
	int gap = 10,
	const wxPoint& pos = wxDefaultPosition,
	const wxSize& size = wxDefaultSize,
	long style = wxScrolledWindowStyle,
	const wxString& name = wxPanelNameStr
	);

    void SetVolume(
        unsigned short*** volume,
        wxArrayString& names,
        int width,
        int height,
        int depth,
        int min,
        int max
        );

    void SetScaleX( int sx );
    void SetScaleY( int sy );
    void SetGap( int gap );
    int GetScaleX( );
    int GetScaleY( );
    int GetGap( );

    int GetFirst( );
    int GetLast( );

    void GetSizeParameters( int* n, int* c, int* r );

    void OnDraw( wxDC& dc );
    void OnSize( wxSizeEvent& event );

    void OnMouseLeftClick( wxMouseEvent& event );
    void OnMouseRightClick( wxMouseEvent& event );

//    void Add( const wxImage& ima, const wxString& nrs );

private:

    int GetIndexClicked( wxMouseEvent& event );

    wxImageList _ima_list;
    wxArrayString _nrs_list;
    int _sx;
    int _sy;
    int _gap;
    int _first_selected;
    int _last_selected;

    DECLARE_EVENT_TABLE( );

};

#endif // __WX__IMAGE__BROWSER__WDG__
