/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxImageViewerWidget.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:18 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef __WX__IMAGE__VIEWER__WIDGET__
#define __WX__IMAGE__VIEWER__WIDGET__

//As it is extremely easy to use vtkImageViewer/ vtkImageViewer2, I gave up with
//vtkImagePlaneWidget
#include <wx/wx.h>

#include "InterfaceVtkPanelWidgets.h"
//  #include "vtk3DSurfaceWidget.h"  //EED pour avoir access a la classe "InterfaceVtkPanelWidgets"

#include "../manualContour.h"
#include "wxVTKRenderWindowInteractorEditContour.h"

#include "wxVTKRenderWindowInteractor.h"
#include "vtkImageViewer2.h"
#include "vtkImageData.h"
#include "vtkActor.h"
#include "vtkPoints.h"

class marZoomROIObserver;


class wxVtk2DView_TMP : public wxVtkBaseView{
public:
	wxVtk2DView_TMP(vtkImageViewer2 *imageviewer2);
	~wxVtk2DView_TMP();
	virtual vtkRenderer			*GetRenderer(); 
	virtual vtkRenderWindow 	*GetRenWin();
	virtual void				Configure();
	void						SetWxVTKRenderWindowInteractor( wxVTKRenderWindowInteractor *wxVTKiren);
	virtual crea::wxVTKRenderWindowInteractor *GetWxVTKRenderWindowInteractor();

private:
	wxVTKRenderWindowInteractor *_wxVTKiren;
	vtkImageViewer2				*_imageviewer2;
};


/**
 * \brief Panel class composed of a vtk renderwindow with double click available 
 * and add some buttons
 */
class wxImageViewerWidget : public wxPanel{
public:

    wxImageViewerWidget(
        wxWindow		*parent,
        wxWindowID		id		= -1,
        const wxPoint	&pos	= wxDefaultPosition,
        const wxSize&	size	= wxDefaultSize,
        long			style	= wxSUNKEN_BORDER, //wxTAB_TRAVERSAL,
        const wxString& name	= wxPanelNameStr
        );
    ~wxImageViewerWidget( );
    
	 virtual void ConstructVTK(vtkImageData *imageData);
     virtual void ExecuteEvent(vtkObject *wdg, unsigned long event, void* calldata);
			 void ExecuteEvent1(vtkObject *wdg, unsigned long event, void* calldata);
			 void ExecuteEvent2(vtkObject *wdg, unsigned long event, void* calldata);
			 void SetImage(vtkImageData* imagedata);
			 void SetInterfaceVtkPanelWidgets(InterfaceVtkPanelWidgets * intVtkPanWid) { _intVtkPanWid = intVtkPanWid; };

			 void	 SetState(int state);
			 void	 SetStateManualContour(int state);
			 void	 CreateNewManualContour();
			 int	 GetNumberOfPointsSplineManualContour();
			 double* GetVectorPointsXManualContour();
			 double* GetVectorPointsYManualContour();
			 void	 EraseManualContour();
			 void	 SetZSlice(int z);
			 int	 GetZSlice();
			 void	 Render();


	void AddObserver_1();
	void AddObserver_2();

protected:
	int										 _state;
 	marZoomROIObserver						*_Observer;
	vtkInteractorStyle2DMaracas				*_interactorStyle2DMaracas;
	vtkImageViewer2							*_imageViewer;
	InterfaceVtkPanelWidgets				*_intVtkPanWid;
	wxVTKRenderWindowInteractorEditContour	*_wxVTKiren;

private:
    manualContourControler					*_manContControl;
	manualContourModel						*_mContourModel;
	manualViewContour						*_mViewContour;

};

//----------------------------------------------------------------------------

class wxImageViewerWidgetRoi : public wxImageViewerWidget{
public :
	wxImageViewerWidgetRoi(
        wxWindow* parent,
        wxWindowID		id		= -1,
        const wxPoint	&pos	= wxDefaultPosition,
        const wxSize&	size	= wxDefaultSize,
			  long		style	= wxSUNKEN_BORDER, //wxTAB_TRAVERSAL,
        const wxString& name	= wxPanelNameStr
        );
    ~wxImageViewerWidgetRoi( );
	void GetROI( int extent[6] );
	virtual void ConstructVTK(vtkImageData *imageData);
	void TransfromeCoordViewWorld(int &X, int &Y, int &Z);
	bool GetRoiSelected();

private :
    virtual void ExecuteEvent(vtkObject *wdg, unsigned long event, void* calldata);
	bool						_bboxEnabled;
	bool						_sliceEnabled;
	bool						_RoiSelected;
	vtkPoints					*_pts;
	vtkActor					*_bboxActor;
	vtkPolyDataMapper			*_bboxMapper;
    vtkPolyData					*_pd;
};
#endif // __WX__IMAGE__VIEWER__WIDGET__
