/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxManualRegistration3D.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:16 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/



#include <wx/wx.h>
#include <wx/splitter.h>
#include <wx/notebook.h>
#include <wx/colordlg.h>

#include "wxManualRegistration3D.h"


//-------------------------------------------------------------------
//-------------------------------------------------------------------
//-------------------------------------------------------------------

BEGIN_EVENT_TABLE( wxManualRegistration3D, wxPanel )
	EVT_MENU( 12121, wxManualRegistration3D::OnRefreshView )
//	EVT_MENU( 12122, wxManualTree_MPRWidget::OnDClickLeft  )
END_EVENT_TABLE( );


wxManualRegistration3D::wxManualRegistration3D( wxWindow* parent,
                          marImageData *marimageData )
: wxPanel( parent, -1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL)
{

	_marimageData							= marimageData;

    _vtkmprbasedata_A = new vtkMPRBaseData();
	_vtkmprbasedata_A->SetMarImageData(_marimageData);

	_wxvtk3Dbaseview_Clipping3D			= NULL;
	_wxvtkmpr3Dview_A					= NULL;
	_wxvtkclipping3Dview_A				= NULL;

	_wxvtkmpr3Dview_B					= NULL;
	_wxvtkclipping3Dview_B				= NULL;

	_panelCutting						= NULL;

    wxSplitterWindow	*pnlSplitter	= new wxSplitterWindow( this , -1);

// EED borrame	
//	int ww,hh;

	wxPanel *	view3Dpanel				= Create3DView( pnlSplitter , _vtkmprbasedata_A );
	wxPanel *   registrationControl		= CreateRegistration3DControl( pnlSplitter ,_vtkmprbasedata_A);

//	this->GetSize(&ww,&hh);

    pnlSplitter	-> SplitVertically( view3Dpanel, registrationControl , 700);
	wxBoxSizer	*sizer	= new wxBoxSizer(wxVERTICAL  );
	sizer		-> Add( pnlSplitter ,1,wxGROW  ,0);
	pnlSplitter	-> SetMinimumPaneSize( 25 );
	this		-> SetSizer(sizer);


	_transform		= vtkTransform::New();
	_transformBak	= vtkTransform::New();
	_transformBak->Identity();
	xBak=0;
	yBak=0;
	zBak=0;
}

//----------------------------------------------------------------------------

wxManualRegistration3D::~wxManualRegistration3D( )
{
	if (_wxvtk3Dbaseview_Clipping3D		!= NULL) { delete	_wxvtk3Dbaseview_Clipping3D;	}
	if (_wxvtkmpr3Dview_A				!= NULL) { delete	_wxvtkmpr3Dview_A;				}
	if (_wxvtkclipping3Dview_A			!= NULL) { delete	_wxvtkclipping3Dview_A;			}

	if (_wxvtkmpr3Dview_B				!= NULL) { delete	_wxvtkmpr3Dview_B;				}
	if (_wxvtkclipping3Dview_B			!= NULL) { delete	_wxvtkclipping3Dview_B;			}
}



//----------------------------------------------------------------------------
void wxManualRegistration3D::ConfigureVTK()
{
	_wxvtk3Dbaseview_Clipping3D		->  Configure();
//
	_wxvtkmpr3Dview_A				->	Configure();
	_wxvtkclipping3Dview_A			->	Configure();
	vtkInteractorStyle3DView *vtkinteractorstyle3Dview_A = new vtkInteractorStyle3DView();
	vtkinteractorstyle3Dview_A->SetWxVtkMPR3DView(_wxvtkmpr3Dview_A);
	vtkinteractorstyle3Dview_A->SetWxVtkClipping3DView(_wxvtkclipping3Dview_A);
	_wxvtk3Dbaseview_Clipping3D->GetInteractorStyleBaseView()->AddInteractorStyleMaracas( vtkinteractorstyle3Dview_A );
//
}

//----------------------------------------------------------------------------
void wxManualRegistration3D::ConfigureVTK_B()
{
	_wxvtkmpr3Dview_B				->	Configure();
	_wxvtkclipping3Dview_B			->	Configure();
	vtkInteractorStyle3DView *vtkinteractorstyle3Dview_B = new vtkInteractorStyle3DView();
	vtkinteractorstyle3Dview_B->SetWxVtkMPR3DView(_wxvtkmpr3Dview_B);
	vtkinteractorstyle3Dview_B->SetWxVtkClipping3DView(_wxvtkclipping3Dview_B);
	_wxvtk3Dbaseview_Clipping3D->GetInteractorStyleBaseView()->AddInteractorStyleMaracas( vtkinteractorstyle3Dview_B );
}

//----------------------------------------------------------------------------
void wxManualRegistration3D::OnRefreshView(wxCommandEvent & event)
{
	RefreshView();
}

//----------------------------------------------------------------------------
void wxManualRegistration3D::OnTracking(wxCommandEvent& event)
{
	if (_wxvtkmpr3Dview_B!=NULL){
		_wxvtkmpr3Dview_B->InitOrientationPointWidget();

		double spc[3];

		this->_marimageData->GetImageData()->GetSpacing(spc);  //image t=0


		xBak  = spc[0] * this->_wxvtkmpr3Dview_B->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetX();
		yBak  = spc[1] * this->_wxvtkmpr3Dview_B->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetY();
		zBak  = spc[2] * this->_wxvtkmpr3Dview_B->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetZ();

		double mat[16];
		mat[0]=_transform->GetMatrix()->GetElement(0,0);
		mat[1]=_transform->GetMatrix()->GetElement(0,1);
		mat[2]=_transform->GetMatrix()->GetElement(0,2);
		mat[3]=_transform->GetMatrix()->GetElement(0,3);

		mat[4]=_transform->GetMatrix()->GetElement(1,0);
		mat[5]=_transform->GetMatrix()->GetElement(1,1);
		mat[6]=_transform->GetMatrix()->GetElement(1,2);
		mat[7]=_transform->GetMatrix()->GetElement(1,3);

		mat[8]=_transform->GetMatrix()->GetElement(2,0);
		mat[9]=_transform->GetMatrix()->GetElement(2,1);
		mat[10]=_transform->GetMatrix()->GetElement(2,2);
		mat[11]=_transform->GetMatrix()->GetElement(2,3);

		mat[12]=_transform->GetMatrix()->GetElement(3,0);
		mat[13]=_transform->GetMatrix()->GetElement(3,1);
		mat[14]=_transform->GetMatrix()->GetElement(3,2);
		mat[15]=_transform->GetMatrix()->GetElement(3,3);

		_transformBak->SetMatrix(mat);
	}

// EED 25 Janvier 2005 TestLoic
	this->_wxvtkmpr3Dview_A->TestLoic1();


}


//----------------------------------------------------------------------------
void wxManualRegistration3D::RefreshView()
{
	double spc[3];

	if ( _wxvtkmpr3Dview_B!=NULL )
	{
		if (_btnTrack->GetValue()==true)
		{
		
			this->_marimageData->GetImageData()->GetSpacing(spc);  // image t=0
			vtkTransform *m = this->_wxvtkmpr3Dview_B->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetTransformOrientation();
			double x  = spc[0] * this->_wxvtkmpr3Dview_B->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetX();
			double y  = spc[1] * this->_wxvtkmpr3Dview_B->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetY();
			double z  = spc[2] * this->_wxvtkmpr3Dview_B->GetVtkMPR3DDataViewer()->GetVtkMPRBaseData()->GetZ();
			double xx=this->_posX->GetValue()/30.0;
			double yy=this->_posY->GetValue()/30.0;
			double zz=this->_posZ->GetValue()/30.0;
			double sx=this->_scaleX->GetValue()/100.0;
			double sy=this->_scaleY->GetValue()/100.0;
			double sz=this->_scaleZ->GetValue()/100.0;
			_transform->Identity();
//			_transform->Translate(x,y,z);	



//			_transform->Translate((x-xBak),(y-yBak),(z-zBak) );
//			_transform->Translate( xBak , yBak , zBak  );
			_transform->Translate( xx , yy , zz  );
			_transform->Translate( x , y , z  );
			_transform->Concatenate( m->GetMatrix() );
			_transform->RotateX( _angAlfa->GetValue()/30.0 );
			_transform->RotateY( _angBeta->GetValue()/30.0 );
			_transform->RotateZ( _angGama->GetValue()/30.0 );
			_transform->Scale( sx,sy,sz );	
			_transform->Translate(-(xBak),-(yBak),-(zBak) );

			_transform->Concatenate( _transformBak->GetMatrix() );

		}



		vtkClipping3DDataViewer *vtkclipping3Ddataviewer = _wxvtkclipping3Dview_B->GetVtkClipping3DDataViewer();
		vtkActor *vtkactor;
		int i;
		for (i=0;i<4;i++)
		{
			vtkactor = vtkclipping3Ddataviewer->GetTissueActor(i);
			vtkactor->SetUserTransform( _transform );  	
		}
		_wxvtkmpr3Dview_B				-> RefreshView();
		_wxvtkclipping3Dview_B			-> Refresh();
	}

	_wxvtkmpr3Dview_A				-> RefreshView();
	_wxvtkclipping3Dview_A			-> Refresh();
	_wxvtk3Dbaseview_Clipping3D		-> Refresh();

	if (_panelCutting!=NULL)
	{
		_panelCutting->RefreshView();
	}

}


// EED 7 nov 2006
//----------------------------------------------------------------------------
wxPanel* wxManualRegistration3D::CreateRegistration3DControl( wxWindow *parent, vtkMPRBaseData *vtkmprbasedata)
{
	wxPanel *panel = new wxPanel(parent,-1);

	int maxX = vtkmprbasedata->GetMaxPositionX();
	int maxY = vtkmprbasedata->GetMaxPositionY();
	int maxZ = vtkmprbasedata->GetMaxPositionZ();
	maxX=100;
	maxY=100;
	maxZ=100;

	_posX = new wxSlider( panel, -1,0 , -maxX*2, maxX*2, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_AUTOTICKS  |wxSL_LABELS );
	_posY = new wxSlider( panel, -1,0 , -maxY*2, maxY*2, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_AUTOTICKS  |wxSL_LABELS );
	_posZ = new wxSlider( panel, -1,0 , -maxZ*2, maxZ*2, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_AUTOTICKS  |wxSL_LABELS );

	_scaleX = new wxSlider( panel, -1,100 , 0, 200, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_AUTOTICKS  |wxSL_LABELS );
	_scaleY = new wxSlider( panel, -1,100 , 0, 200, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_AUTOTICKS  |wxSL_LABELS );
	_scaleZ = new wxSlider( panel, -1,100 , 0, 200, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_AUTOTICKS  |wxSL_LABELS );


	_angAlfa = new wxSlider( panel, -1,0 , -100, 100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_AUTOTICKS  |wxSL_LABELS );
	_angBeta = new wxSlider( panel, -1,0 , -100, 100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_AUTOTICKS  |wxSL_LABELS );
	_angGama = new wxSlider( panel, -1,0 , -100, 100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_AUTOTICKS  |wxSL_LABELS );


	_btnTrack = new wxCheckBox(panel, -1,_T("Tracking"));	

	_posX->SetTickFreq( 10, 0 );
	_posY->SetTickFreq( 10, 0 );
	_posZ->SetTickFreq( 10, 0 );

	_angAlfa->SetTickFreq( 30, 0 );
	_angBeta->SetTickFreq( 30, 0 );
	_angGama->SetTickFreq( 30, 0 );




	Connect(_posX->GetId()	, wxEVT_COMMAND_SLIDER_UPDATED		, (wxObjectEventFunction) &wxManualRegistration3D::OnPositionRotation	);
	Connect(_posY->GetId()	, wxEVT_COMMAND_SLIDER_UPDATED		, (wxObjectEventFunction) &wxManualRegistration3D::OnPositionRotation	);
	Connect(_posZ->GetId()	, wxEVT_COMMAND_SLIDER_UPDATED		, (wxObjectEventFunction) &wxManualRegistration3D::OnPositionRotation	);

	Connect(_scaleX->GetId()	, wxEVT_COMMAND_SLIDER_UPDATED		, (wxObjectEventFunction) &wxManualRegistration3D::OnPositionRotation	);
	Connect(_scaleY->GetId()	, wxEVT_COMMAND_SLIDER_UPDATED		, (wxObjectEventFunction) &wxManualRegistration3D::OnPositionRotation	);
	Connect(_scaleZ->GetId()	, wxEVT_COMMAND_SLIDER_UPDATED		, (wxObjectEventFunction) &wxManualRegistration3D::OnPositionRotation	);

	Connect(_angAlfa->GetId()	, wxEVT_COMMAND_SLIDER_UPDATED		, (wxObjectEventFunction) &wxManualRegistration3D::OnPositionRotation	);
	Connect(_angBeta->GetId()	, wxEVT_COMMAND_SLIDER_UPDATED		, (wxObjectEventFunction) &wxManualRegistration3D::OnPositionRotation	);
	Connect(_angGama->GetId()	, wxEVT_COMMAND_SLIDER_UPDATED		, (wxObjectEventFunction) &wxManualRegistration3D::OnPositionRotation	);

	Connect(_btnTrack->GetId()	, wxEVT_COMMAND_CHECKBOX_CLICKED 		, (wxObjectEventFunction) &wxManualRegistration3D::OnTracking	);


    wxBoxSizer *sizerH1 = new wxBoxSizer(wxHORIZONTAL);
	sizerH1->Add( _posX, 1, wxALL|wxEXPAND, 5);
	sizerH1->Add( _posY, 1, wxALL|wxEXPAND, 5);
	sizerH1->Add( _posZ, 1, wxALL|wxEXPAND, 5);


    wxBoxSizer *sizerH2 = new wxBoxSizer(wxHORIZONTAL);
	sizerH2->Add( _scaleX, 1, wxALL|wxEXPAND, 5);
	sizerH2->Add( _scaleY, 1, wxALL|wxEXPAND, 5);
	sizerH2->Add( _scaleZ, 1, wxALL|wxEXPAND, 5);
	
    wxBoxSizer *sizerH3 = new wxBoxSizer(wxHORIZONTAL);
	sizerH3->Add( _angAlfa, 1, wxALL|wxEXPAND, 5);
	sizerH3->Add( _angBeta, 1, wxALL|wxEXPAND, 5);
	sizerH3->Add( _angGama, 1, wxALL|wxEXPAND, 5);


    wxBoxSizer *sizer = new wxBoxSizer(wxVERTICAL);
	sizer->Add( sizerH1 , 1, wxALL|wxEXPAND, 0);
	sizer->Add( sizerH2 , 1, wxALL|wxEXPAND, 0);
	sizer->Add( sizerH3 , 1, wxALL|wxEXPAND, 0);
	sizer->Add( _btnTrack , 1, wxALL|wxEXPAND, 10);
	sizer->Add( new wxPanel(panel,-1) , 1, wxALL|wxEXPAND, 0);
	sizer->Add( new wxPanel(panel,-1) , 1, wxALL|wxEXPAND, 0);
	sizer->Add( new wxPanel(panel,-1) , 1, wxALL|wxEXPAND, 0);

	panel->SetAutoLayout(true);
	panel->SetSizer(sizer);
	panel->SetSize(400,400);
	panel->Layout();

	return panel;
}
//----------------------------------------------------------------------------
void wxManualRegistration3D::OnPositionRotation(wxScrollEvent& event)
{

	RefreshView();
}

//----------------------------------------------------------------------------
wxPanel* wxManualRegistration3D::Create3DView( wxWindow *parent, vtkMPRBaseData *vtkmprbasedata)
{
	wxWindow *wxwindow;
	wxPanel *panel=new wxPanel(parent,-1);
//
	wxSplitterWindow	*panelClipping3D	= new wxSplitterWindow( panel , -1);
	_wxvtk3Dbaseview_Clipping3D				= new wxVtk3DBaseView( panelClipping3D );
//
	_wxvtkclipping3Dview_A = new wxVtkClipping3DView(_wxvtk3Dbaseview_Clipping3D);
	vtkClipping3DDataViewer *vtkclipping3Ddataviewer_A = new vtkClipping3DDataViewer(); 
	vtkclipping3Ddataviewer_A->SetVtkMPRBaseData(vtkmprbasedata);
	vtkclipping3Ddataviewer_A->Configure();
	_wxvtkclipping3Dview_A->SetVtkClipping3DDataViewer(vtkclipping3Ddataviewer_A);

	_wxvtkmpr3Dview_A = new wxVtkMPR3DView( _wxvtk3Dbaseview_Clipping3D );
	vtkMPR3DDataViewer *vtkmpr3Ddataviewer_A = new vtkMPR3DDataViewer(); 
	vtkmpr3Ddataviewer_A->SetVtkMPRBaseData(vtkmprbasedata);
	vtkmpr3Ddataviewer_A->Configure();
	_wxvtkmpr3Dview_A->SetVtkMPR3DDataViewer(vtkmpr3Ddataviewer_A);

//--

	wxWindow			*window3D			= _wxvtk3Dbaseview_Clipping3D->GetWxVTKRenderWindowInteractor();
	wxSplitterWindow	*panelControlSplit	= new wxSplitterWindow(panelClipping3D,-1);	

//
	wxPanel		*panelControl_A				= new wxPanel(panelControlSplit,-1,wxDefaultPosition,wxSize(800,800));	

	wxPanel		*controlPanelMPR3D_A		= _wxvtkmpr3Dview_A->CreateControlPanel(panelControl_A);
	wxPanel		*controlPanelClipping3D_A	= _wxvtkclipping3Dview_A->CreateControlPanel(panelControl_A);

		         _btnCutImageData			= new wxCheckBox(panelControl_A,-1,_T("Cut Module"));
		Connect(_btnCutImageData->GetId() , wxEVT_COMMAND_CHECKBOX_CLICKED  , (wxObjectEventFunction) &wxManualRegistration3D::OnCutImagaData );


//	wxBoxSizer		*sizerCtrol_A				= new wxBoxSizer(wxVERTICAL);
	wxFlexGridSizer *sizerCtrol_A               = new wxFlexGridSizer(1);

	sizerCtrol_A->Add(controlPanelMPR3D_A		, 1, wxALL|wxEXPAND, 2);
	sizerCtrol_A->Add(controlPanelClipping3D_A	, 1, wxALL|wxEXPAND, 2);
	sizerCtrol_A->Add( _btnCutImageData			, 1, wxALL, 2);


	panelControl_A->SetAutoLayout(true);
	panelControl_A->SetSizer(sizerCtrol_A);
	panelControl_A->SetSize(400,350);
	panelControl_A->Layout();


//
	_panelControl_B				= new wxPanel(panelControlSplit,-1,wxDefaultPosition,wxSize(800,800));	


	panelControlSplit->SplitVertically(panelControl_A, _panelControl_B);
	panelControlSplit->SetMinimumPaneSize( 20 );

	wxBoxSizer  *sizerCtrol             = new wxBoxSizer(wxHORIZONTAL);
	sizerCtrol->Add(panelControlSplit , 1, wxALL|wxEXPAND, 2);

	panelControlSplit->SetAutoLayout(true);
	panelControlSplit->SetSizer(sizerCtrol);
//	panelControlSplit->SetSize(400,350);
	panelControlSplit->Layout();
		
	int ww,hh;
	wxWindow *pp=this;
	while (pp->GetParent()!=NULL) pp=pp->GetParent();
	pp->GetSize(&ww,&hh);

//EEDxx2.4
//		panelClipping3D	-> SetMinimumPaneSize( -50 );
	panelClipping3D	-> SplitHorizontally( panelControlSplit,window3D/*, (int)(hh*0.20)*/ );
	panelClipping3D	-> SetMinimumPaneSize( 20 );
	wxwindow=panelClipping3D;

    wxBoxSizer *sizerH1 = new wxBoxSizer(wxHORIZONTAL);
	sizerH1->Add(wxwindow , 1, wxALL|wxEXPAND, 0);
	panel->SetAutoLayout(true);
	panel->SetSizer(sizerH1);
	panel->SetSize(400,400);
	panel->Layout();

//EEDxx2.4
//	panel->FitInside();
//	FitInside();

	return panel;
}
//--------------------------------------------------------------------------
void wxManualRegistration3D::AddPanelControl_B( wxWindow *parent, marImageData *marimagedata)
{

//	_imageData_B=marimagedata->GetImageData();

    vtkMPRBaseData* vtkmprbasedata = new vtkMPRBaseData();
	vtkmprbasedata->SetMarImageData(marimagedata);

	_wxvtkclipping3Dview_B = new wxVtkClipping3DView(_wxvtk3Dbaseview_Clipping3D);
	vtkClipping3DDataViewer *vtkclipping3Ddataviewer_B = new vtkClipping3DDataViewer(); 
	vtkclipping3Ddataviewer_B->SetVtkMPRBaseData(vtkmprbasedata);
	vtkclipping3Ddataviewer_B->Configure();
	_wxvtkclipping3Dview_B->SetVtkClipping3DDataViewer(vtkclipping3Ddataviewer_B);

	_wxvtkmpr3Dview_B = new wxVtkMPR3DView( _wxvtk3Dbaseview_Clipping3D );
	vtkMPR3DDataViewer *vtkmpr3Ddataviewer_B = new vtkMPR3DDataViewer(); 
	vtkmpr3Ddataviewer_B->SetVtkMPRBaseData(vtkmprbasedata);
	vtkmpr3Ddataviewer_B->Configure();
	_wxvtkmpr3Dview_B->SetVtkMPR3DDataViewer(vtkmpr3Ddataviewer_B);

//
	wxPanel		*controlPanelMPR3D_B		= _wxvtkmpr3Dview_B->CreateControlPanel(_panelControl_B);
	wxPanel		*controlPanelClipping3D_B	= _wxvtkclipping3Dview_B->CreateControlPanel(_panelControl_B);

//	wxBoxSizer		*sizerCtrol_B				= new wxBoxSizer(wxVERTICAL);
	wxFlexGridSizer *sizerCtrol_B               = new wxFlexGridSizer(1);

	sizerCtrol_B->Add(controlPanelMPR3D_B , 1, wxALL|wxEXPAND, 2);
	sizerCtrol_B->Add(controlPanelClipping3D_B , 1, wxALL|wxEXPAND, 2);

	_panelControl_B->SetAutoLayout(true);
	_panelControl_B->SetSizer(sizerCtrol_B);
	_panelControl_B->SetSize(400,350);
	_panelControl_B->Layout();
}

//--------------------------------------------------------------------------
void wxManualRegistration3D::AddSecondVolume(marImageData *marimagedata)
{
	AddPanelControl_B(_panelControl_B,marimagedata);
	ConfigureVTK_B();
	RefreshView();
}
//--------------------------------------------------------------------------
bool wxManualRegistration3D::GetIfSecondVolumeExist()
{
	bool result=false;
	if (_wxvtkmpr3Dview_B!=NULL)
	{
		result=true;
	}
	return result;
}
//----------------------------------------------------------------------------
void wxManualRegistration3D::OnCutImagaData(wxCommandEvent &event) 
{
	if (_btnCutImageData->GetValue()==true){
		_framePanelCutting = new wxFrame(this,-1,_T("Cutting Module"),wxDefaultPosition,wxDefaultSize,wxCAPTION|wxSTAY_ON_TOP| wxRESIZE_BORDER );
		_framePanelCutting->SetSize(550,400);
		_panelCutting	= new wxPanelCuttingImageData(_framePanelCutting);
		_panelCutting->SetWxVtk3DBaseView( _wxvtk3Dbaseview_Clipping3D  );
		_panelCutting->SetVtkMPRBaseData( _vtkmprbasedata_A );
		_panelCutting->Configure( );
		_framePanelCutting->Show();
//		_panelCutting->RefreshView();
		RefreshView();
	} else {
		if (_framePanelCutting!=NULL){
			_panelCutting->RemoveActors();
			_framePanelCutting->Close();
			_framePanelCutting	= NULL;
			_panelCutting		= NULL;
		}
	}
}

//--------------------------------------------------------------------------


// EOF - wxManualRegistration3D.cxx
