/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxManualRegistration3D.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:18 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef __WX__MANUAL__REGISTRATION__3D__HXX__
#define __WX__MANUAL__REGISTRATION__3D__HXX__

/*
#include <vector>

#include <vtkObjectBase.h>
#include <vtkCommand.h>
#include <vtkActor.h>
#include <vtkPoints.h>
#include <vtkPolyData.h>
#include <vtkPolyDataMapper.h>
#include <vtkProbeFilter.h>
#include <vtkPlaneSource.h> 
#include <vtkImageChangeInformation.h>
#include <vtkStructuredPoints.h> 
#include <vtkTransform.h> 
#include <vtkImageViewer2.h> 
#include <vtkBoxWidget.h>
*/
	     
/*
#include "kernel/marInterface.h"

#include "wxMPRBaseData.h"
#include "wxVtkBaseView.h"
*/

#include <vtkImageData.h> 

#include "wxMPRWidget.h"

#include <wx/panel.h>
#include <wx/notebook.h>


//------------------------------------------------------------------
//------------------------------------------------------------------
//------------------------------------------------------------------


class wxManualRegistration3D : public wxPanel
{
public:
    wxManualRegistration3D(wxWindow* parent,marImageData *marimageData);
	~wxManualRegistration3D( );

	void		ConfigureVTK();
	void		ConfigureVTK_B();

	void		RefreshView();
	void		OnRefreshView(wxCommandEvent & event);
	void		OnPositionRotation(wxScrollEvent& event);

	void		AddPanelControl_B( wxWindow *parent, marImageData *marimagedata);
	void		AddSecondVolume(marImageData *marimagedata);
	bool		GetIfSecondVolumeExist();
	void		OnTracking(wxCommandEvent& event);
	
	void		OnCutImagaData(wxCommandEvent &event);

private:

	vtkMPRBaseData						*_vtkmprbasedata_A;

	vtkTransform						*_transform;
	vtkTransform						*_transformBak;

	wxPanelCuttingImageData				*_panelCutting; 
	wxCheckBox							*_btnCutImageData;
	wxFrame								*_framePanelCutting; 

	double								xBak;
	double								yBak;
	double								zBak;
	wxSlider							*_posX;
	wxSlider							*_posY;
	wxSlider							*_posZ; 
	wxSlider							*_scaleX; 
	wxSlider							*_scaleY; 
	wxSlider							*_scaleZ; 
	wxSlider							*_angAlfa; 
	wxSlider							*_angBeta;
	wxSlider							*_angGama; 
	wxCheckBox							*_btnTrack;
	wxPanel								*_panelControl_B;
	marImageData						*_marimageData; 
//	vtkImageData						*_imageData_B; 
	wxVtk3DBaseView						*_wxvtk3Dbaseview_Clipping3D;
	wxVtkMPR3DView						*_wxvtkmpr3Dview_A;
	wxVtkClipping3DView					*_wxvtkclipping3Dview_A;
	wxVtkMPR3DView						*_wxvtkmpr3Dview_B;
	wxVtkClipping3DView					*_wxvtkclipping3Dview_B;

	wxPanel*	Create3DView( wxWindow *parent, vtkMPRBaseData *vtkmprbasedata);
	wxPanel*	CreateRegistration3DControl( wxWindow *parent, vtkMPRBaseData *vtkmprbasedata);

	DECLARE_EVENT_TABLE( );
};



#endif // __WX__MANUAL__REGISTRATION__3D__HXX__

// EOF - wxManualRegistration3D.h
