/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxManualSegmentation_MPRWidget.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:18 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/


#include "wxManualSegmentation_MPRWidget.h"

#include <wx/wx.h>
#include <wx/splitter.h>
#include <wx/notebook.h>
#include <wx/colordlg.h>

//EED 6 aout 2007
//#include "../tools/MaracasTools.h"



//-------------------------------------------------------------------
//-------------------------------------------------------------------
//-------------------------------------------------------------------

BEGIN_EVENT_TABLE( wxManualSegmentation_MPRWidget, wxPanel )
	EVT_MENU( 12121, wxManualSegmentation_MPRWidget::OnRefreshView )
//	EVT_MENU( 12122, wxManualSegmentation_MPRWidget::OnDClickLeft  )
END_EVENT_TABLE( );


wxManualSegmentation_MPRWidget::wxManualSegmentation_MPRWidget( wxWindow* parent,
                          marImageData *marimageData ,double voxelSize)
: wxPanel( parent, -1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL)
{

	_voxelSize							= voxelSize;
	_marimageData							= marimageData;

	_wxvtk3Dbaseview_Clipping3D_C		= NULL;
	_wxvtkmpr3Dview_C					= NULL;
	_wxvtkclipping3Dview_C				= NULL;

    wxSplitterWindow	*pnlSplitter	= new wxSplitterWindow( this , -1);
	
	int ww,hh;
	_MPRWidget2					= new wxMPRWidget2(pnlSplitter,_marimageData,voxelSize);
	wxPanel *	contour3DView	= Create3DViewContour( pnlSplitter , _MPRWidget2->GetVtkMPRBaseData());
	this->GetSize(&ww,&hh);

    pnlSplitter	-> SplitVertically( _MPRWidget2, contour3DView , 600);
	wxBoxSizer	*sizer	= new wxBoxSizer(wxVERTICAL  );
	sizer		-> Add( pnlSplitter ,1,wxGROW  ,0);
	pnlSplitter	-> SetMinimumPaneSize( 50 );
	this		-> SetSizer(sizer);
	//EEDxx2.4
	//	FitInside();
	

	
	//TEST

//EED 6 aout 2007
/*
	MaracasTools* maracasTools = MaracasTools::GetInstance();
	maracasTools->SetMPRWidget(this);
	wxFrame* maracasToolsFrame = maracasTools->GetToolbox(this);
	maracasToolsFrame->Show();
*/
	
	

}

//----------------------------------------------------------------------------

wxManualSegmentation_MPRWidget::~wxManualSegmentation_MPRWidget( )
{
	if (_wxvtk3Dbaseview_Clipping3D_C	!= NULL) { delete	_wxvtk3Dbaseview_Clipping3D_C;	}
	if (_wxvtkmpr3Dview_C				!= NULL) { delete	_wxvtkmpr3Dview_C;				}
	if (_wxvtkclipping3Dview_C			!= NULL) { delete	_wxvtkclipping3Dview_C;			}
}


//----------------------------------------------------------------------------
wxPanel* wxManualSegmentation_MPRWidget::Create3DViewContour( wxWindow *parent, vtkMPRBaseData *vtkmprbasedata)
{
	wxWindow *wxwindow;
	wxPanel *panel=new wxPanel(parent,-1);

	wxSplitterWindow	*panelClipping3D	= new wxSplitterWindow( panel , -1);
	_wxvtk3Dbaseview_Clipping3D_C = new wxVtk3DBaseView( panelClipping3D );

	_wxvtkclipping3Dview_C = new wxVtkClipping3DView(_wxvtk3Dbaseview_Clipping3D_C);
	vtkClipping3DDataViewer *vtkclipping3Ddataviewer = new vtkClipping3DDataViewer(); 
	vtkclipping3Ddataviewer->SetVtkMPRBaseData(vtkmprbasedata);
	vtkclipping3Ddataviewer->Configure();
	_wxvtkclipping3Dview_C->SetVtkClipping3DDataViewer(vtkclipping3Ddataviewer);

	_wxvtkmpr3Dview_C = new wxVtkMPR3DView( _wxvtk3Dbaseview_Clipping3D_C );
	vtkMPR3DDataViewer *vtkmpr3Ddataviewer = new vtkMPR3DDataViewer(); 
	vtkmpr3Ddataviewer->SetVtkMPRBaseData(vtkmprbasedata);
	vtkmpr3Ddataviewer->Configure();
	_wxvtkmpr3Dview_C->SetVtkMPR3DDataViewer(vtkmpr3Ddataviewer);

	wxWindow	*window3D				= _wxvtk3Dbaseview_Clipping3D_C->GetWxVTKRenderWindowInteractor();

	wxPanel		*panelControl			= new wxPanel(panelClipping3D,-1);	
	wxPanel		*controlPanelMPR3D		= _wxvtkmpr3Dview_C->CreateControlPanel(panelControl);
	wxPanel		*controlPanelClipping3D	= _wxvtkclipping3Dview_C->CreateControlPanel(panelControl);

//	wxBoxSizer  *sizerCtrol             = new wxBoxSizer(wxVERTICAL);
	wxFlexGridSizer  *sizerCtrol        = new wxFlexGridSizer(1);

	sizerCtrol->Add(controlPanelMPR3D , 1, wxALL|wxEXPAND, 2);
	sizerCtrol->Add(controlPanelClipping3D , 1, wxALL|wxEXPAND, 2);
	panelControl->SetAutoLayout(true);
	panelControl->SetSizer(sizerCtrol);
	panelControl->SetSize(400,350);
	panelControl->Layout();

	int ww,hh;
	wxWindow *pp=this;
	while (pp->GetParent()!=NULL) pp=pp->GetParent();
	pp->GetSize(&ww,&hh);

//EEDxx2.4
//		panelClipping3D	-> SetMinimumPaneSize( -50 );
	panelClipping3D	-> SplitHorizontally( panelControl,window3D, (int)(hh*0.20) );
	wxwindow=panelClipping3D;

    wxBoxSizer *sizerH1 = new wxBoxSizer(wxHORIZONTAL);
	sizerH1->Add(wxwindow , 1, wxALL|wxEXPAND, 0);
	panel->SetAutoLayout(true);
	panel->SetSizer(sizerH1);
	panel->SetSize(400,400);
	panel->Layout();

//EEDxx2.4
//	panel->FitInside();
//	FitInside();




	return panel;
}


//----------------------------------------------------------------------------
void wxManualSegmentation_MPRWidget::ConfigureVTK(){
	_MPRWidget2->ConfigureVTK();
	_wxvtk3Dbaseview_Clipping3D_C	->  Configure();
	_wxvtkmpr3Dview_C				->	Configure();
	_wxvtkclipping3Dview_C			->	Configure();

	vtkInteractorStyle3DView *vtkinteractorstyle3Dview	= new vtkInteractorStyle3DView();
	vtkinteractorstyle3Dview->SetWxVtkMPR3DView(_wxvtkmpr3Dview_C);
	vtkinteractorstyle3Dview->SetWxVtkClipping3DView(_wxvtkclipping3Dview_C);
	_wxvtk3Dbaseview_Clipping3D_C->GetInteractorStyleBaseView()->AddInteractorStyleMaracas( vtkinteractorstyle3Dview );

}

//----------------------------------------------------------------------------
vtkMPRBaseData  *wxManualSegmentation_MPRWidget::GetVtkMPRBaseData(){
	return _MPRWidget2->GetVtkMPRBaseData();
}
//----------------------------------------------------------------------------
vtkPlane2DView *wxManualSegmentation_MPRWidget::GetVtkPlane2DView()
{
	return _MPRWidget2->GetVtkPlane2DView();
}
//----------------------------------------------------------------------------
void wxManualSegmentation_MPRWidget::OnRefreshView(wxCommandEvent & event)
{
	RefreshView();
}
//----------------------------------------------------------------------------
void wxManualSegmentation_MPRWidget::RefreshView()
{
	this->_MPRWidget2->RefreshView();
	_wxvtkmpr3Dview_C				-> RefreshView();
	_wxvtkclipping3Dview_C			-> Refresh();
	_wxvtk3Dbaseview_Clipping3D_C	-> Refresh();
}


vtkRenderer* wxManualSegmentation_MPRWidget::GetRenderer(){
	return _wxvtkmpr3Dview_C->GetWxvtk3Dbaseview()->GetRenderer();
}



// EOF - wxManualSegmentation_MPRWidget.cxx




