/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxManualSegmentation_MPRWidget.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:18 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef __WX__MANUAL_SEGMENTATION__MPRWIDGET__HXX__
#define __WX__MANUAL_SEGMENTATION__MPRWIDGET__HXX__

#include "wxMPRWidget.h"
#include "../manualContour.h"
#include <wx/notebook.h>





//------------------------------------------------------------------
//------------------------------------------------------------------
//------------------------------------------------------------------


class wxManualSegmentation_MPRWidget : public wxPanel
{

public:
    wxManualSegmentation_MPRWidget(wxWindow* parent,marImageData *marimageData,double voxelSize);
	~wxManualSegmentation_MPRWidget( );

	void ConfigureVTK();

	void RefreshView();
	void OnRefreshView(wxCommandEvent & event);


	vtkMPRBaseData		*GetVtkMPRBaseData();
	vtkPlane2DView		*GetVtkPlane2DView();
	vtkRenderer			*GetRenderer();



private:
	double								_voxelSize;
	marImageData						*_marimageData; 
	wxMPRWidget2						*_MPRWidget2;

	//
	wxVtk3DBaseView						*_wxvtk3Dbaseview_Clipping3D_C;
	wxVtkMPR3DView						*_wxvtkmpr3Dview_C;
	wxVtkClipping3DView					*_wxvtkclipping3Dview_C;

	wxPanel		*Create3DViewContour( wxWindow *parent, vtkMPRBaseData *vtkmprbasedata);
	void		ConfigureContour();

	//MaracasTools* maracasTools;

	DECLARE_EVENT_TABLE( );



};




#endif // __WX__MANUAL__TREE__SEGMENTATION__WIDGET__HXX__ 

// EOF - wxManualSegmentation_MPRWidget.h
