/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef WX_PATHOLOGY_WIDGET_01
#define WX_PATHOLOGY_WIDGET_01
#include <vector>

#include "vtkImageData.h"
#include "vtkActor.h"
#include "vtkMarchingCubes.h"
#include "vtkPolyDataMapper.h"
#include "vtkAppendFilter.h"
#include "vtkImageThreshold.h"
#include "vtkExtractVOI.h"
#include "vtkOutlineFilter.h"
#include "vtkImageGaussianSmooth.h"
#include "vtkImageCast.h"
#include "vtkImageEuclideanDistance.h"
#include "vtkPolyDataConnectivityFilter.h"
#include "vtkPointSet.h"
#include "vtkDataSetMapper.h"
#include "vtkImageContinuousDilate3D.h"
#include "vtkStripper.h"
#include "vtkImageResample.h"
#include "vtkPolyDataNormals.h"
#include "vtkCellCenters.h"
#include "vtkImageEuclideanDistance.h"
//#include "vtkSphericalVOI.h"


#include "wxVTKRenderWindowInteractor.h"
#include "wxSurfaceWidget.h"
#include "wxVtkBaseView.h"


#include "kernel/marInterface.h"
#include "kernel/axisExtractor02.h"
#include "kernel/vtkSTLExtractor.h"
#include "kernel/vtkDijkstraImageData.h"    



class wxPathologyWidget_01: public wxPanel{
public:
	wxPathologyWidget_01(wxWindow *parentmar,marInterface *mar);
	~wxPathologyWidget_01();
	void ConfigureVTK();
	void ConfigureVTK(vtkImageData *imagedata, int x, int y, int z, double param);
	void Refresh();
	
	// --------------------------------------
	// STL FUNCTIONS DHC
	// --------------------------------------
	void ConfigureSTL();
	void generateSTLSurfaces();
	void OnBtnFileSTL(wxCommandEvent& event); 
	void OnBtnLoadBinaryForSTL(wxCommandEvent& event);
	void OnChangeSTLGaussLevel(wxScrollEvent& event);
	void OnChangeSTLMarchingCubesLevel(wxScrollEvent& event);
	void OnOpacitySTLExternal(wxScrollEvent& event);
	void OnOpacitySTLInternal(wxScrollEvent& event);
	void OnSTLSubdivisionLevel(wxScrollEvent& event);

	//---------------------------------------
	// PATHOLOGY FUNCTIONS
	//---------------------------------------
	void generatePathologySurface();
	void OnBtnSetP1(wxCommandEvent& event);
	void OnBtnSetP2(wxCommandEvent& event);
	void OnBtnSetPat(wxCommandEvent& event);
	void OnBtnExtractPat(wxCommandEvent& event);
	void OnChangePatOpacity(wxScrollEvent& event);
	void OnChangePatMarchingCubes(wxScrollEvent& event);
	void OnBtnExtractAxis(wxCommandEvent& event);
	

private:

	
	wxVtk3DBaseView		*_imageviewer3D;
	wxPanel				*CreateControlPanel(wxWindow *parent);
	wxPanel				*CreateViewPanel(wxWindow *parent);

	//Maracas
	marInterface		*_mar;
	wxSurfaceWidget		*_maracasSurfaceWidget;



	//---------------------
	// STL SURFACES DHC
	//---------------------
	char* workingDir;
	double stlDeltaGaussLevel;
	double stlMarchingCubesLevel;
	int stlSubdivisionLevel;

	vtkImageData * stlImageData;
	vtkPolyData *stlInterna;
	vtkPolyData *stlExterna;
	
	wxSlider	*stlSliderDeltaGauss;
	wxSlider	*stlSliderMarchingCubes;
	wxSlider    *stlSliderSubdivision;
	
	vtkPolyDataMapper *dsm1;
    vtkActor *actorInternal;
	wxSlider *stlSliderOpacityInternal;
    
	vtkPolyDataMapper *dsm2; 
    vtkActor *actorExternal;
	wxSlider *stlSliderOpacityExternal;

	vtkSTLExtractor *stlExtractor;
	

	//------------------------
	// MPR
	//------------------------
	void ConfigureMPR();
	int px, py, pz;
	vtkSphereSource				*mprSphereSource;
    vtkPolyDataMapper			*mprMapper;
    vtkActor					*mprActor;



	//--------------------------
	// PATHOLOGY
	//--------------------------
	void ConfigurePathologyExtraction();

	vtkSphereSource		*p1SphereSource;
	vtkPolyDataMapper	*p1Mapper;
	vtkActor			*p1Actor;

	vtkSphereSource		*p2SphereSource;
	vtkPolyDataMapper	*p2Mapper;
	vtkActor			*p2Actor;

	vtkSphereSource		*patSphereSource;
	vtkPolyDataMapper	*patMapper;
	vtkActor			*patActor;

	vtkOutlineFilter    *outlineFilter;
	vtkPolyDataMapper   *outlineMapper;
	vtkActor            *outlineActor;


	vtkSphereSource		*p3SphereSource;
	vtkPolyDataMapper	*p3Mapper;
	vtkActor			*p3Actor;


	wxFrame				*pathologyFrame;
	
	
	double p1Center[3];
	double p2Center[3];

	vtkImageData		*patImageData;
	vtkImageData		*segImageData;
	vtkExtractVOI		*voiFilter;
	
	vtkMarchingCubes	*cubesFilter;
	vtkPolyDataMapper	*dataMapper;
	vtkActor			*dataActor;

	vtkPolyDataMapper	*caminoMapper;
	vtkActor			*caminoActor;
	
	wxSlider	*patSliderOpacity;
	wxSlider	*patSliderMarchingCubes;
	wxSlider	*patSliderDeltaGauss;
	double patOpacityLevel;
	double patMCLevel;
	double patDeltaGauss;
	vtkImageGaussianSmooth		*gaussFilter; 
	vtkImageSeedConnectivity	*connectivityFilter;
	vtkImageThreshold			*thresholdFilter;
	vtkImageCast				*castFilter;
	wxSlider	*porcentajeSlider;
	double thresholdOTSU;
		

	vtkDijkstraImageData *dijkstraFilter;


	vtkImageContinuousDilate3D *dilateFilter;
	vtkStripper *stripper;
	vtkPolyDataConnectivityFilter *polyUnico;

	
	vtkImageData *isoBinaria;
	vtkImageEuclideanDistance *isoDistance;

};

#endif // WX_PATHOLOGY_WIDGET_01




