/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __WX__PROCESSING__CT__WIDGET__
#define __WX__PROCESSING__CT__WIDGET__



#include <vtkActor.h>
#include <vtkMarchingCubes.h>	
#include <vtkPolyDataMapper.h>
#include <vtkImageThreshold.h>
#include <vtkImageData.h>
#include <vtkImageSeedConnectivity.h>




#include "wxMPRWidget.h"
#include "wxVTKRenderWindowInteractor.h"
#include <kernel/axisExtractor02.h>

#include <kernel/marInterfaceCT.h>
#include <kernel/marAxis.h>


#include <wx/wx.h>
#include <wx/panel.h>

//------------------------------------------------------------------
//------------------------------------------------------------------
//------------------------------------------------------------------

class wxProcessingCTWidget: public wxPanel{
public:
	wxProcessingCTWidget(wxWindow *parent, marInterfaceCT *mar);
	~wxProcessingCTWidget();
	void ConfigureVTK(marImageData *marimagedata, int x, int y, int z);
	void Refresh();
	void OnLowThreshold(wxScrollEvent& event); // Umbral inferior
	void OnMidThreshold(wxScrollEvent& event); // Umbral medio
	void LowThreshold();
	void MidThreshold();

// MAZV 27 sep 2006
//	void OnHighThreshold(wxScrollEvent& event); // Umbral alto
	void OnZSlice(wxScrollEvent& event); // Z Slice
	void OnExtract(wxCommandEvent& event);
	void OnRefreshView(wxCommandEvent & event);

	void SetThreshold(int min	,int max);
	void GetThreshold(int *min	,int *max);

	void OnSpinLowThresholdSpin1(wxScrollEvent& event);
	void OnSpinLowThresholdSpin2(wxScrollEvent& event);



private:
	wxWindow					*_parent;

	// Original Volume
	vtkMarchingCubes	*_mCubes;
	vtkPolyDataMapper	*_surfMapper;
	vtkActor			*_surfActor;

	marInterfaceCT		*_mar;

	// New vtk - thresholding
	
	vtkImageThreshold			*_thresh;  //Lower - Upper
	vtkImageThreshold			*_thresh2; //Lower - Medium

	
	vtkImageSeedConnectivity	*_connect;
	vtkImageSeedConnectivity	*_connect2;
	vtkImageCast				*cast3;
	vtkImageCast				*cast4;
	vtkImageData				*data;
	

	wxSlider					*_lowthreshold;
	wxSlider					*_midthreshold;

	wxSlider					*_lowthresholdSpin1;
	wxSlider					*_lowthresholdSpin2;


// MAZV 27 sep 2006
//wxSlider						*_highthreshold;
	wxSlider					*_zslice;
	wxVtk2DBaseView				*_imageviewer2D_1;
	wxVtk2DBaseView				*_imageviewer2D_2;
	wxVtk2DBaseView				*_imageviewer2D_3;

	wxButton					*_extract;

	vtkBaseData					*_vtkbasedata_1;
	vtkBaseData					*_vtkbasedata_2;
	vtkBaseData					*_vtkbasedata_3;

	wxPanel						*CreateControlPanel(wxWindow *parent);
	wxPanel						*CreateViewPanel(wxWindow *parent);

	int			_x, _y, _z;
    double		_range[2];

	DECLARE_EVENT_TABLE( );


};

#endif // __WX__PROCESSING__CT__WIDGET__




