/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

 Program:   wxMaracas
 Module:    $RCSfile: wxQuantificationWidget.cxx,v $
 Language:  C++
 Date:      $Date: 2012/11/15 14:15:18 $
 Version:   $Revision: 1.2 $
 
  Copyright: (c) 2002, 2003
  License:
  
   This software is distributed WITHOUT ANY WARRANTY; without even
   the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
   PURPOSE.  See the above copyright notice for more information.
   
=========================================================================*/

#include "wxQuantificationWidget.h"
#include "../marDictionary.h"
//#include "../wxMaracasMPR.h"


//#include <matrix.h>
//#include <wx/notebook.h>



//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
BEGIN_EVENT_TABLE( wxQuantificationWidget, wxPanel )
	EVT_BUTTON(ID_BUTTON_CONTOUR		, wxQuantificationWidget::OnContour_BT						)
	EVT_BUTTON(ID_BUTTON_CLEAN			, wxQuantificationWidget::OnClean_BT						)
	EVT_BUTTON(ID_BUTTON_CLEAN_ALL		, wxQuantificationWidget::OnCleanAll_BT						)
	EVT_BUTTON(ID_BUTTON_SAVE_CONTOURS3D, wxQuantificationWidget::OnSaveContours3D_BT				)

//	EVT_BUTTON(ID_BUTTON_HEALTHY,	wxQuantificationWidget::OnHealthySlice_BT					)

	// PS ->     EVT_BUTTON(ID_BUTTON_CALCULATED, wxQuantificationWidget::OnCalculated_BT		)
	// PS ->     EVT_BUTTON(ID_BUTTON_PAUSE,      wxQuantificationWidget::OnPause_BT			)
	// PS ->     EVT_BUTTON(ID_BUTTON_DELETE,     wxQuantificationWidget::OnDelete_BT			)
	// PS ->     EVT_BUTTON(ID_BUTTON_POINT,      wxQuantificationWidget::OnSetPoint_BT			)

	EVT_CHECKBOX(ID_CHECKBOX_HEALTHY,			wxQuantificationWidget::OnHealthySlice_CB		)
	EVT_CHECKBOX(ID_CHECKBOX_SHOW_SURFACE,		wxQuantificationWidget::OnShowSurface_CB		)
	EVT_CHECKBOX(ID_CHECKBOX_VISIBLE_RINGS,		wxQuantificationWidget::OnVisibleRing_CB		)
	EVT_CHECKBOX(ID_CHECKBOX_PERPENDICULAR,		wxQuantificationWidget::OnPerpendicular_CB		)

	EVT_RADIOBUTTON(ID_RADIOBUTTON_GREYSCALE,	wxQuantificationWidget::OnGreyScale_RB			)
	EVT_RADIOBUTTON(ID_RADIOBUTTON_COLOR,		wxQuantificationWidget::OnColor_RB				)

	EVT_COMMAND_SCROLL(ID_SLIDER_SLICE,			wxQuantificationWidget::OnSliderSliceScroll		)

	EVT_COMMAND_SCROLL(ID_SLIDER_OPACITY,		wxQuantificationWidget::OnSliderOpacityScroll	)
	EVT_COMMAND_SCROLL_THUMBRELEASE(ID_SLIDER_ISOVALUE, wxQuantificationWidget::OnSliderIsovalueScroll	)
END_EVENT_TABLE( );


//--------------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------------
wxQuantificationWidget::wxQuantificationWidget(wxWindow* parent, wxWindowID id,
                                               const wxPoint& pos, const wxSize& size, long style,
                                               const wxString& name)
: wxQuantificationWidget_base( parent, id, pos, size, style, name )
{
    panel_splitter		 = new wxSplitterWindow( this			, -1, wxDefaultPosition, wxSize(400,400 ), wxSP_3D | wxSP_LIVE_UPDATE | wxCLIP_CHILDREN );
// 	panel_left			 = new wxPanel(panel_splitter			, -1, wxDefaultPosition, wxSize(400,400));
 	panel_right			 = new wxPanel(panel_splitter			, -1, wxDefaultPosition, wxSize(400,400));

    panel_splitter_left	 = new wxSplitterWindow( panel_splitter			, -1, wxDefaultPosition, wxSize(400,400 ), wxSP_3D | wxSP_LIVE_UPDATE | wxCLIP_CHILDREN );
	panel_left_up		 = new wxPanel(panel_splitter_left		, -1, wxDefaultPosition, wxSize(200,200));
	panel_left_down		 = new wxPanel(panel_splitter_left		, -1, wxDefaultPosition, wxSize(200,200));


    panel_splitter_right = new wxSplitterWindow( panel_right	, -1, wxDefaultPosition, wxSize(400,400 ), wxSP_3D | wxSP_LIVE_UPDATE | wxCLIP_CHILDREN );
	panel_right_up		 = new wxPanel(panel_splitter_right		, -1, wxDefaultPosition, wxSize(200,200));
	panel_right_down	 = new wxPanel(panel_splitter_right		, -1, wxDefaultPosition, wxSize(200,200));



	// maracas
	_mar = NULL;
	SetSizeHealthyRegion( 5 );

//EEDxx 2.6
//	this->SetBackgroundColour(*wxLIGHT_GREY);

	_3DWorld = new vtk3DQuantSurfaceWidget( panel_left_up, ID_QUANTIF3D );
	_3DWorld->SetInterfaceVtkPanelWidgets(this);

	_2DWorld = new vtk2DQuantSliceWidget( panel_right_up, -1 );
	_2DWorld->SetSize(800,800);
	_2DWorld->SetInterfaceVtkPanelWidgets(this);
	
	
	this->Set_control();
	this->Do_layout();
	this->Set_Data();
	_bak_ActualSlice=-1;

	Refresh();

//EED Borrame
//startTimeRI = clock();

}


//--------------------------------------------------------------------------------
// Destructor
// ----------------------------------------------------------------------------
wxQuantificationWidget::~wxQuantificationWidget( )
{
//EEDx15
	_3DWorld->Delete( );
//	delete _2DWorld;
}
// ----------------------------------------------------------------------------
wxPanel* wxQuantificationWidget::CreateStenosisPanel(){
	marDictionary marDict;

	wxPanel* panel = new wxPanel(panel_right_down);

	_st_Label100 = new wxStaticText(panel, -1, wxString(marDict.GetString(255), wxConvUTF8) ); // "Stenosis (area)"
	_st_Label101 = new wxStaticText(panel, -1, wxString(marDict.GetString(260), wxConvUTF8) ); // "Stenosis (diameter)"
//	_st_Label102 = new wxStaticText(panel, -1, "                          < Area (mm^2) > Stenosis :  ",wxPoint(0,0),wxDefaultSize,wxALIGN_RIGHT );
//	_st_Label103 = new wxStaticText(panel, -1, "                       < Perimeter (mm) > Stenosis :  ",wxPoint(0,0),wxDefaultSize,wxALIGN_RIGHT );
//	_st_Label104 = new wxStaticText(panel, -1, "        < Diameter (mm) from Area > Stenosis :  ",wxPoint(0,0),wxDefaultSize,wxALIGN_RIGHT );
//	_st_Label105 = new wxStaticText(panel, -1, "  < Diameter (mm) from Perimeter > Stenosis :  ",wxPoint(0,0),wxDefaultSize,wxALIGN_RIGHT );
//	_st_Label106 = new wxStaticText(panel, -1, "          < Minimum Diameter (mm) > Stenosis :  ",wxPoint(0,0),wxDefaultSize,wxALIGN_RIGHT );
//	_st_Label107 = new wxStaticText(panel, -1, "          < Maximum Diameter (mm) > Stenosis :  ",wxPoint(0,0),wxDefaultSize,wxALIGN_RIGHT );
//	_st_Label108 = new wxStaticText(panel, -1, "          < Avarege Diameter (mm) > Stenosis :  ",wxPoint(0,0),wxDefaultSize,wxALIGN_RIGHT );

	_st_Value100 = new wxStaticText(panel, -1, _T("--                ") );
	_st_Value101 = new wxStaticText(panel, -1, _T("--                ") );
//	_st_Value102 = new wxStaticText(panel, -1, "--");
//	_st_Value103 = new wxStaticText(panel, -1, "--");
//	_st_Value104 = new wxStaticText(panel, -1, "--");
//	_st_Value105 = new wxStaticText(panel, -1, "--");
//	_st_Value106 = new wxStaticText(panel, -1, "--");
//	_st_Value107 = new wxStaticText(panel, -1, "--");
//	_st_Value108 = new wxStaticText(panel, -1, "--");

//EEDxx 2.6
//	wxStaticText *_st_LabelBlanc = new wxStaticText(panel, -1, "                 ");
//	_st_LabelBlanc->SetBackgroundColour(*wxLIGHT_GREY);

//EEDxx 2.6
//	panel->SetBackgroundColour(wxColour(100,0,100));
//	_st_Label100->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Label101->SetBackgroundColour(*wxLIGHT_GREY);




//	_st_Label102->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Label103->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Label104->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Label105->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Label106->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Label107->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Label108->SetBackgroundColour(*wxLIGHT_GREY);


//EEDxx 2.6
//	_st_Value100->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Value101->SetBackgroundColour(*wxLIGHT_GREY);


//	_st_Value102->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Value103->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Value104->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Value105->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Value106->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Value107->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Value108->SetBackgroundColour(*wxLIGHT_GREY);

	wxFont font(14,wxDEFAULT ,wxNORMAL,wxBOLD);
//	_st_Label100->SetFont(font);
//	_st_Label101->SetFont(font);
	_st_Value100->SetFont(font);
	_st_Value101->SetFont(font);



	wxGridSizer*  gridSizer1	= new wxFlexGridSizer(1);
	gridSizer1->Add( new wxStaticText(panel, -1, _T("                 "))	,15, wxALL|wxEXPAND|wxALIGN_CENTRE_HORIZONTAL, 0);
	gridSizer1->Add(_st_Value100	,15, wxALL|wxEXPAND|wxALIGN_CENTRE_HORIZONTAL, 0);
	gridSizer1->Add(_st_Label100	,15, wxALL|wxEXPAND|wxALIGN_CENTRE_HORIZONTAL, 0);
	gridSizer1->Add( new wxStaticText(panel, -1, _T("                 "))	,15, wxALL|wxEXPAND|wxALIGN_CENTRE_HORIZONTAL, 0);
	gridSizer1->Add(_st_Value101	,15, wxALL|wxEXPAND|wxALIGN_CENTRE_HORIZONTAL, 0);
	gridSizer1->Add(_st_Label101	,15, wxALL|wxEXPAND|wxALIGN_CENTRE_HORIZONTAL, 0);



//	gridSizer->Add(_st_LabelBlanc);
//	gridSizer->Add(_st_LabelBlanc);
//	gridSizer->Add(_st_LabelBlanc);
//	gridSizer->Add(_st_LabelBlanc);
//	gridSizer->Add(_st_Label102);
//	gridSizer->Add(_st_Value102);
//	gridSizer->Add(_st_LabelBlanc);
//	gridSizer->Add(_st_LabelBlanc);
//	gridSizer->Add(_st_Label103);
//	gridSizer->Add(_st_Value103);
//	gridSizer->Add(_st_LabelBlanc);
//	gridSizer->Add(_st_LabelBlanc);
//	gridSizer->Add(_st_Label104);
//	gridSizer->Add(_st_Value104);
//	gridSizer->Add(_st_LabelBlanc);
//	gridSizer->Add(_st_LabelBlanc);
//	gridSizer->Add(_st_Label105);
//	gridSizer->Add(_st_Value105);
//	gridSizer->Add(_st_LabelBlanc);
//	gridSizer->Add(_st_LabelBlanc);
//	gridSizer->Add(_st_Label106);
//	gridSizer->Add(_st_Value106);
//	gridSizer->Add(_st_LabelBlanc);
//	gridSizer->Add(_st_LabelBlanc);
//	gridSizer->Add(_st_Label107);
//	gridSizer->Add(_st_Value107);
//	gridSizer->Add(_st_LabelBlanc);
//	gridSizer->Add(_st_LabelBlanc);
//	gridSizer->Add(_st_Label108);
//	gridSizer->Add(_st_Value108);

	wxGridSizer*  gridSizer		= new wxFlexGridSizer(4);
	gridSizer->Add( new wxStaticText(panel, -1, _T("                 "))	,15, wxALIGN_LEFT , 50);
	gridSizer->Add( new wxStaticText(panel, -1, _T("                 "))	,15, wxALIGN_LEFT , 50);
	gridSizer->Add( new wxStaticText(panel, -1, _T("                 "))	,15, wxALIGN_LEFT , 50);
	gridSizer->Add(gridSizer1		,15, wxALIGN_LEFT , 50);

	panel->SetAutoLayout(true);
	panel->SetSizer(gridSizer);
	panel->Layout();

//EEDxx 2.6
//	panel->SetBackgroundColour(*wxLIGHT_GREY);

	panel->SetSize(400,300);
	panel->SetSize( gridSizer->GetMinSize() );

	return panel;
}

//--------------------------------------------------------

void wxQuantificationWidget::Set_control(){
	marDictionary marDict;
	
	// wxChart

	// EED 
	//_Chart = new wxChart( this, ID_QUANTIF3D );
	//_Chart->SetMaxWidthHeight(500,300);
	//_Chart->SetBackgroundColour(*wxWHITE);

	 _wxStenosisPanel = CreateStenosisPanel();

	//wxButton
	// PS ->   _bt_Point = new wxButton( this, ID_BUTTON_POINT, "Point...",
	// PS ->                             wxDefaultPosition, wxDefaultSize, wxBU_EXACTFIT, wxDefaultValidator);
//	_bt_Healthy = new wxButton( panel_left, ID_BUTTON_HEALTHY, "Healthy Slice",
//		wxDefaultPosition, wxDefaultSize, wxBU_EXACTFIT, wxDefaultValidator);



	// PS ->   _bt_ContourCalculated = new wxButton( this, ID_BUTTON_CALCULATED, "Contour calculated",
	// PS ->                                         wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator);
	// PS ->   _bt_Pause = new wxButton( this, ID_BUTTON_PAUSE, "Pause",
	// PS ->                             wxDefaultPosition, wxDefaultSize, wxBU_EXACTFIT, wxDefaultValidator);
	// PS ->   _bt_Delete = new wxButton( this, ID_BUTTON_DELETE, "Delete Quantification",
	// PS ->                              wxDefaultPosition, wxDefaultSize, wxBU_EXACTFIT, wxDefaultValidator);


	

	_cb_HealthySlice	= new wxCheckBox( panel_left_down, ID_CHECKBOX_HEALTHY, wxString(marDict.GetString(205), wxConvUTF8)); // "Healthy slice"
	_cb_HealthySlice->SetValue(true);
//EEDxx 2.6
//	_cb_HealthySlice->SetBackgroundColour(*wxLIGHT_GREY);
	_cb_Perpendicular	= new wxCheckBox( panel_left_down, ID_CHECKBOX_PERPENDICULAR, wxString(marDict.GetString(210), wxConvUTF8)); //"Perpendicular section"
	_cb_Perpendicular->SetValue(true);
//EEDxx 2.6
//	_cb_Perpendicular->SetBackgroundColour(*wxLIGHT_GREY);

	_rb_GreyScale		= new wxRadioButton( panel_left_down, ID_RADIOBUTTON_GREYSCALE, wxString(marDict.GetString(230), wxConvUTF8), wxDefaultPosition,wxDefaultSize,wxRB_GROUP  ); //"greyscale    "
	_rb_GreyScale->SetValue(true);
//EEDxx 2.6
//	_rb_GreyScale->SetBackgroundColour(*wxLIGHT_GREY);

	_rb_Color			= new wxRadioButton( panel_left_down, ID_RADIOBUTTON_COLOR, wxString(marDict.GetString(235), wxConvUTF8), wxDefaultPosition,wxDefaultSize );//"color    "
	_rb_Color->SetValue(false);
//EEDxx 2.6
//	_rb_Color->SetBackgroundColour(*wxLIGHT_GREY);

	_cb_VisibleRings	= new wxCheckBox( panel_left_down, ID_CHECKBOX_VISIBLE_RINGS, wxString(marDict.GetString(215), wxConvUTF8));//"Visible rings"
	_cb_VisibleRings->SetValue(true);
//EEDxx 2.6
//	_cb_VisibleRings->SetBackgroundColour(*wxLIGHT_GREY);
	_cb_ShowSurface		= new wxCheckBox( panel_left_down, ID_CHECKBOX_SHOW_SURFACE, wxString(marDict.GetString(220), wxConvUTF8));//"Show Surface"
	_cb_ShowSurface->SetValue(true);
//EEDxx 2.6
//	_cb_ShowSurface->SetBackgroundColour(*wxLIGHT_GREY);

	
	_bt_AddContour3D		= new wxButton( panel_left_down, ID_BUTTON_CONTOUR, wxString(marDict.GetString(245), wxConvUTF8) ,//"Add mark contour"
	                               wxDefaultPosition, wxDefaultSize, wxBU_EXACTFIT, wxDefaultValidator);
	_bt_CleanContour3D		= new wxButton( panel_left_down, ID_BUTTON_CLEAN, wxString(marDict.GetString(250), wxConvUTF8) ,//"Erase mark contours"
	                             wxDefaultPosition, wxDefaultSize, wxBU_EXACTFIT, wxDefaultValidator);

	_bt_CleanAllContours3D	= new wxButton( panel_left_down, ID_BUTTON_CLEAN_ALL, wxString(marDict.GetString(253), wxConvUTF8) ,//"Erase all mark contours"
	                             wxDefaultPosition, wxDefaultSize, wxBU_EXACTFIT, wxDefaultValidator);

	_bt_SaveContours3D	= new wxButton( panel_left_down, ID_BUTTON_SAVE_CONTOURS3D, wxString(marDict.GetString(248), wxConvUTF8) ,//"Save contours 3D"
	                             wxDefaultPosition, wxDefaultSize, wxBU_EXACTFIT, wxDefaultValidator);

	//wxSlider
	_sl_Slice    = new wxSlider( panel_left_down, ID_SLIDER_SLICE	, 0, 0, 10000, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );
	_sl_Isovalue = new wxSlider( panel_left_down, ID_SLIDER_ISOVALUE, 0, 0, 10000, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );
	_sl_Opacity  = new wxSlider( panel_left_down, ID_SLIDER_OPACITY	, 0, 0, 100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );
//EEDxx 2.6
//	_sl_Slice->SetBackgroundColour(*wxLIGHT_GREY);
//	_sl_Isovalue->SetBackgroundColour(*wxLIGHT_GREY);
//	_sl_Opacity->SetBackgroundColour(*wxLIGHT_GREY);

	// size
	_sl_Slice->SetSize(1800,16);
	_sl_Isovalue->SetSize(300,16);
	_sl_Opacity->SetSize(300,16);
	
	// Text
	_st_Slice	 = new wxStaticText(panel_left_down, -1, wxString(marDict.GetString(90), wxConvUTF8) ); //"Slice "
	_st_Isovalue = new wxStaticText(panel_left_down, -1, wxString(marDict.GetString(240), wxConvUTF8) ); //"Isovalue"
	_st_Opacity  = new wxStaticText(panel_left_down, -1, wxString(marDict.GetString(225), wxConvUTF8) ); //"Opacity "
//EEDxx 2.6
//	_st_Slice->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Isovalue->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Opacity->SetBackgroundColour(*wxLIGHT_GREY);
	
	
//	_st_Label0 = new wxStaticText(this, -1, "Partial Axis Lenght");
//	_st_Value0 = new wxStaticText(this, -1, "0.00");
//	_st_Label0->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Value0->SetBackgroundColour(*wxLIGHT_GREY);
	_st_Label1 = new wxStaticText(this, -1, wxString(marDict.GetString(380), wxConvUTF8) ); //"Total Axis Lenght"
	_st_Value1 = new wxStaticText(this, -1, _T("0.00"));

//EEDxx 2.6
//	_st_Label1->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Value1->SetBackgroundColour(*wxLIGHT_GREY);

	_st_Label2 = new wxStaticText(this, -1, wxString(marDict.GetString(390), wxConvUTF8) );//"Area"
	_st_Value2 = new wxStaticText(this, -1, _T("0.00"));
//EEDxx 2.6
//	_st_Label2->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Value2->SetBackgroundColour(*wxLIGHT_GREY);

	_st_Label3 = new wxStaticText(this, -1, wxString(marDict.GetString(400), wxConvUTF8) );//"Perimeter"
	_st_Value3 = new wxStaticText(this, -1, _T("0.00") );
//EEDxx 2.6
//	_st_Label3->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Value3->SetBackgroundColour(*wxLIGHT_GREY);


//	_st_Label4 = new wxStaticText(this, -1, "Diameter from area");
//	_st_Value4 = new wxStaticText(this, -1, "0.00");
//	_st_Label4->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Value4->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Label5 = new wxStaticText(this, -1, "Diameter from perimeter");
//	_st_Value5 = new wxStaticText(this, -1, "0.00");
//	_st_Label5->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Value5->SetBackgroundColour(*wxLIGHT_GREY);
	_st_Label6 = new wxStaticText(this, -1, wxString(marDict.GetString(405), wxConvUTF8) );//"Minimum Diameter"
	_st_Value6 = new wxStaticText(this, -1, _T("0.00"));
//EEDxx 2.6
//	_st_Label6->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Value6->SetBackgroundColour(*wxLIGHT_GREY);
	_st_Label7 = new wxStaticText(this, -1, wxString(marDict.GetString(410), wxConvUTF8) );//"Maximum Diameter"
	_st_Value7 = new wxStaticText(this, -1, _T("0.00"));
//EEDxx 2.6
//	_st_Label7->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Value7->SetBackgroundColour(*wxLIGHT_GREY);
	_st_Label8 = new wxStaticText(this, -1, wxString(marDict.GetString(415), wxConvUTF8) );//"Average Diameter"
	_st_Value8 = new wxStaticText(this, -1, _T("0.00"));
//EEDxx 2.6
//	_st_Label8->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Value8->SetBackgroundColour(*wxLIGHT_GREY);
	// EED -> _st_Label9 = new wxStaticText(this, -1, "Stenosis");
	// EED -> _st_Value9 = new wxStaticText(this, -1, "0.00");
	// EED -> _st_Label9->SetBackgroundColour(*wxLIGHT_GREY);
	// EED -> _st_Value9->SetBackgroundColour(*wxLIGHT_GREY);

	_st_LabelRef101 = new wxStaticText(this, -1, wxString(marDict.GetString(385), wxConvUTF8) );//"Seg. Length"
	_st_ValueRef101 = new wxStaticText(this, -1, _T("--"));
//EEDxx 2.6
//	_st_LabelRef101->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_ValueRef101->SetBackgroundColour(*wxLIGHT_GREY);
	_st_LabelRef102 = new wxStaticText(this, -1, wxString(marDict.GetString(395), wxConvUTF8) );//"Ref. Area"
	_st_ValueRef102 = new wxStaticText(this, -1, _T("--"));
//EEDxx 2.6
//	_st_LabelRef102->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_ValueRef102->SetBackgroundColour(*wxLIGHT_GREY);
	_st_LabelRef103 = new wxStaticText(this, -1, wxString(marDict.GetString(420), wxConvUTF8) );//"Ref. Average Diam."
	_st_ValueRef103 = new wxStaticText(this, -1, _T("--"));
//EEDxx 2.6
//	_st_LabelRef103->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_ValueRef103->SetBackgroundColour(*wxLIGHT_GREY);

	_pl_cntlHealthySick2 = new wxPanelControlsHealthySickSlice2(panel_right_down,this);

//EEDxx 2.6
//   panel_left->SetBackgroundColour(*wxLIGHT_GREY);
//	panel_right_up->SetBackgroundColour(*wxLIGHT_GREY);
//	panel_right_down->SetBackgroundColour(*wxLIGHT_GREY);
//	panel_splitter_right->SetBackgroundColour(*wxLIGHT_GREY);
//	panel_splitter->SetBackgroundColour(*wxLIGHT_GREY);
 
}

//--------------------------------------------------------

void wxQuantificationWidget::Do_layout()
{
	
	//Do the layout:
	
	wxBoxSizer			*sizer_principal	= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*status				= new wxBoxSizer(wxHORIZONTAL);

//EEDxx 2.6	
//	wxFlexGridSizer		*medium_right_up	= new wxFlexGridSizer(1,0);
	wxBoxSizer			*medium_right_up	= new wxBoxSizer(wxVERTICAL);

	wxFlexGridSizer		*medium_right_down	= new wxFlexGridSizer(1,0);


	wxBoxSizer			*medium_left_up		= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*medium_right		= new wxBoxSizer(wxVERTICAL);
//	wxFlexGridSizer		*autoQuantif		= new wxFlexGridSizer(1,0);


//	wxStaticBoxSizer	*axe				= new wxStaticBoxSizer(new wxStaticBox(panel_left_down, -1, _T("")), wxVERTICAL);
	wxFlexGridSizer		*axe				= new wxFlexGridSizer(1);
	axe->AddGrowableCol(0);

	wxFlexGridSizer		*axe1				= new wxFlexGridSizer(10,0);
	wxBoxSizer			*axe2				= new wxBoxSizer(wxHORIZONTAL);
	wxFlexGridSizer		*axe3				= new wxFlexGridSizer(10,0);
	wxFlexGridSizer		*axe4				= new wxFlexGridSizer(10,0);
	wxBoxSizer			*axe5				= new wxBoxSizer(wxHORIZONTAL);
	wxBoxSizer			*axe6				= new wxBoxSizer(wxHORIZONTAL);
	
	wxBoxSizer			*status0			= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*status1			= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*status2			= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*status3			= new wxBoxSizer(wxVERTICAL);
//	wxBoxSizer			*status4			= new wxBoxSizer(wxVERTICAL);
//	wxBoxSizer			*status5			= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*status6			= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*status7			= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*status8			= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*status9			= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*statusRef1			= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*statusRef2			= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*statusRef3			= new wxBoxSizer(wxVERTICAL);
	

	axe1->Add(_st_Slice					, 10, wxALL|wxEXPAND, 0);
	axe1->Add(_sl_Slice					, 10, wxALL|wxGROW, 0);
	axe1->AddGrowableCol(1);

	axe2->Add(_cb_HealthySlice			, 10, wxALL|wxEXPAND, 0);
	axe2->Add(_cb_Perpendicular			, 10, wxALL|wxEXPAND, 0);
	axe2->Add(_cb_VisibleRings			, 10, wxALL|wxEXPAND, 0);
	axe2->Add(_cb_ShowSurface			, 10, wxALL|wxEXPAND, 0);

	axe3->Add(_st_Opacity				,  1, wxALL|wxEXPAND, 0);
	axe3->Add(_sl_Opacity				, 10, wxALL|wxGROW, 0);
	axe3->Add(_rb_GreyScale				, 10, wxALL|wxEXPAND, 0);
	axe3->Add(_rb_Color					, 10, wxALL|wxEXPAND, 0);
	axe3->AddGrowableCol(1);

	axe4->Add(_st_Isovalue				,  1, wxALL|wxEXPAND, 0);
	axe4->Add(_sl_Isovalue				,  1, wxALL|wxGROW, 0);
	axe4->AddGrowableCol(1);

	axe5->Add(_bt_AddContour3D			,  1				);
	axe5->Add(_bt_CleanContour3D		,  1				);
	axe6->Add(_bt_CleanAllContours3D	,  1				);
	axe6->Add(_bt_SaveContours3D		,  1				);


//	status0->Add(_st_Label0, 1, wxALL|wxALIGN_CENTER, 5);
//	status0->Add(_st_Value0, 1, wxALL|wxALIGN_CENTER, 5);
	status1->Add(_st_Label1, 1, wxALL|wxALIGN_CENTER, 5);
	status1->Add(_st_Value1, 1, wxALL|wxALIGN_CENTER, 5);
	status2->Add(_st_Label2, 1, wxALL|wxALIGN_CENTER, 5);
	status2->Add(_st_Value2, 1, wxALL|wxALIGN_CENTER, 5);
	status3->Add(_st_Label3, 1, wxALL|wxALIGN_CENTER, 5);
	status3->Add(_st_Value3, 1, wxALL|wxALIGN_CENTER, 5);
//	status4->Add(_st_Label4, 1, wxALL|wxALIGN_CENTER, 5);
//	status4->Add(_st_Value4, 1, wxALL|wxALIGN_CENTER, 5);
//	status5->Add(_st_Label5, 1, wxALL|wxALIGN_CENTER, 5);
//	status5->Add(_st_Value5, 1, wxALL|wxALIGN_CENTER, 5);
	status6->Add(_st_Label6, 1, wxALL|wxALIGN_CENTER, 5);
	status6->Add(_st_Value6, 1, wxALL|wxALIGN_CENTER, 5);
	status7->Add(_st_Label7, 1, wxALL|wxALIGN_CENTER, 5);
	status7->Add(_st_Value7, 1, wxALL|wxALIGN_CENTER, 5);
	status8->Add(_st_Label8, 1, wxALL|wxALIGN_CENTER, 5);
	status8->Add(_st_Value8, 1, wxALL|wxALIGN_CENTER, 5);
	// EED -> status9->Add(_st_Label9, 1, wxALL|wxALIGN_CENTER, 5);
	// EED -> status9->Add(_st_Value9, 1, wxALL|wxALIGN_CENTER, 5);
	
	statusRef1->Add(_st_LabelRef101, 1, wxALL|wxALIGN_CENTER, 5);
	statusRef1->Add(_st_ValueRef101, 1, wxALL|wxALIGN_CENTER, 5);
	statusRef2->Add(_st_LabelRef102, 1, wxALL|wxALIGN_CENTER, 5);
	statusRef2->Add(_st_ValueRef102, 1, wxALL|wxALIGN_CENTER, 5);
	statusRef3->Add(_st_LabelRef103, 1, wxALL|wxALIGN_CENTER, 5);
	statusRef3->Add(_st_ValueRef103, 1, wxALL|wxALIGN_CENTER, 5);


//	status->Add(status0		, 1, wxALL|wxEXPAND, 0);
	status->Add(status1		, 1, wxALL|wxEXPAND, 0);
	status->Add(statusRef1	, 1, wxALL|wxEXPAND, 0);
	status->Add(status2		, 1, wxALL|wxEXPAND, 0);
	status->Add(statusRef2	, 1, wxALL|wxEXPAND, 0);
	status->Add(status3		, 1, wxALL|wxEXPAND, 0);
//	status->Add(status4		, 1, wxALL|wxEXPAND, 0);
//	status->Add(status5		, 1, wxALL|wxEXPAND, 0);
	status->Add(status6		, 1, wxALL|wxEXPAND, 0);
	status->Add(status7		, 1, wxALL|wxEXPAND, 0);
	status->Add(status8		, 1, wxALL|wxEXPAND, 0);
	status->Add(statusRef3	, 1, wxALL|wxEXPAND, 0);
	// EED -> status->Add(status9, 1, wxALL|wxEXPAND, 0);
	
	axe->Add(axe1, 2, wxALL|wxEXPAND, 0);
	axe->Add(axe2, 2, wxALL|wxEXPAND, 0);   //wxALIGN_CENTER_HORIZONTAL
	axe->Add(axe3, 2, wxALL|wxEXPAND, 0);
	axe->Add(axe4, 2, wxALL|wxEXPAND, 0);

//	axe->Add(axe5, 2, wxALL|wxEXPAND, 0);
//	axe->Add(axe6, 2, wxALL|wxEXPAND, 0);
	axe->Add(axe5);
	axe->Add(axe6);

	panel_left_down->SetAutoLayout(true);
	panel_left_down->SetSizer(axe);
	panel_left_down->Layout();


//EEDxx 2.6 GROW
//	medium_right_up->Add(_2DWorld				, 1, wxALL|wxGROW, 5);
	medium_right_up->Add(_2DWorld				, 1, wxALL|wxEXPAND, 5);

	medium_right_down->Add(_wxStenosisPanel		, 1, wxALL, 5);
	medium_right_down->Add(_pl_cntlHealthySick2	, 1, wxALL, 5);


	//medium_right->Add(_Chart			, 1, wxALL|wxEXPAND	, 0);
	
//	panel_left->SetAutoLayout(true);
//	panel_left->SetSizer(medium_left);
//	panel_left->Layout();


	medium_left_up->Add(_3DWorld					, 1, wxEXPAND, 0);
	panel_left_up->SetAutoLayout(true);
	panel_left_up->SetSizer(medium_left_up);
	panel_left_up->Layout();


    panel_splitter_left->SplitHorizontally( panel_left_up , panel_left_down );
    panel_splitter_left->SetMinimumPaneSize( 50 );



	panel_right_up->SetAutoLayout(true);
	panel_right_up->SetSizer(medium_right_up);
	panel_right_up->Layout();

	panel_right_down->SetAutoLayout(true);
	panel_right_down->SetSizer(medium_right_down);
	panel_right_down->Layout();


	int ww,hh;
	wxWindow *pp=this;
	while (pp->GetParent()!=NULL) pp=pp->GetParent();
	pp->GetSize(&ww,&hh);

    panel_splitter_right->SplitHorizontally( panel_right_up, panel_right_down, (int)(hh*0.4)  );
    panel_splitter_right->SetMinimumPaneSize( 50 );
	

//EEDxx 2.6 GROW
//	medium_right->Add(panel_splitter_right,1 ,wxGROW,0	);
	medium_right->Add(panel_splitter_right,1 ,wxALL|wxEXPAND,0	);
	panel_right->SetAutoLayout(true);
	panel_right->SetSizer(medium_right);
	panel_right->Layout();
//	panel_right->FitInside();


    panel_splitter->SplitVertically( panel_splitter_left , panel_right, (int)(ww*0.6) );
    panel_splitter->SetMinimumPaneSize( 50 );

//EEDxx 2.6 GROW
//	sizer_principal->Add( panel_splitter	, 1	, wxGROW		);
//	sizer_principal->Add( status			, 0	, wxGROW		);
	sizer_principal->Add( panel_splitter	, 1	, wxALL|wxEXPAND		);
	sizer_principal->Add( status			, 0	, wxALL|wxEXPAND		);
	
	this->SetSizer(sizer_principal);

//EEDxx2.4
//	FitInside();


}

//--------------------------------------------------------
void wxQuantificationWidget::Set_Data( )
{
	_axis_index				= -1;
	_given_points			= 0;
	_nClicks				= 0;
	_quantifing				= 0;
	
//EED	_real_first_point_quant	= -1;
//EED	_real_last_point_quant	= -1;
	
	_shown					= 0;
	_quant_shown			= 0;
	
	_actual_area			= 0.00;
	_actual_peri			= 0.00;
	_actual_darea			= 0.00;
	_actual_dperi			= 0.00;
	_actual_dmax			= 0.00;
	_actual_dmin			= 0.00;
	_actual_davg			= 0.00;
	_actual_sten			= 0.00;
	_actual_partial			= 0.00;
	
	//_actual_total   = _mar->_experiment->GetAxisLength();
	//_st_Value1->SetLabel(_actual_total);
	//return( maracas_data::experiment->get_work_axis( )->get_total_length( ) );
}


/*EED
//--------------------------------------------------------
void wxQuantificationWidget::Positionate( )
{
	_given_points = 0;
	_shown = true;
	_first_quant = 1;
}
*/

//--------------------------------------------------------
void wxQuantificationWidget::Forget( )
{
	_shown = false;
}

// ----------------------------------------------------------------------------
void wxQuantificationWidget::ShowMARACASData( marInterface* mar )
{
	double        min, max;
	vtkImageData* imagedata;
	int nos;
	int actualQuant=-1;
	
	wxBusyCursor wait;
	_mar = mar;
	_mar->_experiment->prepareQuantification( );
	nos = _mar->_experiment->getNumberOfSlices( );
	actualQuant = (int) (nos-1)/2 ;
	imagedata = _mar->_experiment->getSliceImage( actualQuant );
	_mar->_experiment->getAxis()->setActualQuant( actualQuant ) ;
	_mar->_experiment->getDynData( )->getVolume( )->getMinMax( min, max );
	
	_3DWorld->ShowMARACASDataAndAxe( mar );
	_3DWorld->InitCameraReset( );
	_2DWorld->ConstructVTK( imagedata );
	
	// GUI
	_sl_Isovalue->SetRange( (int)min, (int)max);
	_sl_Isovalue->SetValue( (int)(max/4) );
	_sl_Opacity->SetValue( 50 );
	Reset_sl_Slider();

	_pl_cntlHealthySick2->GetPnlSearStenosis()->GetPanelAutomatic()->SetRange(0,nos-1);

	int ww1,hh1;
	int ww2,hh2;
	int wwT,hhT;
	int ss;
	this->GetSize(&wwT,&hhT);
	_wxStenosisPanel->GetSize(&ww1,&hh1);
	_pl_cntlHealthySick2->GetSize(&ww2,&hh2);

	ss=hhT-(hh1+hh2+85);
	panel_splitter_right->SetSashPosition(ss,true);

}
//----------------------------------------------------------------------------
void wxQuantificationWidget::Reset_sl_Slider()
{
	int nos = _mar->_experiment->getNumberOfSlices( );
	_sl_Slice->SetRange(0, nos-1);
	_sl_Slice->SetValue( (nos-1)/2 );
//	_pl_cntlHealthySick->Reset_sl_Slider(nos);
}
//----------------------------------------------------------------------------
void wxQuantificationWidget::SetSlider_Isovalue_Opacity(int isovalue,int opacity){
	_sl_Isovalue->SetValue(isovalue);
	_sl_Opacity->SetValue(opacity);
	_3DWorld->SetSurfaceIsoValue( isovalue );
	_3DWorld->SetSurfaceOpacity( opacity );
}
//----------------------------------------------------------------------------
void wxQuantificationWidget::OnShowSurface_CB(wxCommandEvent& event)
{
    _3DWorld->SetSurfaceVisibility( _cb_ShowSurface->GetValue() );
}
// ---------------------------------------------------------------------------
void wxQuantificationWidget::ResetAxis(){	
	Reset_sl_Slider();
	_mar->_experiment->getAxis()->setActualQuant( _sl_Slice->GetValue() );

	_3DWorld->Hide3DHealthySliceActor();
	_mar->_experiment->getAxis( )->setHealthySlice( 0,-1,0 );
}
// ---------------------------------------------------------------------------
void wxQuantificationWidget::RefreshAxis( ){	
	int acuatQuant = _mar->_experiment->getAxis()->getActualQuant();
	vtkImageData* imagedata;
	vtkProbeFilter* image3D;
	vtkPolyData* vtkPolydata_2Dcontour;
	vtkPoints* vtkPoints_2DDiameterMin;
	vtkPoints* vtkPoints_2DDiameterMax;

	image3D					= _mar->_experiment->get3DSlice			( acuatQuant );
	imagedata				= _mar->_experiment->getSliceImage		( acuatQuant );
	vtkPolydata_2Dcontour	= _mar->_experiment->get2Dcontour		( acuatQuant );
	vtkPoints_2DDiameterMin = _mar->_experiment->get2DDiameterMin	( acuatQuant );
	vtkPoints_2DDiameterMax = _mar->_experiment->get2DDiameterMax	( acuatQuant );

	_3DWorld->SetImage(image3D);
	_3DWorld->Render( );
	_2DWorld->SetImage(imagedata);

	if (_cb_VisibleRings->GetValue()==true){
		_2DWorld->SetContour( vtkPolydata_2Dcontour );
		_2DWorld->SetDiameterMin( vtkPoints_2DDiameterMin , true );
		_2DWorld->SetDiameterMax( vtkPoints_2DDiameterMax , true );
	}
	showVariables( );

// PS -> 	marContour * tutu=_mar->_experiment->getAxis()->getContour( event.GetPosition() );
//	cnt = _mar->_experiment->generateContour(event.GetPosition(), -1, -1, NULL);
// PS -> 	tutu=_mar->_experiment->getAxis()->getContour( event.GetPosition() );
//	_2DWorld->SetContour( cnt );


}
// ----------------------------------------------------------------------------
void wxQuantificationWidget::MoveSlider(int actualQuant){

	if (_bak_ActualSlice!=-1){
		SetManualContour_ReplaceContour();
		SetManualContour_2DWorld(false);
	}

	_mar->_experiment->getAxis()->setActualQuant( actualQuant );
	RefreshAxis();
}
// ----------------------------------------------------------------------------
void wxQuantificationWidget::OnSliderSliceScroll(wxScrollEvent& event){
	MoveSlider( event.GetPosition() );
}
// ----------------------------------------------------------------------------
double wxQuantificationWidget::GetStenosisDiameter(int sickSlice){
	double healthyAverageDiameter = _mar->_experiment->getReferenceAverDiam() ;
	marContour *marcontourSick = _mar->_experiment->getContour( sickSlice );
	return doubleStenosis( healthyAverageDiameter , marcontourSick->getMinimumDiameter() );
}
// ----------------------------------------------------------------------------
double wxQuantificationWidget::GetStenosisArea( int sickSlice){
	double healthyArea = _mar->_experiment->getReferenceArea();
	marContour *marcontourSick = _mar->_experiment->getContour( sickSlice );
	return doubleStenosis( healthyArea , marcontourSick->getArea() );
}
// ----------------------------------------------------------------------------


/* EED Borrame 
// ----------------------------------------------------------------------------
double wxQuantificationWidget::GetStenosisTEST1(marContour *marcontourH, marContour *marcontour){
	double healthy= marcontourH->getMinimumDiameter() * marcontourH->getMaximumDiameter();
	double sick= marcontour->getMinimumDiameter() * marcontour->getMaximumDiameter();
	return doubleStenosis( healthy , sick );
}
// ----------------------------------------------------------------------------
double wxQuantificationWidget::GetStenosisTEST2(marContour *marcontourH, marContour *marcontour){
	double steA = GetStenosisArea(marcontourH,marcontour);
	double steB = GetStenosisDiameter(marcontourH,marcontour);
	return sqrt(steA + steB);
}
// ----------------------------------------------------------------------------
double wxQuantificationWidget::GetStenosisTEST3(marContour *marcontourH, marContour *marcontour){
	return doubleStenosis( marcontourH->getAverageDiameter() , marcontour->getAverageDiameter() );
}
*/



// ----------------------------------------------------------------------------
void wxQuantificationWidget::showVariables()
{
	marContour* marcontour;
	int actualQuant;
	int healthySlice; 
	int healthySliceStart; 
	int healthySliceEnd; 

//			healthySlice = _sl_Slice->GetValue();
//			_mar->_experiment->getAxis( )->setHealthySlice( healthySlice );
//			_3DWorld->Set3DHealthySliceActor( );
//			_3DWorld->Show3DHealthySliceActor( );	
	actualQuant = _mar->_experiment->getAxis()->getActualQuant( );
	marcontour=_mar->_experiment->getContour( actualQuant );

	wxString tmpString;
//	tmpString.Printf( "%.2f mm" , marcontour->getPartialAxisLenght());		
//	_st_Value0->SetLabel(tmpString);
	tmpString.Printf( _T("%.2f mm")   , _mar->_experiment->getTotalLength() );		 _st_Value1->SetLabel(tmpString);


	tmpString.Printf( _T("%.2f mm^2") , marcontour->getArea());						 _st_Value2->SetLabel(tmpString);
	tmpString.Printf( _T("%.2f mm")   , marcontour->getPerimeter());				 _st_Value3->SetLabel(tmpString);
//	tmpString.Printf( _T("%.2f mm")   , marcontour->getDiameterFromArea());			 _st_Value4->SetLabel(tmpString);
//	tmpString.Printf( _T("%.2f mm")   , marcontour->getDiameterFromPerimeter());	 _st_Value5->SetLabel(tmpString);
	tmpString.Printf( _T("%.2f mm")   , marcontour->getMinimumDiameter());			 _st_Value6->SetLabel(tmpString);
	tmpString.Printf( _T("%.2f mm")   , marcontour->getMaximumDiameter());			 _st_Value7->SetLabel(tmpString);
	tmpString.Printf( _T("%.2f mm")   , marcontour->getAverageDiameter());			 _st_Value8->SetLabel(tmpString);

	healthySlice		= _mar->_experiment->getAxis( )->getHealthySlice( );
	healthySliceStart	= _mar->_experiment->getAxis( )->getHealthySliceStart( );
	healthySliceEnd		= _mar->_experiment->getAxis( )->getHealthySliceEnd( );
	if ( (healthySlice!=-1) ) {
		_st_Value100->SetLabel( strStenosis( GetStenosisArea(actualQuant)     ) );
		_st_Value101->SetLabel( strStenosis( GetStenosisDiameter(actualQuant) ) );
		tmpString.Printf( _T("%.2f mm^2") , _mar->_experiment->getReferenceArea() );	 _st_ValueRef102->SetLabel(tmpString);
		tmpString.Printf( _T("%.2f mm")   , _mar->_experiment->getReferenceAverDiam() ); _st_ValueRef103->SetLabel(tmpString);
	} else {
		_st_Value100->SetLabel(_T("--"));
		_st_Value101->SetLabel(_T("--"));
		_st_ValueRef101->SetLabel(_T("--"));
		_st_ValueRef102->SetLabel(_T("--"));
		_st_ValueRef103->SetLabel(_T("--"));
	}

	int startSlice	= _mar->_experiment->getAxis()->getStartQuant();
	int finishSlice	= _mar->_experiment->getAxis()->getFinishQuant();
    if ((startSlice!=-1) && (finishSlice!=-1)){
		tmpString.Printf( _T("%.2f mm")   , _mar->_experiment->getSubAxisLength() );	 _st_ValueRef101->SetLabel(tmpString);
	} else {
		_st_ValueRef101->SetLabel(_T("--"));
	}

	panel_splitter->SetSashPosition(panel_splitter->GetSashPosition() );

}
// ----------------------------------------------------------------------------
double wxQuantificationWidget::doubleStenosis(double healthy, double sick){
	double result;
	if (healthy==0) {	
		result=-1;	
	} else {  
//EED borrame
//		result = (fabs(healthy-sick)/healthy) * 100 ; 	
		result = (    (healthy-sick)/healthy) * 100 ; 	
	}

	return result;
}
// ----------------------------------------------------------------------------
wxString wxQuantificationWidget::strStenosis(double stenosis){

	wxString tmpString;
	if (stenosis==-1) {
		tmpString.Printf(_T("%d"),-1);	
	} else {
		tmpString.Printf(_T("%.2f"), stenosis );	
	}
	return tmpString + _T(" \%");
}
// ----------------------------------------------------------------------------
void wxQuantificationWidget::OnSliderIsovalueScroll(wxScrollEvent& event)
{
	wxBusyCursor wait;
	_3DWorld->SetSurfaceIsoValue( event.GetPosition() );
}
// ----------------------------------------------------------------------------
void wxQuantificationWidget::OnSliderOpacityScroll(wxScrollEvent& event)
{
	_3DWorld->SetSurfaceOpacity( event.GetPosition() );
}
//----------------------------------------------------------------------------
void wxQuantificationWidget::AddAxisActors(){
	// Axes ...
	marAxis *maraxis = _mar->_experiment->getAxis( );
	if (maraxis!=NULL) _3DWorld->SetAxis( maraxis->Draw( ) );
	// Other Actors..
	// ..
}
//----------------------------------------------------------------------------
void wxQuantificationWidget::Clean3D( bool eraseAxe )
{
	_first_quant = -1;
	_last_quant = -1;
//EED	_real_first_point_quant = -1;
//EED	_real_last_point_quant = -1;
	//this->controls(1);
	_quant_shown = false;
	
	_3DWorld->InitListContourActor( -1,_mar->_experiment->getNumberOfSlices() );
	if (eraseAxe==true) { _3DWorld->RemoveAxis(); }

/* EED borrame
	_3DWorld->Hide3DSliceActor( );
	_3DWorld->Hide3DContourActor( );
	_3DWorld->Hide3DHealthySliceActor();
*/

	/*
	if (_pRenderer3D != 0) _pRenderer3D->RemoveActor(hs_actor);
	if (_hs_actor != 0)   hs_actor->delete();
	if (_hs_mapper != 0)  hs_mapper->delete();
	if (_hs_grid != 0)   hs_grid->delete();
	if (_hs_points != 0)   hs_points->delete();
	if (_hs_poly_line != 0)   hs_poly_line->delete();
	*/
	
/* EED
	int i = 1;
	int max = _rings_index->GetCount();
	while  (i <= max) {
	
	if (_pRenderer3D != 0)
    _pRenderer3D->RemoveActor(_cont3DActor(hs_actor[i]));
	if (_cont3DActor[i] != 0)
    _cont3DActor[i]->Delete();
	if (_cont3DMapper[i] != 0)
    _cont3DMapper[i]->Delete();
	if (_cont3DGrid[i] != 0)
    _cont3DGrid[i]->Delete();
	if (_cont3DPolyLine[i] != 0)
    _cont3DPolyLine[i]->Delete();
	if (_cont3DPoints[i] != 0)
    _cont3DPoints[i]->Delete();
		
		i++;
	}
	//_rings_index = _list;
*/
	

}

void wxQuantificationWidget::Reload_Axis(bool mask , bool step )
{
/*  if ( step  ) {
this->redoAxisSpline();
if ( pRenderer3D != 0 ) {
_pRenderer3D->RemoveActor(GetSphereActorName(sphere_quant1));
_pRenderer3D->RemoveActor(GetSphereActorName(sphere_quant2));
}
this->DeleteSphere(sphere_quant1);
this->DeleteSphere(sphere_quant2);
_given_points = 0;
}
else if ( mask  ) {
this->recalculeAxisSignal()
}

  if ( ( mask || step ) && _shown ) {
  tk_messageBox -icon info -message "$string_table::str_quant_will_be_erased" -type ok
  catch { renderer_$widgets(work3D) RemoveActor hs_actor_$widgets(work3D) }
  catch { hs_actor_$widgets(work3D) Delete }
  catch { hs_mapper_$widgets(work3D) Delete }
  catch { hs_grid_$widgets(work3D) Delete }
  catch { hs_points_$widgets(work3D) Delete }
  catch { hs_poly_line_$widgets(work3D) Delete }
  foreach i $rings_index {
  catch { renderer_$widgets(work3D) RemoveActor cont3DActor_{$widgets(work3D)}_{$i} }
  catch { cont3DActor_{$widgets(work3D)}_{$i}    Delete }
  catch { cont3DMapper_{$widgets(work3D)}_{$i}   Delete }
  catch { cont3DGrid_{$widgets(work3D)}_{$i}     Delete }
  catch { cont3DPolyLine_{$widgets(work3D)}_{$i} Delete }
  catch { cont3DPoints_{$widgets(work3D)}_{$i}   Delete }
  
   }
   rings_index = list;
   _area = 0.00;
   _peri = 0.00;
   _darea = 0.00;
   _dperi = 0.00;
   _dmax = 0.00;
   _dmin = 0.00;
   _davg = 0.00;
   _sten = 0.00;
   _quant_shown = false;
   this->clean_graph();  // old BLT
   
	_first_quant = 1;
	_range(getIntensityRange());
	_resample(getVTKSource());
	_bounds(resample(GetBounds());
	
	 // Axis
	 set points [ getAxis_dll ]
	 set nP [ expr [ llength $points ] / 3 ]
	 $widgets(sclSlice) configure \
	 -from 0 \
	 -to   [ expr [ getNumberOfAxisPoints_dll ] - 1 ] \
	 -resolution 1
	 
	  // Poly-line actor construction...
	  catch { renderer_$widgets(work3D) RemoveActor axisActor_$widgets(work3D) }
	  catch { axisActor_$widgets(work3D)    Delete }
	  catch { axisMapper_$widgets(work3D)   Delete }
	  catch { axisGrid_$widgets(work3D)     Delete }
	  catch { axisPolyLine_$widgets(work3D) Delete }
	  catch { axisPoints_$widgets(work3D)   Delete }
	  
	   axisPoints = vtkPoints::New();
	   axisPolyLine = vtkPolyLine::New();
	   axisPolyLine->GetPointIds()->SetNumberOfIds( nP);
	   vox_size = getActualVoxelSize();
	   
		for { set i 0 } { $i < $nP } { incr i } {
		
		 [ axisPolyLine_$widgets(work3D) GetPointIds ] SetId $i $i
		 set p [ \
		 PointCoord \
		 [ lindex $points [ expr $i * 3 + 0 ] ] \
		 [ lindex $points [ expr $i * 3 + 1 ] ] \
		 [ lindex $points [ expr $i * 3 + 2 ] ] \
		 [ lindex $bounds 0 ] \
		 [ lindex $bounds 2 ] \
		 [ lindex $bounds 4 ] \
		 $vox_size $vox_size $vox_size \
		 ]
		 axisPoints->InsertNextPoint( lindex $p 0 ] [ lindex $p 1 ] [ lindex $p 2 ]
		 
		  }
		  
		   axisGrid = vtkUnstructuredGrid::New();
		   axisGrid->Allocate( 1, 1);
		   axisGrid->InsertNextCell(  [ axisPolyLine->GetCellType(),  ] \
		   [ axisPolyLine_$widgets(work3D) GetPointIds ]
		   axisGrid->SetPoints(axisPoints);
		   
			axisMapper = vtkDataSetMapper::New();
			axisMapper->SetInput(axisGrid);
			axisMapper->ImmediateModeRenderingOn();
			
			 axisActor = vtkActor::New();
			 axisActor->SetMapper(axisMapper);
			 axisActor->GetProperty()->BackfaceCullingOn();
			 axisActor->GetProperty()->SetDiffuseColor(1, 0, 0);
			 
			  _pRenderer3D->AddActor(axisActor);
			  
			   _pRenderWindow3D->Render();
			   _pRenderWindow2D->Render();
			   
				_pRenderer3D->AddActor(outlineActor));
				
				 this->controls(0);
				 
				  }
				  if ( _given_points == 1 )
				  this->controls(1);
				  
				   if ( _quant_shown )
				   this->update_blt_all_meassures();
*/
}


void wxQuantificationWidget::Show_Max_Min_Diameters()
{
	
/*
slice = widgets(sclSlice);
wxList *lmax = this->getMaximumLine();
wxList *lmin = this->getMinimumLine();

 if ( _pRenderer2D != 0 )
	{
	_pRenderer2D->RemoveActor(dMin_actor);
	_pRenderer2D->RemoveActor(dMax_actor);
	}
	if ( dMax_actor != 0 )  dMax_actor->Delete();
    if ( dMax_mapper != 0 )  dMax_mapper->Delete();
    if ( dMax_line != 0 )  dMax_line->Delete();
    if ( dMin_actor != 0 )  dMin_actor->Delete();
    if ( dMin_mappe != 0 )  dMin_mappe->Delete();
    if ( dMax_actor != 0 )  dMax_actor->Delete();
    if ( dMin_line != 0 )  dMin_line->Delete();
	
	 
	  dMax_line = vtkLineSource::New();
	  dMax_line->SetPoint1( lmax->Getfirst() , lmax->item(1), 0.0 );
	  dMax_line->SetPoint2( lmax->Item(2), lmax->Item(3), 0.0 );
	  
	   dMax_mapper =  vtkPolyDataMapper::New();
	   dMax_mapper->SetInput(dMax_line->GetOutput());
	   dMax_mapper->ImmediateModeRenderingOn();
	   
		dMax_actor = vtkActor::New();
		dMax_actor->SetMapper(dMax_mapper));
		dMax_actor->GetProperty()->SetColor(1.00, 0.00, 0.00);
		
		 dMin_line = vtkLineSource::New();
		 dMin_line->SetPoint1( lmin->GetFirst(), lmin->Item(1), 0.0);
		 dMin_line->SetPoint2( lmin->Item(2),    lmin->Item(3), 0.0);
		 
		  dMin_mapper = vtkPolyDataMapper::New();
		  dMin_mapper->SetInput(dMin_line->GetOutput());
		  dMin_mapper->ImmediateModeRenderingOn();
		  
		   dMin_actor = vtkActor::New();
		   dMin_actor->SetMapper(dMin_mapper);
		   dMin_actor->GetProperty()->SetColor(0.00, 0.00, 1.00);
		   
			array set arr( params(), 0 )
			if ( arr(e_debug_diameters) == 1 )
			{
			_prenderer2D->AddActor(dMax_actor);
			_prenderer2D->AddActor(dMin_actor);
			
			 }
			 
			  //GetRenderWindow Render
	*/
}



int wxQuantificationWidget::Back( )
{
	int ret;
	
	ret = _shown;
	_shown = 0;
	return ret;
}


void wxQuantificationWidget::Set_plane_3D( double  x, double y )
{
/*
_pRenderer3D->IsInViewport(0, 0);

 busy hold
 Update();
 
  if ( _tmp_world_picker3D != 0)  tmp_world_picker3D->Delete();
  
   y =[ [ lindex [ $widgets(work3D) configure - height ] 4 ] - y - 1 ]
   
    _pickWPPos = Pick_point_local_actor $x $y _pRenderer3D _isoActor3D 0.001 ]
	
	 _xc = _pickWPPos->item(1);
	 _yc = _pickWPPos->item(2);
	 _zc = _pickWPPos->item(3);
	 #Chercher le point de l'axe le plus proche au point choisi sur la surface
	 _indP = axisGrid3D->FindPoint(_xc, _yc, _zc);
	 _coordsP = axisGrid3D->GetPoint(_indP);
	 _xc =[lindex _coordsP 0]
	 _yc =[lindex _coordsP 1]
	 _zc =[lindex _coordsP 2]
	 
	  if ( _indP >= 0 )
	  {
	  $widgets(sclSlice) set $indP
	  this->Set_Plane();
	  }
	  
	   busy release .
	   update
	   
		_pRenderWindow3D->Render();
	*/
}


/* EED
void wxQuantificationWidget::Refresh_Quant( )
{
	if ( _real_first_point_quant != -1  &&  _real_last_point_quant  != -1  &&
		_quant_sten->GetCount()  > 0) {
		//_quant_sten = GetStenosisQuant();
		//_sten  =  _quant_sten->Item(_widgets(sclSlice)->get() -
		//		                         _real_first_point_quant  )
	}
	//this->update_blt_all_meassures();
}
*/


void  wxQuantificationWidget::Point_Intensity(double x, double y)
{
	//y = [ lindex [ _pRenderWindow3D->Configure(height) ] ->Item(4) ] - y - 1;
	
	//if ( _tmp_picker != 0 )  _tmp_picker->Delete();
	//_tmp_picker = vtkWorldPointPicker::New();
	//_pickWP     = tmp_picker2D->Pick(x, y, 0) _pRenderer2D
	//_pickWPPos  = tmp_picker2D->GetPickPosition();
	
	//x = [ lindex [ split [ lindex $pickWPPos 0 ] . ] 0 ]
	//y = [ lindex [ split [ lindex $pickWPPos 1 ] . ] 0 ]
	//y = GetCutSize()  - y - 1;
	//_intensity = GetIntensityCut(x, y);
}


void wxQuantificationWidget::CleanContour()
{
/*  if ( _pRenderer2D != 0 ) {
_pRenderer2D->RemoveActor(_debug2Actor3D);
_pRenderer2D->RemoveActor(_debug1Actor3D);
}
if ( _debug2Actor3D != 0 )
_debug2Actor3D->Delete();
//if ( _connMapper3D != 0 )			_connMapper3D->Delete();
//if ( _isoStrips3D != 0 )			_isoStrips3D->Delete();
//if ( _cpd23D != 0 )					_cpd23D->Delete();
//if ( _conn3D != 0 )					_conn3D->Delete();
//if ( _cpd3D != 0 )					_cpd3D->Delete();
if ( _debug1Actor3D != 0 )
_debug1Actor3D->Delete();
//if ( _cntVTKMapper3D != 0 )			_cntVTKMapper3D->Delete();
//if ( _cntVTK3D != 0 )				_cntVTK3D->Delete();

  if ( _pRenderer2D != 0 ) {
  _pRenderer2D->RemoveActor(_aPolyLineActor2D);
  _pRenderer2D->RemoveActor(_aPolygonActor2D);
  }
  
	if ( _aPolyLineActor2D != 0 )
    _aPolyLineActor2D->Delete();
	//if ( _aPolyLineMapper2D != 0 )		_aPolyLineMapper2D->Delete();
	//if ( _aPolyLineGrid2D != 0 )		_aPolyLineGrid2D->Delete();
	//if ( _aPolyLine2D != 0 )			_aPolyLine2D->Delete();
	//if ( _PointsContour2D != 0 )		_PointsContour2D->Delete();
	if ( _aPolygonActor2D != 0 )
    _aPolygonActor2D->Delete();
	//if ( _aPolygonMapper2D != 0 )		_aPolygonMapper2D->Delete();
	//if ( _aPolygonGrid2D != 0 )			_aPolygonGrid2D->Delete();
	//if ( _aPolygon2D != 0 )				_aPolygon2D->Delete();
	
	  if ( _pRenderer2D != 0 ) {
	  _pRenderer2D->RemoveActor(_dMaxActor2D);
	  _pRenderer2D->RemoveActor(_dMinActor2D);
	  }
	  
		if ( _dMaxActor2D != 0 )
		_dMaxActor2D->Delete();
		//if ( _dMaxMapper2D != 0 )				_dMaxMapper2D->Delete();
		//if ( _dMaxLine2D != 0 )					_dMaxLine2D->Delete();
		if ( _dMinActor2D != 0 )
		_dMinActor2D->Delete();
		//if ( _dMinMapper2D != 0 )				_dMinMapper2D->Delete();
		//if ( _dMinLine2D != 0 )					_dMinLine2D->Delete();
		
		  _pRenderWindow3D->Render();
	_pRenderWindow2D->Render();*/
}


//-----------------------------------------------------------------
// Button
void wxQuantificationWidget::Do_Quant()
{
/*
if ( _quantifing == 0 )
{
this->Clean_Graph();
this->Clean3D();

 _quantifing = 1;
 
  int f = ( _first_point_quant < _last_point_quant ) ? _first_point_quant : _last_point_quant;
  int l = ( _first_point_quant > _last_point_quant ) ? _first_point_quant : _last_point_quant;
  
   this->Controls(2);
   
	_quant_x     = _list;
	_quant_area  = _list;
	_quant_peri  = _list;
	_quant_darea = _list;
	_quant_dperi = _list;
	_quant_dmax  = _list;
	_quant_dmin  = _list;
	_quant_davg  = _list;
	
	 for ( int i = f; i <= l; i++ )
	 lappend _quant_x->Append(i);
	 
	  update_blt_all_meassures();
	  
	   startQuant(f);
	   int  cont = f;
	   changeSliceAxis(f);
	   
        wxMessageDialog* Q_recalculate = new wxDialog(this,
		_str_recalculate_contours,
		"Question",
		wxYES_NO|wxNO_DEFAULT|wxCENTRE,
		wxPoint(100, 100));
		
		 int recal = 0;
		 if (Q_recalculate->ShowModal() ==  wxID_OK)
		 recal = 1;
		 
		  delete Q_recalculate;
		  
		   this->Clean_Contour();
		   $widgets(sclSlice) set cont ;
		   planes_window::set_plane
		   _quant_shown = 1;
		   _params = GetContourParams();
		   this->Generate_IsoContour( (GetCutSize()  / 2) (GetCutSize() / 2)
		   (_params->Item(5) )
								   (_params->Item(6) )
								   while ( NextQuant(recal,IsoStrips3D) == 1 && cont <= l )
								   {
								   if ( _quantifing == 1 )
								   {
								   if ( _pRenderer2D != 0 )
								   {
								   _pRenderer2D->RemoveActor(_aPolygonActor2D);
								   _pRenderer2D->RemoveActor(_aPolyLineActor2D);
								   }
								   if ( _aPolygonActor2D != 0 )   _aPolygonActor2D->Delete();
								   if ( _aPolygonGrid2D != 0 )    _aPolygonGrid2D->Delete();
								   if ( _aPolyLineActor2D != 0 )  _aPolyLineActor2D->Delete();
								   if ( _aPolyLineMapper2D != 0 ) _aPolyLineMapper2D->Delete();
								   if ( _aPolyLineGrid2D != 0 )   _aPolyLineGrid2D->Delete();
								   if ( _aPolyLine2D != 0 )       _aPolyLine2D->Delete();
								   if ( _PointsContour2D != 0 )   _PointsContour2D->Delete();
								   if ( _aPolygon2D != 0 )        _aPolygon2D->Delete();
								   
									_points = GetContourPoints();
									_taille = _points->GetLength() / 2;
									
									 aPolygon2D = vtkPolygon::New();
									 PointsContour2D = vtkPoints::New();
									 
									  aPolyLine2D = vtkPolyLine::New();
									  _PointIds = aPolyLine2D->GetPointIds();
									  _PointIds->SetNumberOfIds(_taille);
									  _PointIdsPolygon = aPolygon2D->GetPointIds();
									  _PointIdsPolygon->SetNumberOfIds( _taille);
									  
									   for ( int i =0; i < _taille ; i++ )
									   {
									   _PointIds->SetId(i, i);
									   _PointIdsPolygon->SetId(i, i);
									   PointsContour2D->InsertNextPoint( _points->Item( i * 2 ) + 0 ,
									   _points->Item(i * 2) + 1, 0);
									   }
									   
										aPolyLineGrid2D = vtkUnstructuredGrid::New();
										aPolyLineGrid2D->Allocate(1, 1);
										_param1 = aPolyLine2D->GetCellType();
										_param2 = aPolyLine2D->GetPointIds();
										aPolyLineGrid2D->InsertNextCell(_param1, _param2);
										aPolyLineGrid2D->SetPoints(PointsContour2D)
										
										 aPolyLineMapper2D = vtkDataSetMapper::New();
										 aPolyLineMapper2D->SetInput(aPolyLineGrid2D);
										 
										  aPolyLineActor2D = vtkActor::New();
										  aPolyLineActor2D->SetMapper(aPolyLineMapper2D);
										  _Property1 = aPolyLineActor2D->GetProperty();
										  _Property1->SetColor(0, 1, 0);
										  _Property1->SetLineWidth(2);
										  _Property1->SetPointSize(2);
										  _Property1->BackfaceCullingOff();
										  
										   _pRenderer2D->AddActor(aPolyLineActor2D);
										   
											aPolygonGrid2D = vtkUnstructuredGrid::New();
											aPolygonGri2D->Allocate(1, 1);
											_param1 = aPolygon2D->GetCellType();
											_param2 = aPolygon2D->GetPointIds();
											aPolygonGrid2D->InsertNextCell(_param1, _param2);
											aPolygonGrid2D->SetPoints(PointsContour2D);
											
											 aPolygonMapper2D = vtkDataSetMapper::New();
											 aPolygonMapper2->SetInput(aPolygonGrid2D);
											 
											  aPolygonActor2D = vtkActor::New();
											  aPolygonActor2D->SetMapper(aPolygonMapper2D);
											  _Property1 = aPolygonActor2D->GetProperty();
											  _Property1->SetColor(0, 1, 0);
											  _Property1->SetLineWidth(2);
											  _Property1->SetPointSize(2);
											  _Property1->BackfaceCullingOff();
											  
											   int arr[] = Params(0);
											   if ( arr(e_debug_fill_area) == 1 )
											   _pRenderer2D->AddActor(aPolygonActor2D)
											   
												this->Show_Max_Min_Diameters();
												
												 _pRenderWindow2D->Render();
												 
												  this->Draw3D_Contour(cont);
												  
												   _values = GetValues(cont);
												   
													_quant_area->Append(_values->Item(1));
													_quant_peri->Append(_values->Item(2));
													_quant_darea->Append(_values->Item(3));
													_quant_dperi->Append(_values->Item(4));
													_quant_dmax->Append(_values->Item(5));
													_quant_dmin->Append(_values->Item(6));
													_quant_davg->Append(_values->Item(7));
													
													 this->update_blt_all_meassures();
													 
													  _area  = _values->Item(1);
													  _peri  = _values->Item(2);
													  _darea = _values->Item(3);
													  _dperi = _values->Item(4);
													  _dmax  = _values->Item(5);
													  _dmin  = _values->Item(6);
													  _davg  = _values->Item(7);
													  
													   cont++;
													   
														this->Clean_contour();
														
														 $widgets(sclSlice) set $cont;
														 this->Set_Plane;
														 _params = GetContourParams();
														 this->Generate_IsoContour [  [ GetCutSize() / 2 ]
														 [ GetCutSize() / 2 ]
														 [ _params->Item(5) ]
														 [ _params->Item(6) ];
														 update();
														 
														  }
														  else if ( _quantifing == 2 )
														  {
														  while ( _quantifing == 2 )
														  update();
														  }
														  else if ( _quantifing == 3 )
														  {
														  $widgets(btnPause) configure -text $string_table::str_pause
														  break;
														  }
														  
														   }
														   FinishQuant();
														   this->Clean_contour();
														   _quantifing = 0;
														   
															}
															else
															{
															_quantifing = 2;
															wxMessageDialog* Q_stop = new wxDialog(this,
															_str_stop_quantification,
															"Question",
															wxYES_NO|wxNO_DEFAULT|wxCENTRE,
															wxPoint(100, 100));
															
															 _quantifing = 1;
															 if (Q_stop->ShowModal() ==  wxID_OK)
															 _quantifing = 3;
															 delete Q_stop;
															 }
*/
}


//-----------------------------------------------------------------
void wxQuantificationWidget::OnContour_BT(wxCommandEvent& event){
	int slice=_sl_Slice->GetValue();
	_3DWorld->Set3DContourActor( slice , _mar->_experiment->get3Dcontour(slice) , _cb_VisibleRings->GetValue() ,0 );
}
//-----------------------------------------------------------------
void wxQuantificationWidget::OnClean_BT(wxCommandEvent& event){
	int slice=_sl_Slice->GetValue();
	_3DWorld->Erase3DContourActor( slice );
}

//-----------------------------------------------------------------
void wxQuantificationWidget::OnCleanAll_BT(wxCommandEvent& event){
	marDictionary marDict;
	char tmp[256];

	wxMessageDialog *wxdiag;
	strcpy( tmp , marDict.GetString(870) ); strcat(tmp,"\n"); strcat(tmp,marDict.GetString(875));
	wxdiag= new wxMessageDialog(this, wxString(tmp ,wxConvUTF8), wxString(marDict.GetString(865), wxConvUTF8) , wxOK | wxCANCEL);//"This option erase all 3D contours.\n Do you want to continue?","Alert"
    if ( wxdiag->ShowModal() == wxID_OK ) {
		_3DWorld->InitListContourActor( 0, _mar->_experiment->getNumberOfSlices() );
	}            
	wxdiag->Destroy();
}

//-----------------------------------------------------------------
void wxQuantificationWidget::OnSaveContours3D_BT(wxCommandEvent& event)
{
	
	wxFileDialog dialog(this, _T("Choose a file"), _T(""), _T(""), _T("*.maracas_contour3D"), wxSAVE );
	if (dialog.ShowModal() == wxID_OK)
	{		
		std::string pathfilename(  (const char *)(dialog.GetPath().mb_str()) );
//		std::string directory(  (const char *)(dialog.GetDirectory().mb_str()) );
//		std::string filename(  (const char *)(dialog.GetFilename().mb_str())  );
//		std::string pathfilename	= directory + "/" + filename;
//		printf("EED> wxQuantificationWidget::OnSaveContours3D_BT  > %s\n",pathfilename.c_str());
		FILE *ff;
		ff=fopen(pathfilename.c_str(), "w+");
		  _mar->_experiment->getAxis()->SaveExisting3DContours(ff);
		fclose(ff);
	}
	
}

// PS -> void wxQuantificationWidget::OnContour_BT(wxCommandEvent& event)
// PS -> {
// PS -> 
// PS -> 
// PS ->   int index;
// PS -> 
// PS ->   vtkPolyData* cnt;
// PS ->   //marContour* cnt;
// PS -> //  vtkUnstructuredGrid* allData;
// PS -> 
// PS ->   index = _sl_Slice->GetValue( );
// PS -> //  this->CleanContour( );
// PS ->   cnt = _mar->_experiment->generateContour(index, -1, -1, NULL);
// PS -> //	allData = cnt->Draw( );
// PS -> //  _2DWorld->SetContour( allData );
// PS ->   _2DWorld->SetContour( cnt );
// PS -> 
// PS ->   _first_quant = 0;
// PS -> 
// PS ->   /*planes_window::show_max_min_diameters
// PS -> 
// PS -> 	[ $widgets(image2D) GetRenderWindow ] Render
// PS -> 
// PS -> 	planes_window::draw3D_contour $index
// PS -> 
// PS -> 	set quant_data [ getValues_dll $index ]
// PS -> 	set actual_area  [ change_float_precision [ lindex $quant_data 0 ] 2 ]
// PS -> 	set actual_peri  [ change_float_precision [ lindex $quant_data 1 ] 2 ]
// PS -> 	set actual_darea [ change_float_precision [ lindex $quant_data 2 ] 2 ]
// PS -> 	set actual_dperi [ change_float_precision [ lindex $quant_data 3 ] 2 ]
// PS -> 	set actual_dmax  [ change_float_precision [ lindex $quant_data 4 ] 2 ]
// PS -> 	set actual_dmin  [ change_float_precision [ lindex $quant_data 5 ] 2 ]
// PS -> 	set actual_davg  [ change_float_precision [ lindex $quant_data 6 ] 2 ]
// PS -> 	set i [ lsearch -exact $actual_quant_x $index ]
// PS -> 	if { $i != -1 } {
// PS -> 
// PS -> 		set actual_quant_area  [ lreplace $actual_quant_area  $i $i $actual_area ]
// PS -> 		set actual_quant_peri  [ lreplace $actual_quant_peri  $i $i $actual_peri ]
// PS -> 		set actual_quant_darea [ lreplace $actual_quant_darea $i $i $actual_darea ]
// PS -> 		set actual_quant_dperi [ lreplace $actual_quant_dperi $i $i $actual_dperi ]
// PS -> 		set actual_quant_dmax  [ lreplace $actual_quant_dmax  $i $i $actual_dmax ]
// PS -> 		set actual_quant_dmin  [ lreplace $actual_quant_dmin  $i $i $actual_dmin ]
// PS -> 		set actual_quant_davg  [ lreplace $actual_quant_davg  $i $i $actual_davg ]
// PS -> 		if { [ llength $actual_quant_sten ] > 0 } {
// PS -> 
// PS -> 			set actual_quant_sten [ getStenosisQuant_dll ]
// PS -> 			set actual_sten [ change_float_precision [ lindex $actual_quant_sten [ expr $index - $real_first_point_quant ] ] 2 ]
// PS -> 
// PS -> 		}
// PS -> 
// PS -> 	}
// PS -> 	planes_window::update_blt_all_meassures*/
// PS -> }


// PS -> void wxQuantificationWidget::OnClean_BT(wxCommandEvent& event)
// PS -> {
// PS -> /*  this->CleanContour();*/
// PS -> }



//------------------------------------------------------------------------
void wxQuantificationWidget::DetectHealthySickSlice( bool minSurf , bool maxSurf ){	
	wxBusyCursor wait;
	double		stenosis;
	double		areaB;
	int			iSlice;
	int			startslice;
	int			endslice;
	double		maxStenosis			=	-9999999;
	double		maxArea				=	-9999999;
	int			sickSlice			=	0;
	int			healthySlice		=	0;
	int			sizeHealthyRegion	=	GetSizeHealthyRegion();
	int			analysisTypeStenosis=	GetAnalysisTypeStenosis();


//FILE *ff;
//ff = fopen("c:/temp/MaracasStadistics.txt","a+");
//long int endtime = clock();
//double sg = (double)(endtime-startTimeRI) / (double)CLK_TCK;
//fprintf(ff,"EED %p wxQuantificationWidget::DetectHealthySickSlice > RI_t = %f \n",this,sg);
//fclose(ff);


//startTimeCalcule = clock();

	GetSliceLimites(0,startslice,endslice);

    if (startslice>endslice){
		int temp=endslice;
		endslice=startslice;
		startslice=temp;
	}

	int backSlice;
	if (minSurf==false) { backSlice = _sl_Slice->GetValue(); }

	for (iSlice=startslice; iSlice<=endslice;iSlice++){

		if (minSurf==true){
			// this is equal to the minimum surface/diameter
			if (analysisTypeStenosis==1 ){ stenosis = GetStenosisDiameter(iSlice);	}
			if (analysisTypeStenosis==2 ){ stenosis = GetStenosisArea(iSlice);		}
		}

		if (maxSurf==true){
			areaB = _mar->_experiment->getAverageArea(iSlice-sizeHealthyRegion,iSlice+sizeHealthyRegion);
		}

		if ((stenosis>maxStenosis) &&(minSurf==true)){
			maxStenosis=stenosis;
			sickSlice=iSlice;
		}
		if ((areaB>maxArea) && (maxSurf==true)){
			maxArea=areaB;
			healthySlice=iSlice;
		}
		MoveSlider( iSlice );
		_sl_Slice->SetValue( iSlice );
	}

//ff = fopen("c:/temp/MaracasStadistics.txt","a+");
//endtime = clock();
//sg = (double)(endtime-startTimeCalcule) / (double)CLK_TCK;
//fprintf(ff,"EED %p wxQuantificationWidget::DetectHealthySickSlice > t = %f   ( %d , %d , %d )\n",this,sg,startslice,endslice, endslice-startslice);
//fclose(ff);

	if (minSurf==true){
		MoveSlider( sickSlice );
		_sl_Slice->SetValue( sickSlice );
	}

	if (maxSurf==true){
		MoveSlider( healthySlice );
		_sl_Slice->SetValue( healthySlice );
	}

}


/*EED Borrame 
//------------------------------------------------------------------------
void wxQuantificationWidget::AutoQuantification(){	
	int		analysisTypeStenosis	=	GetAnalysisTypeStenosis();
	int		slice					=	_sl_Slice->GetValue();
	int		healthySlice			=	_mar->_experiment->getAxis()->getHealthySlice( );
	int		healthySliceStart		=	_mar->_experiment->getAxis()->getHealthySliceStart( );
	int		healthySliceEnd			=	_mar->_experiment->getAxis()->getHealthySliceEnd( );
	double	maxStenosis				=	-9999999;
	double	ste						=	0;

	if (healthySlice !=-1 ) {
		int iSickSlice,startslice,endslice;
		GetSliceLimites(0,startslice,endslice);
	    if (startslice>endslice){
			int temp=endslice;
			endslice=startslice;
			startslice=temp;
		}
		for (iSickSlice=startslice; iSickSlice<=endslice;iSickSlice++){
			if (analysisTypeStenosis==1 ){ ste = GetStenosisDiameter(iSickSlice);	}
			if (analysisTypeStenosis==2 ){ ste = GetStenosisArea(iSickSlice);		}
			if (ste>maxStenosis){
				maxStenosis=ste;
				slice=iSickSlice;
			}
			MoveSlider( iSickSlice );
			_sl_Slice->SetValue( iSickSlice );
		}
		MoveSlider( slice );
		_sl_Slice->SetValue( slice );
	} else {
		wxMessageBox( "Set an healthy slice.\n \n ","DxMM : MARACAS", wxOK | wxCENTRE | wxICON_INFORMATION, this);
	}
}
*/

//------------------------------------------------------------------------
int wxQuantificationWidget::GetHealthySlice(){	
	return _mar->_experiment->getAxis()->getHealthySlice( );
}
//------------------------------------------------------------------------
void wxQuantificationWidget::SetHealthySlice(int healthySlice){	
	if (healthySlice==-1) {
		healthySlice=_sl_Slice->GetValue();
	}
	int sizeHealthyRegion	= GetSizeHealthyRegion();
	int maxSlider			= GetMaxActualSlice();
	int healthySliceStart	= healthySlice - sizeHealthyRegion;
	int healthySliceEnd		= healthySlice + sizeHealthyRegion;
	if (healthySliceStart < 0)         { healthySliceStart = 0;			}
	if (healthySliceEnd   < 0)         { healthySliceEnd   = 0;			}
	if (healthySliceStart > maxSlider) { healthySliceStart = maxSlider; }
	if (healthySliceEnd   > maxSlider) { healthySliceEnd   = maxSlider; }
	_mar->_experiment->getAxis()->setHealthySlice( healthySliceStart, healthySlice , healthySliceEnd);

	_3DWorld->Set3DHealthySliceActor(  );
	_3DWorld->Show3DHealthySliceActor();
	_cb_HealthySlice->SetValue(true);	
	_3DWorld->InitListContourActor( 1, _mar->_experiment->getNumberOfSlices() );
	int iHealthySlice;
	for ( iHealthySlice=healthySliceStart ; iHealthySlice<=healthySliceEnd ; iHealthySlice++){
		_3DWorld->Set3DContourActor( iHealthySlice , _mar->_experiment->get3Dcontour(iHealthySlice) , true ,1);
	}
	showVariables();
}

/* EED borrame
//------------------------------------------------------------------------
void wxQuantificationWidget::OnHealthySlice_BT(wxCommandEvent& event){	
	SetHealthySlice( _sl_Slice->GetValue() );
}
*/

// PS -> void wxQuantificationWidget::OnCalculated_BT(wxCommandEvent& event)
// PS -> {
// PS ->     /*
// PS ->     _index = ( $widgets(sclSlice) get )
// PS -> 
// PS ->     this->Clean_Contour();
// PS -> 	_points = GetContourPoints();
// PS -> 	_taille = _points->Item(2) / 2;
// PS -> 
// PS ->     if ( _taille > 0 )
// PS -> 	{
// PS ->         aPolygon2D = vtkPolygon::New();
// PS ->         PointsContour2D = vtkPoints::New();
// PS -> 		aPolyLine2D = vtkPolyLine::New();
// PS -> 
// PS -> 		_PointIds = aPolyLine2D->GetPointIds();
// PS -> 		_PointIds->SetNumberOfIds(_taille);
// PS ->         _PointIdsPolygon = aPolygon2D->GetPointIds();
// PS -> 		_PointIdsPolygon->SetNumberOfIds(_taille);
// PS -> 
// PS ->         for (int i=0; i< _taille ; i++ )
// PS -> 		{
// PS ->             _PointIds->SetId(i, i);
// PS ->             _PointIdsPolygon->SetId(i, i);
// PS ->             PointsContour2D->InsertNextPoint( _points->Item(i * 2  + 0),
// PS -> 				   _points->Item(i * 2  + 1),  0 );
// PS -> 
// PS ->         }
// PS -> 
// PS ->         aPolyLineGrid2D = vtkUnstructuredGrid::New();
// PS -> 		aPolyLineGrid2D->Allocate(1, 1);
// PS ->         _param1 = aPolyLine2D->GetCellType();
// PS ->         _param2 = aPolyLine2D->GetPointIds();
// PS ->         aPolyLineGrid2D->InsertNextCell(_param1, _param2);
// PS ->         aPolyLineGrid2D->SetPoints(PointsContour2D);
// PS -> 
// PS -> 		aPolyLineMapper2D = vtkDataSetMapper::New();
// PS -> 		aPolyLineMapper2D->SetInput(aPolyLineGrid2D);
// PS -> 
// PS -> 		aPolyLineActor2D = vtkActor::New();
// PS -> 		aPolyLineActor2D->SetMapper(aPolyLineMapper2D);
// PS ->         _Property1 = aPolyLineActor2D->GetProperty();
// PS -> 		_Property1->SetColor(0, 1, 0);
// PS ->         _Property1->SetLineWidth(2);
// PS ->         _Property1->SetPointSize(2);
// PS ->         _Property1->BackfaceCullingOff();
// PS -> 
// PS ->         _pRenderer2D->AddActor(aPolyLineActor2D);
// PS -> 
// PS -> 		aPolygonGrid2D = vtkUnstructuredGrid::New();
// PS -> 		aPolygonGrid2D->Allocate(1, 1);
// PS ->         _param1 = aPolygon2D->GetCellType();
// PS ->         _param2 = aPolygon2D->GetPointIds();
// PS ->         aPolygonGrid2D->InsertNextCell(_param1, _param2);
// PS ->         aPolygonGrid2D->SetPoints(PointsContour2D);
// PS -> 
// PS -> 		aPolygonMapper2D = vtkDataSetMapper::New();
// PS -> 		aPolygonMapper2D->SetInput(aPolygonGrid2D);
// PS -> 
// PS -> 		aPolygonActor2D = vtkActor::New();
// PS -> 	    aPolygonActor2D->SetMapper(aPolygonMapper2D);
// PS -> 		_Property1 = aPolygonActor2D->GetProperty();
// PS -> 		_Property1->SetColor(0, 1, 0);
// PS ->         _Property1->SetLineWidth(2);
// PS ->         _Property1->SetPointSize(2);
// PS ->         _Property1->BackfaceCullingOff();
// PS -> 
// PS ->         int arr[] = this->Params(0);
// PS -> 		if ( arr(_e_debug_fill_area) == 1 )
// PS -> 			_pRenderer2D->AddActor(aPolygonActor2D);
// PS -> 
// PS ->         _pRenderWindow3D->Render();
// PS ->         _pRenderWindow2D->Render();
// PS -> 
// PS ->     }
// PS ->  */
// PS -> }



// PS -> void wxQuantificationWidget::OnPause_BT(wxCommandEvent& event)
// PS -> {
// PS ->   if ( _quantifing == 1 ) {
// PS ->     _quantifing = 2;
// PS ->     _bt_Pause->SetLabel("Play");
// PS ->     _mar->_experiment->backQuant();
// PS ->   }
// PS ->   else if ( _quantifing == 2 )
// PS ->   {
// PS ->     _quantifing = 1;
// PS ->     _bt_Pause->SetLabel("Pause");
// PS ->   }
// PS -> }


// PS -> void wxQuantificationWidget::OnDelete_BT(wxCommandEvent& event)
// PS -> {
// PS -> 	/*
// PS -> 	wxMessageDialog* Q_erase = new wxDialog(this,
// PS -> 	   _str_erase_quant_q,
// PS -> 	   "Question",
// PS -> 	   wxYES_NO|wxNO_DEFAULT|wxCENTRE,
// PS -> 	   wxPoint(100, 100));
// PS -> 
// PS ->    if (Q_erase->ShowModal() ==  wxID_OK)
// PS ->    {
// PS ->       _first_quant = 1;
// PS ->       _real_first_point_quant = -1;
// PS ->       _real_last_point_quant = -1;
// PS ->       this->controls(1);
// PS ->       _quant_shown = false;
// PS -> 
// PS -> 	  this->clean_graph();
// PS -> 
// PS -> 	  if (_pRenderer3D != 0) _pRenderer3D->RemoveActor(hs_actor);
// PS -> 	  if (_hs_actor != 0)   hs_actor->delete();
// PS -> 	  if (_hs_mapper != 0)  hs_mapper->delete();
// PS ->       if (_hs_grid != 0)   hs_grid->delete();
// PS ->       if (_hs_points != 0)   hs_points->delete();
// PS ->       if (_hs_poly_line != 0)   hs_poly_line->delete();
// PS -> 
// PS ->      foreach i $rings_index
// PS -> 		{
// PS -> 
// PS ->             catch { renderer_$widgets(work3D) RemoveActor cont3DActor_{$widgets(work3D)}_{$i} }
// PS ->             catch { cont3DActor_{$widgets(work3D)}_{$i}    Delete }
// PS ->             catch { cont3DMapper_{$widgets(work3D)}_{$i}   Delete }
// PS ->             catch { cont3DGrid_{$widgets(work3D)}_{$i}     Delete }
// PS ->             catch { cont3DPolyLine_{$widgets(work3D)}_{$i} Delete }
// PS ->             catch { cont3DPoints_{$widgets(work3D)}_{$i}   Delete }
// PS -> 
// PS ->         }
// PS ->       _rings_index = _list;
// PS -> 	  _quant_x     = _list;
// PS ->       _quant_area  = _list;
// PS ->       _quant_peri  = _list;
// PS ->       _quant_darea = _list;
// PS ->       _quant_dperi = _list;
// PS ->       _quant_dmax  = _list;
// PS ->       _quant_dmin  = _list;
// PS ->       _quant_davg  = _list;
// PS ->       _quant_sten  = _list;
// PS -> 
// PS ->       _area = 0.00;
// PS ->       _peri = 0.00;
// PS ->       _darea = 0.00;
// PS ->       _dperi = 0.00;
// PS ->       _dmax  = 0.00;
// PS ->       _dmin  = 0.00;
// PS ->       _davg  = 0.00;
// PS ->       _sten  = 0.00;
// PS ->       _shown = false;
// PS -> 
// PS ->       _pRenderWindow3D->Render();
// PS -> 	  this->clean_contour();
// PS -> 
// PS ->       wxMessageDialog* Q_extract = new wxDialog(this,
// PS -> 			_str_erase_extracted_contours,
// PS -> 			"Question",
// PS -> 			wxYES_NO|wxNO_DEFAULT|wxCENTRE,
// PS -> 			wxPoint(100, 100));
// PS -> 
// PS ->       if (Q_extract->ShowModal() ==  wxID_OK)
// PS -> 		 this->cleanData();
// PS -> 
// PS -> 	  delete Q_extract;
// PS -> 
// PS ->    }
// PS ->    delete Q_erase;
// PS ->    */
// PS -> }




// PS -> void wxQuantificationWidget::OnSetPoint_BT(wxCommandEvent& event)
// PS -> {
// PS ->     //set slice = [ $widgets(sclSlice) get ]
// PS ->     //this->select_axis_point( 0, 0, $slice
// PS -> }



//--------------------------------------------------------------------
// CheckBox
void wxQuantificationWidget::OnHealthySlice_CB(wxCommandEvent& event)
{
	// Visible
	/*  if ( _show_hs == 1 ) {
    if ( _pRenderer3D != 0 )
	_pRenderer3D->AddActor(_hsActor3D);
	}
	// Hide
	else {
    if ( _pRenderer3D != 0 )
	_pRenderer3D->RemoveActor(_hsActor3D);
	}
	
	_pRenderWindow3D->Render();  // Maj*/

	
	int healthySlice = _mar->_experiment->getAxis( )->getHealthySlice( );
	if (healthySlice!=-1) {
		if ( _cb_HealthySlice->GetValue() )
			_3DWorld->Show3DHealthySliceActor();
		else
			_3DWorld->Hide3DHealthySliceActor();
	}
}


//--------------------------------------------------------------------
void wxQuantificationWidget::OnVisibleRing_CB(wxCommandEvent& event){
	if ( _cb_VisibleRings->GetValue() ){
		_3DWorld->Show3DContourActor();
		_2DWorld->Show2DContourDiameters();
		RefreshAxis();
	} else {
		_3DWorld->Hide3DContourActor();
		_2DWorld->Hide2DContourDiameters();
	}

	// GetNumberOfAxisPoints()
	/*  int noap = _mar->_experiment->getNumberOfAxes();
	for (int i= 0; i < noap;  i++ ) {
    if ( _show_rings == 0 ) {
	if ( _pRenderer3D != 0 )
	_pRenderer3D->RemoveActor(_contActor3D[i]);
    }
    else  {
	if ( _pRenderer3D != 0 )
	_pRenderer3D->AddActor(_contActor3D[i]);
    }
	}
	_pRenderWindow3D->Render(); // Maj*/
}
//--------------------------------------------------------------------
void wxQuantificationWidget::OnPerpendicular_CB(wxCommandEvent& event)
{
	if ( _cb_Perpendicular->GetValue() )
		_3DWorld->Show3DSliceActor();
	else
		_3DWorld->Hide3DSliceActor();
}
//--------------------------------------------------------------------
// RadioButton
void wxQuantificationWidget::OnGreyScale_RB(wxCommandEvent& event){
	if ( _rb_GreyScale->GetValue() ){
		_3DWorld->SetBWLookUp();
	}
}
//--------------------------------------------------------------------
void wxQuantificationWidget::OnColor_RB(wxCommandEvent& event){
	if ( _rb_Color->GetValue() ){
		_3DWorld->SetColorLookUp();
	}
}
//--------------------------------------------------------------------
void wxQuantificationWidget::CallBackOnLeftDClick( wxMouseEvent& event ){

	double pp[3], cp[3];
	_3DWorld->GetLast3DClickPoint(pp,cp);

	int i,iback,maxPoints;
	double *c, cc[3];
	double dist,distMin=-1;
	iback=-1;
	    
	marAxis *maraxis = _mar->_experiment->getAxis( );
	maxPoints = maraxis->getNumberOfSplinePoints();
	for ( i=0 ; i<maxPoints ; i++ ){
		c = maraxis->getSplinePoint(i); 
		cc[0]=c[0]-pp[0];
		cc[1]=c[1]-pp[1];
		cc[2]=c[2]-pp[2];
		dist=sqrt( cc[0]*cc[0] + cc[1]*cc[1] + cc[2]*cc[2] );
		if ((distMin==-1) || (dist<distMin)) {
			iback=i;
			distMin=dist;
		}
	}
	_sl_Slice->SetValue(iback);
	MoveSlider(iback);

}

//--------------------------------------------------------------------
void wxQuantificationWidget::CallBackOnMouseWheel( wxMouseEvent& event ){
	int slice=_sl_Slice->GetValue();
	if (event.GetWheelRotation()>0){ slice++; }
	if (event.GetWheelRotation()<0){ slice--; }
    if (slice < _sl_Slice->GetMin() ) { slice=_sl_Slice->GetMin(); }
    if (slice > _sl_Slice->GetMax() ) { slice=_sl_Slice->GetMax(); }
    _sl_Slice->SetValue(slice);
	MoveSlider(slice);
}
//--------------------------------------------------------------------
int wxQuantificationWidget::GetActualSlice(){
	return _sl_Slice->GetValue();
}
//--------------------------------------------------------------------
int wxQuantificationWidget::GetMaxActualSlice(){
	return _sl_Slice->GetMax();
}
//--------------------------------------------------------------------
int  wxQuantificationWidget::GetSizeHealthyRegion(){
	return _sizeHealthyRegion;
}
//--------------------------------------------------------------------
void wxQuantificationWidget::SetSizeHealthyRegion(int size){
	_sizeHealthyRegion = size;
}
//--------------------------------------------------------------------
void wxQuantificationWidget::GetHealthySliceRange(int &healthySliceStart,int &healthySliceEnd){
	healthySliceStart	= _mar->_experiment->getAxis()->getHealthySliceStart( );
	healthySliceEnd		= _mar->_experiment->getAxis()->getHealthySliceEnd( );
}
//--------------------------------------------------------------------
void wxQuantificationWidget::Set3DRegionSliceActor( int type, int k1,int k2 ){
	_3DWorld->Set3DRegionSliceActor(type,k1,k2);
}
//--------------------------------------------------------------------
void wxQuantificationWidget::Set3DStartRegionSliceActor( int type, int k){
	_3DWorld->Set3DStartRegionSliceActor(type,k);
}
//--------------------------------------------------------------------
void wxQuantificationWidget::Set3DEndRegionSliceActor( int type, int k){
	_3DWorld->Set3DEndRegionSliceActor(type,k);
}
//--------------------------------------------------------------------
void wxQuantificationWidget::Show3DRegionSliceActor( int type ){
	_3DWorld->Show3DRegionSliceActor(type);
}
//--------------------------------------------------------------------
void wxQuantificationWidget::Show3DStartRegionSliceActor( int type ){
	_3DWorld->Show3DStartRegionSliceActor(type);
}
//--------------------------------------------------------------------
void wxQuantificationWidget::Show3DEndRegionSliceActor( int type ){
	_3DWorld->Show3DEndRegionSliceActor(type);
}
//--------------------------------------------------------------------
void wxQuantificationWidget::Hide3DRegionSliceActor( int type ){
	_3DWorld->Hide3DRegionSliceActor(type);
}
//--------------------------------------------------------------------
void wxQuantificationWidget::Hide3DStartRegionSliceActor( int type ){
	_3DWorld->Hide3DStartRegionSliceActor(type);
}
//--------------------------------------------------------------------
void wxQuantificationWidget::Hide3DEndRegionSliceActor( int type ){
	_3DWorld->Hide3DEndRegionSliceActor(type);
}
//--------------------------------------------------------------------
void wxQuantificationWidget::GetSliceLimites(int type, int &sliceStart, int &sliceEnd){
	_3DWorld->GetSliceLimites(type,sliceStart,sliceEnd);
}
//--------------------------------------------------------------------
int wxQuantificationWidget::GetAnalysisTypeStenosis(){
	return _3DWorld->GetAnalysisTypeStenosis();
}
//--------------------------------------------------------------------
void wxQuantificationWidget::SetAnalysisTypeStenosis(int analysisTypeStenosis){
	_3DWorld->SetAnalysisTypeStenosis(analysisTypeStenosis);
}
//--------------------------------------------------------------------
void wxQuantificationWidget::SetManualContour_2DWorld(bool ok){

	if (ok==false){ 
		_2DWorld->SetState(1);
		_2DWorld->EraseManualContour();
	}
	if (ok==true){  
		_2DWorld->SetState(2);
		_2DWorld->CreateNewManualContour();
		_2DWorld->Render();

	}

}
//--------------------------------------------------------------------
void wxQuantificationWidget::SetManualContour_AddPoint_2DWorld(){
	_bak_ActualSlice	= _sl_Slice->GetValue();
	_2DWorld->Hide2DContourDiameters();
	_mar->_experiment->getAxis()->EraseContour(_bak_ActualSlice);
	_3DWorld->Erase3DContourActor( _bak_ActualSlice );

	_2DWorld->SetStateManualContour(0);
}
//--------------------------------------------------------------------
void wxQuantificationWidget::SetManualContour_InsertPoint_2DWorld(){
	_2DWorld->SetStateManualContour(2);
}
//--------------------------------------------------------------------
void wxQuantificationWidget::SetManualContour_ErasePoint_2DWorld(){
	_2DWorld->SetStateManualContour(3);
}
//--------------------------------------------------------------------
void wxQuantificationWidget::SetManualContour_MovePoint_2DWorld(){
	_2DWorld->SetStateManualContour(4);
}
//--------------------------------------------------------------------
void wxQuantificationWidget::SetManualContour_ReplaceContour(){
	if (_bak_ActualSlice!=-1){
		int size		= _2DWorld->GetNumberOfPointsSplineManualContour();
		double *vx		= _2DWorld->GetVectorPointsXManualContour();
		double *vy		= _2DWorld->GetVectorPointsYManualContour();
		_mar->_experiment->getAxis()->replaceContour2D(_bak_ActualSlice,size,vx,vy);
		free(vx);
		free(vy);
		RefreshAxis();
		_bak_ActualSlice=-1;
	}
}
//------------------------------------------------------------------------
kVolume* wxQuantificationWidget::GetVolumeAxisExtended(int wz1,int wz2)
{
	// Create Volume
	vtkImageData *imagedata;
	imagedata=_mar->_experiment->getSliceImage(wz1);
	int dims[3];
	imagedata->GetDimensions (dims);
	int wx=dims[0];
	int wy=dims[1];
	int wz	= wz2-wz1+1;
	kVolume *kvol =new kVolume( kVolume::USHORT, wx, wy, wz,1, 1, 1, malloc(sizeof(unsigned short)*wx*wy*wz ) );
	vtkImageData *vol = kvol->castVtk();

	// Fill Volume
	int i;
	for (i=wz1;i<=wz2;i++)
	{
		// GetImage
		imagedata=_mar->_experiment->getSliceImage(i);

		// InsertImage
	     void *p_imagedata	= imagedata->GetScalarPointer(0,0,0);
		 void *p_vol		= vol->GetScalarPointer(0,0,i-wz1);
         memcpy( p_vol, p_imagedata , sizeof(unsigned short)*dims[0]*dims[1] );
	}
	return kvol;
}


//------------------------------------------------------------------------
void wxQuantificationWidget::OnContourWall()
{
}

//------------------------------------------------------------------------
void wxQuantificationWidget::OnContourLumen()
{
}

//------------------------------------------------------------------------
void wxQuantificationWidget::OnContourHypo()
{
}

//------------------------------------------------------------------------
void wxQuantificationWidget::OnContourCalc()
{
}

//------------------------------------------------------------------------
void wxQuantificationWidget::OnReplaceContourWall()
{
}
//------------------------------------------------------------------------
void wxQuantificationWidget::OnReplaceContourLumen()
{
}
//------------------------------------------------------------------------
void wxQuantificationWidget::OnReplaceContourHypo()
{
}

//------------------------------------------------------------------------
void wxQuantificationWidget::OnReplaceContourCalc() 
{
}


//------------------------------------------------------------------------
void wxQuantificationWidget::OnSliderDiscontinuityScroll(int percentage)
{
}

//------------------------------------------------------------------------
void wxQuantificationWidget::OnSliderLumenPercentageScroll(int percentage)
{
}

//------------------------------------------------------------------------
void wxQuantificationWidget::OnSliderCalcPercentageScroll(int percentage)
{
}

//------------------------------------------------------------------------
void wxQuantificationWidget::OnCalibration() 
{
}
//------------------------------------------------------------------------
void wxQuantificationWidget::OnFile()
{
}

//------------------------------------------------------------------------
void wxQuantificationWidget::OnShowAll(bool value) 
{
}

//------------------------------------------------------------------------
void wxQuantificationWidget::OnShowWall(bool value)
{
}
//------------------------------------------------------------------------
void wxQuantificationWidget::OnShowLumen(bool value)
{
}

//------------------------------------------------------------------------
void wxQuantificationWidget::OnShowCalc(bool value)
{
}

//------------------------------------------------------------------------
void wxQuantificationWidget::OnShowHypo(bool value)
{
}


// EOF - wxQuantificationWidget.cxx



