/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

 Program:   wxMaracas
 Module:    $RCSfile: wxQuantificationWidgetCT.cxx,v $
 Language:  C++
 Date:      $Date: 2012/11/15 14:15:17 $
 Version:   $Revision: 1.2 $
 
  Copyright: (c) 2002, 2003
  License:
  
   This software is distributed WITHOUT ANY WARRANTY; without even
   the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
   PURPOSE.  See the above copyright notice for more information.
   
=========================================================================*/

#include "wxQuantificationWidgetCT.h"
#include "../marDictionary.h"
#include "vtkPolyDataWriter.h"





//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
BEGIN_EVENT_TABLE( wxQuantificationWidgetCT, wxPanel )
	EVT_BUTTON(ID_BUTTON_CONTOUR	, wxQuantificationWidgetCT::OnContour_BT						)
	EVT_BUTTON(ID_BUTTON_CLEAN		, wxQuantificationWidgetCT::OnClean_BT						)
	EVT_BUTTON(ID_BUTTON_CLEAN_ALL	, wxQuantificationWidgetCT::OnCleanAll_BT						)
	EVT_CHECKBOX(ID_CHECKBOX_HEALTHY,			wxQuantificationWidgetCT::OnHealthySlice_CB		)
	EVT_CHECKBOX(ID_CHECKBOX_SHOW_SURFACE,		wxQuantificationWidgetCT::OnShowSurface_CB		)
	EVT_CHECKBOX(ID_CHECKBOX_VISIBLE_RINGS,		wxQuantificationWidgetCT::OnVisibleRing_CB		)
	EVT_CHECKBOX(ID_CHECKBOX_PERPENDICULAR,		wxQuantificationWidgetCT::OnPerpendicular_CB		)

	EVT_RADIOBUTTON(ID_RADIOBUTTON_GREYSCALE,	wxQuantificationWidgetCT::OnGreyScale_RB			)
	EVT_RADIOBUTTON(ID_RADIOBUTTON_COLOR,		wxQuantificationWidgetCT::OnColor_RB				)

	EVT_COMMAND_SCROLL(ID_SLIDER_SLICE,			wxQuantificationWidgetCT::OnSliderSliceScroll		)

	EVT_COMMAND_SCROLL(ID_SLIDER_OPACITY,		wxQuantificationWidgetCT::OnSliderOpacityScroll	)
	EVT_COMMAND_SCROLL_THUMBRELEASE(ID_SLIDER_ISOVALUE, wxQuantificationWidgetCT::OnSliderIsovalueScroll	)
	
END_EVENT_TABLE( );

//--------------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------------
wxQuantificationWidgetCT::wxQuantificationWidgetCT(wxWindow* parent, wxWindowID id,
                                               const wxPoint& pos, const wxSize& size, long style,
                                               const wxString& name)
: wxQuantificationWidget_base( parent, id, pos, size, style, name )
{
/*
    panel_splitter		 = new wxSplitterWindow( this			, -1, wxDefaultPosition, wxSize(400,400 ), wxSP_3D );
 	panel_left			 = new wxPanel(panel_splitter			, -1, wxDefaultPosition, wxSize(400,400));
    panel_splitter_right = new wxSplitterWindow( panel_splitter , -1, wxDefaultPosition, wxSize(400,400 ), wxSP_3D );
	panel_right_up		 = new wxPanel(panel_splitter_right		, -1, wxDefaultPosition, wxSize(600,600));
	panel_right_down	 = new wxPanel(panel_splitter_right		, -1, wxDefaultPosition, wxSize(600,600));
	panel_rightm_up		 = CreateViewPanel(panel_right_up);

	// maracas
	_mar = NULL;
	SetSizeHealthyRegion( 5 );

//EEDxx 2.6
//	this->SetBackgroundColour(*wxLIGHT_GREY);

	_3DWorld = new vtk3DQuantSurfaceWidget( panel_left, ID_QUANTIF3D );

	
//EED OJO Este NULL es solo para que compile	
	_3DWorld->SetInterfaceVtkPanelWidgets(NULL);

//	_2DWorld = new vtk2DQuantSliceWidget( panel_right_up, -1 );
//	_2DWorld->SetSize(200,200);

//EED OJO Este NULL es solo para que compile	
//	_2DWorld->SetInterfaceVtkPanelWidgets(NULL);
	
	
	this->Set_control();
	this->Do_layout();
	this->Set_Data();
*/
	_bak_ActualSlice=-1;
	_bak_ActualSlice2=-1;

	_mar = NULL;

	wxBoxSizer * sizer = new wxBoxSizer(wxVERTICAL);
	sizer->Add( CreatePanelPrincipal(this), 1, wxALL|wxEXPAND, 0 );
	sizer->Add( CreatePanelStatus(this) , 0, wxALL|wxEXPAND, 0 );

	SetSizer(sizer);
	Layout();	



}


//--------------------------------------------------------------------------------
// Destructor
// ----------------------------------------------------------------------------
wxQuantificationWidgetCT::~wxQuantificationWidgetCT( ){
	_3DWorld->Delete( );
	delete _contourViewer;
	delete _lineViewer;
	delete _pointViewer;
//	delete _2DWorld;
	
	for (int i = 0; i < _manContours.size(); i++)
	{
		delete _manContours[i];
		_manContours[i] = NULL;
	}
	delete _imageviewer2D_1;
}
// ----------------------------------------------------------------------------
wxWindow* wxQuantificationWidgetCT::CreatePanelPrincipal(wxWindow *parent)
{
	wxPanel *panel			= new wxPanel(parent,-1);
	_splitPanelPrincipal	= new wxSplitterWindow(panel, -1);
	_splitPanelPrincipal->SetMinimumPaneSize(50);

	wxWindow *principal_Left	= CreatePanel_Left(_splitPanelPrincipal) ;
	wxWindow *principal_Right	= CreatePanel_Right(_splitPanelPrincipal);

	_splitPanelPrincipal->SplitVertically(principal_Left , principal_Right,600 );


	wxBoxSizer * sizer = new wxBoxSizer(wxVERTICAL);
	sizer->Add( _splitPanelPrincipal, 1,wxGROW,0 );
	panel->SetSizer(sizer);
	panel->Layout();	
	return panel;
}

// ----------------------------------------------------------------------------
wxWindow* wxQuantificationWidgetCT::CreatePanel_Left(wxWindow *parent)
{
	wxPanel *panel		= new wxPanel(parent,-1);
	_splitpanel_left	= new wxSplitterWindow(panel, -1);
	_splitpanel_left->SetMinimumPaneSize(50);

	_3DWorld = new vtk3DQuantSurfaceWidget( _splitpanel_left, ID_QUANTIF3D );
	_3DWorld->SetInterfaceVtkPanelWidgets(NULL);
	wxWindow *controlPanel3D	= CreateControlPanel3D(_splitpanel_left);

	_splitpanel_left->SplitHorizontally(_3DWorld , controlPanel3D,0 );


	wxBoxSizer * sizer = new wxBoxSizer(wxVERTICAL);
	sizer->Add( _splitpanel_left, 1,wxGROW,0 );
	panel->SetSizer(sizer);
	panel->Layout();	
	return panel;
}


// ----------------------------------------------------------------------------
wxWindow* wxQuantificationWidgetCT::CreateControlPanel3D(wxWindow *parent)
{
	wxPanel *panel						= new wxPanel(parent,-1);
	marDictionary marDict;
	
	_cb_HealthySlice	= new wxCheckBox( panel, ID_CHECKBOX_HEALTHY, wxString( marDict.GetString(205) , wxConvUTF8)); // "Healthy slice"
	_cb_HealthySlice->SetValue(true);
	_cb_Perpendicular	= new wxCheckBox( panel, ID_CHECKBOX_PERPENDICULAR, wxString(marDict.GetString(210), wxConvUTF8)); //"Perpendicular section"
	_cb_Perpendicular->SetValue(true);

	_rb_GreyScale		= new wxRadioButton( panel, ID_RADIOBUTTON_GREYSCALE, wxString(marDict.GetString(230), wxConvUTF8), wxDefaultPosition,wxDefaultSize,wxRB_GROUP ); //"greyscale    "
	_rb_GreyScale->SetValue(true);

	_rb_Color			= new wxRadioButton( panel, ID_RADIOBUTTON_COLOR, wxString(marDict.GetString(235), wxConvUTF8), wxDefaultPosition,wxDefaultSize );//"color    "
	_rb_Color->SetValue(false);

	_cb_VisibleRings	= new wxCheckBox( panel, ID_CHECKBOX_VISIBLE_RINGS, wxString(marDict.GetString(215), wxConvUTF8));//"Visible rings"
	_cb_VisibleRings->SetValue(true);
	_cb_ShowSurface		= new wxCheckBox( panel, ID_CHECKBOX_SHOW_SURFACE, wxString(marDict.GetString(220), wxConvUTF8));//"Show Surface"
	_cb_ShowSurface->SetValue(true);

	
	_bt_AddContour3D		= new wxButton( panel, ID_BUTTON_CONTOUR, wxString(marDict.GetString(245), wxConvUTF8) ,//"Add mark contour"
	                               wxDefaultPosition, wxDefaultSize, wxBU_EXACTFIT, wxDefaultValidator);
	_bt_CleanContour3D		= new wxButton( panel, ID_BUTTON_CLEAN, wxString(marDict.GetString(250), wxConvUTF8) ,//"Erase mark contours"
	                             wxDefaultPosition, wxDefaultSize, wxBU_EXACTFIT, wxDefaultValidator);

	_bt_CleanAllContours3D	= new wxButton( panel, ID_BUTTON_CLEAN_ALL, wxString(marDict.GetString(253), wxConvUTF8) ,//"Erase all mark contours"
	                             wxDefaultPosition, wxDefaultSize, wxBU_EXACTFIT, wxDefaultValidator);

	//wxSlider
	_sl_Slice    = new wxSlider( panel, ID_SLIDER_SLICE	, 0, 0, 10000, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );
	_sl_Isovalue = new wxSlider( panel, ID_SLIDER_ISOVALUE	, 0, 0, 10000, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );
	_sl_Opacity  = new wxSlider( panel, ID_SLIDER_OPACITY	, 0, 0, 100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );


	// size
	_sl_Slice->SetSize(800,16);
	_sl_Isovalue->SetSize(300,16);
	_sl_Opacity->SetSize(300,16);
	
	// Text
	_st_Slice			= new wxStaticText(panel, -1, wxString(marDict.GetString( 90), wxConvUTF8) ); //"Slice "
	_st_Isovalue		= new wxStaticText(panel, -1, wxString(marDict.GetString(240), wxConvUTF8) ); //"Isovalue"
	_st_Opacity			= new wxStaticText(panel, -1, wxString(marDict.GetString(225), wxConvUTF8) ); //"Opacity "

	_txt_Position		= new wxStaticText(panel, -1, _T("  ") ); //"Position "


//--

	wxFlexGridSizer		*axe				= new wxFlexGridSizer(1);

	wxFlexGridSizer		*axe1				= new wxFlexGridSizer(10);
	wxBoxSizer			*axe2				= new wxBoxSizer(wxHORIZONTAL);
	wxFlexGridSizer		*axe3				= new wxFlexGridSizer(10,0);
	wxFlexGridSizer		*axe4				= new wxFlexGridSizer(10,0);
	wxBoxSizer			*axe5				= new wxBoxSizer(wxHORIZONTAL);



	axe1->Add(_st_Slice				, 10, wxALL|wxEXPAND, 0);
	axe1->Add(_sl_Slice				, 10, wxALL|wxGROW, 0);
	axe1->Add(_txt_Position			, 10, wxALL|wxEXPAND, 0);
	axe1->AddGrowableCol(1);

	axe2->Add(_cb_HealthySlice			, 10, wxALL|wxEXPAND, 0);
	axe2->Add(_cb_Perpendicular			, 10, wxALL|wxEXPAND, 0);
	axe2->Add(_cb_VisibleRings			, 10, wxALL|wxEXPAND, 0);
	axe2->Add(_cb_ShowSurface			, 10, wxALL|wxEXPAND, 0);

	axe3->Add(_st_Opacity				,  1, wxALL|wxEXPAND, 0);
	axe3->Add(_sl_Opacity				, 10, wxALL|wxGROW, 0);
	axe3->Add(_rb_GreyScale				, 10, wxALL|wxEXPAND, 0);
	axe3->Add(_rb_Color				, 10, wxALL|wxEXPAND, 0);
	axe3->AddGrowableCol(1);

	axe4->Add(_st_Isovalue				,  1, wxALL|wxEXPAND, 0);
	axe4->Add(_sl_Isovalue				,  1, wxALL|wxGROW, 0);
	axe4->AddGrowableCol(1);

	axe5->Add(_bt_AddContour3D			,  1 );
	axe5->Add(_bt_CleanContour3D			,  1 );
	axe5->Add(_bt_CleanAllContours3D		,  1 );


	axe->Add(axe1, 2, wxALL|wxGROW, 0);
	axe->Add(axe2, 2, wxALL, 0);   //wxALIGN_CENTER_HORIZONTAL
	axe->Add(axe3, 2, wxALL|wxGROW, 0);
	axe->Add(axe4, 2, wxALL|wxGROW, 0);
	axe->Add(axe5, 2, wxALL, 0);




	wxBoxSizer * sizer = new wxBoxSizer(wxVERTICAL);
	sizer->Add( axe, 1,wxALL|wxGROW,5 );
	panel->SetSizer(sizer);
	panel->Layout();	
	return panel;

}

// ----------------------------------------------------------------------------
wxWindow* wxQuantificationWidgetCT::CreatePanel_Right(wxWindow *parent)
{
	wxPanel *panel		= new wxPanel(parent,-1);
	_splitpanel_right	= new wxSplitterWindow(panel, -1);
	_splitpanel_right->SetMinimumPaneSize(50);

	wxWindow *window2D			= CreateView2DPanel(_splitpanel_right);
	wxWindow *windowRightDown	= CreatePanel_Right_Down(_splitpanel_right);

	_splitpanel_right->SplitHorizontally(window2D , windowRightDown,0 );


	wxBoxSizer * sizer = new wxBoxSizer(wxVERTICAL);
	sizer->Add( _splitpanel_right, 1,wxGROW,0 );
	panel->SetSizer(sizer);
	panel->Layout();	
	return panel;
}


// ----------------------------------------------------------------------------
wxWindow* wxQuantificationWidgetCT::CreatePanel_Right_Down(wxWindow *parent)
{
	wxPanel *panel			= new wxPanel(parent,-1);
	_splitpanel_right_down	= new wxSplitterWindow(panel, -1);
	_splitpanel_right_down->SetMinimumPaneSize(10);

	_pl_cntlHealthySick2	= new wxPanelControlsHealthySickSliceCT(_splitpanel_right_down,this);
	_wxStenosisPanel		= CreateStenosisPanel(_splitpanel_right_down);

	_splitpanel_right_down->SplitHorizontally(_pl_cntlHealthySick2,_wxStenosisPanel  ,300 );


	wxBoxSizer * sizer = new wxBoxSizer(wxVERTICAL);
	sizer->Add( _splitpanel_right_down, 1,wxGROW,0 );
	panel->SetSizer(sizer);
	panel->Layout();	
	return panel;
}


// ----------------------------------------------------------------------------
wxWindow* wxQuantificationWidgetCT::CreatePanelStatus(wxWindow *parent)
{
	wxPanel *panel = new wxPanel(parent,-1);

	
//--	
	marDictionary marDict;
	
	_st_Label1 = new wxStaticText(panel, -1, wxString(marDict.GetString(380), wxConvUTF8) ); //"Total Axis Lenght"
	_st_Value1 = new wxStaticText(panel, -1, _T("0.00"));
	_st_Label2 = new wxStaticText(panel, -1, wxString(marDict.GetString(390), wxConvUTF8) );//"Area"
	_st_Value2 = new wxStaticText(panel, -1, _T("0.00"));
	_st_Label3 = new wxStaticText(panel, -1, wxString(marDict.GetString(400), wxConvUTF8) );//"Perimeter"
	_st_Value3 = new wxStaticText(panel, -1, _T("0.00"));
	_st_Label6 = new wxStaticText(panel, -1, wxString(marDict.GetString(405), wxConvUTF8) );//"Minimum Diameter"
	_st_Value6 = new wxStaticText(panel, -1, _T("0.00"));
	_st_Label7 = new wxStaticText(panel, -1, wxString(marDict.GetString(410), wxConvUTF8) );//"Maximum Diameter"
	_st_Value7 = new wxStaticText(panel, -1, _T("0.00"));
	_st_Label8 = new wxStaticText(panel, -1, wxString(marDict.GetString(415), wxConvUTF8) );//"Average Diameter"
	_st_Value8 = new wxStaticText(panel, -1, _T("0.00"));

	_st_LabelRef101 = new wxStaticText(panel, -1, wxString(marDict.GetString(385), wxConvUTF8) );//"Seg. Length"
	_st_ValueRef101 = new wxStaticText(panel, -1, _T("--"));
	_st_LabelRef102 = new wxStaticText(panel, -1, wxString(marDict.GetString(395), wxConvUTF8) );//"Ref. Area"
	_st_ValueRef102 = new wxStaticText(panel, -1, _T("--"));
	_st_LabelRef103 = new wxStaticText(panel, -1, wxString(marDict.GetString(420), wxConvUTF8) );//"Ref. Average Diam."
	_st_ValueRef103 = new wxStaticText(panel, -1, _T("--"));

//--
	wxBoxSizer			*status				= new wxBoxSizer(wxHORIZONTAL);
	wxBoxSizer			*status0			= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*status1			= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*status2			= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*status3			= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*status6			= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*status7			= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*status8			= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*status9			= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*statusRef1			= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*statusRef2			= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*statusRef3			= new wxBoxSizer(wxVERTICAL);
	
	status1->Add(_st_Label1, 1, wxALL|wxALIGN_CENTER, 5);
	status1->Add(_st_Value1, 1, wxALL|wxALIGN_CENTER, 5);
	status2->Add(_st_Label2, 1, wxALL|wxALIGN_CENTER, 5);
	status2->Add(_st_Value2, 1, wxALL|wxALIGN_CENTER, 5);
	status3->Add(_st_Label3, 1, wxALL|wxALIGN_CENTER, 5);
	status3->Add(_st_Value3, 1, wxALL|wxALIGN_CENTER, 5);

	status6->Add(_st_Label6, 1, wxALL|wxALIGN_CENTER, 5);
	status6->Add(_st_Value6, 1, wxALL|wxALIGN_CENTER, 5);
	status7->Add(_st_Label7, 1, wxALL|wxALIGN_CENTER, 5);
	status7->Add(_st_Value7, 1, wxALL|wxALIGN_CENTER, 5);
	status8->Add(_st_Label8, 1, wxALL|wxALIGN_CENTER, 5);
	status8->Add(_st_Value8, 1, wxALL|wxALIGN_CENTER, 5);

	
	statusRef1->Add(_st_LabelRef101, 1, wxALL|wxALIGN_CENTER, 5);
	statusRef1->Add(_st_ValueRef101, 1, wxALL|wxALIGN_CENTER, 5);
	statusRef2->Add(_st_LabelRef102, 1, wxALL|wxALIGN_CENTER, 5);
	statusRef2->Add(_st_ValueRef102, 1, wxALL|wxALIGN_CENTER, 5);
	statusRef3->Add(_st_LabelRef103, 1, wxALL|wxALIGN_CENTER, 5);
	statusRef3->Add(_st_ValueRef103, 1, wxALL|wxALIGN_CENTER, 5);



	status->Add(status1		, 1, wxALL|wxEXPAND, 0);
	status->Add(statusRef1	, 1, wxALL|wxEXPAND, 0);
	status->Add(status2		, 1, wxALL|wxEXPAND, 0);
	status->Add(statusRef2	, 1, wxALL|wxEXPAND, 0);
	status->Add(status3		, 1, wxALL|wxEXPAND, 0);

	status->Add(status6		, 1, wxALL|wxEXPAND, 0);
	status->Add(status7		, 1, wxALL|wxEXPAND, 0);
	status->Add(status8		, 1, wxALL|wxEXPAND, 0);
	status->Add(statusRef3	, 1, wxALL|wxEXPAND, 0);


//--	
	
	wxBoxSizer * sizer = new wxBoxSizer(wxHORIZONTAL);
	sizer->Add( status, 1,wxALL|wxEXPAND,0 );
	panel->SetSizer(sizer);
	panel->Layout();	
	return panel;
}
// ----------------------------------------------------------------------------
wxWindow* wxQuantificationWidgetCT::CreateStenosisPanel(wxWindow *parent){
	marDictionary marDict;

	wxPanel* panel = new wxPanel(parent);

	_st_Label100 = new wxStaticText(panel, -1, (wxChar)(marDict.GetString(255)) ); // "Stenosis (area)"
	_st_Label101 = new wxStaticText(panel, -1, (wxChar)(marDict.GetString(260)) ); // "Stenosis (diameter)"
	_st_Value100 = new wxStaticText(panel, -1, _T("--                "));
	_st_Value101 = new wxStaticText(panel, -1, _T("--                "));
//	wxStaticText *_st_LabelBlanc = new wxStaticText(panel, -1, "                 ");

//EEDxx 2.6
//	_st_LabelBlanc->SetBackgroundColour(*wxLIGHT_GREY);

//EEDxx 2.6
//	panel->SetBackgroundColour(wxColour(100,0,100));
//	_st_Label100->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Label101->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Value100->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Value101->SetBackgroundColour(*wxLIGHT_GREY);


	wxFont font(14,wxDEFAULT ,wxNORMAL,wxBOLD);
	_st_Value100->SetFont(font);
	_st_Value101->SetFont(font);



	wxGridSizer*  gridSizer1	= new wxFlexGridSizer(1);
	gridSizer1->Add(new wxStaticText(panel, -1, _T("                 "))	,15, wxALL|wxEXPAND|wxALIGN_CENTRE_HORIZONTAL, 0);
	gridSizer1->Add(_st_Value100	,15, wxALL|wxEXPAND|wxALIGN_CENTRE_HORIZONTAL, 0);
	gridSizer1->Add(_st_Label100	,15, wxALL|wxEXPAND|wxALIGN_CENTRE_HORIZONTAL, 0);
	gridSizer1->Add(new wxStaticText(panel, -1, _T("                 "))	,15, wxALL|wxEXPAND|wxALIGN_CENTRE_HORIZONTAL, 0);
	gridSizer1->Add(_st_Value101	,15, wxALL|wxEXPAND|wxALIGN_CENTRE_HORIZONTAL, 0);
	gridSizer1->Add(_st_Label101	,15, wxALL|wxEXPAND|wxALIGN_CENTRE_HORIZONTAL, 0);

	wxGridSizer*  gridSizer		= new wxFlexGridSizer(4);
	gridSizer->Add(new wxStaticText(panel, -1, _T("                 "))	,15, wxALIGN_LEFT , 50);
	gridSizer->Add(new wxStaticText(panel, -1, _T("                 "))	,15, wxALIGN_LEFT , 50);
	gridSizer->Add(new wxStaticText(panel, -1, _T("                 "))	,15, wxALIGN_LEFT , 50);
	gridSizer->Add(gridSizer1		,15, wxALIGN_LEFT , 50);

	panel->SetAutoLayout(true);
	panel->SetSizer(gridSizer);
	panel->Layout();
//EEDxx 2.6
//	panel->SetBackgroundColour(*wxLIGHT_GREY);
	panel->SetSize(400,300);
	panel->SetSize( gridSizer->GetMinSize() );

	return panel;
}

//--------------------------------------------------------
/*
void wxQuantificationWidgetCT::Set_control(){
	marDictionary marDict;
	
    _wxStenosisPanel = CreateStenosisPanel();

	_cb_HealthySlice	= new wxCheckBox( panel_left, ID_CHECKBOX_HEALTHY, wxT( marDict.GetString(205) )); // "Healthy slice"
	_cb_HealthySlice->SetValue(true);
//EEDxx 2.6
//	_cb_HealthySlice->SetBackgroundColour(*wxLIGHT_GREY);
	_cb_Perpendicular	= new wxCheckBox( panel_left, ID_CHECKBOX_PERPENDICULAR, wxT(marDict.GetString(210))); //"Perpendicular section"
	_cb_Perpendicular->SetValue(true);
//EEDxx 2.6
//	_cb_Perpendicular->SetBackgroundColour(*wxLIGHT_GREY);

	_rb_GreyScale		= new wxRadioButton( panel_left, ID_RADIOBUTTON_GREYSCALE, wxT(marDict.GetString(230)), wxDefaultPosition,wxDefaultSize,wxRB_GROUP ); //"greyscale    "
	_rb_GreyScale->SetValue(true);
//EEDxx 2.6
//	_rb_GreyScale->SetBackgroundColour(*wxLIGHT_GREY);

	_rb_Color			= new wxRadioButton( panel_left, ID_RADIOBUTTON_COLOR, wxT(marDict.GetString(235)), wxDefaultPosition,wxDefaultSize );//"color    "
	_rb_Color->SetValue(false);
//EEDxx 2.6
//	_rb_Color->SetBackgroundColour(*wxLIGHT_GREY);

	_cb_VisibleRings	= new wxCheckBox( panel_left, ID_CHECKBOX_VISIBLE_RINGS, wxT(marDict.GetString(215)));//"Visible rings"
	_cb_VisibleRings->SetValue(true);
//EEDxx 2.6
//	_cb_VisibleRings->SetBackgroundColour(*wxLIGHT_GREY);
	_cb_ShowSurface		= new wxCheckBox( panel_left, ID_CHECKBOX_SHOW_SURFACE, wxT(marDict.GetString(220)));//"Show Surface"
	_cb_ShowSurface->SetValue(true);
//EEDxx 2.6
//	_cb_ShowSurface->SetBackgroundColour(*wxLIGHT_GREY);

	
	_bt_AddContour3D		= new wxButton( panel_left, ID_BUTTON_CONTOUR, marDict.GetString(245) ,//"Add mark contour"
	                               wxDefaultPosition, wxDefaultSize, wxBU_EXACTFIT, wxDefaultValidator);
	_bt_CleanContour3D		= new wxButton( panel_left, ID_BUTTON_CLEAN, marDict.GetString(250) ,//"Erase mark contours"
	                             wxDefaultPosition, wxDefaultSize, wxBU_EXACTFIT, wxDefaultValidator);

	_bt_CleanAllContours3D	= new wxButton( panel_left, ID_BUTTON_CLEAN_ALL, marDict.GetString(253) ,//"Erase all mark contours"
	                             wxDefaultPosition, wxDefaultSize, wxBU_EXACTFIT, wxDefaultValidator);

	//wxSlider
	_sl_Slice    = new wxSlider( panel_left, ID_SLIDER_SLICE	, 0, 0, 10000, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );
	_sl_Isovalue = new wxSlider( panel_left, ID_SLIDER_ISOVALUE	, 0, 0, 10000, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );
	_sl_Opacity  = new wxSlider( panel_left, ID_SLIDER_OPACITY	, 0, 0, 100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );
//EEDxx 2.6
//	_sl_Slice->SetBackgroundColour(*wxLIGHT_GREY);
//	_sl_Isovalue->SetBackgroundColour(*wxLIGHT_GREY);
//	_sl_Opacity->SetBackgroundColour(*wxLIGHT_GREY);

	// size
	_sl_Slice->SetSize(800,16);
	_sl_Isovalue->SetSize(300,16);
	_sl_Opacity->SetSize(300,16);
	
	// Text
	_st_Slice			= new wxStaticText(panel_left, -1, marDict.GetString( 90) ); //"Slice "
	_st_Isovalue		= new wxStaticText(panel_left, -1, marDict.GetString(240) ); //"Isovalue"
	_st_Opacity			= new wxStaticText(panel_left, -1, marDict.GetString(225) ); //"Opacity "

	_txt_Position		= new wxStaticText(panel_left, -1, "  " ); //"Position "

//EEDxx 2.6
//	_st_Slice->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Isovalue->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Opacity->SetBackgroundColour(*wxLIGHT_GREY);
	

	_st_Label1 = new wxStaticText(this, -1, marDict.GetString(380) ); //"Total Axis Lenght"
	_st_Value1 = new wxStaticText(this, -1, "0.00");
//EEDxx 2.6
//	_st_Label1->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Value1->SetBackgroundColour(*wxLIGHT_GREY);
	_st_Label2 = new wxStaticText(this, -1, marDict.GetString(390) );//"Area"
	_st_Value2 = new wxStaticText(this, -1, "0.00");
//EEDxx 2.6
//	_st_Label2->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Value2->SetBackgroundColour(*wxLIGHT_GREY);
	_st_Label3 = new wxStaticText(this, -1, marDict.GetString(400) );//"Perimeter"
	_st_Value3 = new wxStaticText(this, -1, "0.00");
//EEDxx 2.6
//	_st_Label3->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Value3->SetBackgroundColour(*wxLIGHT_GREY);
	_st_Label6 = new wxStaticText(this, -1, marDict.GetString(405) );//"Minimum Diameter"
	_st_Value6 = new wxStaticText(this, -1, "0.00");
//EEDxx 2.6
//	_st_Label6->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Value6->SetBackgroundColour(*wxLIGHT_GREY);
	_st_Label7 = new wxStaticText(this, -1, marDict.GetString(410) );//"Maximum Diameter"
	_st_Value7 = new wxStaticText(this, -1, "0.00");
//EEDxx 2.6
//	_st_Label7->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Value7->SetBackgroundColour(*wxLIGHT_GREY);
	_st_Label8 = new wxStaticText(this, -1, marDict.GetString(415) );//"Average Diameter"
	_st_Value8 = new wxStaticText(this, -1, "0.00");
//EEDxx 2.6
//	_st_Label8->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_Value8->SetBackgroundColour(*wxLIGHT_GREY);

	_st_LabelRef101 = new wxStaticText(this, -1, marDict.GetString(385) );//"Seg. Length"
	_st_ValueRef101 = new wxStaticText(this, -1, "--");
//EEDxx 2.6
//	_st_LabelRef101->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_ValueRef101->SetBackgroundColour(*wxLIGHT_GREY);
	_st_LabelRef102 = new wxStaticText(this, -1, marDict.GetString(395) );//"Ref. Area"
	_st_ValueRef102 = new wxStaticText(this, -1, "--");
//EEDxx 2.6
//	_st_LabelRef102->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_ValueRef102->SetBackgroundColour(*wxLIGHT_GREY);
	_st_LabelRef103 = new wxStaticText(this, -1, marDict.GetString(420) );//"Ref. Average Diam."
	_st_ValueRef103 = new wxStaticText(this, -1, "--");
//EEDxx 2.6
//	_st_LabelRef103->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_ValueRef103->SetBackgroundColour(*wxLIGHT_GREY);

	_pl_cntlHealthySick2 = new wxPanelControlsHealthySickSliceCT(panel_right_down,this);

//EEDxx 2.6
//    panel_left->SetBackgroundColour(*wxLIGHT_GREY);
//	panel_right_up->SetBackgroundColour(*wxLIGHT_GREY);
//	panel_right_down->SetBackgroundColour(*wxLIGHT_GREY);
//	panel_splitter_right->SetBackgroundColour(*wxLIGHT_GREY);
//	panel_splitter->SetBackgroundColour(*wxLIGHT_GREY);
 
}
*/
//--------------------------------------------------------
/*
void wxQuantificationWidgetCT::Do_layout()
{
	
	//Do the layout:
	
	wxBoxSizer			*sizer_principal	= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*status				= new wxBoxSizer(wxHORIZONTAL);
	
// EED 25 sep 2006
//	wxFlexGridSizer		*medium_right_up	= new wxFlexGridSizer(1,0);
//	wxFlexGridSizer		*medium_right_down	= new wxFlexGridSizer(1,0);
	wxBoxSizer		    *medium_right_up	= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer		    *medium_right_down	= new wxBoxSizer(wxVERTICAL);

	//MIS TESTS
//	wxFlexGridSizer		*right_up_div		= new wxFlexGridSizer(1,0);

// EED 25 sep 2006
	wxBoxSizer		    *right_up_div		= new wxBoxSizer(wxVERTICAL);


	wxBoxSizer			*medium_left		= new wxBoxSizer(wxVERTICAL);


	wxStaticBoxSizer	*axe				= new wxStaticBoxSizer(new wxStaticBox(this, -1, ""), wxVERTICAL);


//	wxFlexGridSizer		*axe1				= new wxFlexGridSizer(10,0);
	wxBoxSizer			*axe1				= new wxBoxSizer(wxHORIZONTAL);

	wxBoxSizer			*axe2				= new wxBoxSizer(wxHORIZONTAL);
	wxFlexGridSizer		*axe3				= new wxFlexGridSizer(10,0);
	wxFlexGridSizer		*axe4				= new wxFlexGridSizer(10,0);
	wxBoxSizer			*axe5				= new wxBoxSizer(wxHORIZONTAL);
	wxFlexGridSizer		*axe6				= new wxFlexGridSizer(10,0);
	wxFlexGridSizer		*axe7				= new wxFlexGridSizer(10,0);
	wxFlexGridSizer		*axe8				= new wxFlexGridSizer(10,0);
	
	wxBoxSizer			*status0			= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*status1			= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*status2			= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*status3			= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*status6			= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*status7			= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*status8			= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*status9			= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*statusRef1			= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*statusRef2			= new wxBoxSizer(wxVERTICAL);
	wxBoxSizer			*statusRef3			= new wxBoxSizer(wxVERTICAL);
	

	axe1->Add(_st_Slice					, 10, wxALL|wxEXPAND, 0);
	axe1->Add(_sl_Slice					, 10, wxALL|wxEXPAND, 0);
	axe1->Add(_txt_Position				, 10, wxALL|wxEXPAND, 0);

	axe2->Add(_cb_HealthySlice			, 10, wxALL|wxEXPAND, 0);
	axe2->Add(_cb_Perpendicular			, 10, wxALL|wxEXPAND, 0);
	axe2->Add(_cb_VisibleRings			, 10, wxALL|wxEXPAND, 0);
	axe2->Add(_cb_ShowSurface			, 10, wxALL|wxEXPAND, 0);

	axe3->Add(_st_Opacity				,  1, wxALL|wxEXPAND, 0);
	axe3->Add(_sl_Opacity				, 10, wxALL|wxEXPAND, 0);
	axe3->Add(_rb_GreyScale				, 10, wxALL|wxEXPAND, 0);
	axe3->Add(_rb_Color					, 10, wxALL|wxEXPAND, 0);

	axe4->Add(_st_Isovalue				,  1, wxALL|wxEXPAND, 0);
	axe4->Add(_sl_Isovalue				,  1, wxALL|wxEXPAND, 0);

	axe5->Add(_bt_AddContour3D			,  1				);
	axe5->Add(_bt_CleanContour3D		,  1				);
	axe5->Add(_bt_CleanAllContours3D	,  1				);



	status1->Add(_st_Label1, 1, wxALL|wxALIGN_CENTER, 5);
	status1->Add(_st_Value1, 1, wxALL|wxALIGN_CENTER, 5);
	status2->Add(_st_Label2, 1, wxALL|wxALIGN_CENTER, 5);
	status2->Add(_st_Value2, 1, wxALL|wxALIGN_CENTER, 5);
	status3->Add(_st_Label3, 1, wxALL|wxALIGN_CENTER, 5);
	status3->Add(_st_Value3, 1, wxALL|wxALIGN_CENTER, 5);

	status6->Add(_st_Label6, 1, wxALL|wxALIGN_CENTER, 5);
	status6->Add(_st_Value6, 1, wxALL|wxALIGN_CENTER, 5);
	status7->Add(_st_Label7, 1, wxALL|wxALIGN_CENTER, 5);
	status7->Add(_st_Value7, 1, wxALL|wxALIGN_CENTER, 5);
	status8->Add(_st_Label8, 1, wxALL|wxALIGN_CENTER, 5);
	status8->Add(_st_Value8, 1, wxALL|wxALIGN_CENTER, 5);

	
	statusRef1->Add(_st_LabelRef101, 1, wxALL|wxALIGN_CENTER, 5);
	statusRef1->Add(_st_ValueRef101, 1, wxALL|wxALIGN_CENTER, 5);
	statusRef2->Add(_st_LabelRef102, 1, wxALL|wxALIGN_CENTER, 5);
	statusRef2->Add(_st_ValueRef102, 1, wxALL|wxALIGN_CENTER, 5);
	statusRef3->Add(_st_LabelRef103, 1, wxALL|wxALIGN_CENTER, 5);
	statusRef3->Add(_st_ValueRef103, 1, wxALL|wxALIGN_CENTER, 5);



	status->Add(status1		, 1, wxALL|wxEXPAND, 0);
	status->Add(statusRef1	, 1, wxALL|wxEXPAND, 0);
	status->Add(status2		, 1, wxALL|wxEXPAND, 0);
	status->Add(statusRef2	, 1, wxALL|wxEXPAND, 0);
	status->Add(status3		, 1, wxALL|wxEXPAND, 0);

	status->Add(status6		, 1, wxALL|wxEXPAND, 0);
	status->Add(status7		, 1, wxALL|wxEXPAND, 0);
	status->Add(status8		, 1, wxALL|wxEXPAND, 0);
	status->Add(statusRef3	, 1, wxALL|wxEXPAND, 0);

	
	axe->Add(axe1, 2, wxALL|wxEXPAND, 0);
	axe->Add(axe2, 2, wxALL|wxEXPAND, 0);   //wxALIGN_CENTER_HORIZONTAL
	axe->Add(axe3, 2, wxALL|wxEXPAND, 0);
	axe->Add(axe4, 2, wxALL|wxEXPAND, 0);
	axe->Add(axe6, 2, wxALL|wxEXPAND, 0);
	axe->Add(axe7, 2, wxALL|wxEXPAND, 0);
	axe->Add(axe8, 2, wxALL|wxEXPAND, 0);
	axe->Add(axe5, 2);
	

//	right_up_div->Add(_2DWorld, 1, wxALL|wxEXPAND, 5);
	right_up_div->Add(panel_rightm_up, 1, wxALL|wxEXPAND, 5);
	medium_left->Add(_3DWorld					, 1, wxEXPAND, 0);
	medium_left->Add(axe						, 0, wxALL|wxEXPAND, 0);
	medium_right_up->Add( right_up_div	, 1, wxALL|wxEXPAND, 5);
//	medium_right_up->Add(		, 2, wxALL|wxEXPAND, 5);
	medium_right_down->Add(_pl_cntlHealthySick2	, 1, wxALL, 5);
	medium_right_down->Add(_wxStenosisPanel		, 1, wxALL, 5);


	
	
	panel_left->SetAutoLayout(true);
	panel_left->SetSizer(medium_left);
	panel_left->Layout();

	panel_right_up->SetAutoLayout(true);
	panel_right_up->SetSizer(medium_right_up);
	panel_right_up->Layout();

	panel_right_down->SetAutoLayout(true);
	panel_right_down->SetSizer(medium_right_down);
	panel_right_down->Layout();

    panel_splitter_right->SetMinimumPaneSize( 50 );
    panel_splitter_right->SplitHorizontally( panel_right_up, panel_right_down, 400 );



    panel_splitter->SetMinimumPaneSize( 50 );
    panel_splitter->SplitVertically( panel_left, panel_splitter_right, 420 );

	
	sizer_principal->Add(panel_splitter, 1, wxALL|wxEXPAND, 0);
	sizer_principal->Add(status, 0, wxALL|wxEXPAND, 0);
	
	this->SetAutoLayout(true);
	this->SetSizer(sizer_principal);
	this->Layout();

//EEDxx2.4
//	FitInside();
}

*/

//--------------------------------------------------------
void wxQuantificationWidgetCT::Set_Data( )
{
	_axis_index				= -1;
	_given_points			= 0;
	_nClicks				= 0;
	_quantifing				= 0;
	

	
	_shown					= 0;
	_quant_shown			= 0;
	
	_actual_area			= 0.00;
	_actual_peri			= 0.00;
	_actual_darea			= 0.00;
	_actual_dperi			= 0.00;
	_actual_dmax			= 0.00;
	_actual_dmin			= 0.00;
	_actual_davg			= 0.00;
	_actual_sten			= 0.00;
	_actual_partial			= 0.00;
	

}




//--------------------------------------------------------
void wxQuantificationWidgetCT::Forget( )
{
	_shown = false;
}

// ----------------------------------------------------------------------------
void wxQuantificationWidgetCT::ShowMARACASData( marInterfaceCT* mar )
{
	double        min, max;
	vtkImageData* imagedata;
	int nos;
	int actualQuant=-1;
	
	wxBusyCursor wait;
	_mar = mar;
	
	_mar->prepareQuantification();
	nos = _mar->getNumberOfSlices();

	//MAZV se a�ade para manejo de contornos manuales
	for (int i = 0; i < nos; i++)
	{
		_manContours.push_back(NULL);
	}


	actualQuant = (int) (nos-1)/2 ;
	imagedata = _mar->getSliceImage(actualQuant);
	
	_mar->setActualQuant( actualQuant ) ;
	_mar->getMinMax(min, max);
	
	
	_3DWorld->ShowMARACASDataAndAxeCT( mar );
	_3DWorld->InitCameraReset( );
//	_2DWorld->ConstructVTK( imagedata );
	

	ConfigureVTK( new marImageData(imagedata) );
	
	// GUI
	_sl_Isovalue->SetRange( (int)min, (int)max);
	_sl_Isovalue->SetValue( (int)(max/4) );
	_sl_Opacity->SetValue( 50 );
	Reset_sl_Slider();

// EED 02Dic2006
//	int ww1,hh1;
//	int ww2,hh2;
//	int wwT,hhT;
//	int ss;
//	this->GetSize(&wwT,&hhT);
//	_wxStenosisPanel->GetSize(&ww1,&hh1);
//	_pl_cntlHealthySick2->GetSize(&ww2,&hh2);

//	ss=hhT-(hh1+hh2+85);

//	panel_splitter_right->SetSashPosition(ss,true);

	_splitPanelPrincipal	-> SetSashPosition(600,true);
	_splitpanel_left		-> SetSashPosition(360,true);
	_splitpanel_right		-> SetSashPosition(200,true);
	_splitpanel_right_down	-> SetSashPosition(230,true);
}
//----------------------------------------------------------------------------
void wxQuantificationWidgetCT::Reset_sl_Slider()
{
	int nos = _mar->getNumberOfSlices();
	
	_sl_Slice->SetRange(0, nos-1);
	_sl_Slice->SetValue( (nos-1)/2 );

}
//----------------------------------------------------------------------------
void wxQuantificationWidgetCT::SetSlider_Isovalue_Opacity(int isovalue,int opacity){
	_sl_Isovalue->SetValue(isovalue);
	_sl_Opacity->SetValue(opacity);
	_3DWorld->SetSurfaceIsoValue( isovalue );
	_3DWorld->SetSurfaceOpacity( opacity );
}
//----------------------------------------------------------------------------
void wxQuantificationWidgetCT::OnShowSurface_CB(wxCommandEvent& event)
{
    _3DWorld->SetSurfaceVisibility( _cb_ShowSurface->GetValue() );
}
// ---------------------------------------------------------------------------
void wxQuantificationWidgetCT::ResetAxis(){	
	Reset_sl_Slider();
	_mar->setActualQuant( _sl_Slice->GetValue() );

	_3DWorld->Hide3DHealthySliceActor();
	_mar->setHealthySlice( 0,-1,0 );
	_mar->setActualQuant( _sl_Slice->GetValue() );

}
// ---------------------------------------------------------------------------
void wxQuantificationWidgetCT::RefreshAxis( ){	
	int actualQuant = _mar->getActualQuant();
	vtkImageData* imagedata;
	vtkProbeFilter* image3D;
	vtkPolyData* vtkPolydata_2Dcontour;

// EED 26 sep 2006
//	vtkPoints* vtkPoints_2DDiameterMin;
//	vtkPoints* vtkPoints_2DDiameterMax;

	int contours = _mar->getNumberOfContours(actualQuant);

	image3D					= _mar->get3DSlice			( actualQuant );
	imagedata				= _mar->getSliceImage		( actualQuant );

	
	_contourViewer->DeleteContours();
	_lineViewer->DeleteLines();
	_pointViewer->DeletePoints();
	


	
	_pointViewer->CreateNewPoint(64,64,0);
	for (int i = 0; i < contours; i++)
	{
		;
		vtkPolydata_2Dcontour	= _mar->get2Dcontour( actualQuant, i );
		
//		vtkPoints_2DDiameterMin = _mar->get2DDiameterMin	( actualQuant, 0 );
//		vtkPoints_2DDiameterMax = _mar->get2DDiameterMax	( actualQuant, 0 );

		if (_cb_VisibleRings->GetValue()==true){
//			_2DWorld->SetContour( vtkPolydata_2Dcontour );
			_contourViewer->CreateNewContour(vtkPolydata_2Dcontour,  _mar->getContourType(actualQuant, i));
//			_2DWorld->SetDiameterMin( vtkPoints_2DDiameterMin , true );
//			_2DWorld->SetDiameterMax( vtkPoints_2DDiameterMax , true );
		}
	}

	int puntos = _mar->getPointSize();

	for (int j = 0; j < puntos; j++)
	{
		marPoint *p = _mar->getPoint(j);
		_pointViewer->CreateNewPoint(p->getX(),p->getY(),p->getType());
	}
	

	_3DWorld->SetImage(image3D);
	_3DWorld->Render( );
//	_2DWorld->SetImage(imagedata);
	
	RefreshView( new marImageData(imagedata) );

	

	
	showVariables( );




}


// ----------------------------------------------------------------------------
void wxQuantificationWidgetCT::MoveSlider(int actualQuant){

	if (actualQuant!=_bak_ActualSlice2)
	{
	   _bak_ActualSlice2=actualQuant;
		if (_bak_ActualSlice!=-1){
			SetManualContour_ReplaceContour();
			SetManualContour_2DWorld(false);
		}
		_mar->setActualQuant( actualQuant );
		RefreshAxis();

// EED 17 NOV 2006
		double *p;
		p = _mar->GetExperiment()->getAxis()->getPoints( actualQuant );
		double spc[3];
		_mar->getDynData()->GetMarImageData()->GetImageData()->GetSpacing(spc);
		int nX=0,nY=0,nZ=0;
		nX = _mar->getDynData()->GetMarImageData()->GetXOriginal( (int)(p[0]/spc[0]) );
		nY = _mar->getDynData()->GetMarImageData()->GetYOriginal( (int)(p[1]/spc[1]) );
		nZ = _mar->getDynData()->GetMarImageData()->GetZOriginal( (int)(p[2]/spc[2]) );
		char resultText[50],temp[50];
		strcpy(resultText," \n        (");

//		ltoa ((int)nX,temp,10);
		sprintf(temp,"%d",(int)nX);

		strcat(resultText,temp);
		strcat(resultText,",");

//		ltoa ((int)nY,temp,10);
		sprintf(temp,"%d",(int)nY);

		strcat(resultText,temp);
		strcat(resultText,",");

//		ltoa ((int)nZ,temp,10);
		sprintf(temp,"%d",(int)nZ);

		strcat(resultText,temp);
		strcat(resultText,")");
		_txt_Position->SetLabel( wxString(resultText, wxConvUTF8) );
	} // 
}
// ----------------------------------------------------------------------------
void wxQuantificationWidgetCT::OnSliderSliceScroll(wxScrollEvent& event){
	MoveSlider( event.GetPosition() );
}

// ----------------------------------------------------------------------------
double wxQuantificationWidgetCT::GetStenosisDiameter(int sickSlice){
	double healthyAverageDiameter = _mar->getReferenceAverDiam() ;
	marContour *marcontourSick = _mar->getContour( sickSlice, sickSlice );
	return doubleStenosis( healthyAverageDiameter , marcontourSick->getMinimumDiameter() );
}
// ----------------------------------------------------------------------------
double wxQuantificationWidgetCT::GetStenosisArea( int sickSlice){
	double healthyArea = _mar->getReferenceArea();
	marContour *marcontourSick = _mar->getContour( sickSlice, sickSlice );
	return doubleStenosis( healthyArea , marcontourSick->getArea() );
}
// ----------------------------------------------------------------------------






// ----------------------------------------------------------------------------
void wxQuantificationWidgetCT::showVariables()
{
// EED 26 sep 2006
//	marContour* marcontour;

	int actualQuant;
	int healthySlice; 
	int healthySliceStart; 
	int healthySliceEnd; 
	
	actualQuant = _mar->getActualQuant( );
//	marcontour=_mar->getContour( actualQuant, actualQuant );
	
	wxString tmpString;

	tmpString.Printf( _T("%.2f mm")   , 20)/*_mar->getTotalLength() )*/;		 _st_Value1->SetLabel(tmpString);


	tmpString.Printf( _T("%.2f mm^2") , 20)/*marcontour->getArea())*/;						 _st_Value2->SetLabel(tmpString);
	tmpString.Printf( _T("%.2f mm")   , 20)/*marcontour->getPerimeter())*/;				 _st_Value3->SetLabel(tmpString);

	tmpString.Printf( _T("%.2f mm")   , 20)/*marcontour->getMinimumDiameter())*/;			 _st_Value6->SetLabel(tmpString);
	tmpString.Printf( _T("%.2f mm")   , 20)/*marcontour->getMaximumDiameter())*/;			 _st_Value7->SetLabel(tmpString);
	tmpString.Printf( _T("%.2f mm")   , 20)/*marcontour->getAverageDiameter())*/;			 _st_Value8->SetLabel(tmpString);

	healthySlice		= _mar->getHealthySlice( );
	healthySliceStart	= _mar->getHealthySliceStart( );
	healthySliceEnd		= _mar->getHealthySliceEnd( );
	if ( (healthySlice!=-1) ) {
		_st_Value100->SetLabel( strStenosis( GetStenosisArea(actualQuant)     ) );
		_st_Value101->SetLabel( strStenosis( GetStenosisDiameter(actualQuant) ) );
		tmpString.Printf( _T("%.2f mm^2") , _mar->getReferenceArea() );	 _st_ValueRef102->SetLabel(tmpString);
		tmpString.Printf( _T("%.2f mm")   , _mar->getReferenceAverDiam() ); _st_ValueRef103->SetLabel(tmpString);
		//CAMBIAR ESTOS DOS
	} else {
		_st_Value100->SetLabel(_T("--"));
		_st_Value101->SetLabel(_T("--"));
		_st_ValueRef101->SetLabel(_T("--"));
		_st_ValueRef102->SetLabel(_T("--"));
		_st_ValueRef103->SetLabel(_T("--"));
	}

	int startSlice	= _mar->getQuantStart();
	int finishSlice	= _mar->getQuantFinish();
    if ((startSlice!=-1) && (finishSlice!=-1)){
		tmpString.Printf( _T("%.2f mm")   , _mar->getSubAxisLength() );	 _st_ValueRef101->SetLabel(tmpString);
	} else {
		_st_ValueRef101->SetLabel(_T("--"));
	}

}
// ----------------------------------------------------------------------------
double wxQuantificationWidgetCT::doubleStenosis(double healthy, double sick){
	double result;
	if (healthy==0) {	
		result=-1;	
	} else {  
		result = (    (healthy-sick)/healthy) * 100 ; 	
	}

	return result;
}
// ----------------------------------------------------------------------------
wxString wxQuantificationWidgetCT::strStenosis(double stenosis){
	wxString tmpString;
	if (stenosis==-1) {
		tmpString.Printf(_T("%d"),-1);	
	} else {
		tmpString.Printf(_T("%.2f"), stenosis );	
	}
	return tmpString + _T(" \%");
}
// ----------------------------------------------------------------------------
void wxQuantificationWidgetCT::OnSliderIsovalueScroll(wxScrollEvent& event)
{
	wxBusyCursor wait;
	_3DWorld->SetSurfaceIsoValue( event.GetPosition() );
}
// ----------------------------------------------------------------------------
void wxQuantificationWidgetCT::OnSliderOpacityScroll(wxScrollEvent& event)
{
	_3DWorld->SetSurfaceOpacity( event.GetPosition() );
}
//----------------------------------------------------------------------------
void wxQuantificationWidgetCT::AddAxisActors(){

	marAxis *maraxis = _mar->getAxis( );
	if (maraxis!=NULL) _3DWorld->SetAxis( maraxis->Draw( ) );

}
//----------------------------------------------------------------------------
void wxQuantificationWidgetCT::Clean3D( bool eraseAxe )
{
	_first_quant = -1;
	_last_quant = -1;

	_quant_shown = false;
	
	_3DWorld->InitListContourActor( -1,_mar->getNumberOfSlices() );
	if (eraseAxe==true) { _3DWorld->RemoveAxis(); }


	

}

void wxQuantificationWidgetCT::Reload_Axis(bool mask , bool step )
{

}


void wxQuantificationWidgetCT::Show_Max_Min_Diameters()
{

}



int wxQuantificationWidgetCT::Back( )
{
	int ret;
	
	ret = _shown;
	_shown = 0;
	return ret;
}


void wxQuantificationWidgetCT::Set_plane_3D( double  x, double y )
{

}





void  wxQuantificationWidgetCT::Point_Intensity(double x, double y)
{

}


void wxQuantificationWidgetCT::CleanContour()
{

}


//-----------------------------------------------------------------
// Button
void wxQuantificationWidgetCT::Do_Quant()
{

}


//-----------------------------------------------------------------
void wxQuantificationWidgetCT::OnContour_BT(wxCommandEvent& event){
	int slice=_sl_Slice->GetValue();
    _3DWorld->Set3DContourActor( slice , _mar->get3Dcontour(slice, slice) , _cb_VisibleRings->GetValue() ,0 );
}
//-----------------------------------------------------------------
void wxQuantificationWidgetCT::OnClean_BT(wxCommandEvent& event){
	int slice=_sl_Slice->GetValue();
	_3DWorld->Erase3DContourActor( slice );
}

//-----------------------------------------------------------------
void wxQuantificationWidgetCT::OnCleanAll_BT(wxCommandEvent& event){
	marDictionary marDict;
	char tmp[256];

	wxMessageDialog *wxdiag;
	strcpy( tmp , marDict.GetString(870) ); strcat(tmp,"\n"); strcat(tmp,marDict.GetString(875));
	wxdiag= new wxMessageDialog(this, wxString(tmp, wxConvUTF8), wxString(marDict.GetString(865), wxConvUTF8) , wxOK | wxCANCEL);//"This option erase all 3D contours.\n Do you want to continue?","Alert"
    if ( wxdiag->ShowModal() == wxID_OK ) {
		_3DWorld->InitListContourActor( 0, _mar->getNumberOfSlices() );
	}            
	wxdiag->Destroy();
}





//------------------------------------------------------------------------
void wxQuantificationWidgetCT::DetectHealthySickSlice( bool minSurf , bool maxSurf ){	

	//ESTE ES EL METODO QUE SE MODIFICA PARA CALCULAR LA ESTENOSIS 
	/*
	wxBusyCursor wait;
	double		stenosis;
	double		areaB;
	int			iSlice;
	int			startslice;
	int			endslice;
	double		maxStenosis			=	-9999999;
	double		maxArea				=	-9999999;
	int			sickSlice			=	0;
	int			healthySlice		=	0;
	int			sizeHealthyRegion	=	GetSizeHealthyRegion();
	int			analysisTypeStenosis=	GetAnalysisTypeStenosis();






	GetSliceLimites(0,startslice,endslice);

    if (startslice>endslice){
		int temp=endslice;
		endslice=startslice;
		startslice=temp;
	}

	int backSlice;
	if (minSurf==false) { backSlice = _sl_Slice->GetValue(); }

	for (iSlice=startslice; iSlice<=endslice;iSlice++){

		if (minSurf==true){
			// this is equal to the minimum surface/diameter
			if (analysisTypeStenosis==1 ){ stenosis = GetStenosisDiameter(iSlice);	}
			if (analysisTypeStenosis==2 ){ stenosis = GetStenosisArea(iSlice);		}
		}

		if (maxSurf==true){
			areaB = _mar->getAverageArea(iSlice-sizeHealthyRegion,iSlice+sizeHealthyRegion);
			_3DWorld->InitListContourActor( 0, _mar->getNumberOfSlices() );

		}

		if ((stenosis>maxStenosis) &&(minSurf==true)){
			maxStenosis=stenosis;
			sickSlice=iSlice;
		}
		if ((areaB>maxArea) && (maxSurf==true)){
			maxArea=areaB;
			healthySlice=iSlice;
		}
		MoveSlider( iSlice );
		_sl_Slice->SetValue( iSlice );
	}



	if (minSurf==true){
		MoveSlider( sickSlice );
		_sl_Slice->SetValue( sickSlice );
	}

	if (maxSurf==true){
		MoveSlider( healthySlice );
		_sl_Slice->SetValue( healthySlice );
	}
*/
}




//------------------------------------------------------------------------
int wxQuantificationWidgetCT::GetHealthySlice(){
	return _mar->getHealthySlice( );
}
//------------------------------------------------------------------------
void wxQuantificationWidgetCT::SetHealthySlice(int healthySlice){	
	if (healthySlice==-1) {
		healthySlice=_sl_Slice->GetValue();
	}
	/*int sizeHealthyRegion	= GetSizeHealthyRegion();
	int maxSlider			= GetMaxActualSlice();
	int healthySliceStart	= healthySlice - sizeHealthyRegion;
	int healthySliceEnd		= healthySlice + sizeHealthyRegion;
	if (healthySliceStart < 0)         { healthySliceStart = 0;			}
	if (healthySliceEnd   < 0)         { healthySliceEnd   = 0;			}
	if (healthySliceStart > maxSlider) { healthySliceStart = maxSlider; }
	if (healthySliceEnd   > maxSlider) { healthySliceEnd   = maxSlider; }
	_mar->setHealthySlice( healthySliceStart, healthySlice , healthySliceEnd);

	_3DWorld->Set3DHealthySliceActor(  );
	_3DWorld->Show3DHealthySliceActor();
	_cb_HealthySlice->SetValue(true);
	_3DWorld->InitListContourActor( 1, _mar->getNumberOfSlices() );
	int iHealthySlice;
	for ( iHealthySlice=healthySliceStart ; iHealthySlice<=healthySliceEnd ; iHealthySlice++){
		_3DWorld->Set3DContourActor( iHealthySlice , _mar->get3Dcontour(iHealthySlice, iHealthySlice) , true ,1);
	}
	showVariables();*/
}





//--------------------------------------------------------------------
// CheckBox
void wxQuantificationWidgetCT::OnHealthySlice_CB(wxCommandEvent& event)
{


	int healthySlice = _mar->getHealthySlice( );
	if (healthySlice!=-1) {
		if ( _cb_HealthySlice->GetValue() )
			_3DWorld->Show3DHealthySliceActor();
		else
			_3DWorld->Hide3DHealthySliceActor();
	}
}


//--------------------------------------------------------------------
void wxQuantificationWidgetCT::OnVisibleRing_CB(wxCommandEvent& event){
	if ( _cb_VisibleRings->GetValue() ){
		_3DWorld->Show3DContourActor();
//		_2DWorld->Show2DContourDiameters();
		RefreshAxis();
	} else {
		_3DWorld->Hide3DContourActor();
//		_2DWorld->Hide2DContourDiameters();
	}


}
//--------------------------------------------------------------------
void wxQuantificationWidgetCT::OnPerpendicular_CB(wxCommandEvent& event)
{
	if ( _cb_Perpendicular->GetValue() )
		_3DWorld->Show3DSliceActor();
	else
		_3DWorld->Hide3DSliceActor();
}
//--------------------------------------------------------------------
// RadioButton
void wxQuantificationWidgetCT::OnGreyScale_RB(wxCommandEvent& event){
	if ( _rb_GreyScale->GetValue() ){
		_3DWorld->SetBWLookUp();
	}
}
//--------------------------------------------------------------------
void wxQuantificationWidgetCT::OnColor_RB(wxCommandEvent& event){
	if ( _rb_Color->GetValue() ){
		_3DWorld->SetColorLookUp();
	}
}
//--------------------------------------------------------------------
void wxQuantificationWidgetCT::CallBackOnLeftDClick( wxMouseEvent& event ){

	double pp[3], cp[3];
	_3DWorld->GetLast3DClickPoint(pp,cp);

	int i,iback,maxPoints;
	double *c, cc[3];
	double dist,distMin=-1;
	iback=-1;
	
    marAxis *maraxis = _mar->getAxis( );
	maxPoints = maraxis->getNumberOfSplinePoints();
	for ( i=0 ; i<maxPoints ; i++ ){
		c = maraxis->getSplinePoint(i); 
		cc[0]=c[0]-pp[0];
		cc[1]=c[1]-pp[1];
		cc[2]=c[2]-pp[2];
		dist=sqrt( cc[0]*cc[0] + cc[1]*cc[1] + cc[2]*cc[2] );
		if ((distMin==-1) || (dist<distMin)) {
			iback=i;
			distMin=dist;
		}
	}
	_sl_Slice->SetValue(iback);
	MoveSlider(iback);

}

//--------------------------------------------------------------------
void wxQuantificationWidgetCT::CallBackOnMouseWheel( wxMouseEvent& event ){
	int slice=_sl_Slice->GetValue();
	if (event.GetWheelRotation()>0){ slice++; }
	if (event.GetWheelRotation()<0){ slice--; }
    if (slice < _sl_Slice->GetMin() ) { slice=_sl_Slice->GetMin(); }
    if (slice > _sl_Slice->GetMax() ) { slice=_sl_Slice->GetMax(); }
    _sl_Slice->SetValue(slice);
	MoveSlider(slice);
}
//--------------------------------------------------------------------
int wxQuantificationWidgetCT::GetActualSlice(){
	return _sl_Slice->GetValue();
}
//--------------------------------------------------------------------
void wxQuantificationWidgetCT::SetActualSlice(int slice){
	_sl_Slice->SetValue(slice);
	MoveSlider(slice);
}
//--------------------------------------------------------------------
int wxQuantificationWidgetCT::GetMaxActualSlice(){
	return _sl_Slice->GetMax();
}
//--------------------------------------------------------------------
int  wxQuantificationWidgetCT::GetSizeHealthyRegion(){
	return _sizeHealthyRegion;
}
//--------------------------------------------------------------------
void wxQuantificationWidgetCT::SetSizeHealthyRegion(int size){
	_sizeHealthyRegion = size;
}
//--------------------------------------------------------------------
void wxQuantificationWidgetCT::GetHealthySliceRange(int &healthySliceStart,int &healthySliceEnd){
	healthySliceStart	= _mar->getHealthySliceStart( );
	healthySliceEnd		= _mar->getHealthySliceEnd( );
	
}
//--------------------------------------------------------------------
void wxQuantificationWidgetCT::Set3DRegionSliceActor( int type, int k1,int k2 ){
	_3DWorld->Set3DRegionSliceActor(type,k1,k2);
}
//--------------------------------------------------------------------
void wxQuantificationWidgetCT::Set3DStartRegionSliceActor( int type, int k){
//	_3DWorld->Set3DStartRegionSliceActor(type,k);
}
//--------------------------------------------------------------------
void wxQuantificationWidgetCT::Set3DEndRegionSliceActor( int type, int k){
//	_3DWorld->Set3DEndRegionSliceActor(type,k);
}
//--------------------------------------------------------------------
void wxQuantificationWidgetCT::Show3DRegionSliceActor( int type ){
	_3DWorld->Show3DRegionSliceActor(type);
}
//--------------------------------------------------------------------
void wxQuantificationWidgetCT::Show3DStartRegionSliceActor( int type ){
	_3DWorld->Show3DStartRegionSliceActor(type);
}
//--------------------------------------------------------------------
void wxQuantificationWidgetCT::Show3DEndRegionSliceActor( int type ){
	_3DWorld->Show3DEndRegionSliceActor(type);
}
//--------------------------------------------------------------------
void wxQuantificationWidgetCT::Hide3DRegionSliceActor( int type ){
	_3DWorld->Hide3DRegionSliceActor(type);
}
//--------------------------------------------------------------------
void wxQuantificationWidgetCT::Hide3DStartRegionSliceActor( int type ){
	_3DWorld->Hide3DStartRegionSliceActor(type);
}
//--------------------------------------------------------------------
void wxQuantificationWidgetCT::Hide3DEndRegionSliceActor( int type ){
	_3DWorld->Hide3DEndRegionSliceActor(type);
}
//--------------------------------------------------------------------
void wxQuantificationWidgetCT::GetSliceLimites(int type, int &sliceStart, int &sliceEnd){
	_3DWorld->GetSliceLimites(type,sliceStart,sliceEnd);
}
//--------------------------------------------------------------------
int wxQuantificationWidgetCT::GetAnalysisTypeStenosis(){
	return _3DWorld->GetAnalysisTypeStenosis();
}
//--------------------------------------------------------------------
void wxQuantificationWidgetCT::SetAnalysisTypeStenosis(int analysisTypeStenosis){
	_3DWorld->SetAnalysisTypeStenosis(analysisTypeStenosis);
}
//--------------------------------------------------------------------
void wxQuantificationWidgetCT::SetManualContour_2DWorld(bool ok){

	if (ok==false){ 
//		_2DWorld->SetState(1);
//		_2DWorld->EraseManualContour();
	}
	if (ok==true){  
	//	_2DWorld->SetState(2);
	//	_2DWorld->CreateNewManualContour();
	}

}
//--------------------------------------------------------------------
//TODO: SIM - MODIFICAR PARA VARIOS CONTORNOS
void wxQuantificationWidgetCT::SetManualContour_AddPoint_2DWorld(){
	_bak_ActualSlice	= _sl_Slice->GetValue();
//	_2DWorld->Hide2DContourDiameters();
	//ESTE NO EXISTE
	_mar->EraseContour(_bak_ActualSlice);
	
	_3DWorld->Erase3DContourActor( _bak_ActualSlice );

//	_2DWorld->SetStateManualContour(0);
}
//--------------------------------------------------------------------
void wxQuantificationWidgetCT::SetManualContour_InsertPoint_2DWorld(){
//	_2DWorld->SetStateManualContour(2);
}
//--------------------------------------------------------------------
void wxQuantificationWidgetCT::SetManualContour_ErasePoint_2DWorld(){
//	_2DWorld->SetStateManualContour(3);
}
//--------------------------------------------------------------------
void wxQuantificationWidgetCT::SetManualContour_MovePoint_2DWorld(){
//	_2DWorld->SetStateManualContour(4);
}
//--------------------------------------------------------------------
void wxQuantificationWidgetCT::SetManualContour_ReplaceContour(){
/*	if (_bak_ActualSlice!=-1){
		int size		= _2DWorld->GetNumberOfPointsSplineManualContour();
		double *vx		= _2DWorld->GetVectorPointsXManualContour();
		double *vy		= _2DWorld->GetVectorPointsYManualContour();
		
		_mar->replaceContour2D(_bak_ActualSlice,size,vx,vy);
		free(vx);
		free(vy);
		RefreshAxis();
		_bak_ActualSlice=-1;
	}*/
	//TODO El remplazo de contornos debe cambiar
}
//------------------------------------------------------------------------
kVolume* wxQuantificationWidgetCT::GetVolumeAxisExtended(int wz1,int wz2)
{
	// Create Volume
	vtkImageData *imagedata;
	imagedata=_mar->getSliceImage(wz1);
	int dims[3];
	imagedata->GetDimensions (dims);
	int wx=dims[0];
	int wy=dims[1];
	int wz	= wz2-wz1+1;
	kVolume *kvol =new kVolume( kVolume::USHORT, wx, wy, wz,1, 1, 1, malloc(sizeof(unsigned short)*wx*wy*wz ) );
	vtkImageData *vol = kvol->castVtk();

	// Fill Volume
	int i;
	for (i=wz1;i<=wz2;i++)
	{
		// GetImage
		imagedata=_mar->getSliceImage(i);

		// InsertImage
	     void *p_imagedata	= imagedata->GetScalarPointer(0,0,0);
		 void *p_vol		= vol->GetScalarPointer(0,0,i-wz1);
         memcpy( p_vol, p_imagedata , sizeof(unsigned short)*dims[0]*dims[1] );
	}
	return kvol;
}

//-------------------------------------------------------------------
wxWindow* wxQuantificationWidgetCT::CreateView2DPanel(wxWindow *parent)
{
	wxPanel		*panel	=	new wxPanel(parent,-1);
    wxBoxSizer	*sizer	=	new wxBoxSizer(wxVERTICAL);

	_imageviewer2D_1 = new wxVtk2DBaseView(panel);
	wxVTKRenderWindowInteractor *iren   = _imageviewer2D_1->GetWxVTKRenderWindowInteractor();
	sizer->Add(iren , 1, wxEXPAND, 0);


	panel->SetSizer(sizer);
	panel->SetAutoLayout(true);
	panel->SetSize(400,400);
	panel->Layout();
	return panel;
}

//------------------------------------------------------------------------
void wxQuantificationWidgetCT::Refresh()
{
	_imageviewer2D_1->Refresh();
}

//------------------------------------------------------------------------
void wxQuantificationWidgetCT::RefreshView(marImageData *marimagedata)
{
	vtkImageData *imagedata= marimagedata->GetImageData(); // t=0
	_imageviewer2D_1->SetActualSlice(0);
	imagedata->UpdateInformation();
	imagedata->SetUpdateExtent(imagedata->GetWholeExtent());
	imagedata->Update();
	_data = imagedata;
	
	_vtkbasedata_1->SetMarImageData(marimagedata);	
	_imageviewer2D_1->ResetView();

	int i;
	for (i = 0; i < _manContours.size(); i++)
	{
		if (_manContours[i] !=NULL)
		{
			_manContours[i]->clear();
		}
	}

	for (i = 0; i < _manContours.size(); i++)
	{
		if (_manContours[i] !=NULL)
		{
			_manContours[i]->refreshWall(_imageviewer2D_1);
			_manContours[i]->refreshLumen(_imageviewer2D_1);

			int j; 
			for (j = 0; j < _manContours[i]->getNumberOfCalcContours(); j++)
			{
				_manContours[i]->refreshCalc(j,_imageviewer2D_1);
			}

			for (j = 0; j < _manContours[i]->getNumberOfHypoContours(); j++)
			{
				_manContours[i]->refreshHypo(j,_imageviewer2D_1);
				
			}

			
		}
			
		

	}


	
		
/*	_mViewContourWall->ClearContour();
	_mViewContourLumen->ClearContour();
	
	delete _mViewContourWall;
	delete _manContourControlWall;
	delete _mContourModelWall;
	
	delete _mViewContourLumen;
	delete _manContourControlLumen;
	delete _mContourModelLumen;
*/
	CreateManualContours();

}

//------------------------------------------------------------------------
void wxQuantificationWidgetCT::ConfigureVTK(marImageData *marimagedata)
{
   wxBusyCursor wait;

	vtkImageData *imagedata=marimagedata->GetImageData(); // t=0
	imagedata->UpdateInformation();
	imagedata->SetUpdateExtent(imagedata->GetWholeExtent());
	imagedata->Update();
	_data = imagedata;
	_vtkbasedata_1 = new vtkBaseData();
	_vtkbasedata_1->SetMarImageData(marimagedata);	
	_imageviewer2D_1->SetVtkBaseData( _vtkbasedata_1 );
	_imageviewer2D_1->Configure();


	_contourViewer = new ContourView();
	_contourViewer->SetWxVtkBaseView(_imageviewer2D_1);
	_lineViewer = new LineView();
	_lineViewer->SetWxVtkBaseView(_imageviewer2D_1);
	_pointViewer = new PointView();
	_pointViewer->SetWxVtkBaseView(_imageviewer2D_1);
	CreateManualContours();
	Refresh();	
}

//------------------------------------------------------------------------
void wxQuantificationWidgetCT::OnContourWall()
{
	if (_manContours[_mar->getActualQuant()]->getWallController() == NULL)
	{
		_manContours[_mar->getActualQuant()]->createWallContour(_imageviewer2D_1);
		_imageviewer2D_1->GetInteractorStyleBaseView()->AddInteractorStyleMaracas( 
						_manContours[_mar->getActualQuant()]->getWallController() );
	}
	_manContours[_mar->getActualQuant()]->setWallActive();
	_manContours[_mar->getActualQuant()]->setWallVisibility(true);
}

//------------------------------------------------------------------------
void wxQuantificationWidgetCT::OnContourLumen()
{
	if (_manContours[_mar->getActualQuant()]->getLumenController() == NULL)
	{
		_manContours[_mar->getActualQuant()]->createLumenContour(_imageviewer2D_1);
		_imageviewer2D_1->GetInteractorStyleBaseView()->AddInteractorStyleMaracas( 
						_manContours[_mar->getActualQuant()]->getLumenController() );
	}
	_manContours[_mar->getActualQuant()]->setLumenActive();
}
//------------------------------------------------------------------------
void wxQuantificationWidgetCT::OnContourHypo()
{
	


	if (_manContours[_mar->getActualQuant()]->getNumberOfHypoContours() > 0)
	{

		int answer = wxMessageBox(_T("Create new hypodense contour? (answer no, will modify existing ones)"), 
						_T("Confirm"), wxYES_NO | wxCANCEL, this);

		if (answer == wxYES)
		{
			addManualContours(HYPODENSE);
			int tam = _manContours[_mar->getActualQuant()]->getNumberOfHypoContours() - 1;
			_manContours[_mar->getActualQuant()] -> setHypoContourActive(tam);

		}
		else if (answer == wxNO)
		{
			_manContours[_mar->getActualQuant()] ->setHypoActive();
		}
	}
	else
	{
		addManualContours(HYPODENSE);
		int tam = _manContours[_mar->getActualQuant()]->getNumberOfHypoContours() - 1;
		_manContours[_mar->getActualQuant()] -> setHypoContourActive(tam);
	}
	



}

//------------------------------------------------------------------------
void wxQuantificationWidgetCT::OnContourCalc()
{


	if (_manContours[_mar->getActualQuant()]->getNumberOfCalcContours() > 0)
	{

		int answer = wxMessageBox(_T("Create new calcification contour? (answer no, will modify existing ones)"), 
						_T("Confirm"), wxYES_NO | wxCANCEL, this);

		if (answer == wxYES)
		{
			addManualContours(CALCIFICATION);
			int tam = _manContours[_mar->getActualQuant()]->getNumberOfCalcContours() - 1;
			_manContours[_mar->getActualQuant()] -> setCalcContourActive(tam);

		}
		else if (answer == wxNO)
		{
			_manContours[_mar->getActualQuant()] ->setCalcActive();
		}
	}
	else
	{
		addManualContours(CALCIFICATION);
		int tam = _manContours[_mar->getActualQuant()]->getNumberOfCalcContours() - 1;
		_manContours[_mar->getActualQuant()] -> setCalcContourActive(tam);
	}

}



//------------------------------------------------------------------------
void wxQuantificationWidgetCT::OnReplaceContourWall()
{

	int size = _manContours[_mar->getActualQuant()]->getNumberOfWallContourPoints();
	double *vx = _manContours[_mar->getActualQuant()]->getXVectorWallPoints();
	double *vy = _manContours[_mar->getActualQuant()]->getYVectorWallPoints();


	_mar->cleanContours(WALL);
	_mar->replaceContour2D(size,vx,vy,WALL);
	_manContours[_mar->getActualQuant()]->clearWall();
	_manContours[_mar->getActualQuant()]->restartWallContour(_imageviewer2D_1);
	RefreshAxis();



}
//------------------------------------------------------------------------
void wxQuantificationWidgetCT::OnReplaceContourLumen()
{
	int size = _manContours[_mar->getActualQuant()]->getNumberOfLumenContourPoints();
	double *vx = _manContours[_mar->getActualQuant()]->getXVectorLumenPoints();
	double *vy = _manContours[_mar->getActualQuant()]->getYVectorLumenPoints();

	_mar->cleanContours(ELUMEN);
	_mar->replaceContour2D(size,vx,vy,ELUMEN);
	_manContours[_mar->getActualQuant()]->clearLumen();
	_manContours[_mar->getActualQuant()]->restartLumenContour(_imageviewer2D_1);
	RefreshAxis();

}
//------------------------------------------------------------------------
void wxQuantificationWidgetCT::OnReplaceContourCalc()
{
	int conts = _manContours[_mar->getActualQuant()]->getNumberOfCalcContours();

	_mar->cleanContours(CALCIFICATION);
	for (int i = 0; i < conts; i++)
	{
		int size = _manContours[_mar->getActualQuant()]->getNumberOfCalcContourPoints(i);
		double *vx = _manContours[_mar->getActualQuant()]->getXVectorCalcPoints(i);
		double *vy = _manContours[_mar->getActualQuant()]->getYVectorCalcPoints(i);
		_mar->replaceContour2D(size,vx,vy,CALCIFICATION);
	}
	_manContours[_mar->getActualQuant()]->clearCalc();
	_manContours[_mar->getActualQuant()]->restartCalcContours();
	RefreshAxis();
}

//------------------------------------------------------------------------
void wxQuantificationWidgetCT::OnReplaceContourHypo()
{
/*	int conts = _manContours[_mar->getActualQuant()]->getNumberOfHypoContours();

	_mar->cleanContours(HYPODENSE);
	for (int i = 0; i < conts; i++)
	{
		int size = _manContours[_mar->getActualQuant()]->getNumberOfHypoContourPoints(i);
		double *vx = _manContours[_mar->getActualQuant()]->getXVectorHypoPoints(i);
		double *vy = _manContours[_mar->getActualQuant()]->getYVectorHypoPoints(i);
	}

	_manContours[_mar->getActualQuant()]->clearHypo();
	_manContours[_mar->getActualQuant()]->restartHypoContours();
	RefreshAxis();*/
	performXOR();
}

//------------------------------------------------------------------------
void wxQuantificationWidgetCT::performXOR()
{
	if (_manContours [_mar->getActualQuant()]->getWallController() != NULL)
	{
		int size = _manContours[_mar->getActualQuant()]->getNumberOfWallContourPoints();
		double *vx = _manContours[_mar->getActualQuant()]->getXVectorWallPoints();
		double *vy = _manContours[_mar->getActualQuant()]->getYVectorWallPoints();	

		marIsocontour* m = _mar->loadMarIsocontour(size,vx,vy);
		std::vector<marIsocontour *> walls;

		walls.push_back(m);

		double intersection = _mar->performUnion(WALL,walls);
		double xor_ = _mar->performXOR(WALL,walls);
		
		xor_ = xor_ / intersection;
		wxLogMessage(wxString("Indice XOR (pared): %f", wxConvUTF8), xor_*100);

		double and_ = _mar->performAND(WALL,walls);
		and_ = and_/ intersection;
		
		
		wxLogMessage(wxString("Indice AND (pared): %f", wxConvUTF8), and_*100);

		
		wxLogMessage(wxString("Indice Uni�n (pared): %f", wxConvUTF8), intersection);

		double razon = 0;


		if (and_ == 0)
		{
			razon = -1;
		}
		else
		{
			razon = xor_ / and_;
		}

		wxLogMessage(wxString("Raz�n (pared): %f", wxConvUTF8), razon);
	}
		else
	{
		wxLogMessage(wxString("SIN INFORMACION PARED", wxConvUTF8));
	}	

	//LUMEN

	if (_manContours [_mar->getActualQuant()]->getLumenController() != NULL)
	{
		int size = _manContours[_mar->getActualQuant()]->getNumberOfLumenContourPoints();
		double* vx = _manContours[_mar->getActualQuant()]->getXVectorLumenPoints();
		double* vy = _manContours[_mar->getActualQuant()]->getYVectorLumenPoints();
		marIsocontour* m = _mar->loadMarIsocontour(size,vx,vy);
		std::vector<marIsocontour *> lumen;


		lumen.push_back(m);
		double intersection = _mar->performUnion(ELUMEN,lumen);
		double xor_ = _mar->performXOR(ELUMEN,lumen);
		xor_ = xor_ / intersection;
		wxLogMessage(wxString("Indice OR (lumen): %f", wxConvUTF8), xor_*100);

		double and_ = _mar->performAND(ELUMEN,lumen);
		and_ = and_/ intersection;
		wxLogMessage(wxString("Indice AND (lumen): %f", wxConvUTF8), and_*100);

		
		wxLogMessage(wxString("Indice Uni�n (pared): %f", wxConvUTF8), intersection);

		double razon = 0;

		if (and_ == 0)
		{
			razon = -1;
		}
		else
		{
			razon = xor_ / and_;
		}
		wxLogMessage(wxString("Raz�n (lumen): %f", wxConvUTF8), razon);
	}
	else
	{
		wxLogMessage(wxString("SIN INFORMACION LUMEN", wxConvUTF8));
	}
	

	

	//CALC
	int conts = _manContours[_mar->getActualQuant()]->getNumberOfCalcContours();

	std::vector<marIsocontour *> calc;
	for (int i = 0; i < conts; i++)
	{
		int size = _manContours[_mar->getActualQuant()]->getNumberOfCalcContourPoints(i);
		double* vx = _manContours[_mar->getActualQuant()]->getXVectorCalcPoints(i);
		double* vy = _manContours[_mar->getActualQuant()]->getYVectorCalcPoints(i);
		marIsocontour* m = _mar->loadMarIsocontour(size,vx,vy);
		calc.push_back(m);
	}

	if (conts > 0)
	{
		double intersection = _mar->performUnion(CALCIFICATION,calc);
		double xor_ = _mar->performXOR(CALCIFICATION,calc);
		xor_ = xor_ /intersection;

		wxLogMessage(wxString("Indice OR (calc): %f", wxConvUTF8), xor_*100);

		double and_ = _mar->performAND(CALCIFICATION,calc);
		and_ = and_ / intersection;
		wxLogMessage(wxString("Indice AND (calc): %f", wxConvUTF8), and_*100);

		
		wxLogMessage(wxString("Indice Uni�n (pared): %f", wxConvUTF8), intersection);

		double razon = 0;

		if (and_ == 0)
		{
			razon = -1;
		}
		else
		{
			razon = xor_ / and_;
		}

		wxLogMessage(wxString("Raz�n (calc): %f", wxConvUTF8), razon);
	}
	else
	{
		wxLogMessage(_T("INFORMACION NO DISPONIBLE PARA CALCIFICACION"));
	}
	
}

void wxQuantificationWidgetCT::performAND()
{

	int size = _manContours[_mar->getActualQuant()]->getNumberOfWallContourPoints();
	double *vx = _manContours[_mar->getActualQuant()]->getXVectorWallPoints();
	double *vy = _manContours[_mar->getActualQuant()]->getYVectorWallPoints();	

	marIsocontour* m = _mar->loadMarIsocontour(size,vx,vy);
	std::vector<marIsocontour *> walls;

	walls.push_back(m);

	


}

void wxQuantificationWidgetCT::getIndex()
{
}

//------------------------------------------------------------------------
void wxQuantificationWidgetCT::OnSliderDiscontinuityScroll(int percentage)
{
	_mar->updateDiscontinuityThreshold(percentage);
	RefreshAxis();
	
}


//------------------------------------------------------------------------
void wxQuantificationWidgetCT::OnSliderLumenPercentageScroll(int percentage)
{
	_mar->updateLumenPercentage(percentage);
	_contourViewer->Refresh();
}


//------------------------------------------------------------------------
void wxQuantificationWidgetCT::OnCalibration() 
{

	int actual = _mar->getActualQuant();
	_mar->ClearContoursPartial(actual - 1);
	_mar->setStartIndex(actual);
	_mar->setCalibration(true);

	wxLogMessage(_T("Contours calibrated"));
	_mar->markUpLumen(actual);
	RefreshAxis(); 
}

//------------------------------------------------------------------------
void wxQuantificationWidgetCT::OnFile()
{
	
	_mar->generateFile();
}

//------------------------------------------------------------------------
void wxQuantificationWidgetCT::OnShowAll(bool value) 
{
	OnShowWall(value);
	OnShowLumen(value);
	OnShowCalc(value);
	OnShowHypo(value);
}

//------------------------------------------------------------------------
void wxQuantificationWidgetCT::OnShowWall(bool value)
{

	_manContours[_mar->getActualQuant()]->setWallVisibility(value);
	_imageviewer2D_1->Refresh();
	_imageviewer2D_1->RefreshView();
}
//------------------------------------------------------------------------
void wxQuantificationWidgetCT::OnShowLumen(bool value)
{
	_manContours[_mar->getActualQuant()]->setLumenVisibility(value);
	_imageviewer2D_1->Refresh();
	_imageviewer2D_1->RefreshView();
}

//------------------------------------------------------------------------
void wxQuantificationWidgetCT::OnShowCalc(bool value)
{
	_manContours[_mar->getActualQuant()]->setCalcVisibility(value);
	_imageviewer2D_1->Refresh();
	_imageviewer2D_1->RefreshView();
}

//------------------------------------------------------------------------
void wxQuantificationWidgetCT::OnShowHypo(bool value)
{
	_manContours[_mar->getActualQuant()]->setHypoVisibility(value);
	_imageviewer2D_1->Refresh();
	_imageviewer2D_1->RefreshView();
}

//------------------------------------------------------------------------
void wxQuantificationWidgetCT::OnSliderCalcPercentageScroll(int percentage)
{
	int actual = _mar->getActualQuant();
	_mar->updateCalcPercentage(percentage);
	_contourViewer->Refresh();
	//_mar->markUpLumen(actual);
	RefreshAxis();
	
}


//------------------------------------------------------------------------
void wxQuantificationWidgetCT::CreateManualContours()
{
	

	for (int i = 0; i < _mar->getNumberOfSlices(); i++)
	{
		if (_manContours[i] != NULL && _mar->getActualQuant() != i)
		{
			_manContours[i]->setWallVisibility(false);
			_manContours[i]->setLumenVisibility(false);
			_manContours[i]->setCalcVisibility(false);
			_manContours[i]->setHypoVisibility(false);
			_manContours[i]->inactivate();	
		}
	}

	_imageviewer2D_1->Refresh();

// EED 31 Mai 2007
//_imageviewer2D_1->RefreshView();

	if (_manContours[_mar->getActualQuant()] == NULL)
	{
		_manContours[_mar->getActualQuant()] = new manualContourContainer();
		
	/*	_imageviewer2D_1->GetInteractorStyleBaseView()->AddInteractorStyleMaracas( _manContours[_mar->getActualQuant()]->getWallController() );
		_imageviewer2D_1->GetInteractorStyleBaseView()->AddInteractorStyleMaracas( _manContours[_mar->getActualQuant()]->getLumenController() );*/
	}
	else
	{
		_manContours[_mar->getActualQuant()]->setWallVisibility(true);
		_manContours[_mar->getActualQuant()]->setLumenVisibility(true);
		_manContours[_mar->getActualQuant()]->setCalcVisibility(true);
		_manContours[_mar->getActualQuant()]->setHypoVisibility(true);
		_imageviewer2D_1->Refresh();
		_imageviewer2D_1->RefreshView();
	}


}

//------------------------------------------------------------------------
void wxQuantificationWidgetCT::addManualContours(int type)
{
	int tam = 0;
	
	if (type == CALCIFICATION)
	{
		tam = _manContours[_mar->getActualQuant()]->addCalcificationContour(_imageviewer2D_1);
		_imageviewer2D_1->GetInteractorStyleBaseView()->AddInteractorStyleMaracas( _manContours[_mar->getActualQuant()]->getCalcController(tam) );
	}
	else if (type == HYPODENSE)
	{
		tam = _manContours[_mar->getActualQuant()]->addHypodenseContour(_imageviewer2D_1);
		_imageviewer2D_1->GetInteractorStyleBaseView()->AddInteractorStyleMaracas( _manContours[_mar->getActualQuant()]->getHypoController(tam) );
	}
}


// EOF - wxQuantificationWidgetCT.cxx



