/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxQuantificationWidgetCT.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:17 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef __WX__MARACAS__QUANTIF__CT__WDG__HXX__
#define __WX__MARACAS__QUANTIF__CT__WDG__HXX__


#include "vtk3DQuantSurfaceWidget.h"
#include "vtk2DQuantSliceWidget.h"
#include "wxImageViewerWidget.h"

#include "wxChart.h"

#include <wx/wx.h>
#include <wx/slider.h>
#include <wx/panel.h>
#include <wx/minifram.h>
#include <wx/splitter.h>
#include <kernel/marInterfaceCT.h>
#include "wxQuantificationWidget_base.h"
#include "ContourView.h"
#include "PointView.h"
#include "LineView.h"
#include "../manualContourContainer.h"
#include <vector>



class wxQuantificationWidgetCT : public wxQuantificationWidget_base
{
public:

  enum WidgetsIDs { 
    ID_QUANTIF3D = wxID_HIGHEST + 1 
  };

  enum  FunctionIDs {
    ID_BUTTON_CONTOUR = wxID_HIGHEST + 1,
    ID_BUTTON_CLEAN,
    ID_BUTTON_CLEAN_ALL,
    ID_BUTTON_AUTOQUANT,
    ID_BUTTON_HEALTHY,
    ID_BUTTON_CALCULATED,
    ID_BUTTON_PAUSE,
    ID_BUTTON_DELETE,
    ID_BUTTON_POINT
  };
  
  enum  ParamIDs {
    ID_CHECKBOX_HEALTHY = wxID_HIGHEST + 1,
    ID_CHECKBOX_PERPENDICULAR,
    ID_CHECKBOX_VISIBLE_RINGS,
    ID_CHECKBOX_SHOW_SURFACE,
    ID_RADIOBUTTON_GREYSCALE,
    ID_RADIOBUTTON_COLOR,
    ID_SLIDER_SLICE,
    ID_SLIDER_SLICE22,
    ID_SLIDER_ISOVALUE,
    ID_SLIDER_OPACITY
};

  

  // Constructor &  Destructor
  wxQuantificationWidgetCT(wxWindow* parent, wxWindowID id = -1,
                         const wxPoint& pos = wxDefaultPosition,
                         const wxSize& size = wxDefaultSize,
                         long style = 0/*wxScrolledWindowStyle*/,
                         const wxString& name = wxPanelNameStr);
  
  ~wxQuantificationWidgetCT( );
    
  // Initialize

//  void Set_control( );
//  void Do_layout( );
  void Set_Data( );

//EED  void Positionate( );
  void Forget( );
  void Reload_Axis(bool mask, bool step);
  void Show_Max_Min_Diameters( );
  int  Back( );
  void AddAxisActors();
  void Clean3D( bool eraseAxe = false  );
  void ResetAxis( );
  void RefreshAxis( );
//EED  void Refresh_Quant( );
  void Point_Intensity(double x, double y);
  void Set_plane_3D( double  x, double y );
  void CleanContour();


  //Button
  void Do_Quant( );
  void OnContour_BT(wxCommandEvent& event);
  void OnClean_BT(wxCommandEvent& event);
  void OnCleanAll_BT(wxCommandEvent& event);


  void OnAutoQuantification_BT(wxCommandEvent& event);



  void DetectHealthySickSlice( bool minSurf , bool maxSurf );
    
  //CheckBox
  void OnHealthySlice_CB(wxCommandEvent& event);
  void OnShowSurface_CB(wxCommandEvent& event);
  void OnVisibleRing_CB(wxCommandEvent& event);
  void OnPerpendicular_CB(wxCommandEvent& event);
    
  // RadioButton
  void OnGreyScale_RB(wxCommandEvent& event);
  void OnColor_RB(wxCommandEvent& event);
    
  //Slider
  void OnSliderSliceScroll(wxScrollEvent& event);
  void OnSliderIsovalueScroll(wxScrollEvent& event);
  void OnSliderOpacityScroll(wxScrollEvent& event);
  
  int  GetActualSlice();
  void SetActualSlice(int slice);
  int  GetMaxActualSlice();
  int  GetHealthySlice();
  void GetHealthySliceRange(int &healthySliceStart,int &healthySliceEnd);
  int  GetSizeHealthyRegion();
  void SetSizeHealthyRegion(int size);
  void SetHealthySlice(int healthySlice=-1);	

  void	MoveSlider(int actualQuant);


  void ShowMARACASData( marInterfaceCT* mar );
  void CallBackOnMouseWheel( wxMouseEvent& event );
  void CallBackOnLeftDClick( wxMouseEvent& event );

  void Set3DRegionSliceActor( int type, int k1,int k2 );
  void Set3DStartRegionSliceActor( int type, int k );
  void Set3DEndRegionSliceActor( int type, int k );

  void Show3DRegionSliceActor(int type );
  void Show3DStartRegionSliceActor(int type );
  void Show3DEndRegionSliceActor(int type );

  void Hide3DRegionSliceActor(int type );
  void Hide3DStartRegionSliceActor(int type );
  void Hide3DEndRegionSliceActor(int type );
 
  void GetSliceLimites(int type, int &sliceStart,int &sliceEnd);

  int  GetAnalysisTypeStenosis();
  void SetAnalysisTypeStenosis(int analysisTypeStenosis);

  void SetSlider_Isovalue_Opacity(int isovalue,int opacity);
  void SetManualContour_2DWorld(bool ok);
  void SetManualContour_AddPoint_2DWorld();
  void SetManualContour_InsertPoint_2DWorld();
  void SetManualContour_ErasePoint_2DWorld();
  void SetManualContour_MovePoint_2DWorld();
  void SetManualContour_ReplaceContour();

  kVolume *GetVolumeAxisExtended(int wz1,int wz2);


  void Refresh();
  void RefreshView(marImageData *marimagedata);
  void ConfigureVTK(marImageData *marimagedata);

  void OnContourWall();
  void OnContourLumen();
  void OnContourHypo();
  void OnContourCalc();
  void OnReplaceContourWall();
  void OnReplaceContourLumen();
  void OnReplaceContourHypo();
  void OnReplaceContourCalc();

  void OnSliderDiscontinuityScroll(int percentage);
  void OnSliderLumenPercentageScroll(int percentage);
  void OnSliderCalcPercentageScroll(int percentage);
  void OnCalibration();
  void OnFile();

  void OnShowAll(bool value); 
  void OnShowWall(bool value);
  void OnShowLumen(bool value);
  void OnShowCalc(bool value);
  void OnShowHypo(bool value);

  void performXOR();
  void performAND();
  void getIndex();

private:

enum ContourTypes
	{
		WALL = 1,              /*!< Wall Type. */ 
		CALCIFICATION,     /*!< Calcification Type. */  
		HYPODENSE,          /*!< Hypodense Type. */
		ELUMEN				/*!< Extracted Lumen */
	};

	

  // App
  marInterfaceCT			*_mar;
  
  // VTK
  vtk3DQuantSurfaceWidget	*_3DWorld;
//  vtk2DQuantSliceWidget		*_2DWorld;

  //Visualization
  wxVtk2DBaseView			*_imageviewer2D_1;
  vtkImageData				*_data;
  vtkBaseData				*_vtkbasedata_1;


  //Manual Contour Wall
  /*manualContourControler	*_manContourControlWall;
  manualContourModel		*_mContourModelWall;
  manualViewContour			*_mViewContourWall;

  //Manual Contour Lumen
  manualContourControler	*_manContourControlLumen;
  manualContourModel		*_mContourModelLumen;
  manualViewContour			*_mViewContourLumen;

  //Manual Contour Calc
  std::vector <manualContourControler *> _manContourControlCalc;
  std::vector <manualContourModel *> _mContourModelCalc;
  std::vector <manualViewContour *> _mViewContourCalc;

  //Manual Contour Hypo
  std::vector <manualContourControler *> _manContourControlHypo;
  std::vector <manualContourModel *> _mContourModelHypo;
  std::vector <manualViewContour *> _mViewContourHypo;	
  
*/
  std::vector <manualContourContainer *> _manContours;
  //Default contours, points and lines viewing
  ContourView				*_contourViewer;
  LineView					*_lineViewer;
  PointView					*_pointViewer;

  // Chart

  // EED
  //wxChart					*_Chart;
  wxWindow					*_wxStenosisPanel;

//  wxSplitterWindow			*panel_splitter; 
//  wxSplitterWindow			*panel_splitter_right; 
//  wxPanel					*panel_left;
//  wxPanel					*panel_right_up;
//  wxPanel					*panel_right_down;
//  wxPanel					*panel_rightm_up;

  // Group button
  wxButton					*_bt_AddContour3D;
  wxButton					*_bt_CleanContour3D;
  wxButton					*_bt_CleanAllContours3D;
  wxButton					*_bt_Healthy;

  wxPanelControlsHealthySickSliceCT *_pl_cntlHealthySick2;


//  wxButton				*_bt_ContourCalculated;
//  wxButton				*_bt_Pause;
//  wxButton				*_bt_Delete;
//  wxButton				*_bt_Point;

  // Tool graph
  wxRadioButton				*_rb_GreyScale;
  wxRadioButton				*_rb_Color;

  wxCheckBox				*_cb_HealthySlice;
  wxCheckBox				*_cb_Perpendicular;

  wxCheckBox				*_cb_VisibleRings;
  wxCheckBox				*_cb_ShowSurface;
  wxSlider					*_sl_Slice;
  wxSlider					*_sl_Isovalue;
  wxSlider					*_sl_Opacity;
  wxStaticText				*_st_Slice;
  wxStaticText				*_st_Isovalue;
  wxStaticText				*_st_Opacity; 
  

  // Status Text
//  wxStaticText	*_st_Label0;
//  wxStaticText	*_st_Value0;
  wxStaticText		*_txt_Position;

  wxStaticText		*_st_Label1;
  wxStaticText		*_st_Value1;
  wxStaticText		*_st_Label2;
  wxStaticText		*_st_Value2;
  wxStaticText		*_st_Label3;
  wxStaticText		*_st_Value3;
//  wxStaticText	*_st_Label4;
//  wxStaticText	*_st_Value4;
//  wxStaticText	*_st_Label5;
//  wxStaticText	*_st_Value5;
  wxStaticText		*_st_Label6;
  wxStaticText		*_st_Value6;
  wxStaticText		*_st_Label7;
  wxStaticText		*_st_Value7;
  wxStaticText		*_st_Label8;
  wxStaticText		*_st_Value8;
//  wxStaticText	*_st_Label9;
//  wxStaticText	*_st_Value9;


  wxStaticText		*_st_Label100;
  wxStaticText		*_st_Value100;
  wxStaticText		*_st_Label101;
  wxStaticText		*_st_Value101;
//  wxStaticText	*_st_Label102;
//  wxStaticText	*_st_Value102;
//  wxStaticText	*_st_Label103;
//  wxStaticText	*_st_Value103;
//  wxStaticText	*_st_Label104;
//  wxStaticText	*_st_Value104;
//  wxStaticText	*_st_Label105;
//  wxStaticText	*_st_Value105;
//  wxStaticText	*_st_Label106;
//  wxStaticText	*_st_Value106;
//  wxStaticText	*_st_Label107;
//  wxStaticText	*_st_Value107;
//  wxStaticText	*_st_Label108;
//  wxStaticText	*_st_Value108;


  wxStaticText		*_st_LabelRef101;
  wxStaticText		*_st_ValueRef101;
  wxStaticText		*_st_LabelRef102;
  wxStaticText		*_st_ValueRef102;
  wxStaticText		*_st_LabelRef103;
  wxStaticText		*_st_ValueRef103;



  // Quantification
  // int
  int _numpoint;
  int _axis_index;
  int _width, _height, _depth;
  int _bak_ActualSlice;
  int _bak_ActualSlice2;

  int _given_points;
  int _typ;
  int _actual_actor;
  int _perpe;
  int _shown;
  int _quant_shown;
  int _show_rings;
  int _show_hs;
  int _showS;
  
  int _first_quant;
  int _last_quant;
  int _first_point_quant;
  int _last_point_quant;
  int _bounds;
  int _intRange;
  int _nClicks;
  int _quantifing;
  int _sizeHealthyRegion;

  int _initX;
  int _initY;
  int _initWindow;
  int _initLevel;

  // float
//  float _real_first_point_quant;
//  float _real_last_point_quant;
  float _actual_area;
  float _actual_peri;
  float _actual_darea;
  float _actual_dperi;
  float _actual_dmax;
  float _actual_dmin;
  float _actual_davg;
  float _actual_sten;
  float _actual_partial;
  float _actual_total;
  float _ip[3], _fp[3];

  // wxList
  wxList  *_rings_index;
  wxList  *_quant_sten;
  wxList  *_man_points;
  wxList  *_actual_quant_x;
  wxList  *_actual_quant_area;
  wxList  *_actual_quant_peri;
  wxList  *_actual_quant_darea;
  wxList  *_actual_quant_dperi;
  wxList  *_actual_quant_dmax;
  wxList  *_actual_quant_dmin;
  wxList  *_actual_quant_davg;
  wxList  *_actual_quant_sten;

  DECLARE_EVENT_TABLE( );
	
  void		Reset_sl_Slider();
  void		showVariables();
  wxString	strStenosis(double stenosis);
  double	doubleStenosis(double healthy, double sick);
  double	GetStenosisArea(int sickSlice);
  double	GetStenosisDiameter(int sickSlice);
  wxWindow* CreateView2DPanel(wxWindow *parent);
  void		CreateManualContours();
  void		addManualContours(int type);

  	wxSplitterWindow *_splitPanelPrincipal;
	wxSplitterWindow *_splitpanel_left;
	wxSplitterWindow *_splitpanel_right;
	wxSplitterWindow *_splitpanel_right_down;

	wxWindow* CreatePanelPrincipal(wxWindow *parent);
	wxWindow* CreatePanelStatus(wxWindow *parent);
	wxWindow* CreatePanel_Left(wxWindow *parent);
	wxWindow* CreatePanel_Right(wxWindow *parent);
	wxWindow* CreateStenosisPanel(wxWindow *parent);
	wxWindow* CreateControlPanel3D(wxWindow *parent);
	wxWindow* CreatePanel_Right_Down(wxWindow *parent);

};




#endif // __WX__MARACAS__QUANTIF__CT__WDG__HXX__

