/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

 Program:   wxMaracas
 Module:    $RCSfile: wxQuantificationWidget_base.cxx,v $
 Language:  C++
 Date:      $Date: 2012/11/15 14:15:17 $
 Version:   $Revision: 1.2 $
 
  Copyright: (c) 2002, 2003
  License:
  
   This software is distributed WITHOUT ANY WARRANTY; without even
   the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
   PURPOSE.  See the above copyright notice for more information.
   
=========================================================================*/

#include "wxQuantificationWidget_base.h"
#include "../marDictionary.h"
#include "../wxMaracasMPR.h"


//#include <matrix.h>
//#include <wx/notebook.h>




// EED Borrame
long int startTimeCalcule;
long int startTimeRI;



//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
wxPnlModifyContour::wxPnlModifyContour(wxWindow* parent, wxQuantificationWidget_base *quantificationWidget_base)
					: wxPanel(parent,-1){

	marDictionary marDict;
	char tmp[256];

	_quantificationWidget_base=quantificationWidget_base;
//EEDxx 2.6
//	this->SetBackgroundColour(*wxLIGHT_GREY);
	wxStaticText *title		= new wxStaticText(this,-1,wxString(marDict.GetString(803), wxConvUTF8)); // "Contour modification"

// EEDxx 2.6
//	wxStaticText *blank		= new wxStaticText(this,-1,"   ");

	strcpy( tmp , marDict.GetString(820) ); strcat( tmp , "\n" ); strcat( tmp , marDict.GetString(825) );
			_newContour		= new wxButton(this, -1, wxString(tmp, wxConvUTF8)					,wxPoint(0,0),wxSize(80,80));  // " New\nContour"
			_fixContour		= new wxButton(this, -1, wxString(marDict.GetString(830), wxConvUTF8) ,wxPoint(0,0),wxSize(80,80));  // " Replace " 
//			_cancelContour	= new wxButton(this, -1, marDict.GetString(835)	,wxPoint(0,0),wxSize(80,35));  // " End "
//			_insert			= new wxRadioButton(this, -1, wxString(marDict.GetString(840), wxConvUTF8), wxDefaultPosition, wxDefaultSize, wxRB_SINGLE  ); // " Insert Point "
//			_erase			= new wxRadioButton(this, -1, wxString(marDict.GetString(845), wxConvUTF8), wxDefaultPosition, wxDefaultSize, wxRB_SINGLE  ); // " Delete Point "
//			_move			= new wxRadioButton(this, -1, wxString(marDict.GetString(850), wxConvUTF8), wxDefaultPosition, wxDefaultSize, wxRB_SINGLE ); // " Move Point "
				  _one		= new wxStaticText(this,-1,wxString(marDict.GetString(805), wxConvUTF8) );  // "1"
				  _two		= new wxStaticText(this,-1,wxString(marDict.GetString(810), wxConvUTF8) );  // "2"
				  _three	= new wxStaticText(this,-1,wxString(marDict.GetString(815), wxConvUTF8) );  // "3"

	strcpy( tmp , "\n\n" ); 
	strcat( tmp , marDict.GetString(855) ); 
	strcat( tmp , "\n" ); 
	strcat( tmp , marDict.GetString(860) );
				  _msg		= new wxStaticText(this,-1,wxString(tmp, wxConvUTF8) );  // "\n\nUse mouse left button \n to create the new contour"

	wxFont font(12,wxDEFAULT ,wxNORMAL,wxBOLD);
	title	-> SetFont(font);
	_one	-> SetFont(font);
	_two	-> SetFont(font);
	_three	-> SetFont(font);

//EEDxx 2.6
//	title	-> SetBackgroundColour(*wxLIGHT_GREY);
//	_insert	-> SetBackgroundColour(*wxLIGHT_GREY);
//	_erase	-> SetBackgroundColour(*wxLIGHT_GREY);
//	_move	-> SetBackgroundColour(*wxLIGHT_GREY);
//	_msg	-> SetBackgroundColour(*wxLIGHT_GREY);

	_fixContour		-> Disable();
//	_cancelContour	-> Disable();
//	_insert			-> Disable();
//	_erase			-> Disable();
//	_move			-> Disable();
	_two			-> Disable();
	_three			-> Disable();
	_msg			-> Disable();
//	_msg			-> Show(false);

	Connect(_newContour->GetId()	, wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxPnlModifyContour::OnNewContour	);
	Connect(_fixContour->GetId()	, wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxPnlModifyContour::OnFixContour	);
//	Connect(_cancelContour->GetId()	, wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxPnlModifyContour::OnCancelContour	);
//	Connect(_insert->GetId()		, wxEVT_COMMAND_RADIOBUTTON_SELECTED , (wxObjectEventFunction) &wxPnlModifyContour::OnInsertPoint	);
//	Connect(_erase->GetId()			, wxEVT_COMMAND_RADIOBUTTON_SELECTED , (wxObjectEventFunction) &wxPnlModifyContour::OnErasePoint	);
//	Connect(_move->GetId()			, wxEVT_COMMAND_RADIOBUTTON_SELECTED , (wxObjectEventFunction) &wxPnlModifyContour::OnMovePoint	);


	wxFlexGridSizer *sizer	= new wxFlexGridSizer(1);
	wxFlexGridSizer *sizerAh= new wxFlexGridSizer(6);
	wxFlexGridSizer *sizerAv= new wxFlexGridSizer(1);
	wxFlexGridSizer *sizerBv= new wxFlexGridSizer(1);

//	sizerAv->Add(_insert		,	1, wxALL|wxEXPAND, 6);
//	sizerAv->Add(_erase			,	1, wxALL|wxEXPAND, 6);
//	sizerAv->Add(_move			,	1, wxALL|wxEXPAND, 6);

	sizerBv->Add(_fixContour	,	1, wxALL|wxEXPAND, 6);
//	sizerBv->Add(_cancelContour	,	1, wxALL|wxEXPAND, 6);

	sizerAh->Add(new wxStaticText(this,-1,_T("   "))			,	1, wxALL|wxEXPAND, 3);
	sizerAh->Add(_one			,	1, wxALIGN_CENTER_HORIZONTAL, 3);
	sizerAh->Add(new wxStaticText(this,-1,_T("   "))			,	1, wxALL|wxEXPAND, 3);
	sizerAh->Add(_two			,	1, wxALIGN_CENTER_HORIZONTAL, 3);
	sizerAh->Add(new wxStaticText(this,-1,_T("   "))			,	1, wxALL|wxEXPAND, 3);
	sizerAh->Add(_three			,	1, wxALIGN_CENTER_HORIZONTAL, 3);

	sizerAh->Add(new wxStaticText(this,-1,_T("   "))			,	1, wxALL|wxEXPAND, 3);
	sizerAh->Add(_newContour	,	1, wxALL|wxEXPAND, 3);
	sizerAh->Add(new wxStaticText(this,-1,_T("   "))			,	1, wxALL|wxEXPAND, 3);
	sizerAh->Add(_msg			,	1, wxALL|wxEXPAND, 3);
	sizerAh->Add(new wxStaticText(this,-1,_T("   "))			,	1, wxALL|wxEXPAND, 3);
	sizerAh->Add(sizerBv		,	1, wxALL|wxEXPAND, 3);

//	sizerAh->Add(blank			,	1, wxALL|wxEXPAND, 3);
//	sizerAh->Add(blank			,	1, wxALL|wxEXPAND, 3);
//	sizerAh->Add(blank			,	1, wxALL|wxEXPAND, 3);
//	sizerAh->Add(_msg			,	1, wxALIGN_CENTER_HORIZONTAL, 3);
//	sizerAh->Add(blank			,	1, wxALL|wxEXPAND, 3);
//	sizerAh->Add(blank			,	1, wxALL|wxEXPAND, 3);

	sizer->Add(title			,	1, wxALL|wxEXPAND, 10);
	sizer->Add(sizerAh			,	1, wxALL|wxEXPAND, 10);

	this->SetSizer(sizer);
	this->SetSize(wxSize(400,400));
}

//------------------------------------------------------------------------
void wxPnlModifyContour::OnFixContour(wxCommandEvent& event){
	_fixContour		-> Enable(false);
	_two			-> Enable(false);
	_three			-> Enable(false);
	_msg			-> Enable(false);
    _quantificationWidget_base->SetManualContour_ReplaceContour();
    _quantificationWidget_base->SetManualContour_2DWorld(false);
}
//------------------------------------------------------------------------
void wxPnlModifyContour::OnNewContour(wxCommandEvent& event){

//	_insert			-> Enable(true);
//	_erase			-> Enable(true);
//	_move			-> Enable(true);
	_fixContour		-> Enable(true);
//	_cancelContour	-> Enable(true);
	_two			-> Enable(true);
	_three			-> Enable(true);
	_msg			-> Enable(true);
//	_msg			-> Show(true);

//	_insert			-> SetValue(true);
//	_erase			-> SetValue(false);
//	_move			-> SetValue(false);

    _quantificationWidget_base->SetManualContour_AddPoint_2DWorld();
    _quantificationWidget_base->SetManualContour_2DWorld(false);
    _quantificationWidget_base->SetManualContour_2DWorld(true);

}



//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
wxPnlSearchStenosisAutomatic::wxPnlSearchStenosisAutomatic(wxWindow *parent, wxQuantificationWidget_base *quantificationWidget_base)
								:wxPanel(parent,-1){
	marDictionary marDict;
	char tmp[256];

	_quantificationWidget_base=quantificationWidget_base;
	int wx_border = 5;
	wxPanel* _panelAutomatic=this;
	wxFlexGridSizer *sizerPanelAutomatic1	= new wxFlexGridSizer(7);

//EEDxx 2.6
//					_st1_blank				= new wxStaticText(_panelAutomatic,-1," ");

	strcpy( tmp , marDict.GetString(275) ); strcat( tmp , "\n" ); strcat( tmp , marDict.GetString(280) );
					_st1_text1				= new wxStaticText(_panelAutomatic,-1,wxString(tmp, wxConvUTF8) ); //"Select\n slice"
					_st1_next1				= new wxStaticText(_panelAutomatic,-1,_T("    ")); //->
					_st1_next2				= new wxStaticText(_panelAutomatic,-1,_T("    ")); //->
					_st1_next3				= new wxStaticText(_panelAutomatic,-1,_T("    ")); //->
					_st1_cero				= new wxStaticText(_panelAutomatic,-1,wxString(marDict.GetString(273), wxConvUTF8) );//"0"
					_st1_one				= new wxStaticText(_panelAutomatic,-1,wxString(marDict.GetString(283), wxConvUTF8) );//"1"
					_st1_two				= new wxStaticText(_panelAutomatic,-1,wxString(marDict.GetString(293), wxConvUTF8) );//"2"
					_st1_three				= new wxStaticText(_panelAutomatic,-1,wxString(marDict.GetString(303), wxConvUTF8) );//"3"
	strcpy( tmp , marDict.GetString(285) ); strcat( tmp , "\n" ); strcat( tmp , marDict.GetString(290) );
					_bt1_HealthySlice		= new wxButton(_panelAutomatic,-1,wxString(tmp, wxConvUTF8),wxPoint(0,0),wxSize(80,85));//"    Validate\nHealthy Slice"
	strcpy( tmp , marDict.GetString(295) ); strcat( tmp , "\n" ); strcat( tmp , marDict.GetString(300) );
					_bt1_EndRegion			= new wxButton(_panelAutomatic,-1,wxString(tmp, wxConvUTF8),wxPoint(0,0),wxSize(80,85));//"   Validate\nEnd region"
	strcpy( tmp , marDict.GetString(305) ); strcat( tmp , "\n" ); strcat( tmp , marDict.GetString(310) );
					_bt1_Start				= new wxButton(_panelAutomatic,-1,wxString(tmp, wxConvUTF8),wxPoint(0,0),wxSize(80,85));//"   Find \nStenosis"
	wxStaticText	*title					= new wxStaticText(this,-1,wxString(marDict.GetString(270), wxConvUTF8)); //"Automatic stenosis search"

    // SpecialPanel
	_panelSpecial				= new wxPanel(_panelAutomatic,-1,wxDefaultPosition,wxSize(400,200));
	_st_BeginRegion				= new wxStaticText(_panelSpecial,-1,_T("Begin Region : "));
	_st_EndRegion				= new wxStaticText(_panelSpecial,-1,_T("   End Region : "));
	_sl_BeginRegion				= new wxSlider(_panelSpecial, -1, 0, 0, 100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );
	_sl_EndRegion				= new wxSlider(_panelSpecial, -1, 0, 0, 100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );
	_rb_surface					= new wxRadioButton(_panelSpecial, -1, _T("Stenosis by Surface     "), wxDefaultPosition, wxDefaultSize, wxRB_GROUP   );
	_rb_diameter				= new wxRadioButton(_panelSpecial, -1, _T("Stenosis by Diameter    "), wxDefaultPosition, wxDefaultSize  );
	_bt_MaxSurface				= new wxButton(_panelSpecial,-1,_T("Find Max Surface"));
	wxButton *bt_AxisMPR		= new wxButton(_panelSpecial,-1,_T("Axis MPR"));

	_bt_plus		= new wxButton(_panelAutomatic,-1,_T("+"),wxPoint(0,0),wxSize(15,15));
	_bt_plus->Show(true);


	Connect(_bt1_HealthySlice->GetId()	, wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxPnlSearchStenosisAutomatic::OnBtHealthySlice	);
	Connect(_bt1_EndRegion->GetId()		, wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxPnlSearchStenosisAutomatic::OnBtEndRegion		);
	Connect(_bt1_Start->GetId()			, wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxPnlSearchStenosisAutomatic::OnBtStart			);

	Connect(_sl_BeginRegion->GetId()	, wxEVT_COMMAND_SLIDER_UPDATED , (wxObjectEventFunction) &wxPnlSearchStenosisAutomatic::OnBeginSlider );
	Connect(_sl_EndRegion->GetId()		, wxEVT_COMMAND_SLIDER_UPDATED , (wxObjectEventFunction) &wxPnlSearchStenosisAutomatic::OnEndSlider   );
	Connect(_bt_plus->GetId()	  		, wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxPnlSearchStenosisAutomatic::OnBtPlus );	
	Connect(_bt_MaxSurface->GetId()		, wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxPnlSearchStenosisAutomatic::OnBtMaxSurf );
	Connect(bt_AxisMPR->GetId()			, wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxPnlSearchStenosisAutomatic::OnBtAxisMPR );

	Connect(_rb_surface->GetId()	  , wxEVT_COMMAND_RADIOBUTTON_SELECTED , (wxObjectEventFunction) &wxPnlSearchStenosisAutomatic::OnRbArea );
	Connect(_rb_diameter->GetId()	  , wxEVT_COMMAND_RADIOBUTTON_SELECTED , (wxObjectEventFunction) &wxPnlSearchStenosisAutomatic::OnRbDiameter );
	    

	wxFlexGridSizer *sizerPanelSpecial	= new wxFlexGridSizer(1);
	wxFlexGridSizer *sizerPanelSpecial1	= new wxFlexGridSizer(2);
	wxFlexGridSizer *sizerPanelSpecial2	= new wxFlexGridSizer(2);
	wxFlexGridSizer *sizerPanelSpecial3	= new wxFlexGridSizer(3);

	wxFlexGridSizer *sizerPanelAutomatic	= new wxFlexGridSizer(1);

//EEDxx 2.6
//	_panelAutomatic->SetBackgroundColour(*wxLIGHT_GREY);

//EEDxx 2.6
//	_st1_blank	->SetBackgroundColour(*wxLIGHT_GREY);
//	_st1_text1	->SetBackgroundColour(*wxLIGHT_GREY);
//	_st1_next1	->SetBackgroundColour(*wxLIGHT_GREY);
//	_st1_next2	->SetBackgroundColour(*wxLIGHT_GREY);
//	_st1_next3	->SetBackgroundColour(*wxLIGHT_GREY);
//	_st1_next3	->SetBackgroundColour(*wxLIGHT_GREY);
//	_st1_cero	->SetBackgroundColour(*wxLIGHT_GREY);
//	_st1_one	->SetBackgroundColour(*wxLIGHT_GREY);
//	_st1_two	->SetBackgroundColour(*wxLIGHT_GREY);
//	_st1_three	->SetBackgroundColour(*wxLIGHT_GREY);

	wxFont font(12,wxDEFAULT ,wxNORMAL,wxBOLD);
	title		->SetFont(font);
//EEDxx 2.6
//	title		->SetBackgroundColour(*wxLIGHT_GREY);
	_st1_cero	->SetFont(font);
	_st1_one	->SetFont(font);
	_st1_two	->SetFont(font);
	_st1_three	->SetFont(font);
	_st1_next1	->SetFont(font);
	_st1_next2	->SetFont(font);
	_st1_next3	->SetFont(font);
//    _st1_one	->Disable();
    _st1_two	->Disable();
    _st1_three	->Disable();
//    bt1_HealthySlice->Disable();
    _bt1_EndRegion->Disable();
    _bt1_Start->Disable();

//EEDxx 2.6
//	_panelSpecial   ->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_BeginRegion	->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_EndRegion	->SetBackgroundColour(*wxLIGHT_GREY);
//	_sl_BeginRegion	->SetBackgroundColour(*wxLIGHT_GREY);
//	_sl_EndRegion	->SetBackgroundColour(*wxLIGHT_GREY);
//	_rb_diameter	->SetBackgroundColour(*wxLIGHT_GREY);
//	_rb_surface		->SetBackgroundColour(*wxLIGHT_GREY);

	_sl_BeginRegion	->SetSize(330,30);
	_sl_EndRegion	->SetSize(330,30);
    _st_BeginRegion	->Disable();
    _st_EndRegion	->Disable();
    _sl_BeginRegion	->Disable();
    _sl_EndRegion	->Disable();
    _rb_diameter	->Disable();
    _rb_surface		->Disable();
    _bt_MaxSurface	->Disable();

	_rb_surface->SetValue(true);
	_quantificationWidget_base->SetAnalysisTypeStenosis(2);

	// line cero
	sizerPanelAutomatic1->Add(new wxStaticText(_panelAutomatic,-1,_T(" "))			,	15, wxALIGN_CENTER_HORIZONTAL, wx_border);
	sizerPanelAutomatic1->Add(new wxStaticText(_panelAutomatic,-1,_T(" "))			,	15, wxALIGN_CENTER_HORIZONTAL, wx_border);
	sizerPanelAutomatic1->Add(new wxStaticText(_panelAutomatic,-1,_T(" "))			,	15, wxALIGN_CENTER_HORIZONTAL, wx_border);
	sizerPanelAutomatic1->Add(new wxStaticText(_panelAutomatic,-1,_T(" "))			,	15, wxALIGN_CENTER_HORIZONTAL, wx_border);
	sizerPanelAutomatic1->Add(new wxStaticText(_panelAutomatic,-1,_T(" "))			,	15, wxALIGN_CENTER_HORIZONTAL, wx_border);
	sizerPanelAutomatic1->Add(new wxStaticText(_panelAutomatic,-1,_T(" "))			,	15, wxALIGN_CENTER_HORIZONTAL, wx_border);
	sizerPanelAutomatic1->Add(new wxStaticText(_panelAutomatic,-1,_T(" "))			,	15, wxALIGN_CENTER_HORIZONTAL, wx_border);

	// fist line
	sizerPanelAutomatic1->Add(_st1_cero				,	15, wxALIGN_CENTER_HORIZONTAL, wx_border);
	sizerPanelAutomatic1->Add(new wxStaticText(_panelAutomatic,-1,_T(" "))			,	15, wxALIGN_CENTER_HORIZONTAL, wx_border);
	sizerPanelAutomatic1->Add(_st1_one				,	15, wxALIGN_CENTER_HORIZONTAL, wx_border);
	sizerPanelAutomatic1->Add(new wxStaticText(_panelAutomatic,-1,_T(" "))			,	15, wxALIGN_CENTER_HORIZONTAL, wx_border);
	sizerPanelAutomatic1->Add(_st1_two				,	15, wxALIGN_CENTER_HORIZONTAL, wx_border);
	sizerPanelAutomatic1->Add(new wxStaticText(_panelAutomatic,-1,_T(" "))			,	15, wxALIGN_CENTER_HORIZONTAL, wx_border);
	sizerPanelAutomatic1->Add(_st1_three			,	15, wxALIGN_CENTER_HORIZONTAL, wx_border);
	// second line
	sizerPanelAutomatic1->Add(_st1_text1			,	15, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, wx_border);
	sizerPanelAutomatic1->Add(_st1_next1			,	15, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, wx_border);
	sizerPanelAutomatic1->Add(_bt1_HealthySlice		,	15, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, wx_border);
	sizerPanelAutomatic1->Add(_st1_next2			,	15, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, wx_border);
	sizerPanelAutomatic1->Add(_bt1_EndRegion		,	15, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, wx_border);
	sizerPanelAutomatic1->Add(_st1_next3			,	15, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, wx_border);
	sizerPanelAutomatic1->Add(_bt1_Start			,	15, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, wx_border);

	// Special panel
	sizerPanelSpecial1->Add(_rb_surface			,1	,wxALL			,0);
	sizerPanelSpecial1->Add(_rb_diameter		,1	,wxALL			,0);
	sizerPanelSpecial2->Add(_st_BeginRegion		,1	,wxALL			,0);
	sizerPanelSpecial2->Add(_sl_BeginRegion		,1	,wxALL|wxGROW	,0);
	sizerPanelSpecial2->Add(_st_EndRegion		,1	,wxALL			,0);
	sizerPanelSpecial2->Add(_sl_EndRegion		,1	,wxALL|wxGROW	,0);
	sizerPanelSpecial3->Add(_bt_MaxSurface		,1	,wxALL			,0);
	sizerPanelSpecial3->Add( bt_AxisMPR			,1	,wxALL			,0);

// EED 27 oct 2007
	sizerPanelSpecial2->AddGrowableCol(1);
	

	sizerPanelSpecial->Add(sizerPanelSpecial1	,1	,wxALL|wxALIGN_RIGHT	, 0 );
	sizerPanelSpecial->Add(sizerPanelSpecial2	,1	,wxALL|wxGROW			, 0 );
	sizerPanelSpecial->Add(sizerPanelSpecial3	,1	,wxALL					, 0 );
	_panelSpecial->SetSizer(sizerPanelSpecial);
	_panelSpecial->SetAutoLayout(true);
	_panelSpecial->SetSize( sizerPanelSpecial->GetMinSize() );

	sizerPanelAutomatic->Add(title					,15, wxALL				, 10);
	sizerPanelAutomatic->Add(sizerPanelAutomatic1	,15, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL	, 10);
	sizerPanelAutomatic->Add(_bt_plus				,15, wxALL				, 0);
	sizerPanelAutomatic->Add(_panelSpecial			,15, wxALL|wxGROW		, 0);
	_panelAutomatic->SetSizer(sizerPanelAutomatic);
	_panelAutomatic->SetAutoLayout(true);

	_panelSpecial->Show(true);

	_panelAutomatic->SetSize(400,270);
	_panelAutomatic->SetSize( sizerPanelAutomatic->GetMinSize() );
}


//------------------------------------------------------------------------
void wxPnlSearchStenosisAutomatic::SetRange(int min, int max)
{
	_sl_BeginRegion->SetRange(min,max);
	_sl_EndRegion->SetRange(min,max);
}


//------------------------------------------------------------------------
void wxPnlSearchStenosisAutomatic::OnBtHealthySlice(wxCommandEvent& event){
	// Automatique panel
    _st1_two		-> Enable();
    _bt1_EndRegion	-> Enable();
    _st_BeginRegion	-> Enable();
    _sl_BeginRegion	-> Enable();
	int slice=_quantificationWidget_base->GetActualSlice();
	_quantificationWidget_base->SetHealthySlice(slice);

	int startSlice,endSlice;
	_quantificationWidget_base->GetSliceLimites(0,startSlice,endSlice);
	if ((_panelSpecial->IsShown()==false) || (startSlice==-1)){
 		_quantificationWidget_base->Set3DStartRegionSliceActor( 0, slice );
		_quantificationWidget_base->Show3DStartRegionSliceActor(0);
		_sl_BeginRegion	->SetValue(slice);
		_quantificationWidget_base->RefreshAxis();
	}
}
//------------------------------------------------------------------------
void wxPnlSearchStenosisAutomatic::OnBtEndRegion(wxCommandEvent& event){
    _st1_three		-> Enable();
    _bt1_Start		-> Enable();
    _st_EndRegion	-> Enable();
    _sl_EndRegion	-> Enable();
    _rb_diameter	-> Enable();
    _rb_surface		-> Enable();
    _bt_MaxSurface	-> Enable();
	int slice=_quantificationWidget_base->GetActualSlice();
  	_quantificationWidget_base->Set3DEndRegionSliceActor( 0, slice );
	_quantificationWidget_base->Show3DEndRegionSliceActor(0);
	_sl_EndRegion->SetValue(slice);
	_quantificationWidget_base->RefreshAxis();
}

//------------------------------------------------------------------------
void wxPnlSearchStenosisAutomatic::OnBtStart(wxCommandEvent& event)
{
	_quantificationWidget_base->DetectHealthySickSlice( true, false );
}


//------------------------------------------------------------------------

void wxPnlSearchStenosisAutomatic::OnBtAxisMPR(wxCommandEvent& event){
	wxBusyCursor wait;
	wxFrame *frame = new wxFrame(this,-1,_T("MPR Axe"),wxDefaultPosition,wxDefaultSize,wxDEFAULT_FRAME_STYLE|wxSTAY_ON_TOP);
	int wz1 = _sl_BeginRegion->GetValue();
	int wz2 = _sl_EndRegion->GetValue();
	if (wz2<wz1)
	{
		int tmp = wz1;
		wz1 = wz2;
		wz2 = tmp;
	}

	kVolume *vol = _quantificationWidget_base->GetVolumeAxisExtended(wz1,wz2);


	wxMaracasMPR *wxmaracasMPR = new wxMaracasMPR( frame , new marImageData( vol->castVtk() ) , 1);
//	wxMaracasMPR *wxmaracasMPR = new wxMaracasMPR( frame , vol->castVtk() , getVoxelSize???? );


	vtkPlane2DView *planeView = wxmaracasMPR->GetVtkPlane2DView();
	planeView->SetImgSize(100);
	wxmaracasMPR->ConfigureVTK();
	frame->SetSize(600,600);
	frame->Show();
}

//------------------------------------------------------------------------
void wxPnlSearchStenosisAutomatic::OnBtPlus(wxCommandEvent& event){
	if (_panelSpecial->IsShown()==true){
		_bt_plus->SetLabel(_T("+"));
		_panelSpecial->Show(false);
	} else {
		_bt_plus->SetLabel(_T("-"));
		// Sliders
		int startSlice,endSlice;
		_quantificationWidget_base->GetSliceLimites(0,startSlice,endSlice);
		int maxSlices	= _quantificationWidget_base->GetMaxActualSlice();
		_sl_BeginRegion->SetRange(0,maxSlices);
		_sl_BeginRegion->SetValue(startSlice);
		_sl_EndRegion->SetRange(0,maxSlices);
		_sl_EndRegion->SetValue(endSlice);
		_quantificationWidget_base->RefreshAxis();
		//Show panel
		_panelSpecial->Show(true);
	}
}
//------------------------------------------------------------------------
void wxPnlSearchStenosisAutomatic::OnBeginSlider(wxScrollEvent& event){
	_quantificationWidget_base->Set3DStartRegionSliceActor(  0, _sl_BeginRegion->GetValue() );
	_quantificationWidget_base->Show3DStartRegionSliceActor( 0 );
	_quantificationWidget_base->RefreshAxis();
}
//------------------------------------------------------------------------
void wxPnlSearchStenosisAutomatic::OnEndSlider(wxScrollEvent& event){
	_quantificationWidget_base->Set3DEndRegionSliceActor(  0, _sl_EndRegion->GetValue() );
	_quantificationWidget_base->Show3DEndRegionSliceActor( 0 );
	_quantificationWidget_base->RefreshAxis();
}
//------------------------------------------------------------------------
void wxPnlSearchStenosisAutomatic::OnBtMaxSurf(wxCommandEvent& event){
	_quantificationWidget_base->DetectHealthySickSlice( false, true );
}
//------------------------------------------------------------------------
void wxPnlSearchStenosisAutomatic::OnRbArea(wxCommandEvent& event){
	_quantificationWidget_base->SetAnalysisTypeStenosis( 2 );
}
//------------------------------------------------------------------------
void wxPnlSearchStenosisAutomatic::OnRbDiameter(wxCommandEvent& event){
	_quantificationWidget_base->SetAnalysisTypeStenosis( 1 );
}
//------------------------------------------------------------------------







//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
wxPnlSearchStenosisManual::wxPnlSearchStenosisManual(wxWindow *parent, wxQuantificationWidget_base *quantificationWidget_base)
								:wxPanel(parent,-1){
	marDictionary marDict;
	char tmp[256];

	_quantificationWidget_base=quantificationWidget_base;
	wxPanel* _panelManual=this;
	wxFlexGridSizer *sizerPanelManual	= new wxFlexGridSizer(1);
	wxFlexGridSizer *sizerPanelManual1	= new wxFlexGridSizer(1);
	wxFlexGridSizer *sizerPanelManual2	= new wxFlexGridSizer(5);

//EEDxx 2.6
//					_st2_blank			= new wxStaticText(_panelManual,-1," ");

	strcpy( tmp , marDict.GetString(330) ); strcat( tmp , "\n" ); strcat( tmp , marDict.GetString(335) );
					_st2_text1			= new wxStaticText(_panelManual,-1,wxString(tmp, wxConvUTF8));//"Select\n slice"
	strcpy( tmp , marDict.GetString(340) ); strcat( tmp , "\n" ); strcat( tmp , marDict.GetString(345) );
					_st2_text2			= new wxStaticText(_panelManual,-1,wxString(tmp, wxConvUTF8));//"    Select \n other slice"
					_st2_next1			= new wxStaticText(_panelManual,-1,_T("        ")); //->
					_st2_next2			= new wxStaticText(_panelManual,-1,_T("        ")); //->
					_st2_cero			= new wxStaticText(_panelManual,-1, wxString(marDict.GetString(328), wxConvUTF8) ); //"0"
					_st2_one			= new wxStaticText(_panelManual,-1, wxString(marDict.GetString(338), wxConvUTF8) ); //"1"
					_st2_two			= new wxStaticText(_panelManual,-1, wxString(marDict.GetString(348), wxConvUTF8) ); //"2"
	strcpy( tmp , marDict.GetString(350) ); strcat( tmp , "\n" ); strcat( tmp , marDict.GetString(355) );
					_bt2_HealthySlice	= new wxButton(_panelManual,-1,wxString(tmp, wxConvUTF8),wxPoint(0,0),wxSize(85,85)); //"    Validate\nHealthy Slice"
	wxStaticText	*title				= new wxStaticText(this,-1,wxString( marDict.GetString(325) , wxConvUTF8  ));//"Manual stenosis search"

	Connect(_bt2_HealthySlice->GetId() , wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxPnlSearchStenosisManual::OnBtHealthySlice	);
//EEDxx 2.6
//	_panelManual->SetBackgroundColour(*wxLIGHT_GREY);
//	_st2_blank	->SetBackgroundColour(*wxLIGHT_GREY);
//	_st2_text1	->SetBackgroundColour(*wxLIGHT_GREY);
//	_st2_text2	->SetBackgroundColour(*wxLIGHT_GREY);
//	_st2_cero	->SetBackgroundColour(*wxLIGHT_GREY);
//	_st2_one	->SetBackgroundColour(*wxLIGHT_GREY);
//	_st2_two	->SetBackgroundColour(*wxLIGHT_GREY);
//	_st2_next1	->SetBackgroundColour(*wxLIGHT_GREY);
//	_st2_next2	->SetBackgroundColour(*wxLIGHT_GREY);

	wxFont font(12,wxDEFAULT ,wxNORMAL,wxBOLD);
	title		->SetFont(font);
//EEDxx 2.6
//	title		->SetBackgroundColour(*wxLIGHT_GREY);
	_st2_cero	->SetFont(font);
	_st2_one	->SetFont(font);
	_st2_two	->SetFont(font);
	_st2_next1	->SetFont(font);
	_st2_next2	->SetFont(font);

	_st2_two->Disable();
	_st2_text2->Disable();

	sizerPanelManual1->Add( title, 15, wxALL, 10 );

	// cero line
	sizerPanelManual2->Add( new wxStaticText(_panelManual,-1,_T(" "))		,	15, wxALIGN_CENTER_HORIZONTAL, 10);
	sizerPanelManual2->Add( new wxStaticText(_panelManual,-1,_T(" "))		,	15, wxALIGN_CENTER_HORIZONTAL, 10);
	sizerPanelManual2->Add( new wxStaticText(_panelManual,-1,_T(" "))		,	15, wxALIGN_CENTER_HORIZONTAL, 10);
	sizerPanelManual2->Add( new wxStaticText(_panelManual,-1,_T(" "))		,	15, wxALIGN_CENTER_HORIZONTAL, 10);
	sizerPanelManual2->Add( new wxStaticText(_panelManual,-1,_T(" "))		,	15, wxALIGN_CENTER_HORIZONTAL, 10);
	// fist line
	sizerPanelManual2->Add(_st2_cero		,	15, wxALIGN_CENTER_HORIZONTAL, 10);
	sizerPanelManual2->Add( new wxStaticText(_panelManual,-1,_T(" "))		,	15, wxALIGN_CENTER_HORIZONTAL, 10);
	sizerPanelManual2->Add(_st2_one			,	15, wxALIGN_CENTER_HORIZONTAL, 10);
	sizerPanelManual2->Add( new wxStaticText(_panelManual,-1,_T(" "))		,	15, wxALIGN_CENTER_HORIZONTAL, 10);
	sizerPanelManual2->Add(_st2_two			,	15, wxALIGN_CENTER_HORIZONTAL, 10);
	// second line
	sizerPanelManual2->Add(_st2_text1		,	15, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 10);
	sizerPanelManual2->Add(_st2_next1		,	15, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 10);
	sizerPanelManual2->Add(_bt2_HealthySlice,	15, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 10);
	sizerPanelManual2->Add(_st2_next2		,	15, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 10);
	sizerPanelManual2->Add(_st2_text2		,	15, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 10);

	sizerPanelManual->Add(sizerPanelManual1);
	sizerPanelManual->Add(sizerPanelManual2);


	_panelManual->SetSizer(sizerPanelManual);
	_panelManual->SetAutoLayout(true);
	_panelManual->SetSize(400,300);
}
//------------------------------------------------------------------------
void wxPnlSearchStenosisManual::OnBtHealthySlice(wxCommandEvent& event){
	// Manual Panel
	_st2_two	->Enable();
	_st2_text2	->Enable();
	_quantificationWidget_base->SetHealthySlice();
}
//------------------------------------------------------------------------


//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
wxPnlSearchStenosis::wxPnlSearchStenosis(wxWindow* parent, wxQuantificationWidget_base *quantificationWidget_base)
					: wxPanel(parent,-1){
	marDictionary marDict;
	_quantificationWidget_base=quantificationWidget_base;
//EEDxx 2.6
//	this->SetBackgroundColour(*wxLIGHT_GREY);

	wxFlexGridSizer *axis1			= new wxFlexGridSizer(2);
	wxFlexGridSizer *sizer			= new wxFlexGridSizer(1);
    wxRadioButton	*rb_automatique	= new wxRadioButton(this,-1,wxString(marDict.GetString(315), wxConvUTF8), wxDefaultPosition, wxDefaultSize, wxRB_GROUP  ); //"Automatic"
    wxRadioButton	*rb_manual		= new wxRadioButton(this,-1,wxString(marDict.GetString(320), wxConvUTF8), wxDefaultPosition, wxDefaultSize   );            //"Manual"

	Connect(rb_automatique->GetId() , wxEVT_COMMAND_RADIOBUTTON_SELECTED , (wxObjectEventFunction) &wxPnlSearchStenosis::OnRbAutomatic );
	Connect(rb_manual->GetId()		, wxEVT_COMMAND_RADIOBUTTON_SELECTED , (wxObjectEventFunction) &wxPnlSearchStenosis::OnRbManual );

	rb_automatique->SetValue(true);
//EEDxx 2.6
//	rb_automatique->SetBackgroundColour(*wxLIGHT_GREY);
//	rb_manual->SetBackgroundColour(*wxLIGHT_GREY);

    wxPanel			*panelWork		= new wxPanel(this,-1);
					_panelAutomatic	= new wxPnlSearchStenosisAutomatic(panelWork,_quantificationWidget_base);
					_panelManual	= new wxPnlSearchStenosisManual(panelWork,_quantificationWidget_base);
	panelWork->SetSize(_panelAutomatic->GetSize());

	_panelAutomatic->Show(true);
	_panelManual->Show(false);

	axis1->Add(rb_automatique);
	axis1->Add(rb_manual);

	sizer->Add(panelWork,1, wxALL|wxEXPAND, 0);
	sizer->Add(axis1	,1, wxALL|wxALIGN_RIGHT , 0);
	this->SetSizer(sizer);
	this->SetAutoLayout(true);
	this->SetSize(wxSize(400,600));
	this->SetSize( sizer->GetMinSize() );
}
//------------------------------------------------------------------------
void wxPnlSearchStenosis::OnRbAutomatic(wxCommandEvent& event){
	_panelAutomatic->Show(true);
	_panelManual->Show(false);
	_quantificationWidget_base->Show3DStartRegionSliceActor( 0 );
	_quantificationWidget_base->Show3DEndRegionSliceActor( 0 );
}
//------------------------------------------------------------------------
void wxPnlSearchStenosis::OnRbManual(wxCommandEvent& event){
	_panelAutomatic->Show(false);
	_panelManual->Show(true);
	_quantificationWidget_base->Hide3DStartRegionSliceActor( 0 );
	_quantificationWidget_base->Hide3DEndRegionSliceActor( 0 );
}
//------------------------------------------------------------------------
wxPnlSearchStenosisAutomatic* wxPnlSearchStenosis::GetPanelAutomatic(){
	return _panelAutomatic;
}




//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
wxPanelSizeHealthyRegion::wxPanelSizeHealthyRegion(wxWindow* parent, wxQuantificationWidget_base *quantificationWidget_base)
								: wxPanel(parent,-1){
	marDictionary marDict;
//EEDxx 2.6
//	this->SetBackgroundColour(*wxLIGHT_GREY);
	_quantificationWidget_base		= quantificationWidget_base;
	int maxSliderSize				= 30;
	int sizeHealthyRegion			= 0;
	sizeHealthyRegion				= _quantificationWidget_base->GetSizeHealthyRegion();

	wxFlexGridSizer	*sizer			= new wxFlexGridSizer(1);
	wxFlexGridSizer	*sizer1			= new wxFlexGridSizer(1);
	wxFlexGridSizer	*sizer2			= new wxFlexGridSizer(2);

//EEDxx 2.6
//	wxStaticText	*st_Blank		= new wxStaticText( this, -1,"    ",wxPoint(0,0));

	wxStaticText	*st_Title		= new wxStaticText( 	this, -1,wxString(marDict.GetString(370), wxConvUTF8),wxPoint(0,0));//"Size of the Healty Region:"
	wxStaticText	*st_Size		= new wxStaticText( 	this, -1, wxString(marDict.GetString(373), wxConvUTF8) ); //"n : "
					_sl_Size		= new wxSlider(		this, -1, sizeHealthyRegion, 0, maxSliderSize, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );
	wxButton 		*buttonRefresh	= new wxButton(		this, -1, wxString(marDict.GetString(375), wxConvUTF8));//"Refresh healthy region"
	wxStaticText	*title			= new wxStaticText(	this, -1,wxString(marDict.GetString(365), wxConvUTF8));//"Healthy region size "


	wxFont font(12,wxDEFAULT ,wxNORMAL,wxBOLD);
	title		->SetFont(font);
//EEDxx 2.6
//	title		->SetBackgroundColour(*wxLIGHT_GREY);

	Connect(buttonRefresh->GetId()  , wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxPanelSizeHealthyRegion::OnButtonRefresh );
	sizer1->Add( title, 15, wxALL, 10 );

	sizer2->Add( new wxStaticText( this, -1,_T("    "),wxPoint(0,0)) );
	sizer2->Add( st_Title );

	sizer2->Add( new wxStaticText( this, -1,_T("    "),wxPoint(0,0)) );
	sizer2->Add( new wxStaticText( this, -1,_T("    "),wxPoint(0,0)) );

	sizer2->Add( st_Size );
	sizer2->Add( _sl_Size ,1,wxALL|wxGROW);
// EED 27 oct 2007
	sizer2->AddGrowableCol(1);

	sizer2->Add( new wxStaticText( this, -1,_T("    "),wxPoint(0,0)) );
	sizer2->Add( new wxStaticText( this, -1,_T("    "),wxPoint(0,0)) );

	sizer2->Add( new wxStaticText( this, -1,_T("    "),wxPoint(0,0)) );
	sizer2->Add( buttonRefresh );

	sizer->Add( sizer1 );
	sizer->Add( sizer2 );

	this->SetSizer(sizer);
	this->SetAutoLayout(true);
	this->SetSize(200,400);
} 
//------------------------------------------------------------------------
void wxPanelSizeHealthyRegion::OnButtonRefresh(wxScrollEvent& event){
	_quantificationWidget_base->SetSizeHealthyRegion( _sl_Size->GetValue() );
	int healthySlice=_quantificationWidget_base->GetHealthySlice();
	if (healthySlice!=-1) {
		_quantificationWidget_base->SetHealthySlice( healthySlice );
	}
}



//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
wxPanelControlsHealthySickSlice2::wxPanelControlsHealthySickSlice2(wxWindow* parent,wxQuantificationWidget_base *quantificationWidget_base)
								: wxPanel(parent,-1){
	marDictionary marDict;
//EEDxx 2.6
//	this->SetBackgroundColour(*wxLIGHT_GREY);


	//_quantificationWidget = quantificationWidget;

    wxNotebook *wxnotbook = new wxNotebook(this, -1);
//EEDxx 2.6
//	wxnotbook->SetBackgroundColour(*wxLIGHT_GREY);

					wxpnlsearchstenosis	= new wxPnlSearchStenosis( wxnotbook , quantificationWidget_base);
	wxPanelSizeHealthyRegion	*page2	= new wxPanelSizeHealthyRegion (wxnotbook , quantificationWidget_base);
	wxPnlModifyContour			*page3	= new wxPnlModifyContour( wxnotbook , quantificationWidget_base);
	wxnotbook->AddPage(wxpnlsearchstenosis, wxString(marDict.GetString(265), wxConvUTF8) ); //"Stenosis search "
	wxnotbook->AddPage(page2, wxString(marDict.GetString(360), wxConvUTF8) ); //"Healty region size "
	wxnotbook->AddPage(page3, wxString(marDict.GetString(800), wxConvUTF8) ); //"Contour modification"
	wxnotbook->SetSize(400,315);
//	int w,h;
//	page1->GetSize(&w,&h);
//	wxnotbook->SetSize( w+20 , h+25 );

	wxFlexGridSizer *sizer				= new wxFlexGridSizer(1);
	sizer->Add(wxnotbook, 1, wxALL|wxEXPAND, 0);
	this->SetSizer(sizer);
	this->SetAutoLayout(true);
	this->Layout();
	this->SetSize(400,315);
//	this->SetSize( wxnotbook->GetSize() );

}

//------------------------------------------------------------------------
wxPnlSearchStenosis *wxPanelControlsHealthySickSlice2::GetPnlSearStenosis()
{
	return wxpnlsearchstenosis;
}

//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
wxPnlContourControl::wxPnlContourControl(wxWindow* parent,wxQuantificationWidget_base *quantificationWidget_base)
			:wxPanel(parent,-1){

	marDictionary marDict;
	
	_quantificationWidget_base=quantificationWidget_base;
//EEDxx 2.6
//	this->SetBackgroundColour(*wxLIGHT_GREY);

	wxStaticText *title		= new wxStaticText(this,-1,wxString(marDict.GetString(940), wxConvUTF8)); // "Contour modification"
//	wxStaticText *blank		= new wxStaticText(this,-1,"   ");
	
//EEDxx 2.6
//	title	-> SetBackgroundColour(*wxLIGHT_GREY);


	wxFont font(12,wxDEFAULT ,wxNORMAL,wxBOLD);
	title	-> SetFont(font);

    _sl_Discontinuity   = new wxSlider(this, -1, 10, 0, 20, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS);
    _sl_LumenPercentage = new wxSlider(this, -1, 86, 0, 100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS);
    _sl_CalcPercentage	= new wxSlider(this, -1, 90, 0, 100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS);

//EEDxx 2.6
//	_sl_Discontinuity->SetBackgroundColour(*wxLIGHT_GREY);
//	_sl_LumenPercentage->SetBackgroundColour(*wxLIGHT_GREY);
//	_sl_CalcPercentage->SetBackgroundColour(*wxLIGHT_GREY);

	_sl_Discontinuity->SetSize(300,16);
	_sl_LumenPercentage->SetSize(300,16);
	_sl_CalcPercentage->SetSize(300,16);

	_st_Discontinuity	= new wxStaticText(this, -1, wxString(marDict.GetString(925), wxConvUTF8) ); //"Threshold "
	_st_LumenPercentage	= new wxStaticText(this, -1, wxString(marDict.GetString(930), wxConvUTF8) ); //"Lumen % "
	_st_CalcPercentage	= new wxStaticText(this, -1, wxString(marDict.GetString(935), wxConvUTF8) ); //"Calcification % "


	btnCalibration	= new wxButton( this, -1, _T("Calibrate"),wxPoint(0,0),wxSize(92,20));
	btnFile			= new wxButton( this, -1, _T("Generate File"),wxPoint(0,0),wxSize(92,20));

//EEDxx 2.6
//	_st_Discontinuity->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_LumenPercentage->SetBackgroundColour(*wxLIGHT_GREY);
//	_st_CalcPercentage->SetBackgroundColour(*wxLIGHT_GREY);


	Connect(_sl_Discontinuity->GetId()	, wxEVT_SCROLL_THUMBRELEASE	, (wxObjectEventFunction) &wxPnlContourControl::OnSliderDiscontinuityScroll	);
	Connect(_sl_LumenPercentage->GetId()	, wxEVT_SCROLL_THUMBRELEASE	, (wxObjectEventFunction) &wxPnlContourControl::OnSliderLumenPercentageScroll	);
	Connect(_sl_CalcPercentage->GetId()	, wxEVT_SCROLL_THUMBRELEASE	, (wxObjectEventFunction) &wxPnlContourControl::OnSliderCalcPercentageScroll	);
	Connect(btnCalibration->GetId()		, wxEVT_COMMAND_BUTTON_CLICKED	, (wxObjectEventFunction) &wxPnlContourControl::OnCalibration );
	Connect(btnFile->GetId()		, wxEVT_COMMAND_BUTTON_CLICKED	, (wxObjectEventFunction) &wxPnlContourControl::OnFile );

	wxFlexGridSizer *sizer	= new wxFlexGridSizer(1);

	wxFlexGridSizer		*axe1				= new wxFlexGridSizer(2);
	wxFlexGridSizer		*axe2				= new wxFlexGridSizer(2);
	wxFlexGridSizer		*axe3				= new wxFlexGridSizer(2);


	axe1->Add(_st_Discontinuity			,  1, wxALL|wxEXPAND, 0);
	axe1->Add(_sl_Discontinuity			,  1, wxALL|wxEXPAND, 0);

	axe2->Add(_st_LumenPercentage		,  1, wxALL|wxEXPAND, 0);
	axe2->Add(_sl_LumenPercentage		,  1, wxALL|wxEXPAND, 0);

	axe3->Add(_st_CalcPercentage		,  1, wxALL|wxEXPAND, 0);
	axe3->Add(_sl_CalcPercentage		,  1, wxALL|wxEXPAND, 0);

	sizer->Add(title			,	1, wxALL|wxEXPAND, 10);
	sizer->Add(axe1, 2, wxALL|wxEXPAND, 10);
	sizer->Add(axe2, 2, wxALL|wxEXPAND, 10);   //wxALIGN_CENTER_HORIZONTAL
	sizer->Add(axe3, 2, wxALL|wxEXPAND, 10);
	sizer->Add(btnCalibration, 2, wxALL|wxEXPAND, 10);
	sizer->Add(btnFile, 2, wxALL|wxEXPAND, 10);

	this->SetSizer(sizer);
	this->SetSize(wxSize(400,400));

}
// ----------------------------------------------------------------------------
void wxPnlContourControl::OnSliderDiscontinuityScroll(wxScrollEvent& event) 
{

	_quantificationWidget_base->OnSliderDiscontinuityScroll(event.GetPosition());

}
// ----------------------------------------------------------------------------
void wxPnlContourControl::OnSliderLumenPercentageScroll(wxScrollEvent& event)
{

	_quantificationWidget_base->OnSliderLumenPercentageScroll(event.GetPosition());

}
// ----------------------------------------------------------------------------
void wxPnlContourControl::OnSliderCalcPercentageScroll(wxScrollEvent& event)
{
	_quantificationWidget_base->OnSliderCalcPercentageScroll(event.GetPosition());
}

// ----------------------------------------------------------------------------
void wxPnlContourControl::OnCalibration(wxScrollEvent& event)
{
	_quantificationWidget_base->OnCalibration();
}

// ----------------------------------------------------------------------------
void wxPnlContourControl::OnFile(wxScrollEvent& event)
{
	_quantificationWidget_base->OnFile();
}

//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
wxPnlManualContour::wxPnlManualContour(wxWindow* parent,wxQuantificationWidget_base *quantificationWidget_base)  
			:wxPanel(parent,-1){

	marDictionary marDict;
	_quantificationWidget_base=quantificationWidget_base;

//EEDxx 2.6
//	this->SetBackgroundColour(*wxLIGHT_GREY);

	wxStaticText *title		= new wxStaticText(this,-1,wxString(marDict.GetString(803), wxConvUTF8)); // "Contour modification"
//	wxStaticText *blank		= new wxStaticText(this,-1,"   ");
	

	wxFont font(12,wxDEFAULT ,wxNORMAL,wxBOLD);
	title	-> SetFont(font);

//EEDxx 2.6
//	title	-> SetBackgroundColour(*wxLIGHT_GREY);


	//MAZV - texts not included in marDictionary since this is not the final version
	btnContourWall	= new wxButton( this, -1, _T("External wall \ncontour"),wxPoint(0,0),wxSize(92,40));
	btnContourLumen	= new wxButton( this, -1, _T("Lumen contours"),wxPoint(0,0),wxSize(92,40));
	btnContourCalc	= new wxButton( this, -1, _T("Calcification \ncontours"),wxPoint(0,0),wxSize(92,40));
	btnContourHypo	= new wxButton( this, -1, _T("Hipodense \ncontours"),wxPoint(0,0),wxSize(92,40));
	
	
//	btnContourAB		= new wxButton( this, -1, "Active Contour AB",wxPoint(0,0),wxSize(92,20));
	fixContourWall		= new wxButton(this, -1, _T("Replace \nExternal wall") ,wxPoint(0,0),wxSize(92,40));  
	fixContourLumen		= new wxButton(this, -1, _T("Replace \nLumen") ,wxPoint(0,0),wxSize(92,40));  
	fixContourCalc		= new wxButton(this, -1, _T("Replace \nCalcifications") ,wxPoint(0,0),wxSize(92,40)); 
	fixContourHypo		= new wxButton(this, -1, _T("Replace \nHipodense") ,wxPoint(0,0),wxSize(92,40)); 
	
	cbShowAllManual		= new wxCheckBox(this,-1,_T("Show All")); 
	cbShowWall			= new wxCheckBox(this,-1,_T("Show Wall"));
	cbShowLumen			= new wxCheckBox(this,-1,_T("Show Lumen"));  
	cbShowCalc			= new wxCheckBox(this,-1,_T("Show Calcifications"));
	cbShowHypo			= new wxCheckBox(this,-1,_T("Show Hypodense"));

	cbShowAllManual->SetValue(true);
	cbShowWall->SetValue(true);
	cbShowLumen->SetValue(true);
	cbShowCalc->SetValue(true);
	cbShowHypo->SetValue(true);


	wxFlexGridSizer *sizer	= new wxFlexGridSizer(1);

	wxFlexGridSizer		*conts				= new wxFlexGridSizer(4);
	wxFlexGridSizer		*replace			= new wxFlexGridSizer(4);
	wxFlexGridSizer		*options			= new wxFlexGridSizer(5);	


	conts->Add(btnContourWall	,  1, wxALL|wxEXPAND, 0);
	conts->Add(btnContourLumen	,  1, wxALL|wxEXPAND, 0);
	conts->Add(btnContourCalc	,  1, wxALL|wxEXPAND, 0);
	conts->Add(btnContourHypo	,  1, wxALL|wxEXPAND, 0);
	//conts->Add(btnContourAB	,  1, wxALL|wxEXPAND, 0);

	replace->Add(fixContourWall	,  1, wxALL|wxEXPAND, 0);
	replace->Add(fixContourLumen	,  1, wxALL|wxEXPAND, 0);
	replace->Add(fixContourCalc	,  1, wxALL|wxEXPAND, 0);
	replace->Add(fixContourHypo	,  1, wxALL|wxEXPAND, 0);
	//replace->Add(fixContourAB	,  1, wxALL|wxEXPAND, 0);

	options->Add(cbShowAllManual	,  1, wxALL|wxEXPAND, 0);
	options->Add(cbShowWall		,  1, wxALL|wxEXPAND, 0);
	options->Add(cbShowLumen	,  1, wxALL|wxEXPAND, 0);
	options->Add(cbShowCalc		,  1, wxALL|wxEXPAND, 0);
	options->Add(cbShowHypo		,  1, wxALL|wxEXPAND, 0);

	sizer->Add(title		,	1, wxALL|wxEXPAND, 10);
	sizer->Add(conts		,	2, wxALL|wxEXPAND, 10);
	sizer->Add(replace		,	2, wxALL|wxEXPAND, 10);   //wxALIGN_CENTER_HORIZONTAL
	sizer->Add(options		,	2, wxALL|wxEXPAND, 10); 	

	this->SetSizer(sizer);
	this->SetSize(wxSize(400,400));

	Connect(btnContourWall->GetId()		, wxEVT_COMMAND_BUTTON_CLICKED	, (wxObjectEventFunction) &wxPnlManualContour::OnContourWall  );
	Connect(btnContourLumen->GetId()	, wxEVT_COMMAND_BUTTON_CLICKED	, (wxObjectEventFunction) &wxPnlManualContour::OnContourLumen  );
	Connect(btnContourCalc->GetId()		, wxEVT_COMMAND_BUTTON_CLICKED	, (wxObjectEventFunction) &wxPnlManualContour::OnContourCalc );
	Connect(btnContourHypo->GetId()		, wxEVT_COMMAND_BUTTON_CLICKED	, (wxObjectEventFunction) &wxPnlManualContour::OnContourHypo );

	Connect(fixContourWall->GetId()		, wxEVT_COMMAND_BUTTON_CLICKED	, (wxObjectEventFunction) &wxPnlManualContour::OnReplaceContourWall  );
	Connect(fixContourLumen->GetId()	, wxEVT_COMMAND_BUTTON_CLICKED	, (wxObjectEventFunction) &wxPnlManualContour::OnReplaceContourLumen  );
	Connect(fixContourCalc->GetId()		, wxEVT_COMMAND_BUTTON_CLICKED	, (wxObjectEventFunction) &wxPnlManualContour::OnReplaceContourCalc );
	Connect(fixContourHypo->GetId()		, wxEVT_COMMAND_BUTTON_CLICKED	, (wxObjectEventFunction) &wxPnlManualContour::OnReplaceContourHypo );

	Connect(cbShowAllManual->GetId()	, wxEVT_COMMAND_CHECKBOX_CLICKED	, (wxObjectEventFunction) &wxPnlManualContour::OnShowAll );
	Connect(cbShowWall->GetId()		, wxEVT_COMMAND_CHECKBOX_CLICKED	, (wxObjectEventFunction) &wxPnlManualContour::OnShowWall );
	Connect(cbShowLumen->GetId()		, wxEVT_COMMAND_CHECKBOX_CLICKED	, (wxObjectEventFunction) &wxPnlManualContour::OnShowLumen );
	Connect(cbShowCalc->GetId()		, wxEVT_COMMAND_CHECKBOX_CLICKED	, (wxObjectEventFunction) &wxPnlManualContour::OnShowCalc );
	Connect(cbShowHypo->GetId()		, wxEVT_COMMAND_CHECKBOX_CLICKED	, (wxObjectEventFunction) &wxPnlManualContour::OnShowHypo );


}

//------------------------------------------------------------------------
void wxPnlManualContour::OnContourWall(wxCommandEvent& event)
{
	_quantificationWidget_base->OnContourWall();
}
//------------------------------------------------------------------------
void wxPnlManualContour::OnContourLumen(wxCommandEvent& event)
{
	_quantificationWidget_base->OnContourLumen();
}
//------------------------------------------------------------------------
void wxPnlManualContour::OnContourHypo(wxCommandEvent& event)
{
	_quantificationWidget_base->OnContourHypo();
}
//------------------------------------------------------------------------
void wxPnlManualContour::OnContourCalc(wxCommandEvent& event)
{
	_quantificationWidget_base->OnContourCalc();
}

//------------------------------------------------------------------------
void wxPnlManualContour::OnReplaceContourWall(wxCommandEvent& event)
{
	_quantificationWidget_base->OnReplaceContourWall();
}
//------------------------------------------------------------------------
void wxPnlManualContour::OnReplaceContourLumen(wxCommandEvent& event)
{
	_quantificationWidget_base->OnReplaceContourLumen();
}
//------------------------------------------------------------------------
void wxPnlManualContour::OnReplaceContourHypo(wxCommandEvent& event)
{
	_quantificationWidget_base->OnReplaceContourHypo();
}

//------------------------------------------------------------------------
void wxPnlManualContour::OnReplaceContourCalc(wxCommandEvent& event)
{
	_quantificationWidget_base->OnReplaceContourCalc();
}

//------------------------------------------------------------------------
void wxPnlManualContour::OnShowAll(wxCommandEvent& event)
{
	cbShowCalc->SetValue(cbShowAllManual->GetValue());
	cbShowHypo->SetValue(cbShowAllManual->GetValue());
	cbShowLumen->SetValue(cbShowAllManual->GetValue());
	cbShowWall->SetValue(cbShowAllManual->GetValue());
	_quantificationWidget_base->OnShowAll(cbShowAllManual->GetValue());

}

//------------------------------------------------------------------------
void wxPnlManualContour::OnShowWall(wxCommandEvent& event)
{
	_quantificationWidget_base->OnShowWall(cbShowWall->GetValue());
}
//------------------------------------------------------------------------
void wxPnlManualContour::OnShowLumen(wxCommandEvent& event)
{
	_quantificationWidget_base->OnShowLumen(cbShowLumen->GetValue());
}

//------------------------------------------------------------------------
void wxPnlManualContour::OnShowCalc(wxCommandEvent& event)
{
	_quantificationWidget_base->OnShowCalc(cbShowCalc->GetValue());
}

//------------------------------------------------------------------------
void wxPnlManualContour::OnShowHypo(wxCommandEvent& event)
{
	_quantificationWidget_base->OnShowHypo(cbShowHypo->GetValue());
}


//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
wxPanelControlsHealthySickSliceCT::wxPanelControlsHealthySickSliceCT(wxWindow* parent,wxQuantificationWidget_base *quantificationWidget_base)
								: wxPanel(parent,-1)
{
	marDictionary marDict;
//EEDxx 2.6
//	this->SetBackgroundColour(*wxLIGHT_GREY);


	//_quantificationWidget = quantificationWidget;

    wxNotebook *wxnotbook = new wxNotebook(this, -1);
//EEDxx 2.6
//	wxnotbook->SetBackgroundColour(*wxLIGHT_GREY);

	wxPnlSearchStenosis		*page1	= new wxPnlSearchStenosis( wxnotbook , quantificationWidget_base);
	wxPanelSizeHealthyRegion	*page2	= new wxPanelSizeHealthyRegion (wxnotbook , quantificationWidget_base);
	wxPnlManualContour		*page3	= new wxPnlManualContour( wxnotbook , quantificationWidget_base);
	wxPnlContourControl		*page4	= new wxPnlContourControl( wxnotbook , quantificationWidget_base);
	wxnotbook->AddPage(page1, wxString(marDict.GetString(265), wxConvUTF8) ); //"Stenosis search "
	wxnotbook->AddPage(page2, wxString(marDict.GetString(360), wxConvUTF8) ); //"Healty region size "
	wxnotbook->AddPage(page3, wxString(marDict.GetString(800), wxConvUTF8) ); //"Contour modification"
	wxnotbook->AddPage(page4, wxString(marDict.GetString(940), wxConvUTF8) ); //"Contour Control"
	wxnotbook->SetSize(400,315);

	wxFlexGridSizer *sizer		= new wxFlexGridSizer(1);
	sizer->Add(wxnotbook, 1, wxTOP|wxLEFT|wxRIGHT, 5);
	this->SetSizer(sizer);
	this->SetAutoLayout(true);
	this->Layout();
	this->SetSize(400,400);

}



//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------

















//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------



//--------------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------------


wxQuantificationWidget_base::wxQuantificationWidget_base(wxWindow* parent, wxWindowID id,
                                               const wxPoint& pos, const wxSize& size, long style,
                                               const wxString& name)
: wxPanel( parent, id, pos, size, style, name )
{
}


//--------------------------------------------------------------------------------
// Destructor
// ----------------------------------------------------------------------------
wxQuantificationWidget_base::~wxQuantificationWidget_base()  // virtual 
{
}


// ----------------------------------------------------------------------------
void wxQuantificationWidget_base::SetManualContour_ReplaceContour()  // virtual 
{
}

// ----------------------------------------------------------------------------
void wxQuantificationWidget_base::SetManualContour_2DWorld(bool ok)  // virtual 
{
}


// ----------------------------------------------------------------------------
void wxQuantificationWidget_base::SetManualContour_AddPoint_2DWorld() // virtual 
{
}

// ----------------------------------------------------------------------------
void wxQuantificationWidget_base::SetAnalysisTypeStenosis(int analysisTypeStenosis) // virtual 
{
}


// ----------------------------------------------------------------------------
int  wxQuantificationWidget_base::GetActualSlice() // virtual 
{
	return 0;
}

// ----------------------------------------------------------------------------
void wxQuantificationWidget_base::SetHealthySlice(int healthySlice) // virtual 
{
}

// ----------------------------------------------------------------------------
void wxQuantificationWidget_base::GetSliceLimites(int type, int &sliceStart,int &sliceEnd)// virtual 
{
}

// ----------------------------------------------------------------------------
void wxQuantificationWidget_base::Set3DStartRegionSliceActor( int type, int k )// virtual 
{
}

// ----------------------------------------------------------------------------
void wxQuantificationWidget_base::RefreshAxis( )// virtual 
{
}

//------------------------------------------------------------------------
void wxQuantificationWidget_base::OnContourWall()// virtual 
{
}

//------------------------------------------------------------------------
void wxQuantificationWidget_base::OnContourLumen()// virtual 
{
}

//------------------------------------------------------------------------
void wxQuantificationWidget_base::OnContourHypo()// virtual 
{
}

//------------------------------------------------------------------------
void wxQuantificationWidget_base::OnContourCalc()// virtual 
{
}

//------------------------------------------------------------------------
void wxQuantificationWidget_base::OnReplaceContourWall()// virtual 
{
}
//------------------------------------------------------------------------
void wxQuantificationWidget_base::OnReplaceContourLumen()// virtual 
{
}
//------------------------------------------------------------------------
void wxQuantificationWidget_base::OnReplaceContourHypo()// virtual 
{
}

//------------------------------------------------------------------------
void wxQuantificationWidget_base::OnReplaceContourCalc()// virtual 
{
}

//------------------------------------------------------------------------
void wxQuantificationWidget_base::OnSliderDiscontinuityScroll(int percentage) // virtual
{
}

//------------------------------------------------------------------------
void wxQuantificationWidget_base::OnSliderLumenPercentageScroll(int percentage) // virtual
{
}

//------------------------------------------------------------------------
void wxQuantificationWidget_base::OnSliderCalcPercentageScroll(int percentage) // virtual
{
}

//------------------------------------------------------------------------
void wxQuantificationWidget_base::OnCalibration() //virtual
{
}

//------------------------------------------------------------------------
void wxQuantificationWidget_base::OnFile() //virtual
{
}


// ----------------------------------------------------------------------------
kVolume *wxQuantificationWidget_base::GetVolumeAxisExtended(int wz1,int wz2)// virtual 
{
	return NULL;
}

// ----------------------------------------------------------------------------
int  wxQuantificationWidget_base::GetMaxActualSlice()// virtual 
{
	return 0;
}

// ----------------------------------------------------------------------------
void wxQuantificationWidget_base::Set3DRegionSliceActor( int type, int k1,int k2 )// virtual 
{
}

// ----------------------------------------------------------------------------
void wxQuantificationWidget_base::DetectHealthySickSlice( bool minSurf , bool maxSurf )// virtual 
{
}

// ----------------------------------------------------------------------------
void wxQuantificationWidget_base::Show3DStartRegionSliceActor(int type ) // virtual 
{
}


// ----------------------------------------------------------------------------
void wxQuantificationWidget_base::Set3DEndRegionSliceActor( int type, int k ) // virtual 
{
}

// ----------------------------------------------------------------------------
void wxQuantificationWidget_base::Show3DEndRegionSliceActor(int type ) // virtual 
{
}


// ----------------------------------------------------------------------------
void wxQuantificationWidget_base::Hide3DStartRegionSliceActor(int type ) // virtual 
{
}

// ----------------------------------------------------------------------------
void wxQuantificationWidget_base::Hide3DEndRegionSliceActor(int type ) // virtual 
{
}

// ----------------------------------------------------------------------------
int wxQuantificationWidget_base::GetSizeHealthyRegion() // virtual
{
	return 0;
}

// ----------------------------------------------------------------------------
void wxQuantificationWidget_base::SetSizeHealthyRegion(int size) // virtual
{
}
// ----------------------------------------------------------------------------
int  wxQuantificationWidget_base::GetHealthySlice() // virtual
{
	return 0;
}

//------------------------------------------------------------------------
void wxQuantificationWidget_base::OnShowAll(bool value) // virtual
{
	
}

//------------------------------------------------------------------------
void wxQuantificationWidget_base::OnShowWall(bool value) // virtual
{
}
//------------------------------------------------------------------------
void wxQuantificationWidget_base::OnShowLumen(bool value) // virtual
{
}

//------------------------------------------------------------------------
void wxQuantificationWidget_base::OnShowCalc(bool value) // virtual
{
}

//------------------------------------------------------------------------
void wxQuantificationWidget_base::OnShowHypo(bool value) // virtual
{
}
