/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxQuantificationWidget_base.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:18 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef __WX__MARACAS__QUANTIF__WDG__BASE__HXX__
#define __WX__MARACAS__QUANTIF__WDG__BASE__HXX__


#include "vtk3DQuantSurfaceWidget.h"
#include "vtk2DQuantSliceWidget.h"
#include "wxImageViewerWidget.h"

#include "wxChart.h"

#include <wx/wx.h>
#include <wx/slider.h>
#include <wx/panel.h>
#include <wx/minifram.h>
#include <wx/splitter.h>
#include <kernel/marInterface.h>


//------------------------------------------------------------------------
//------------------------------------------------------------------------


//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------



class wxQuantificationWidget_base : public wxPanel, public InterfaceVtkPanelWidgets
{
public:

	// Constructor &  Destructor
	wxQuantificationWidget_base(wxWindow* parent, wxWindowID id,
                                               const wxPoint& pos, const wxSize& size, long style,
                                               const wxString& name);
  
	virtual ~wxQuantificationWidget_base();

	virtual void SetManualContour_ReplaceContour();
	virtual void SetManualContour_2DWorld(bool ok);
    virtual void SetManualContour_AddPoint_2DWorld();
	virtual void SetAnalysisTypeStenosis(int analysisTypeStenosis);
	virtual int  GetActualSlice();
	virtual void SetHealthySlice(int healthySlice=-1);	
	virtual void GetSliceLimites(int type, int &sliceStart,int &sliceEnd);
	virtual void Set3DStartRegionSliceActor( int type, int k );
	virtual void RefreshAxis( );
	virtual kVolume *GetVolumeAxisExtended(int wz1,int wz2);
	virtual int  GetMaxActualSlice();
	virtual void Set3DRegionSliceActor( int type, int k1,int k2 );
	virtual void DetectHealthySickSlice( bool minSurf , bool maxSurf );
	virtual void Show3DStartRegionSliceActor(int type );
	virtual void Set3DEndRegionSliceActor( int type, int k );
	virtual void Show3DEndRegionSliceActor(int type );
	virtual void Hide3DStartRegionSliceActor(int type );
	virtual void Hide3DEndRegionSliceActor(int type );
	virtual int  GetSizeHealthyRegion();
	virtual void SetSizeHealthyRegion(int size);
	virtual int  GetHealthySlice();
	virtual void OnContourWall();
	virtual void OnContourLumen();
	virtual void OnContourHypo();
	virtual void OnContourCalc();
	virtual void OnReplaceContourWall();
	virtual void OnReplaceContourLumen();
	virtual void OnReplaceContourHypo();
	virtual void OnReplaceContourCalc();
	virtual void OnSliderDiscontinuityScroll(int percentage);
	virtual void OnSliderLumenPercentageScroll(int percentage);
	virtual void OnSliderCalcPercentageScroll(int percentage);
	virtual void OnCalibration(); 
	virtual void OnFile();
	virtual void OnShowAll(bool value); 
	virtual void OnShowWall(bool value);
	virtual void OnShowLumen(bool value);
	virtual void OnShowCalc(bool value);
	virtual void OnShowHypo(bool value);
	

private:



};

//------------------------------------------------------------------------
//------------------------------------------------------------------------
class wxPnlSearchStenosisAutomatic: public wxPanel{
public:
	wxPnlSearchStenosisAutomatic(wxWindow* parent, wxQuantificationWidget_base *quantificationWidget_base);
	void OnBtHealthySlice(wxCommandEvent& event);
	void OnBtEndRegion(wxCommandEvent& event);
	void OnBtStart(wxCommandEvent& event);
	void OnBtPlus(wxCommandEvent& event);
	void OnBeginSlider(wxScrollEvent& event);
	void OnEndSlider(wxScrollEvent& event);
	void OnBtMaxSurf(wxCommandEvent& event);
	void OnRbArea(wxCommandEvent& event);
	void OnRbDiameter(wxCommandEvent& event);
	void OnBtAxisMPR(wxCommandEvent& event);

	void SetRange(int min, int max);

private:
	wxQuantificationWidget_base				*_quantificationWidget_base;

//    wxStaticText	*_st1_blank;
    wxStaticText	*_st1_text1;
    wxStaticText	*_st1_next1;
    wxStaticText	*_st1_next2;
    wxStaticText	*_st1_next3;
    wxStaticText	*_st1_cero;
    wxStaticText	*_st1_one;
    wxStaticText	*_st1_two;
    wxStaticText	*_st1_three;
    wxButton		*_bt1_HealthySlice;
    wxButton		*_bt1_EndRegion;
    wxButton		*_bt1_Start;

	// Special Panel
	wxButton		*_bt_plus;
	wxPanel			*_panelSpecial;
	wxStaticText	*_st_BeginRegion;
	wxStaticText	*_st_EndRegion;
	wxSlider		*_sl_BeginRegion;
	wxSlider		*_sl_EndRegion;
    wxRadioButton	*_rb_diameter;
    wxRadioButton	*_rb_surface;
	wxButton		*_bt_MaxSurface;

}; 
//------------------------------------------------------------------------
//------------------------------------------------------------------------
class wxPnlSearchStenosisManual : public wxPanel{
public:
	wxPnlSearchStenosisManual(wxWindow* parent, wxQuantificationWidget_base *quantificationWidget_base);
	void OnBtHealthySlice(wxCommandEvent& event);

private:
	wxQuantificationWidget_base				*_quantificationWidget_base;
//    wxStaticText	*_st2_blank;
    wxStaticText	*_st2_text1;
    wxStaticText	*_st2_text2;
    wxStaticText	*_st2_next1;
    wxStaticText	*_st2_next2;
    wxStaticText	*_st2_cero;
    wxStaticText	*_st2_one;
    wxStaticText	*_st2_two;
    wxButton		*_bt2_HealthySlice;
}; 
//------------------------------------------------------------------------
//------------------------------------------------------------------------
class wxPnlSearchStenosis : public wxPanel{
public:
	wxPnlSearchStenosis(wxWindow* parent,wxQuantificationWidget_base *quantificationWidget_base);
	void OnRbAutomatic(wxCommandEvent& event);
	void OnRbManual(wxCommandEvent& event);
	wxPnlSearchStenosisAutomatic* GetPanelAutomatic();

private:
	wxQuantificationWidget_base	*_quantificationWidget_base;
	// Automatic Stenosis Quantification Panel
	wxPnlSearchStenosisAutomatic	*_panelAutomatic;
	// Manual Stenosis Quantification Panel
	wxPanel							*_panelManual;
}; 
//------------------------------------------------------------------------
//------------------------------------------------------------------------

class wxPanelSizeHealthyRegion : public wxPanel {
public :
	wxPanelSizeHealthyRegion(wxWindow* parent, wxQuantificationWidget_base *quantificationWidget_base);
private:
	wxQuantificationWidget_base	*_quantificationWidget_base;
	wxSlider					*_sl_Size;

	void OnButtonRefresh(wxScrollEvent& event);
};
//------------------------------------------------------------------------
//------------------------------------------------------------------------
class wxPnlModifyContour : public wxPanel{
public:
	wxPnlModifyContour(wxWindow* parent,wxQuantificationWidget_base *quantificationWidget_base);
	void OnNewContour(wxCommandEvent& event);
	void OnFixContour(wxCommandEvent& event);

	
private:
    wxQuantificationWidget_base				*_quantificationWidget_base;
	wxButton		*_newContour;
	wxButton		*_editContour;
	wxButton		*_fixContour;
	wxButton		*_cancelContour;
	wxRadioButton	*_insert;
	wxRadioButton	*_erase;
	wxRadioButton	*_move;

	wxStaticText	*_one;
	wxStaticText	*_two;
	wxStaticText	*_three;
	wxStaticText	*_msg;

}; 


//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
class wxPanelControlsHealthySickSlice2 : public wxPanel{
public:
	wxPanelControlsHealthySickSlice2(wxWindow* parent , wxQuantificationWidget_base *quantificationWidget_base);
	wxPnlSearchStenosis *GetPnlSearStenosis();
private: 
	wxPnlSearchStenosis			*wxpnlsearchstenosis;
};  

//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
class wxPnlContourControl : public wxPanel{
public:


	wxPnlContourControl(wxWindow* parent,wxQuantificationWidget_base *quantificationWidget_base);
	void OnSliderDiscontinuityScroll(wxScrollEvent& event);
	void OnSliderLumenPercentageScroll(wxScrollEvent& event);
	void OnSliderCalcPercentageScroll(wxScrollEvent& event);
	void OnCalibration(wxScrollEvent& event);
	void OnFile(wxScrollEvent& event);

private:
	wxQuantificationWidget_base	*_quantificationWidget_base;
	wxSlider					*_sl_Discontinuity;
	wxSlider					*_sl_LumenPercentage;
	wxSlider					*_sl_CalcPercentage;
	wxButton					*btnCalibration;
	wxButton					*btnFile;

	wxStaticText				*_st_Discontinuity;
	wxStaticText				*_st_LumenPercentage;
	wxStaticText				*_st_CalcPercentage;
};

//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
class wxPanelControlsHealthySickSliceCT : public wxPanel{
public:
	wxPanelControlsHealthySickSliceCT(wxWindow* parent , wxQuantificationWidget_base *quantificationWidget_base);
private: 
};


//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
class wxPnlManualContour : public wxPanel{
public:
	wxPnlManualContour(wxWindow* parent,wxQuantificationWidget_base *quantificationWidget_base);
	void OnContourWall(wxCommandEvent& event);
	void OnContourLumen(wxCommandEvent& event);
	void OnContourHypo(wxCommandEvent& event);
	void OnContourCalc(wxCommandEvent& event);
	void OnReplaceContourWall(wxCommandEvent& event);
	void OnReplaceContourLumen(wxCommandEvent& event);
	void OnReplaceContourHypo(wxCommandEvent& event);
	void OnReplaceContourCalc(wxCommandEvent& event);
	void OnShowAll(wxCommandEvent& event);
	void OnShowWall(wxCommandEvent& event);
	void OnShowLumen(wxCommandEvent& event);
	void OnShowCalc(wxCommandEvent& event);
	void OnShowHypo(wxCommandEvent& event);

private:
	wxQuantificationWidget_base	*_quantificationWidget_base;
	wxButton					*btnContourWall;
	wxButton					*btnContourLumen;
	wxButton					*btnContourCalc;
	wxButton					*btnContourHypo;
	wxButton					*btnContourAB;
	wxButton					*fixContourWall;
	wxButton					*fixContourLumen;
	wxButton					*fixContourCalc;
	wxButton					*fixContourHypo;
	wxCheckBox					*cbShowAllManual; 
	wxCheckBox					*cbShowWall;
	wxCheckBox					*cbShowLumen;
	wxCheckBox					*cbShowCalc;
	wxCheckBox					*cbShowHypo;
	
};

#endif // __WX__MARACAS__QUANTIF__WDG__BASE__HXX__

