/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/////////////////////////////////////////////////////////////////////////////
// Name:        Test_ReadingPriorityFrm.cpp
// Purpose:     
// Author:      
// Modified by: 
// Created:     
// RCS-ID:      
// Copyright:   (C)2003 
// Licence:     wxWindows
/////////////////////////////////////////////////////////////////////////////

// ----------------------------------------------------------------------------
// headers
// ----------------------------------------------------------------------------
#include "wx/wxprec.h"
#include <wx/thread.h>


#ifndef WX_PRECOMP
	#include "wx/wx.h"
#endif

#include "wxReadingPriorityPanel.h"


// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
PriorityLoop::PriorityLoop(){
	_vecIdImage			=	NULL;
	_loadingSerie		=	false;
	_forceReadRegion	=	false;
	_i_forceReadReagion =	-1;
	_needToChange       =   false;
	_deltaImg			=	0;
}
// ----------------------------------------------------------------------------
PriorityLoop::~PriorityLoop(){
	if (_vecIdImage!=NULL) {
		free(_vecIdImage);
	}
}
// ----------------------------------------------------------------------------
void PriorityLoop::StopLoop(){
	_loadingSerie =	false;
}
// ----------------------------------------------------------------------------
bool PriorityLoop::IsLoop(){
	return _loadingSerie;
}
// ----------------------------------------------------------------------------
void PriorityLoop::ForceEndLoopRegion(){
	_forceReadRegion=true;
}

// ----------------------------------------------------------------------------
void PriorityLoop::InitLoop(){
	_loadingSerie = true;
	NeedToChange();
	Create_Empty_Vector();
	InitConfiguration();
	_counterReading = 0;
}

// ----------------------------------------------------------------------------
void PriorityLoop::Iteration(){

	NeedToChange();

	if (_forceReadRegion==false){
		int ii,i=Get_i_image();
		for (ii=i-_deltaImg;ii<=i+_deltaImg;ii++){
			if (_Action_i( ii )==true){
				_counterReading++;
			}
		}
	} else {
		_loadingSerie=_ForceEndLoopRegion();
	}

	if (_counterReading==_maxImages){
		_loadingSerie=false;
	}

}

// ----------------------------------------------------------------------------
bool PriorityLoop::_ForceEndLoopRegion (){
	bool ok=true;
	if (_i_forceReadReagion==-1){
		_i_forceReadReagion=_start;
	}
	_Action_i( _i_forceReadReagion );
	_i_forceReadReagion++;
	if (_i_forceReadReagion>_end){
		ok=false;
	}
	return ok;
}
// ----------------------------------------------------------------------------
void PriorityLoop::Create_Empty_Vector(){
	if (_vecIdImage!=NULL) {
		free(_vecIdImage);
	}
	_vecIdImage =  (bool*)malloc(sizeof(bool)*(_maxImages+1) );
	int i;
	for (i=0; i<=_maxImages;i++){
		_vecIdImage[i]=false;
	}	

}

// ----------------------------------------------------------------------------
void PriorityLoop::SetStartEndActualMax(int start,int end, int actual, int deltaImg,int maxImages){
	_tstart		= start;
	_tend		= end;
	_tactual	= actual;
	_tdeltaImg	= deltaImg;
	_tmaxImages	= maxImages;
	_needToChange = true;
}
// ----------------------------------------------------------------------------
void PriorityLoop::NeedToChange(){
	if (_needToChange==true){
		_needToChange	= false;
		_start			= _tstart;
		_end			= _tend;
		_actual			= _tactual;
		_deltaImg		= _tdeltaImg;
		_maxImages		= _tmaxImages;
		InitConfiguration();
	}
}

// ----------------------------------------------------------------------------
void PriorityLoop::InitConfiguration(){
	_forceReadRegion=false;
	int i;
	for (i=0;i<PriorityLoadImage_MAX_P;i++){
		_dg[i]=false;
		_counterActual[i]=0;
	}
	_priorityType=0;
	_priority=9;
}

// ----------------------------------------------------------------------------
bool PriorityLoop::_Action_i( int i ){
	bool ok=false;
	if (i!=-1) {
		if ((i>=0) && (i<_maxImages)){
			if (_vecIdImage[i]==false ) {
				Action_i(i);
				_vecIdImage[i]=true;
				ok=true;
			}
		}
	}
	return ok;
}

// ----------------------------------------------------------------------------
void PriorityLoop::Action_i( int i ){
}

// ----------------------------------------------------------------------------
int PriorityLoop::Get_i_image(){
	int p=4;

	int i=-1;
	while ((i==-1) || (p==4) ){
		if (_priorityType==0){
			if ((_priority<=9) && (_priority>=5))	{ p=0; }
			if ((_priority<=4) && (_priority>=2))	{ p=1; }
			if ((_priority<=1) && (_priority>=0))	{ p=2; }
		}
		if (_priorityType==1){
			if ((_priority<=9) && (_priority>=4))	{ p=1; }
			if ((_priority<=3) && (_priority>=2))	{ p=2; }
			if ((_priority<=1) && (_priority>=0))	{ p=3; }
		}
		if (_priorityType==2){
			if ((_priority<=9) && (_priority>=3))	{ p=2; }
			if ((_priority<=2) && (_priority>=0))	{ p=3; }
		}
		if (_priorityType==3){
			if ((_priority<=9) && (_priority>=0))	{ p=3; }
		}
		if (_priorityType==4){
			p=4;
		}
		_priority--;
		if (_priority==-1) {_priority=9;}

		if (p==0) { i=Geti(p,5,_start,_actual		,_actual		,_end);			}
		if (p==1) { i=Geti(p,1,_start,_actual		,_actual		,_end);			}
		if (p==2) { i=Geti(p,5,0	 ,_start		,_end			,_maxImages);	}
		if (p==3) { i=Geti(p,1,0	 ,_start		,_end			,_maxImages);	}
		if (p==4) { i=Geti(p,1,0	 ,_maxImages	,_maxImages		,_maxImages);	}

		if ((_priorityType==0) && (p==0) && (i==-1)) { _priorityType++; _priority=9; }
		if ((_priorityType==1) && (p==1) && (i==-1)) { _priorityType++; _priority=9; }
		if ((_priorityType==2) && (p==2) && (i==-1)) { _priorityType++; _priority=9; }
		if ((_priorityType==3) && (p==3) && (i==-1)) { _priorityType++; _priority=9; }
	}
	return i;
}

// ----------------------------------------------------------------------------

int PriorityLoop::Geti(int id,int step,int start,int actualg,int actuald,int end){
	int tempig=0;
	int tempid=0;
	int i=-2;
	while (i==-2){
		if (_dg[id]==true) { _counterActual[id] = _counterActual[id]+step; }
		tempig=actualg - _counterActual[id];
		tempid=actuald + _counterActual[id];
		if (_dg[id]==true){
			if (tempig>=start) { 
				if (_vecIdImage[tempig]==false ) {
					i=tempig;
				}
			}
		}
		if (_dg[id]==false){
			if (tempid<=end) { 
				if (_vecIdImage[tempid]==false ) {
					i=tempid;
				}
			}
		}
		if ((tempig<start) && (tempid>end)){
			i=-1;
		}
		_dg[id]=!_dg[id];
	}
	return i;
}
// ----------------------------------------------------------------------------
void PriorityLoop::WaitUntil_i_isDone(int i){
	WaitUntil_segment_isDone(i-_deltaImg,i+_deltaImg,false);
}
// ----------------------------------------------------------------------------
void PriorityLoop::WaitUntil_segment_isDone(int start, int end,bool forceEndLoopRegion){
	if (forceEndLoopRegion==true) { ForceEndLoopRegion(); }
	if (_loadingSerie==true){
		int s=start,e=end;
		if (s<0){
			s=0;
		}
		if (e>_maxImages-1){
			e=_maxImages-1;
		}
		bool ok=false;
		while (ok==false){
			int i;
			ok=true;
			for (i=s;i<=e;i++){
				ok = ok && _vecIdImage[i];
			}
			if (ok==false) { 
				RefreshForce();
				wxThread::Sleep(100); 
			}
		}
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
PriorityLoadImageBar::PriorityLoadImageBar(marFilesBase *marfilesbase, BarLoading *bar){
	_marfilesbase=marfilesbase;
	_bar=bar;
}
// ----------------------------------------------------------------------------
PriorityLoadImageBar::~PriorityLoadImageBar(){
}
// ----------------------------------------------------------------------------
void PriorityLoadImageBar::Action_i(int i){

	if (_bar!=NULL){

// EED 09 Oct 2007 
		_bar->SetI(i);

		#if defined(WIN32)
//			_bar->Refresh(false);
			//_bar->Paint();
//			Sleep(1);
		#else
//			_bar->Refresh(false);
//			_bar->Update();
//			_bar->Paint();
//			usleep(1000);
		#endif
	}


	if (_marfilesbase!=NULL){
		_marfilesbase->loadImage(i);
		vtkImageData *imagedata = _marfilesbase->getVolume()->castVtk();
		imagedata->Update();
	}
}
// ----------------------------------------------------------------------------
void PriorityLoadImageBar::RefreshForce(){
	_bar->RefreshForce();
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

IMPLEMENT_CLASS(BarLoading, wxPanel)
BEGIN_EVENT_TABLE(BarLoading, wxPanel)
	 EVT_PAINT(BarLoading::OnPaint)
END_EVENT_TABLE()

static wxMutex *s_mutexProtectingTheGlobalData=NULL;


// ----------------------------------------------------------------------------
BarLoading::BarLoading(wxWindow *parent, int w, int h) 
 :wxPanel(parent,-1,wxDefaultPosition,wxDefaultSize,wxTAB_TRAVERSAL)
{
	_w=w;
	_h=h;
	SetSize(_w,_h);
	SetWindowStyle(wxNO_FULL_REPAINT_ON_RESIZE);
	_bitmap = new wxBitmap(_w,_h);
	_flag_bitmap=true;
	_flag2_bitmap=true;

	if (s_mutexProtectingTheGlobalData!=NULL)
	{
		delete s_mutexProtectingTheGlobalData;
		s_mutexProtectingTheGlobalData=NULL;
	}
	s_mutexProtectingTheGlobalData = new wxMutex();
	Reset();
}

// ----------------------------------------------------------------------------
BarLoading::~BarLoading()
{
}
// ----------------------------------------------------------------------------
void BarLoading::SetI(int i)
{

s_mutexProtectingTheGlobalData->Lock();

	_flag_bitmap=false;

	while (_flag2_bitmap==false){
		//sleep force
#if defined(WIN32)
		Sleep(1);
#else
//		usleep(1000);
#endif
	}

/*
	wxMemoryDC temp_dc;
	temp_dc.SelectObject( *_bitmap );
	int x = (_w*i)/_sizeData;
	int d = (_w/_sizeData)+1;
	temp_dc.SetBrush(wxBrush( wxColour(0,0,255),wxSOLID  ));
	temp_dc.SetPen(wxPen( wxColour(0,0,255),1,wxSOLID  ));
	temp_dc.DrawRectangle(x,0,d,_h);
*/

       lstInt.push_back(i);

s_mutexProtectingTheGlobalData->Unlock();
	_flag_bitmap=true;

}
// ----------------------------------------------------------------------------
void BarLoading::RefreshForce()
{
//	Refresh();
//	Update();
}
// ----------------------------------------------------------------------------
void BarLoading::SetSizeData(int sizeData)
{
   _sizeData=sizeData;
}
// ----------------------------------------------------------------------------
void BarLoading::Reset()
{
	if (_flag_bitmap==true){
		wxMemoryDC temp_dc;
		temp_dc.SelectObject( *_bitmap );
		temp_dc.SetBrush(wxBrush( wxColour(255,0,0),wxSOLID  ));
		temp_dc.SetPen(wxPen( wxColour(255,0,0),1,wxSOLID  ));
		temp_dc.DrawRectangle(0,0,_w,_h);
		lstInt.clear();
	}
}


// ----------------------------------------------------------------------------
void BarLoading::Paint( )
{
  _flag2_bitmap=false;
  wxMutexLocker lock(*s_mutexProtectingTheGlobalData);


	if (_flag_bitmap==true){
	        wxMemoryDC temp_dc;
		temp_dc.SelectObject( *_bitmap );
	
	int i,ii,size=lstInt.size();
        for (ii=0;ii<size; ii++)
	{
		i=lstInt[ii];
		int x = (_w*i)/_sizeData;
		int d = (_w/_sizeData)+1;
		temp_dc.SetBrush(wxBrush( wxColour(0,0,255),wxSOLID  ));
		temp_dc.SetPen(wxPen( wxColour(0,0,255),1,wxSOLID  ));
		temp_dc.DrawRectangle(x,0,d,_h);
	}
	lstInt.clear();




		wxPaintDC dc( this );
		dc.Blit(0,0, _w, _h, &temp_dc, 0, 0);
	}
	_flag2_bitmap=true;//SIL//POR QUE TANTAS VECES LO MISMO??????
	_flag2_bitmap=true;
	_flag2_bitmap=true;
	_flag2_bitmap=true;
	_flag2_bitmap=true;
	_flag2_bitmap=true;


}


// ----------------------------------------------------------------------------
void BarLoading::OnPaint( wxPaintEvent &WXUNUSED(event) )
{
	Paint();
}


// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
/* EED Borrame
IMPLEMENT_CLASS(BarRange, wxPanel)
BEGIN_EVENT_TABLE(BarRange, wxPanel)
	 EVT_PAINT(BarRange::OnPaint)
END_EVENT_TABLE()


BarRange::BarRange(wxWindow *parent, int w, int h)
 :wxPanel(parent,-1,wxDefaultPosition,wxDefaultSize,wxTAB_TRAVERSAL)
{
	_w=w;
	_h=h;
	SetSize(_w,_h);
	SetWindowStyle(wxNO_FULL_REPAINT_ON_RESIZE);
	_bitmap = new wxBitmap(_w,_h);

	_start = 0;
	_max   = 100;
	_end   = _max;
}
// ----------------------------------------------------------------------------
BarRange::~BarRange()
{
}
// ----------------------------------------------------------------------------
void BarRange::SetStart(int i)
{
	_start=i;
}
// ----------------------------------------------------------------------------
void BarRange::SetActual(int i)
{
	_actual=i;
}
// ----------------------------------------------------------------------------
void BarRange::SetEnd(int i)
{
	_end=i;
}
// ----------------------------------------------------------------------------
void BarRange::SetMax(int i)
{
	_max=i;
}
// ----------------------------------------------------------------------------
void BarRange::OnPaint( wxPaintEvent &WXUNUSED(event) )
{

	RefreshView();

    wxMemoryDC temp_dc;
	temp_dc.SelectObject( *_bitmap );
	wxPaintDC dc( this );
	dc.Blit(0,0, _w, _h, &temp_dc, 0, 0);

}
// ----------------------------------------------------------------------------

void BarRange::RefreshView()
{
	wxPoint points[3];

	int px1=(_w*_start)/_max;
	int px2=(_w*_end)/_max;
	int px3=(_w*_actual)/_max;

	wxMemoryDC temp_dc;
	temp_dc.SelectObject( *_bitmap );

	// Background
	wxColour colourParent =  GetParent()->GetBackgroundColour();
	temp_dc.SetBrush(wxBrush( colourParent ,wxSOLID  ));
	temp_dc.SetPen(wxPen( colourParent ,1,wxSOLID  ));
	temp_dc.DrawRectangle(0,0,_w,_h);

	// Yellow line
	temp_dc.SetBrush(wxBrush( wxColour(255,0,255),wxSOLID  ));
	temp_dc.SetPen(wxPen( wxColour(255,0,255),1,wxSOLID  ));
	temp_dc.DrawRectangle( px1 , 0 , px2-px1 , _h );

	// 2 Start End ( triangles )
	temp_dc.SetBrush(wxBrush( wxColour(0,0,255),wxSOLID  ));
	temp_dc.SetPen(wxPen( wxColour(0,0,255),1,wxSOLID  ));
	points[0].x=0;
	points[0].y=0;
	points[1].x=-3;
	points[1].y=_h;
	points[2].x=3;
	points[2].y=_h;
	temp_dc.DrawPolygon(3,points,px1,0);
	temp_dc.DrawPolygon(3,points,px2,0);

	// Actual ( black triangles )
	// 2 Start End ( yellow triangles )
	temp_dc.SetBrush(wxBrush( wxColour(255,255,0),wxSOLID  ));
	temp_dc.SetPen(wxPen( wxColour(255,255,0),1,wxSOLID  ));
	points[0].x = -3;
	points[0].y = 0;
	points[1].x = 3;
	points[1].y = 0;
	points[2].x = 0;
	points[2].y = _h;
	temp_dc.DrawPolygon(3,points,px3,0);

}
// ----------------------------------------------------------------------------
void BarRange::RefreshForce()
{
	Refresh();
	Update();
}
// ----------------------------------------------------------------------------
*/

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------



/*
PriorityBar::PriorityBar(BarLoading *bar){
	_bar = bar;
}
// ----------------------------------------------------------------------------
PriorityBar::~PriorityBar(){
}
// ----------------------------------------------------------------------------
void PriorityBar::Action_i(int i){
	_bar->SetI(i);
	_bar->Refresh();
	wxThread::Sleep(100); 
}
// ----------------------------------------------------------------------------
void PriorityBar::RefreshForce(){
	_bar->RefreshForce();
}
*/

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
AdminThreadEED::AdminThreadEED()
: m_condAllDone(m_mutexAllDone){

	 // the mutex associated with a condition must be initially locked, it will
    // only be unlocked when we call Wait()
    m_mutexAllDone.Lock();
    m_waitingUntilAllDone = FALSE;

}
// ----------------------------------------------------------------------------
AdminThreadEED::~AdminThreadEED(){
	// the mutex must be unlocked before being destroyed
    m_mutexAllDone.Unlock();
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
MyThread::MyThread(PriorityLoop *priorityLoop,AdminThreadEED *adminThreadEED){
   _priorityLoop	=	priorityLoop;
   _adminThreadEED	=	adminThreadEED;

}

// ----------------------------------------------------------------------------
void MyThread::OnExit(){
    _priorityLoop->StopLoop();
    wxCriticalSectionLocker locker(_adminThreadEED->m_critsect);
    wxArrayThread& threads = _adminThreadEED->m_threads;
    threads.Remove(this);

    if ( threads.IsEmpty() )    {
        if ( _adminThreadEED->m_waitingUntilAllDone ){
            _adminThreadEED->m_waitingUntilAllDone = FALSE;
            wxMutexLocker lock(_adminThreadEED->m_mutexAllDone);
            _adminThreadEED->m_condAllDone.Signal();
        }
    }
}
// ----------------------------------------------------------------------------

void *MyThread::Entry(){
	_priorityLoop->InitLoop();
	while ( _priorityLoop->IsLoop()==true ){
        if ( TestDestroy() ){
            break;
		}
		_priorityLoop->Iteration();
    }
    return NULL;
}



// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------


// ----------------------------------------------------------------------------
LoadRangeImage::LoadRangeImage(wxWindow *parent,marFilesBase *marfilesbase ) 
: wxPanel(parent, -1)
{
	_marfilesbase		= marfilesbase;
	
    wxPanel *panel		= new wxPanel(this, -1);
	int wx=550;
	_bar				= new BarLoading(panel,wx-10,15);
	//SIL//_barRange			= new BarRange(panel,wx-10,5);
	//SIL//
	_sl_barRange_ROI	= new mBarRange(panel,wx-10 ,70);
	_sl_barRange_ROI-> SetOrientation(true);
	_sl_barRange_ROI -> setVisibleLabels ( true );
	_sl_barRange_ROI -> setActiveStateTo ( true );	
	_sl_barRange_ROI -> setDeviceBlitStart (2,2);
	_sl_barRange_ROI -> setDeviceEndMargin(0);
	_sl_barRange_ROI -> SetTrianglesHalfWidth(5);

	
	parent->SetBackgroundColour(wxColour(255,255,255 )) ;
	panel->SetBackgroundColour(parent-> GetBackgroundColour());

/*
	parent->SetBackgroundColour(wxColour(255,0,0 )) ;
	panel->SetBackgroundColour(wxColour(0,255,0 )) ;*/
	/*
	panel->SetBackgroundColour(wxColour(0,0,0 ));
	parent->SetBackgroundColour(wxColour(255,0,0 ));
	(parent->GetParent())->SetBackgroundColour(wxColour(0,255,0 )) ;
	((parent->GetParent())->GetParent())->SetBackgroundColour(wxColour(0,0,255 )) ;*/
	

	_sl_barRange_ROI-> setBackgroundColor( parent-> GetBackgroundColour()/*wxColour(255,255,255 )*/);
	reseteableActual =true;


/*_//SIL//
	_sldActual			= new wxSlider(panel,-1,0,0,10000,wxDefaultPosition,wxSize(wx-10,20),wxSL_HORIZONTAL);
	
	_btnStart			= new wxButton(panel,-1,_T("Start:"),wxDefaultPosition, wxSize(70,20) );
	_btnEnd				= new wxButton(panel,-1,_T("End:"),wxDefaultPosition, wxSize(70,20) );
	_textActual			= new wxStaticText(panel,-1,_T("Actual: 0000000000"));*/
	_textActual			= new wxStaticText(panel,-1,_T("  "));

//EEDxx2.4
//	_sldActual	->SetSize(wx-10,20);
//	_btnStart	->SetSize(70,20);
//	_btnEnd		->SetSize(70,20);

	//SIL//_sizer1a = new wxFlexGridSizer(1);
	//SIL//_sizer1a->Add(_btnStart  					);
	//SIL//_sizer1a->Add(_textActual ,wxALIGN_CENTER,0	);
	//SIL//_sizer1a->Add(_btnEnd						);

//	_btnStart	->Show(true);
//	_btnEnd		->Show(true);

	//SIL//_sizer1a->Show(_btnStart, false);
	//SIL//_sizer1a->Show(_btnEnd, false);


//	_sizer1a = new wxFlexGridSizer(1);
//	_sizer1a->Add(_textActual ,wxALIGN_CENTER,0	);

	wxFlexGridSizer *sizer1 = new wxFlexGridSizer(1);
//	sizer1->AddGrowableRow(1);
//	wxBoxSizer *sizer1 =  new wxBoxSizer(wxVERTICAL );
	//SIL//sizer1->Add(_sldActual);
	sizer1->Add(_bar);
	//SIL//sizer1->Add(_barRange);
	//SIL//
	sizer1->Add(_sl_barRange_ROI,1,wxEXPAND,0);

	wxFlexGridSizer *sizer = new wxFlexGridSizer(2);
//	sizer -> AddGrowableRow(1);//SIL//
//	sizer->Add(_sizer1a, 1, wxALL , 5 );
	sizer->Add(_textActual);
	sizer->Add(sizer1,1,wxEXPAND,0);



	/*wxBoxSizer *sizer = new wxBoxSizer( wxVERTICAL );
	sizer->Add(_bar, 0, wxEXPAND);	
	sizer->Add(_sl_barRange_ROI, 0, wxEXPAND);*/


/*//SIL//
	Connect(_btnStart->GetId()  , wxEVT_COMMAND_BUTTON_CLICKED	, (wxObjectEventFunction) (wxCommandEventFunction) &LoadRangeImage::OnBtnStart		);
	Connect(_btnEnd->GetId()	, wxEVT_COMMAND_BUTTON_CLICKED	, (wxObjectEventFunction) (wxCommandEventFunction) &LoadRangeImage::OnBtnEnd			);
*/
	//Connect(_sldActual->GetId() , wxEVT_COMMAND_SLIDER_UPDATED	, (wxObjectEventFunction) (wxEventFunction) (wxScrollEventFunction) &LoadRangeImage::OnSliceActual	);
	//SIL//
	Connect(_sl_barRange_ROI->GetId(),wxEVT_TSBAR,(wxObjectEventFunction) (wxCommandEventFunction) &LoadRangeImage::OnBarrange );
	Connect(_sl_barRange_ROI->GetId(),wxEVT_TSBAR_START,(wxObjectEventFunction) (wxCommandEventFunction)  &LoadRangeImage::OnStartChange_BarRange );
	Connect(_sl_barRange_ROI->GetId(),wxEVT_TSBAR_END,(wxObjectEventFunction) (wxCommandEventFunction)  &LoadRangeImage::OnEndChange_BarRange );
	Connect(_sl_barRange_ROI->GetId(),wxEVT_TSBAR_ACTUAL,(wxObjectEventFunction) (wxCommandEventFunction)  &LoadRangeImage::OnActualChange_BarRange );
	Connect(_sl_barRange_ROI->GetId(),wxEVT_TSBAR_MOVED,(wxObjectEventFunction) (wxCommandEventFunction)  &LoadRangeImage::OnBarMoved_BarRange );
	Connect(_sl_barRange_ROI->GetId(),wxEVT_SELECTION_END,(wxObjectEventFunction) (wxCommandEventFunction)  &LoadRangeImage::OnSelectionEnd_BarRange );

	// EED
	_timer=NULL;
#if defined(WIN32)
	//...
#else
    _timer = new wxTimer(this);
	_timer->Start(100);
    Connect( _timer->GetId(), wxEVT_TIMER , (wxObjectEventFunction) (wxTimerEventFunction)  &LoadRangeImage::OnTimer );
#endif


	panel->SetSizer(sizer);
	panel->SetAutoLayout( TRUE );

	this->SetSize(wx,75);
	panel->SetSize(wx,75);

	_mythread			= NULL;
	_priorityLoadImageBar		= new PriorityLoadImageBar(_marfilesbase,_bar);
	_adminThreadEED			= new AdminThreadEED();
}
// ----------------------------------------------------------------------------
LoadRangeImage::~LoadRangeImage()
{
	if (_timer!=NULL){
		_timer->Stop();
		delete _timer;
	}
	_Stop();
}

// ----------------------------------------------------------------------------
void LoadRangeImage::ResetLoadRegion()
{
	int s,e,a;
	s=_startSlice;
	e=_endSlice;
	//SIL//a=_sldActual->GetValue();
	//a=_sl_barRange_ROI->GetActual();
	a = _toShowSlice;
	if ((a<s) || (a>e))
	{
		s=0;
		e=_maxZ;
	} 
	_priorityLoadImageBar->SetStartEndActualMax(s,e,a,0,_maxZ);
}

// ----------------------------------------------------------------------------
void LoadRangeImage::Start(  )
{

    vtkImageData *vol = _marfilesbase->getVolume( )->castVtk();
	int dim[3];
	vol->GetDimensions(dim);
	_maxZ=dim[2]-1;

	_startSlice	=	0;
	_endSlice	=	_maxZ;

	this->SetStartSlice(_startSlice);
	this->SetEndSlice(_endSlice);


	_bar ->			SetSizeData(_maxZ);
//SIL// Para quitar luego als siguientes dos lineas
	/*_sldActual ->	SetRange(0, _maxZ);
	_sldActual ->	SetValue( _maxZ/2 );*/

	//SIL//
	_sl_barRange_ROI -> setRepresentedValues (0,_maxZ);
	_sl_barRange_ROI -> SetActual(_maxZ/2);
	_sl_barRange_ROI -> RefreshForce();	


	SetStartSlice( 0 );
	SetEndSlice( _maxZ );
	_toShowSlice = _sl_barRange_ROI->GetActual();
	RefreshSlice();

//EEDx44
	_marfilesbase->ResetLstFileNotReaded();

	_Start();
}
// ----------------------------------------------------------------------------
void LoadRangeImage::_Start()
{

	ResetLoadRegion();
	_mythread = new MyThread (_priorityLoadImageBar,_adminThreadEED);
	_mythread->Create();
	wxCriticalSectionLocker enter(_adminThreadEED->m_critsect);
	_adminThreadEED->m_threads.Add(_mythread);
	if ( _mythread->Run() != wxTHREAD_NO_ERROR ){
		wxLogError(wxT("Can't start thread!"));
	}
}
// ----------------------------------------------------------------------------
void LoadRangeImage::_Stop(  )
{

    _adminThreadEED->m_critsect.Enter();
    // stop the last thread
    if ( _adminThreadEED->m_threads.IsEmpty() ){
        //wxLogError(wxT("No thread to stop!"));
       _adminThreadEED->m_critsect.Leave();
    } else {
        wxThread *_mythread = _adminThreadEED->m_threads.Last();
        // it's important to leave critical section before calling Delete()
        // because delete will (implicitly) call OnExit() which also tries
        // to enter the same crit section - would dead lock.
        _adminThreadEED->m_critsect.Leave();
        _mythread->Delete();
    }

}

// ----------------------------------------------------------------------------
/*
void LoadRangeImage::OnBtnRestart( wxCommandEvent& event ){
	_priorityLoadImageBar->WaitUntil_segment_isDone( _sldStart->GetValue(),_sldEnd->GetValue() );

	OnBtnStop(event);
	_bar->Reset();
	_bar->Refresh();
}
*/
// ----------------------------------------------------------------------------
void LoadRangeImage::OnSliceActual(wxScrollEvent& event)
{
	//SIL// metodo para quitar
	_toShowSlice = _sl_barRange_ROI->GetActual();
	ResetLoadRegion();
	RefreshSlice();
}

// ----------------------------------------------------------------------------

void LoadRangeImage::OnBtnStart( wxCommandEvent &  event )
{
	//SIL// metodo para quitar
	/*SetStartSlice( _sldActual->GetValue() );
	ResetLoadRegion();
	RefreshSlice();*/
}

// ----------------------------------------------------------------------------
void LoadRangeImage::OnBtnEnd( wxCommandEvent &  event )
{
	//SIL// metodo para quitar
	/*SetEndSlice( _sldActual->GetValue() );
	ResetLoadRegion();
	RefreshSlice();*/
}
// ----------------------------------------------------------------------------
void LoadRangeImage::SetStartEnd( int start, int end )
{
	SetStartSlice( start );
	SetEndSlice( end );
	ResetLoadRegion();
	RefreshSlice();
}

// ----------------------------------------------------------------------------
void LoadRangeImage::Reset( )
{
	int delta= (int) (_maxZ*0.1);
	SetStartSlice( 0 + delta );
	SetEndSlice( _maxZ - delta );

//EEDxx2.4
//	_btnStart	->Show(true);
//	_btnEnd		->Show(true);

	//SIL//_sizer1a->Show(_btnStart, true );
	//SIL//_sizer1a->Show(_btnEnd	, true );
//    _sizer1a->Layout();	
	RefreshSlice();
}

// ----------------------------------------------------------------------------
void LoadRangeImage::SetStartSlice(int value)
{
	if (value<_endSlice){
		_startSlice	= value;
		/*wxString txt;
		txt.Printf(_T("%d"),_startSlice);
		_textActual->SetLabel(txt);*/
		
		//SIL// para quitar las siguientes 4 lineas
		/*
		_btnStart->SetLabel(_T("Start:  ")+txt);
		_barRange->SetMax(_maxZ);
		_barRange->SetStart(_startSlice);
		_barRange->RefreshForce();*/

		//SIL//
		_sl_barRange_ROI->SetMax(_maxZ);
		_sl_barRange_ROI->SetStart(_startSlice);
		_sl_barRange_ROI->RefreshForce(); 
	}
}
// ----------------------------------------------------------------------------
void LoadRangeImage::SetEndSlice(int value)
{
	if (value>_startSlice){
		_endSlice	= value;
		/*wxString txt;
		txt.Printf(_T("%d"),_endSlice);
		_textActual->SetLabel(txt);*/
		//SIL//_btnEnd->SetLabel(_T("End:  ")+txt);
		_sl_barRange_ROI->SetEnd(_endSlice);
		_sl_barRange_ROI->RefreshForce(); 

	}
}

// ----------------------------------------------------------------------------
void LoadRangeImage::RefreshSlice()
{
//SIL//	_priorityLoadImageBar->WaitUntil_i_isDone( _sldActual->GetValue() );
	_priorityLoadImageBar->WaitUntil_i_isDone( _toShowSlice );

	wxCommandEvent newevent(wxEVT_COMMAND_MENU_SELECTED,12122);
	this->GetParent()->ProcessEvent(newevent);
/* //SIL//
	wxString text;	
	//SIL//text.Printf(_T("Actual: %d "), _sldActual->GetValue() );
	text.Printf(_T("Start: %d\n Actual: %d\n End: %d"), _sl_barRange_ROI->GetStart(),_sl_barRange_ROI->GetActual(),_sl_barRange_ROI->GetEnd() );
	_textActual->SetLabel(text);*/
	
	//SIL// Para borrar las lineas de barrange
	/*_barRange->SetMax(_maxZ);
	_barRange->SetActual( _sldActual->GetValue() );
	_barRange->SetStart(_startSlice);
	_barRange->SetEnd(_endSlice);
	_barRange->RefreshForce();*/

	//SIL//
	// EED
//	_sl_barRange_ROI->SetMax(_maxZ);
	//_sl_barRange_ROI->SetActual(  _sldActual->GetValue() );
//	_sl_barRange_ROI->SetStart(_startSlice);
//	_sl_barRange_ROI->SetEnd(_endSlice);
	_sl_barRange_ROI->RefreshForce();

//EED 28 Fev 2008
//	_bar->Refresh();
//	_bar->Update();

   Refresh(false);
//	_imageViewerWidget->SetZSlice( _sldActual->GetValue()  );
//	_imageViewerWidget->Render();
}
// ----------------------------------------------------------------------------
void LoadRangeImage::CallBackOnMouseWheel( wxMouseEvent& event )
{
	/* //SIL ImageViewer no existe//int actual = _imageViewerWidget->GetZSlice();
	if (actual<_sl_barRange_ROI->GetActual()) {
		actual = _sl_barRange_ROI->GetActual();
	}
	if (actual>_sl_barRange_ROI->GetEnd()) {
		actual = _sl_barRange_ROI->GetEnd();
	}
	_sl_barRange_ROI->SetActual( actual );
	ResetLoadRegion();
	RefreshSlice();
*/
	/*int actual = _imageViewerWidget->GetZSlice();
	if (actual<_sldStart->GetValue()) {
		actual = _sldStart->GetValue();
	}
	if (actual>_sldEnd->GetValue()) {
		actual = _sldEnd->GetValue();
	}
	_sldActual->SetValue( actual );
	ResetLoadRegion();
	RefreshSlice();*/

}
// ----------------------------------------------------------------------------
void LoadRangeImage::ForceToFinisReadActiveImages()
{
	int s=_startSlice;
	int e=_endSlice;

	_priorityLoadImageBar->WaitUntil_segment_isDone(s,e,true);


//EEDx44
	std::string msgLstFile( _marfilesbase->GetMsgLstFile() );
	if ( msgLstFile!="")
	{
		wxDialog *dialog = new wxDialog( this , -1, wxString(_T("The following files doesn't exist:")), wxDefaultPosition, wxSize(550,300),  wxDEFAULT_DIALOG_STYLE | wxRESIZE_BORDER );			
		wxTextCtrl *textCtrl = new wxTextCtrl(dialog, -1, wxString (msgLstFile.c_str(), wxConvUTF8) ,wxDefaultPosition , wxSize(100,100) , wxTE_MULTILINE | wxTE_READONLY );
		textCtrl->SetSelection(0,0);
		wxBoxSizer *sizer	= new wxBoxSizer(wxVERTICAL  );
		sizer->Add( textCtrl , 1, wxALL|wxEXPAND, 0);
		dialog->SetAutoLayout(true);
		dialog->SetSizer( sizer );      // use the sizer for layout
		dialog->Layout(); 
//EEDxx2.4
//		dialog->FitInside();
		dialog->ShowModal();
	}




}
// ----------------------------------------------------------------------------
void LoadRangeImage::GetROI( int extent[6] )
{
	extent[4]=_startSlice;
	extent[5]=_endSlice;
}
// ----------------------------------------------------------------------------
void LoadRangeImage::SetActualSlice( int actual )
{

	if ( actual > _endSlice ){
		actual=_endSlice;
	}
	if ( actual < _startSlice ){
		actual = _startSlice;
	}

	//SIL//_sldActual->SetValue( actual  );//SIL// para quitar esta linea
	//SIL//
	_sl_barRange_ROI->SetActual( actual);//de pronto no se necesita aca
	_toShowSlice=actual;

	ResetLoadRegion();
	RefreshSlice();
}
// ----------------------------------------------------------------------------
int LoadRangeImage::GetActualSlice( )
{
	return _toShowSlice;/*_sl_barRange_ROI->GetActual()*/; 
}
// ----------------------------------------------------------------------------

void  LoadRangeImage::ResetActualSlice( )
{
	if( reseteableActual )
		_toShowSlice = _sl_barRange_ROI->GetActual();
}

//------------------------------------------------------------------------
// Events captured form the barrange used configuring the ROI
//------------------------------------------------------------------------
void  LoadRangeImage::OnBarrange(wxCommandEvent& event)
{
	
}
void  LoadRangeImage::OnActualChange_BarRange(wxCommandEvent& event)
{
	//reseteableActual =true;
	_toShowSlice = _sl_barRange_ROI->GetActual();
	ResetLoadRegion();
	RefreshSlice();	
}
void  LoadRangeImage::OnStartChange_BarRange(wxCommandEvent& event)
{	
	reseteableActual =false;
	_toShowSlice = _sl_barRange_ROI->GetStart();
	SetStartSlice( _sl_barRange_ROI->GetStart() );
	ResetLoadRegion();
	RefreshSlice();
}

void  LoadRangeImage::OnEndChange_BarRange(wxCommandEvent& event)
{
	reseteableActual =false;
	_toShowSlice = _sl_barRange_ROI->GetEnd();
	SetEndSlice( _sl_barRange_ROI->GetEnd() );
	ResetLoadRegion();
	RefreshSlice();
}
void  LoadRangeImage:: OnBarMoved_BarRange (wxCommandEvent& event)
{
	SetEndSlice( _sl_barRange_ROI->GetEnd() );
	SetStartSlice( _sl_barRange_ROI->GetStart() );
	ResetLoadRegion();
	RefreshSlice();

}
void  LoadRangeImage:: OnSelectionEnd_BarRange (wxCommandEvent& event)
{
	reseteableActual = true;
}

// ---  Timer ------
void LoadRangeImage:: OnTimer(wxTimerEvent& event)
{
//  EED  used in linux  (see constructor)
	_bar->Refresh(false);
	_bar->Update();
	RefreshSlice();
}


// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------


