/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef wx_Reading_Priority_Panel_H
#define wx_Reading_Priority_Panel_H

#include <wx/wx.h>
#include <wx/slider.h>
#include <wx/panel.h>


//EED 15Avril2008 
//  #include "wxImageViewerWidget.h"
#include "InterfaceVtkPanelWidgets.h"

#include "marGdcmDicom.h"
#include "pPlotter/mBarRange.h"//SIL//

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------


#define PriorityLoadImage_MAX_P 5

class PriorityLoop  {
	public:
		PriorityLoop();
		virtual ~PriorityLoop();
				void	SetStartEndActualMax(int start,int end, int actual,int deltaImg, int maxImages);
				void	Iteration();
				void	InitLoop();

				void    StopLoop();
				bool    IsLoop();
				void    WaitUntil_i_isDone(int i);
				void    WaitUntil_segment_isDone(int start, int end,bool forceEndLoopRegion=true);
				void	ForceEndLoopRegion();
		virtual void	Action_i( int i );
		virtual void	RefreshForce() {}; 

	private:


		int		_start;
		int		_end;
		int		_actual;
		int		_deltaImg;
		int		_maxImages;
		int		_tstart;
		int		_tend;
		int		_tactual;
		int		_tdeltaImg;
		int		_tmaxImages;

		int		_counterReading;
		int		_max_p;
		bool    _loadingSerie;
		int     _forceReadRegion;
		int		_i_forceReadReagion;
		bool    _needToChange;

		int		_priority;
		int		_priorityType;
		bool	_dg[PriorityLoadImage_MAX_P];                 // right - left
		int		_counterActual[PriorityLoadImage_MAX_P];      // 
		bool	*_vecIdImage;

		int		Get_i_image();
		int		Geti(int id,int step,int start,int actualg,int actuald,int end);
		bool	_Action_i( int i );
		void	Create_Empty_Vector();
		void	InitConfiguration();
		bool    _ForceEndLoopRegion();
		void	NeedToChange();
};

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

class BarLoading :public  wxPanel{
public:
	BarLoading(wxWindow *parent, int w, int h);
	virtual ~BarLoading();
	void SetI(int i);
	void Reset();
	void Paint();
	virtual void OnPaint( wxPaintEvent &WXUNUSED(event) );
	void SetSizeData(int sizeData);
	void RefreshForce();
private:
        std::vector<int>    lstInt;
	int			_w;
	int			_h;
	int			_sizeData;
	wxBitmap	*_bitmap;
	bool		_flag_bitmap;
	bool		_flag2_bitmap;
	DECLARE_CLASS(BarLoading)
    // any class wishing to process wxWindows events must use this macro
    DECLARE_EVENT_TABLE()
};


// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
/*  EED Borrame
class BarRange :public  wxPanel{
public:
	BarRange(wxWindow *parent, int w, int h);
	~BarRange();
	void SetActual(int i);
	void SetStart(int i);
	void SetEnd(int i);
	void SetMax(int i);
	void OnPaint( wxPaintEvent &WXUNUSED(event) );
	void RefreshView();
	void RefreshForce();

private:
	int			_w;
	int			_h;
	int			_actual;
	int			_start;
	int			_end;
	int			_max;
	wxBitmap	*_bitmap;
	DECLARE_CLASS(BarRange)
    // any class wishing to process wxWindows events must use this macro
    DECLARE_EVENT_TABLE()
};
*/


// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

class PriorityLoadImageBar : public PriorityLoop{
public:
	PriorityLoadImageBar(marFilesBase *marfilesbase, BarLoading *bar);
	virtual ~PriorityLoadImageBar();
	void Action_i(int i);
	virtual void RefreshForce();

private:
	marFilesBase	*_marfilesbase;
	BarLoading		*_bar;
};




// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
/*

class PriorityBar : public PriorityLoop{
public:
	PriorityBar(BarLoading *bar);
	~PriorityBar();
	void Action_i(int i);
	virtual void RefreshForce();

private:
	BarLoading *_bar;
};
*/
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

WX_DEFINE_ARRAY(wxThread *, wxArrayThread);

class AdminThreadEED{
public:
	AdminThreadEED();
	~AdminThreadEED();

	wxCriticalSection m_critsect;
    // all the threads currently alive - as soon as the thread terminates, it's
    // removed from the array
    wxArrayThread m_threads;
    // the last exiting thread should signal m_condAllDone if this is true
    // (protected by the same m_critsect)
    bool m_waitingUntilAllDone;
    wxCondition m_condAllDone;
    // the (mutex, condition) pair used to wait for the threads to exit, see
    // MyFrame::OnQuit()
    wxMutex m_mutexAllDone;

private:
};

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

class MyThread : public wxThread{
public:
	MyThread(PriorityLoop *priorityLoop, AdminThreadEED *adminThreadEED);
    virtual void* Entry();
	virtual void  OnExit();
private:
	PriorityLoop *_priorityLoop;
	AdminThreadEED *_adminThreadEED;
};


// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

class LoadRangeImage : public wxPanel, InterfaceVtkPanelWidgets{
public:
	LoadRangeImage(wxWindow *parent,marFilesBase *marfilesbase/*,wxImageViewerWidget *imageViewerWidget*/);
	virtual ~LoadRangeImage();
// EED Borrame
//	void OnSliceStart(wxScrollEvent& event);
//	void OnSliceEnd(wxScrollEvent& event);
	void OnSliceActual(wxScrollEvent& event);
	void OnBtnStart(wxCommandEvent& event);
	void OnBtnEnd(wxCommandEvent& event);
//	void OnBtnResetRoi(wxCommandEvent& event);
	void Reset();

	void RefreshSlice();
	void SetActualSlice(int actual);
	int  GetActualSlice();
	void ResetActualSlice();

	virtual void CallBackOnMouseWheel( wxMouseEvent& event );
	void Start();
	void ForceToFinisReadActiveImages();
	void GetROI( int extent[6] );
	void SetStartEnd( int start, int end );

	//SIL//
	// --------------------------------------
	// Events captured form the barrange used configuring the ROI
	// --------------------------------------
	void  OnBarrange(wxCommandEvent& event);
	void  OnActualChange_BarRange(wxCommandEvent& event);
	void  OnStartChange_BarRange(wxCommandEvent& event);
	void  OnEndChange_BarRange(wxCommandEvent& event);
	void  OnBarMoved_BarRange(wxCommandEvent& event);
	void  OnSelectionEnd_BarRange(wxCommandEvent& event);

	void OnTimer(wxTimerEvent& event);

private:

	wxTimer 			*_timer;
	bool				reseteableActual;
	int				_toShowSlice;
	int				_maxZ;
	marFilesBase			*_marfilesbase;
// EED Borrame
//	wxSlider				*_sldStart;
//	wxSlider				*_sldEnd;
	int						_startSlice;
	int						_endSlice;
//	wxSlider				*_sldActual;
	BarLoading				*_bar;

// EED Borrame
//	BarRange				*_barRange;

	//SIL//
	mBarRange				*_sl_barRange_ROI;
	PriorityLoadImageBar	*_priorityLoadImageBar;
	AdminThreadEED			*_adminThreadEED;
	MyThread				*_mythread;

	wxFlexGridSizer			*_sizer1a;
	wxButton				*_btnStart;
	wxButton				*_btnEnd;
	wxStaticText			*_textActual; 

//	wxImageViewerWidget		*_imageViewerWidget;

	void	ResetLoadRegion();
	void	_Start();
	void	_Stop();

	void	SetStartSlice(int value);
	void	SetEndSlice(int value);


};







#endif // wx_Reading_Priority_Panel_H
