/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "vtkObjectFactory.h"

#include "vtkActor.h"
#include "vtkCylinderSource.h"
#include "vtkPolyDataMapper.h"
#include "vtkRenderer.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkProperty.h"
#include "vtkCamera.h"
#include "vtkPoints.h"
#include "vtkCellArray.h"
#include "vtkPolyData.h"
#include "vtkPolyDataMapper.h"
#include "vtkPolyDataWriter.h"
#include "vtkPolyDataReader.h"
#include "vtkImageReader.h"
#include "vtkImageViewer.h"
#include "vtkImageViewer2.h"
#include "vtkImageToStructuredPoints.h"
#include <vtkImageThreshold.h> 
#include "vtkImageWriter.h"


#include "vtkExtractVOI.h"
#include "vtkImageClip.h"
#include "vtkImageResample.h"
#include "vtkImageThreshold.h"
#include "vtkImageCast.h"
#include "vtkImageSeedConnectivity.h"
#include "vtkImageData.h"
#include "vtkMarchingCubes.h"
#include "vtkImageReslice.h"
#include "vtkTransform.h"
#include "vtkSphereSource.h"
#include "vtkDoubleArray.h"
#include "vtkPointData.h"
#include "vtkCommand.h"
#include "vtkCallbackCommand.h"
#include "vtkImageResample.h"
#include "vtkMath.h"
#include "vtkStripper.h"
#include <vtkSTLReader.h> 


#include "vtkTriangleFilter.h"
#include "vtkSTLWriter.h"
#include "vtkPolyDataConnectivityFilter.h"
#include "vtkClosePolyData.h"
#include "vtkAppendFilter.h"

#include "wxSTLWidget_02.h"

#include <wx/splitter.h>

#include <wx/filedlg.h>



//-------------------------------------------------------------------
//-------------------------------------------------------------------
//-------------------------------------------------------------------
wxSTLWidget_02::wxSTLWidget_02(wxWindow *parent, marInterface* mar)
: wxPanel( parent, -1) 
{
	_sensibility_JF			= 0.5;
	_maxSphereSize_JF		= 30;
	_minSphereSize_JF		= 5;

	_stlMarchingCubesLevel	= 128;
	_stlDeltaGaussLevel		= 100;

	_mar=new marInterface();	
	_mar->_parameters->setRescaleSlope( mar->_parameters->getRescaleSlope() );
	_mar->_parameters->setRescaleIntercept( mar->_parameters->getRescaleIntercept() );
	_mar->_parameters->setIntParam( marParameters::e_voxel_type, marParameters::VOX_TYPE_MINIMUM );
	_mar->_parameters->setDoubleParam( marParameters::e_voxel_x_dimension, mar->_parameters->getDoubleParam(marParameters::e_voxel_x_dimension) );
	_mar->_parameters->setDoubleParam( marParameters::e_voxel_y_dimension, mar->_parameters->getDoubleParam(marParameters::e_voxel_y_dimension) );
	_mar->_parameters->setDoubleParam( marParameters::e_voxel_z_dimension, mar->_parameters->getDoubleParam(marParameters::e_voxel_z_dimension) );
	int voi[6];
	mar->_experiment->getVOI( voi );
	_mar->_experiment->setVOI( voi );
	_mar->SetDicom(mar->_dicom);
	_mar->initExperiment( );
	 

	wxBoxSizer			*sizer			= new wxBoxSizer(wxVERTICAL  );
    wxSplitterWindow	*pnlSplitter	= new wxSplitterWindow( this , -1);
	wxPanel				*viewPanel		= CreateViewPanel(pnlSplitter);
	wxPanel				*controlPanel	= CreateControlPanel(pnlSplitter);

	sizer		-> Add( pnlSplitter ,1,wxGROW  ,0);
	pnlSplitter	-> SetMinimumPaneSize( 150 );
    pnlSplitter	-> SplitVertically( viewPanel, controlPanel, 600 );
	this		-> SetSizer(sizer);

	// Result 2: Volume + Axis
	_2_prgov			= NULL;
	_2_mapfinal			= NULL;
	_2_stripfinal		= NULL;
	_2_isoMapperMC6		= NULL;
	_2_isoActorMC6		= NULL;
	_2_isoMC6			= NULL;


	//DHC STL SURFACES
	stlInterna = NULL;
	stlExterna = NULL;

	_loadSTLMapper		= NULL;
	_loadActorSTL		= NULL;

	
	//JOIN REGIONS
	arteryImageData		= NULL;
	joinMarchingCubes	= NULL;
    joinMapper			= NULL; 
	joinActor			= NULL;


}
//-------------------------------------------------------------------
wxSTLWidget_02::~wxSTLWidget_02(){
	ResetTree2_JF();
	Reset_vtk_STLFile();
}
//-------------------------------------------------------------------
wxPanel* wxSTLWidget_02::CreateViewPanel(wxWindow *parent)
{
 	wxPanel *panel		=	new wxPanel(parent,-1);
    wxBoxSizer *sizer	=	new wxBoxSizer(wxVERTICAL);


   // MPR
	vtkImageData *imagedata;
	imagedata = _mar->_experiment->getDynData( )->getVolume( )->castVtk();
	imagedata->Update(); 	
	_wxMaracasMPR = new wxMaracasMPR( panel, new marImageData(imagedata), _mar->_parameters->getVoxelSize() );
	_wxMaracasMPR->ConfigureVTK();
	
	sizer->Add(	_wxMaracasMPR , 1, wxEXPAND, 0);
	panel->SetSizer(sizer);
	panel->SetAutoLayout(true);
	panel->SetSize(400,400);
	panel->Layout();
	return panel;
}
//-------------------------------------------------------------------
wxPanel* wxSTLWidget_02::CreateControlPanel(wxWindow *parent)
{
	wxPanel *panel			= new wxPanel(parent,-1);
	
	_opacity_Res2VolJF		= new wxSlider( panel, -1, 25, 0, 100				 , wxDefaultPosition, wxSize(200,40), wxSL_HORIZONTAL | wxSL_LABELS );
	_sl_sensibility_JF		= new wxSlider( panel, -1, 0 , 0, 100				 , wxDefaultPosition, wxSize(200,40), wxSL_HORIZONTAL | wxSL_LABELS );
	_sl_maxSphereSize_JF	= new wxSlider( panel, -1, _maxSphereSize_JF, 0, 100 , wxDefaultPosition, wxSize(200,40), wxSL_HORIZONTAL | wxSL_LABELS );
	_sl_minSphereSize_JF	= new wxSlider( panel, -1, _minSphereSize_JF , 0, 20 , wxDefaultPosition, wxSize(200,40), wxSL_HORIZONTAL | wxSL_LABELS );


	int tmp_sensibility= (int)(_sensibility_JF*100.0);
	_sl_sensibility_JF->SetValue( tmp_sensibility );

	_opacity_Res2VolJF	->SetSize(250,20);  // Result 2 Volume JF

	//Extract Tree 2 JF
	wxButton *btnExtractTree2_JF	= new wxButton(panel,-1,_T("Extract Tree 2 JF"));
	wxButton *btnEraseTree2_JF		= new wxButton(panel,-1,_T("Erase Tree 2 JF"));


	wxButton *btnReadSTLFile			= new wxButton(panel,-1,_T("Read STL File"));
	wxButton *btnEraseReadSTLFile		= new wxButton(panel,-1,_T("Erase STL File"));
	_sl_opacity_STL_file				= new wxSlider( panel, -1, 100 , 0, 100 , wxDefaultPosition, wxSize(200,40), wxSL_HORIZONTAL | wxSL_LABELS );


    wxFlexGridSizer *sizer = new wxFlexGridSizer(2);
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));


	sizer->Add(new wxStaticText(panel,-1,_T("  - - -  Segmentation - - - ")));
	sizer->Add(new wxStaticText(panel,-1,_T("  "))); 
	sizer->Add(new wxStaticText(panel,-1,_T(" % Sensibility")));
	sizer->Add(_sl_sensibility_JF);
	sizer->Add(new wxStaticText(panel,-1,_T(" Biggest radium")));
	sizer->Add(_sl_maxSphereSize_JF);
	sizer->Add(new wxStaticText(panel,-1,_T(" Minimum radium")));
	sizer->Add(_sl_minSphereSize_JF);


	sizer->Add(btnExtractTree2_JF);
	sizer->Add(btnEraseTree2_JF);

	wxButton *btnJoinRegions = new wxButton(panel,-1,_T("Join Regions"));
	sizer->Add(btnJoinRegions);
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));


	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("Opacity - Result Volume")));
	sizer->Add(_opacity_Res2VolJF);
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));


//-- STL WIDGETS
	
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
    sizer->Add(new wxStaticText(panel,-1,_T("  - - -  STL - - - ")));
    sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	stlSliderDeltaGauss	= new wxSlider( panel, -1, (int)(_stlDeltaGaussLevel) , 0, 300 , wxDefaultPosition, wxSize(200,40), wxSL_HORIZONTAL | wxSL_LABELS );
	stlSliderMarchingCubes= new wxSlider( panel, -1, (int)(_stlMarchingCubesLevel) , 0, 256 , wxDefaultPosition, wxSize(200,40), wxSL_HORIZONTAL | wxSL_LABELS );
	


	sizer->Add(new wxStaticText(panel,-1,_T(" Delta Gauss")));
	sizer->Add(stlSliderDeltaGauss);

	sizer->Add(new wxStaticText(panel,-1,_T(" Marching Cubes Level")));
	sizer->Add(stlSliderMarchingCubes);

	stlSliderOpacityInternal = new wxSlider(panel, -1, 100,0,100, wxDefaultPosition, wxSize(200,40), wxSL_HORIZONTAL | wxSL_LABELS);
	stlSliderOpacityExternal = new wxSlider(panel, -1, 100,0,100, wxDefaultPosition, wxSize(200,40), wxSL_HORIZONTAL | wxSL_LABELS);

	sizer->Add(new wxStaticText(panel, -1,_T(" Opacity STL Internal")));
	sizer->Add(stlSliderOpacityInternal);

	sizer->Add(new wxStaticText(panel, -1,_T(" Opacity STL External")));
	sizer->Add(stlSliderOpacityExternal);

	wxButton *btnFileSTL = new wxButton(panel,-1,_T("Generate STL files"));
	sizer->Add(btnFileSTL);
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
//-- STL WIDGETS
	

	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(new wxStaticText(panel,-1,_T("  ")));
	sizer->Add(btnReadSTLFile );
	sizer->Add(btnEraseReadSTLFile );
	sizer->Add(new wxStaticText(panel, -1,_T(" Opacity STL File")));
	sizer->Add(_sl_opacity_STL_file);

	panel->SetSizer(sizer);
	panel->SetAutoLayout(true);
	panel->SetSize(400,600);
	panel->Layout();

	Connect(_opacity_Res2VolJF->GetId()		, wxEVT_COMMAND_SLIDER_UPDATED  , (wxObjectEventFunction) &wxSTLWidget_02::OnOpacity_Res2VolJF	); 
	Connect(_sl_sensibility_JF->GetId()		, wxEVT_COMMAND_SLIDER_UPDATED  , (wxObjectEventFunction) &wxSTLWidget_02::OnSensibility	); 
	Connect(_sl_maxSphereSize_JF->GetId()		, wxEVT_COMMAND_SLIDER_UPDATED  , (wxObjectEventFunction) &wxSTLWidget_02::OnMaxSphereSize_JF	); 
	Connect(_sl_minSphereSize_JF->GetId()		, wxEVT_COMMAND_SLIDER_UPDATED  , (wxObjectEventFunction) &wxSTLWidget_02::OnMinSphereSize_JF	); 


	Connect(btnExtractTree2_JF->GetId()		, wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &wxSTLWidget_02::OnBtnExtractTree2_JF	); 
	Connect(btnEraseTree2_JF->GetId()		, wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &wxSTLWidget_02::OnBtnEraseTree2_JF 	); 
	Connect(btnJoinRegions->GetId()			, wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &wxSTLWidget_02::OnJoinRegions 	); 

	
	Connect(btnReadSTLFile->GetId()			, wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &wxSTLWidget_02::OnBtnSTLFileLoad 	); 
	Connect(btnEraseReadSTLFile->GetId()	, wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &wxSTLWidget_02::OnBtnSTLFileErase 	); 
	Connect(_sl_opacity_STL_file->GetId()	, wxEVT_COMMAND_SLIDER_UPDATED  , (wxObjectEventFunction) &wxSTLWidget_02::OnOpacitySTLFile		); 


	// -- STL CONNECT WIDGETS
	Connect(btnFileSTL->GetId()				, wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &wxSTLWidget_02::OnBtnCreateFileSTL         );
	Connect(stlSliderDeltaGauss->GetId()	, wxEVT_SCROLL_THUMBRELEASE		, (wxObjectEventFunction) &wxSTLWidget_02::OnChangeSTLGaussLevel	);
	Connect(stlSliderMarchingCubes->GetId()	, wxEVT_SCROLL_THUMBRELEASE		, (wxObjectEventFunction) &wxSTLWidget_02::OnChangeSTLMarchingCubesLevel);
	Connect(stlSliderOpacityInternal->GetId(), wxEVT_COMMAND_SLIDER_UPDATED	, (wxObjectEventFunction) &wxSTLWidget_02::OnOpacitySTLInternal);
	Connect(stlSliderOpacityExternal->GetId(), wxEVT_COMMAND_SLIDER_UPDATED	, (wxObjectEventFunction) &wxSTLWidget_02::OnOpacitySTLExternal);
	// -- STL CONNECT WIDGETS

	return panel;
}

//------------------------------------------------------------------------

void wxSTLWidget_02::Refresh()
{
	_wxMaracasMPR->RefreshView();
}

//------------------------------------------------------------------------

void wxSTLWidget_02::ConfigureVTK()
{
    wxBusyCursor wait;
	vtkImageData	*imagedata		= _mar->_experiment->getDynData( )->getVolume( )->castVtk();

	//CONFIGURACION ADICIONAL
    this->ConfigureSTL();
	this->ConfigureJoinRegions();

	
}


void wxSTLWidget_02::ResetTree2_JF()
{
	// Remove 
	vtkRenderer *ren = _wxMaracasMPR->GetWxvtkmpr3Dview_BB()->GetWxvtk3Dbaseview()->GetRenderer();

    if (_2_isoActorMC6){
		ren->RemoveActor(_2_isoActorMC6);
	}
    if (_2_stripfinal){
		ren->RemoveActor(_2_stripfinal);
	}

	// Delete 
	if (_2_prgov		) {	_2_prgov		-> Delete(); }
	if (_2_mapfinal		) {	_2_mapfinal		-> Delete(); }
	if (_2_stripfinal	) {	_2_stripfinal	-> Delete(); }
	if (_2_isoMapperMC6	) {	_2_isoMapperMC6	-> Delete(); }
	if (_2_isoActorMC6	) {	_2_isoActorMC6	-> Delete(); }
	if (_2_isoMC6		) {	_2_isoMC6		-> Delete(); }

	// Init
	_2_prgov		= NULL;
	_2_mapfinal		= NULL;
	_2_stripfinal	= NULL;
	_2_isoMapperMC6	= NULL;
	_2_isoActorMC6	= NULL;
	_2_isoMC6		= NULL;
}






//------------------------------------------------------------------------
void wxSTLWidget_02::ExtractTree2_JF(int x, int y, int z)
{
	
	double opacity_Res2VolJF = ((double)_opacity_Res2VolJF->GetValue())/100;
	vtkImageData *imagedata = _mar->_experiment->getDynData( )->getVolume( )->castVtk();

	double	puntoactualprov[3];
	double	espprin[3];
	int		extprin[6];				

	puntoactualprov[0]=x;
	puntoactualprov[1]=y;
	puntoactualprov[2]=z;
	
	imagedata->GetSpacing(espprin);
	imagedata->GetExtent(extprin);

	puntoactualprov[0]=puntoactualprov[0]*espprin[0];
	puntoactualprov[1]=puntoactualprov[1]*espprin[1];
	puntoactualprov[2]=puntoactualprov[2]*espprin[2];
	
	_2_prgov= axisExtractor02::New();
	_2_prgov->SetParam(1);
	_2_prgov->SetParam2(1);
	_2_prgov->SetParam3(_sensibility_JF);
	_2_prgov->SetMaxant(_maxSphereSize_JF);
	_2_prgov->SetMinant(_minSphereSize_JF);
	_2_prgov->SetInput(imagedata);
	_2_prgov->SetPoint(puntoactualprov);
	_2_prgov->Update();


	//--------------------------------------------------------

	marAxis *maraxis = this->_mar->_experiment->getAxis( );
	

	if (maraxis!=NULL) {
		vtkPolyData  *inputAxisRadio	= maraxis->GetAxisData();
		_2_prgov->distanciaejes(inputAxisRadio,_2_prgov->GetOutput());

			
	}

	//--------------------------------------------------------
	
	
	//ADICIONAR SEGMENTO
	if (arteryImageData){
		arteryImageData = joiner->join(arteryImageData, _2_prgov->GetVolumen());
	}
	else{
		arteryImageData = _2_prgov->GetVolumen();
	}
	
	//ADICIONAR SEGMENTO

	
		
		
	// Visualisation - result vascular tree
	vtkPolyData *polydata	=	_2_prgov->GetOutput();
	_2_mapfinal = vtkPolyDataMapper::New();
	_2_mapfinal->SetInput(polydata);

	_2_stripfinal = vtkActor::New();
	_2_stripfinal->SetMapper(_2_mapfinal);
	_2_stripfinal->GetProperty()->SetColor(0.0, 0.0, 1.0);
	_2_stripfinal->GetProperty()->SetLineWidth(2);
	_2_stripfinal->GetProperty()->BackfaceCullingOff();

	// Visualisation - result volume
   
    _2_isoMC6 = vtkMarchingCubes::New();
    //_2_isoMC6->SetInput(_2_prgov->GetVolumen());
	_2_isoMC6->SetInput(arteryImageData);
    _2_isoMC6->SetValue(0, 128);
	_2_isoMC6->Update();

	_2_isoMapperMC6 = vtkPolyDataMapper::New();
    _2_isoMapperMC6->SetInput(_2_isoMC6->GetOutput());
    _2_isoMapperMC6->ScalarVisibilityOff();
    _2_isoMapperMC6->ImmediateModeRenderingOn();

	_2_isoActorMC6 = vtkActor::New();
    _2_isoActorMC6->SetMapper(_2_isoMapperMC6);
    _2_isoActorMC6->GetProperty()->SetColor(1.0, 1.0, 0.5);
    _2_isoActorMC6->GetProperty()->SetOpacity( opacity_Res2VolJF );
    
	// Interface Update

	vtkRenderer *ren = _wxMaracasMPR->GetWxvtkmpr3Dview_BB()->GetWxvtk3Dbaseview()->GetRenderer();
	ren->AddActor(_2_isoActorMC6);
	ren->AddActor(_2_stripfinal);

}

//------------------------------------------------------------------------
void wxSTLWidget_02::OnSensibility(wxScrollEvent& event)
{
	_sensibility_JF = (double)(_sl_sensibility_JF->GetValue())/100;
}
//------------------------------------------------------------------------
void wxSTLWidget_02::OnOpacity_Res2VolJF(wxScrollEvent& event)
{
	if (_2_isoActorMC6!=NULL){
		double value = ((double)_opacity_Res2VolJF->GetValue())/100;
		_2_isoActorMC6->GetProperty( )->SetOpacity( value );
		Refresh();
	}
}
//------------------------------------------------------------------------
void wxSTLWidget_02::OnMaxSphereSize_JF(wxScrollEvent& event)
{
	_maxSphereSize_JF = _sl_maxSphereSize_JF->GetValue();
}
//------------------------------------------------------------------------
void wxSTLWidget_02::OnMinSphereSize_JF(wxScrollEvent& event)
{
	_minSphereSize_JF = _sl_minSphereSize_JF->GetValue();
}
//------------------------------------------------------------------------
void wxSTLWidget_02::OnBtnExtractTree2_JF(wxCommandEvent& event)
{
	wxBusyCursor wait;		
	double px=_wxMaracasMPR->GetVtkMPRBaseData()->GetX();
	double py=_wxMaracasMPR->GetVtkMPRBaseData()->GetY();
	double pz=_wxMaracasMPR->GetVtkMPRBaseData()->GetZ();
	ExtractTree2_JF( (int)(px) , (int)(py) , (int)(pz) );
	//------------------------------------
	generateSTLSurfaces(); //DHC: AFTER EXTRACTING THE TREE, THE STL SURFACES ARE CALCULATED.
	//------------------------------------
	Refresh();
}
//------------------------------------------------------------------------
void wxSTLWidget_02::OnBtnEraseTree2_JF(wxCommandEvent& event)
{
	ResetTree2_JF();
	Refresh();
}
//------------------------------------------------------------------------
void wxSTLWidget_02::OnOpacitySTLFile(wxScrollEvent& event)
{
	if (_loadActorSTL!=NULL)
	{
		double value = ((double)_sl_opacity_STL_file->GetValue())/100;
		_loadActorSTL->GetProperty( )->SetOpacity( value );
		Refresh();
	}
}
//------------------------------------------------------------------------
void wxSTLWidget_02::Reset_vtk_STLFile()
{
	// Remove
	vtkRenderer *ren = _wxMaracasMPR->GetWxvtkmpr3Dview_BB()->GetWxvtk3Dbaseview()->GetRenderer();
    if (_loadActorSTL){
		ren->RemoveActor(_loadActorSTL);
	}

	// Delete 
	if (_loadSTLMapper		) {	_loadSTLMapper		-> Delete(); }
	if (_loadActorSTL		) {	_loadActorSTL		-> Delete(); }

	// Init
	_loadSTLMapper		= NULL;
	_loadActorSTL		= NULL;

}
//------------------------------------------------------------------------
void wxSTLWidget_02::OnBtnSTLFileErase(wxCommandEvent& event)
{
	Reset_vtk_STLFile();
	Refresh();
}
//------------------------------------------------------------------------
void wxSTLWidget_02::OnBtnSTLFileLoad(wxCommandEvent& event)
{
	wxString dirSTL = _mar->_parameters->getStringParam( 
    marParameters::e_installation_directory ); 
	dirSTL = ( dirSTL == _T("NO_DIRECTORY") ) ? wxGetHomeDir( ) : dirSTL;
	wxFileDialog dialog( this, _T("Choose a directory..."), ( !dirSTL.IsEmpty( ) )?
	dirSTL: wxGetHomeDir( ) );

	if( dialog.ShowModal( ) == wxID_OK ) 
	{
		Reset_vtk_STLFile();
		vtkSTLReader *imgReader= vtkSTLReader::New();
		imgReader->SetFileName( dialog.GetPath().mb_str(wxConvUTF8) );	
		_loadSTLMapper = vtkPolyDataMapper::New();
		_loadSTLMapper->SetInput(imgReader->GetOutput());
		_loadActorSTL = vtkActor::New();
		_loadActorSTL->SetMapper(_loadSTLMapper);
		_loadActorSTL->GetProperty()->SetColor( 1, 0, 0);
		_loadActorSTL->GetProperty()->SetOpacity( 0.5 );
		vtkRenderer *ren = _wxMaracasMPR->GetWxvtkmpr3Dview_BB()->GetWxvtk3Dbaseview()->GetRenderer();
		ren->AddActor(_loadActorSTL);
		imgReader->Delete();
	}
	//By default *always* update e_installation_directory:
	_mar->_parameters->setStringParam( marParameters::e_installation_directory, dialog.GetPath( ) ); 
	_mar->saveParameters( );
}

// ------------------------------------------------------------------------
// START JOIN FUNCTIONS - DHC
// ------------------------------------------------------------------------
void wxSTLWidget_02::ConfigureJoinRegions()
{
	arteryImageData = NULL;
	joiner = new vtkJoiner();
}


void wxSTLWidget_02::OnJoinRegions(wxCommandEvent& event)
{
	
   
    joinMarchingCubes= vtkMarchingCubes::New();
    joinMarchingCubes->SetInput(arteryImageData);
    joinMarchingCubes->SetValue(0, 128);
	joinMarchingCubes->Update();

	joinMapper = vtkPolyDataMapper::New();
    joinMapper->SetInput(joinMarchingCubes->GetOutput());
    joinMapper->ScalarVisibilityOff();
    joinMapper->ImmediateModeRenderingOn();

	joinActor = vtkActor::New();
    joinActor->SetMapper(joinMapper);
    joinActor->GetProperty()->SetColor(1.0, 0.3, 1.0);
    joinActor->GetProperty()->SetOpacity( 0.9 );
    
	// Interface Update
//	vtkRenderer *ren = _maracasSurfaceWidget->GetVtk3DSurfaceWidget()->GetRenderer();
	vtkRenderer *ren = _wxMaracasMPR->GetWxvtkmpr3Dview_BB()->GetWxvtk3Dbaseview()->GetRenderer();
	ren->AddActor(joinActor);

}
// ------------------------------------------------------------------------
// END JOIN FUNCTIONS - DHC
// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
// START STL FUNCTIONS - DHC
// ------------------------------------------------------------------------

void wxSTLWidget_02::ConfigureSTL()
{
	stlExterna = vtkPolyData::New();
	stlInterna = vtkPolyData::New();

	dsm1 = vtkPolyDataMapper ::New();
    dsm1->SetInput (stlInterna); 
    dsm1->ScalarVisibilityOff();

    actorInternal = vtkActor::New();
    actorInternal->SetMapper (dsm1);
    actorInternal->GetProperty()->SetColor (0,1,0);

    dsm2 = vtkPolyDataMapper ::New();
    dsm2->SetInput (stlExterna);
    dsm2->ScalarVisibilityOff();

    actorExternal= vtkActor::New();
    actorExternal->SetMapper (dsm2);
    actorExternal->GetProperty()->SetRepresentationToWireframe();

//    vtkRenderer *ren = _maracasSurfaceWidget->GetVtk3DSurfaceWidget()->GetRenderer();
	vtkRenderer *ren = _wxMaracasMPR->GetWxvtkmpr3Dview_BB()->GetWxvtk3Dbaseview()->GetRenderer();
    ren->AddActor(actorInternal);
    ren->AddActor(actorExternal);

	stlExtractor = new vtkSTLExtractor();  
}

void wxSTLWidget_02::generateSTLSurfaces()
{
	stlExtractor->setVolume(_2_prgov->GetVolumen());
	stlExtractor->setSigmaLevel(_stlDeltaGaussLevel);
	stlExtractor->setMarchingCubesLevel(_stlMarchingCubesLevel);
	stlExtractor->calculate();
	stlInterna->DeepCopy(stlExtractor->getInnerSurface());
	stlExterna->DeepCopy(stlExtractor->getOuterSurface());
}


void wxSTLWidget_02::OnOpacitySTLExternal(wxScrollEvent& event){
	double value = ((double)stlSliderOpacityExternal->GetValue())/100;
    actorExternal->GetProperty( )->SetOpacity( value );
	Refresh();
}


void wxSTLWidget_02::OnOpacitySTLInternal(wxScrollEvent& event){
	double value = ((double)stlSliderOpacityInternal->GetValue())/100;
    actorInternal->GetProperty( )->SetOpacity( value );
	Refresh();
}

void wxSTLWidget_02::OnBtnCreateFileSTL(wxCommandEvent& event)
{

	wxString dirSTL = _mar->_parameters->getStringParam( 
    marParameters::e_installation_directory ); 
	dirSTL = ( dirSTL == _T("NO_DIRECTORY") ) ? wxGetHomeDir( ) : dirSTL;
	wxDirDialog dialog( this, _T("Choose a directory..."), ( !dirSTL.IsEmpty( ) )?
	dirSTL: wxGetHomeDir( ) );

	if( dialog.ShowModal( ) == wxID_OK ) 
	{
	   
      	
		// ------------------------------------------------------------------------
		//  1.  GENERATE STL FILES
		// ------------------------------------------------------------------------
//		const char* fileprefix = "c:\\Creatis\\";
		std::string prefix( dialog.GetPath().mb_str(wxConvUTF8) );
		std::string filename;

		// 1.1. Se hace un filtro triangular puesto que el stl writer solo recibe poligonos triangulares.

        vtkTriangleFilter *filtro = vtkTriangleFilter::New();
		filtro->SetInput(stlInterna);
		vtkPolyDataConnectivityFilter *pdcf = vtkPolyDataConnectivityFilter::New();
        pdcf->SetInput( filtro->GetOutput() );
        vtkClosePolyData *cpd = vtkClosePolyData::New();
        cpd->SetInput( pdcf->GetOutput() );

		// 1.2 se escribe a disco el archivo stl de la superficie interna
        cpd->Update();
        vtkSTLWriter *writerI = vtkSTLWriter::New();
        writerI->SetInput( cpd->GetOutput() );
//        prefix = fileprefix;
		filename=prefix+"\\internal.stl";
        writerI->SetFileName(filename.c_str());
        writerI->SetFileTypeToASCII();
        writerI->Write();
        writerI->Delete();

		// 1.3 se escribe a disco el archivo stl de la superficie externa
		filtro->SetInput(stlExterna);
        cpd->Update();
        vtkSTLWriter *writerE = vtkSTLWriter::New();
        writerE->SetInput( cpd->GetOutput() );
//        prefix = fileprefix;
		filename=prefix+"\\external.stl";
        writerE->SetFileName( filename.c_str() );
        writerE->SetFileTypeToASCII();
        writerE->Write();
        writerE->Delete();
   
        filtro->Delete();
        cpd->Delete();
        pdcf->Delete();
	}

	//By default *always* update e_installation_directory:
	_mar->_parameters->setStringParam( marParameters::e_installation_directory, dialog.GetPath( ) ); 
	_mar->saveParameters( );
}


void wxSTLWidget_02::OnChangeSTLGaussLevel(wxScrollEvent& event)
{
	wxBusyCursor wait;
	_stlDeltaGaussLevel  = ((double)stlSliderDeltaGauss->GetValue())/100;
	generateSTLSurfaces();
	Refresh();
}


void wxSTLWidget_02::OnChangeSTLMarchingCubesLevel(wxScrollEvent& event)
{
	wxBusyCursor wait;
	_stlMarchingCubesLevel = ((double)stlSliderMarchingCubes->GetValue());
 	generateSTLSurfaces();
	Refresh();
	
}


// ------------------------------------------------------------------------
// END STL FUNCTIONS - DHC
// ------------------------------------------------------------------------







