/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef WX_STL_WIDGET_02
#define WX_STL_WIDGET_02

#include <vector>

#include <vtkImageData.h>
#include <vtkActor.h>
#include <vtkMarchingCubes.h>
#include <vtkPolyDataMapper.h>
#include <vtkAppendFilter.h>
#include <vtkImageThreshold.h>
#include <vtkExtractVOI.h>
#include <vtkOutlineFilter.h>
#include <vtkImageSeedConnectivity.h>
#include <vtkImageCast.h>

#include "wxVTKRenderWindowInteractor.h"
#include "wxSurfaceWidget.h"
#include "wxVtkBaseView.h"


#include "../wxMaracasMPR.h"

#include <kernel/marInterface.h>
#include <kernel/axisExtractor02.h>


#include "kernel/vtkSTLExtractor.h"    
#include "kernel/vtkJoiner.h"




//------------------------------------------------------------------
//------------------------------------------------------------------
//------------------------------------------------------------------

class wxSTLWidget_02: public wxPanel{
public:
	wxSTLWidget_02(wxWindow *parentmar,marInterface *mar);
	~wxSTLWidget_02();
	void ConfigureVTK();
	void Refresh();

	void OnOpacity_Res2VolJF(wxScrollEvent& event);		// Result 2 Volume JF


	void OnBtnExtractTree2_JF(wxCommandEvent& event);
	void OnBtnEraseTree2_JF(wxCommandEvent& event);

	void OnSensibility(wxScrollEvent& event);
	void OnMaxSphereSize_JF(wxScrollEvent& event);		// radio Max
	void OnMinSphereSize_JF(wxScrollEvent& event);		// radio Min

	//
	void Reset_vtk_STLFile();
	void OnBtnSTLFileLoad(wxCommandEvent& event);
	void OnBtnSTLFileErase(wxCommandEvent& event);
	void OnOpacitySTLFile(wxScrollEvent& event);		


	// --------------------------------------
	// STL FUNCTIONS DHC
	// --------------------------------------
	void generateSTLSurfaces();
	void OnBtnCreateFileSTL(wxCommandEvent& event); 
	void OnChangeSTLGaussLevel(wxScrollEvent& event);
	void OnChangeSTLMarchingCubesLevel(wxScrollEvent& event);
	void OnOpacitySTLExternal(wxScrollEvent& event);
	void OnOpacitySTLInternal(wxScrollEvent& event);

	//---------------------------------------
	// JOIN REGIONS FUNCTIONS
	//---------------------------------------
	void OnJoinRegions(wxCommandEvent& event);

private:


	// Result 1 volume + Axis   
//	vtkPolyDataMapper	*_1_mapfinal;
//	vtkActor			*_1_stripfinal;
//	vtkPolyDataMapper	*_1_isoMapperMC6;
//	vtkActor			*_1_isoActorMC6;
//	vtkMarchingCubes	*_1_isoMC6;

	// Result 2 volume + Axis   
	axisExtractor02		*_2_prgov;
	vtkPolyDataMapper	*_2_mapfinal;
	vtkActor			*_2_stripfinal;
	vtkPolyDataMapper	*_2_isoMapperMC6;
	vtkActor			*_2_isoActorMC6;
	vtkMarchingCubes	*_2_isoMC6;
	double				_sensibility_JF;
	int					_maxSphereSize_JF;
	int					_minSphereSize_JF;

	// Load STL file
	vtkPolyDataMapper *_loadSTLMapper;
	vtkActor		  *_loadActorSTL;


	wxSlider			*_opacity_Res2VolJF;
	wxSlider			*_sl_sensibility_JF;
	wxSlider			*_sl_maxSphereSize_JF;
	wxSlider			*_sl_minSphereSize_JF;
	
	wxVtk3DBaseView		*_imageviewer3D;
	wxPanel				*CreateControlPanel(wxWindow *parent);
	wxPanel				*CreateViewPanel(wxWindow *parent);

	//Maracas
	marInterface		*_mar;
	wxMaracasMPR		*_wxMaracasMPR;

	void ResetTree2_JF();
	void ExtractTree2_JF(int x, int y, int z);



	//---------------------
	// STL SURFACES DHC
	//---------------------
	void		ConfigureSTL();
	double		_stlDeltaGaussLevel;
	double		_stlMarchingCubesLevel;

	
	vtkPolyData *stlInterna;
	vtkPolyData *stlExterna;
	
	wxSlider	*stlSliderDeltaGauss;
	wxSlider	*stlSliderMarchingCubes;
	
	vtkPolyDataMapper *dsm1;
    vtkActor	*actorInternal;
	wxSlider	*stlSliderOpacityInternal;
    
	vtkPolyDataMapper *dsm2; 
    vtkActor	*actorExternal;
	wxSlider	*stlSliderOpacityExternal;

	vtkSTLExtractor *stlExtractor;   

	wxSlider	*_sl_opacity_STL_file;



	//--------------------------
	// JOIN REGIONS
	//--------------------------
	void ConfigureJoinRegions();

	vtkImageData		*arteryImageData;
	vtkJoiner			*joiner;
	vtkMarchingCubes	*joinMarchingCubes;
    vtkPolyDataMapper	*joinMapper; 
	vtkActor			*joinActor; 

};

#endif // WX_STL_WIDGET_02




