/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include <vtkPlanes.h>
#include <vtkProperty.h> 
#include <vtkPolyData.h> 
#include <vtkDataSet.h> 

#include "wxSurfaceMPR.h"
#include <wx/colordlg.h>



//-------------------------------------------------------------------
//-------------------------------------------------------------------
//-------------------------------------------------------------------

/*


void boxVolumeObserver::Execute(vtkObject *wdg, unsigned long eventId, void* calldata) {  // virtual
	if (eventId==vtkCommand::StartInteractionEvent){
		_renWin->SetDesiredUpdateRate(10);
	}
	if (eventId==vtkCommand::InteractionEvent){
		_renWin->SetDesiredUpdateRate(0.001);
	}
	if (eventId==vtkCommand::EndInteractionEvent){
		vtkPlanes *planes = vtkPlanes::New();
		vtkBoxWidget *boxwidget = reinterpret_cast<vtkBoxWidget*>(wdg);
		boxwidget->GetPlanes(planes);
		_volumeMapper->SetClippingPlanes(planes);
		planes -> Delete();
	}
}
//-------------------------------------------------------------------
void boxVolumeObserver::SetRenWin( vtkRenderWindow *renWin ){
	_renWin = renWin;
}
//-------------------------------------------------------------------
void boxVolumeObserver::SetVolumeMapper(vtkVolumeRayCastMapper *volumeMapper){
	_volumeMapper = volumeMapper;
}


//-------------------------------------------------------------------
//-------------------------------------------------------------------
//-------------------------------------------------------------------

void boxSurfaceObserver::Execute(vtkObject *wdg, unsigned long eventId, void* calldata) {  // virtual
	vtkBoxWidget *boxwidget = reinterpret_cast<vtkBoxWidget*>(wdg);
	boxwidget->GetPlanes(_planes);
	_actor->VisibilityOn();
}
//-------------------------------------------------------------------
void boxSurfaceObserver::SetPlanes(vtkPlanes *planes){
	_planes = planes;
}
//-------------------------------------------------------------------
void boxSurfaceObserver::SetActor(vtkActor *actor){
	_actor = actor;
}

*/

//-------------------------------------------------------------------
//-------------------------------------------------------------------
//-------------------------------------------------------------------


/*
vtkMPR3DData::vtkMPR3DData()
{
	_colour[0]= new wxColour(255,127, 64);
	_colour[1]= new wxColour(255,255,250);
	_colour[2]= new wxColour(  0,255,000);
	_colour[3]= new wxColour(  0,  0,255);
	_visiblePosition[0]=true;
	_visiblePosition[1]=true;
	_visiblePosition[2]=true;
}
//-------------------------------------------------------------------
vtkMPR3DData::~vtkMPR3DData()
{
  	int i;
	for (i=0; i< VTKMPRDATA_MAXTISSUE ; i++){
		_tissueExtractor[i]		->Delete();
		_tissueNormals[i]		->Delete();
		_tissueStripper[i]		->Delete();
		_tissueMapper[i]		->Delete();
		delete _colour[i];
		_tissuePlanes[i]		->Delete();
		_tissueClipper[i]		->Delete();
	}
	_outlineData		->Delete();
	_mapOutline			->Delete();
	_outline			->Delete();

	// Volume
	_tfun				->Delete();
	_ctfun				->Delete();
	_compositeFunction	->Delete();
	_volumeMapper		->Delete();
	_volumeProperty		->Delete();
	_newvol				->Delete();
}
//-------------------------------------------------------------------
vtkActor* vtkMPR3DData::GetOutlineActor()
{
	return _outline;
}
//-------------------------------------------------------------------
vtkPolyDataMapper* vtkMPR3DData::GetTissueMapper(int id)
{
	return _tissueMapper[id];
}
//-------------------------------------------------------------------
vtkPlanes* vtkMPR3DData::GetTissuePlanes(int id)
{
	return _tissuePlanes[id];
}
//-------------------------------------------------------------------
vtkStripper* vtkMPR3DData::GetTissueStripper(int id)
{
	return _tissueStripper[id];
}
//-------------------------------------------------------------------
vtkImageActor* vtkMPR3DData::GetImageActor(int id)
{
	vtkImageActor *tmpVtkActor=NULL;
	if (id==0){
		tmpVtkActor = GetvtkActor_saggital();
	}
	if (id==1){
		tmpVtkActor = GetvtkActor_coronal();
	}
	if (id==2){
		tmpVtkActor = GetvtkActor_axial();
	}
	return tmpVtkActor;
}
//-------------------------------------------------------------------
void vtkMPR3DData::Configure()
{
	int i;

	for (i=0; i< VTKMPRDATA_MAXTISSUE ; i++){

		_tissueExtractor[i] = vtkContourFilter::New();
		_tissueExtractor[i]->SetInput((vtkDataSet *) GetImageData() );
		_tissueExtractor[i]->SetValue(0, 0);
	    _tissueNormals[i] = vtkPolyDataNormals::New();
		_tissueNormals[i]->SetInput(_tissueExtractor[i]->GetOutput());
		_tissueNormals[i]->SetFeatureAngle(60.0);
		_tissueStripper[i] = vtkStripper::New();
		_tissueStripper[i]->SetInput(_tissueNormals[i]->GetOutput());

		if (i==0){
			_tissuePlanes[i]  = vtkPlanes::New();
			_tissueClipper[i] = vtkClipPolyData::New();
			_tissueClipper[i]->SetInput( _tissueStripper[i]->GetOutput() );
			_tissueClipper[i]->SetClipFunction( _tissuePlanes[i] );
			_tissueClipper[i]->InsideOutOn( );

			_tissueMapper[i] = vtkPolyDataMapper::New();
			_tissueMapper[i]->SetInput( _tissueClipper[i]->GetOutput() );
		} else {
			_tissueMapper[i] = vtkPolyDataMapper::New();
			_tissueMapper[i]->SetInput(_tissueStripper[i]->GetOutput());
//			_tissueMapper[i]->ScalarVisibilityOff();

		}

	}



  // An outline provides context around the data.
  //
	_outlineData = vtkOutlineFilter::New();
    _outlineData->SetInput((vtkDataSet *) GetImageData() );
	_mapOutline = vtkPolyDataMapper::New();
    _mapOutline->SetInput(_outlineData->GetOutput());
	_outline = vtkActor::New();
    _outline->SetMapper(_mapOutline);
    _outline->GetProperty()->SetColor(0,0,0);

  // Now we are creating three orthogonal planes passing through the
  // volume. Each plane uses a different texture map and therefore has
  // diferent coloration.


  // Volume
  _tfun = vtkPiecewiseFunction::New();

//	_tfun->AddPoint(70.0, 0.0);
//	_tfun->AddPoint(599.0, 0);
//	_tfun->AddPoint(600.0, 0);
//	_tfun->AddPoint(1195.0, 0);
//	_tfun->AddPoint(1200, .2);
//	_tfun->AddPoint(1300, .3);
//	_tfun->AddPoint(2000, .3);
//	_tfun->AddPoint(4095.0, 1.0);

	_tfun->AddPoint(70	, 0.0);
	_tfun->AddPoint(599	, 0.0);
	_tfun->AddPoint(600	, 0.0);
	_tfun->AddPoint(1110, 0.0);
	_tfun->AddPoint(1111, 1.0);
	_tfun->AddPoint(1300, 1.0);
	_tfun->AddPoint(2000, 1.0);
	_tfun->AddPoint(4095, 1.0);

  _ctfun = vtkColorTransferFunction::New();

//    _ctfun->AddRGBPoint(0.0, 0.5, 0.0, 0.0);
//	_ctfun->AddRGBPoint(600.0, 1.0, 0.5, 0.5);
//	_ctfun->AddRGBPoint(1280.0, 0.9, 0.2, 0.3);
//	_ctfun->AddRGBPoint(1960.0, 0.81, 0.27, 0.1);
//	_ctfun->AddRGBPoint(4095.0, 0.5, 0.5, 0.5);

	_ctfun->AddRGBPoint(0.0		, 0.5	, 0.0	, 0.0 );
	_ctfun->AddRGBPoint(600.0	, 1.0	, 0.5	, 0.5 );
	_ctfun->AddRGBPoint(1130.0	, 0.9	, 0.2	, 0.3 );
	_ctfun->AddRGBPoint(1131.0	, 0.3	, 0.9	, 0.9 );
	_ctfun->AddRGBPoint(1135.0	, 0.3	, 0.8	, 0.8 );
	_ctfun->AddRGBPoint(1960.0	, 0.1	, 0.27	, 0.71);
	_ctfun->AddRGBPoint(4095.0	, 0.5	, 0.5	, 0.5 );

  _compositeFunction = vtkVolumeRayCastCompositeFunction::New();
  
  _volumeMapper = vtkVolumeRayCastMapper::New();
	_volumeMapper->SetInput( GetImageData() );
	_volumeMapper->SetVolumeRayCastFunction(_compositeFunction);

  _volumeProperty = vtkVolumeProperty::New();
	_volumeProperty->SetColor(_ctfun);
	_volumeProperty->SetScalarOpacity(_tfun);
	_volumeProperty->SetInterpolationTypeToLinear();
	_volumeProperty->ShadeOn();

  _newvol = vtkVolume::New();
	_newvol->SetMapper(_volumeMapper);
	_newvol->SetProperty(_volumeProperty);

	vtkMPRBaseData::Configure();

}


//-------------------------------------------------------------------
void vtkMPR3DData::SetIsovalue(int idTissue, int isoValue)
{
	_tissueExtractor[idTissue]->SetValue(0, isoValue);
}

//-------------------------------------------------------------------
wxColour* vtkMPR3DData::GetColour(int idColour)
{
	return _colour[idColour];
}
//-------------------------------------------------------------------
void vtkMPR3DData::SetVisiblePosition(int idPosition, bool visible)
{
	_visiblePosition[idPosition]=visible;
}
//-------------------------------------------------------------------
bool vtkMPR3DData::GetVisiblePosition(int idPosition)
{
	return _visiblePosition[idPosition];
}
//-------------------------------------------------------------------
vtkVolume* vtkMPR3DData::GetVolumeActor()
{
   return _newvol;
}
//-------------------------------------------------------------------
vtkVolumeRayCastMapper* vtkMPR3DData::GetVolumeMapper(){
	return _volumeMapper;
}

*/

//-------------------------------------------------------------------
//-------------------------------------------------------------------
//-------------------------------------------------------------------

/*

wxVtkMPR3DView::wxVtkMPR3DView(wxWindow *parent)
:wxVtk3DBaseView( parent )
{
	int i;
	for (i=0; i<VTKMPRDATA_MAXTISSUE; i++){
		_visibleTissue[i]=true;
	}
	_visibleVolume=true;

}

//-------------------------------------------------------------------
wxVtkMPR3DView::~wxVtkMPR3DView(){
  	int i;
	for (i=0; i< VTKMPRDATA_MAXTISSUE ; i++){
		_tissue[i]->Delete();
	}

	_boxWidget		-> Delete();
	_observerV		-> Delete();
	_boxWidgetS1	-> Delete();
	_observerS1		-> Delete();

}
//-------------------------------------------------------------------
void wxVtkMPR3DView::SetVisibleTissue(int idTissue, bool visible){
	_visibleTissue[idTissue]=visible;
}
//-------------------------------------------------------------------
bool wxVtkMPR3DView::GetVisibleTissue(int idTissue){
	return _visibleTissue[idTissue];
}
//-------------------------------------------------------------------
vtkActor* wxVtkMPR3DView::GetTissueActor(int id){
	return _tissue[id];
}
//-------------------------------------------------------------------
void wxVtkMPR3DView::Configure(){
	vtkMPR3DData *vtkmpr3Ddata = (vtkMPR3DData*)GetVtkmprbasedata();
	wxVtk3DBaseView::Configure();
	// vtkActor tissue
	int i;
	for (i=0; i< VTKMPRDATA_MAXTISSUE ; i++){
		// tissue
		_tissue[i] = vtkActor::New();
		_tissue[i]->SetMapper(vtkmpr3Ddata->GetTissueMapper(i));

//		wxColour* cc=_vtkmprdata->GetColour(i);	
//		float cr=cc->Red(),cg=cc->Green(),cb=cc->Blue();
//		_tissue[i]->GetProperty()->SetDiffuseColor(cr/255, cg/255   , cb/255   );
//		_tissue[i]->GetProperty()->SetSpecular(.3);
//		_tissue[i]->GetProperty()->SetSpecularPower(20);

		if (i==0) _tissue[i]->GetProperty()->SetColor(1, 0   , 0   );
		if (i==2) _tissue[i]->GetProperty()->SetColor(0.85, 0.85   , 0.85   );
		if (i==3) _tissue[i]->GetProperty()->SetColor(0, 1   ,  0  );
		if (i==4) _tissue[i]->GetProperty()->SetColor(0, 0   , 1   );

		if (i==0){
		  _tissue[i]->VisibilityOff();
		  _tissue[i]->SetScale(1.01, 1.01, 1.01);
		}
	}

  // Volume (RayCast)
	GetRenderer()->AddVolume( vtkmpr3Ddata->GetVolumeActor()  );	// RayCast
	GetRenderer()->SetBackground(0.5, 0.5, 0.5);

  // Actors are added to the renderer. 
  GetRenderer()->AddActor( vtkmpr3Ddata->GetOutlineActor() );			
  GetRenderer()->AddActor( vtkmpr3Ddata->GetImageActor(0)  );	// _saggital
  GetRenderer()->AddActor( vtkmpr3Ddata->GetImageActor(1)  );	// _axial
  GetRenderer()->AddActor( vtkmpr3Ddata->GetImageActor(2)  );	// _coronal



	// Box Volume
	
  // The SetInteractor method is how 3D widgets are associated with the
  // render window interactor. Internally, SetInteractor sets up a bunch
  // of callbacks using the Command/Observer mechanism (AddObserver()).
  _boxWidget = vtkBoxWidget::New();
	_boxWidget->SetInteractor( GetWxVTKRenderWindowInteractor() );
	_boxWidget->SetPlaceFactor(1.0);

  // Place the interactor initially. The output of the reader is used to
  // place the box widget.

	_observerV = boxVolumeObserver::New();
	_observerV->SetRenWin( GetRenWin() );
	_observerV->SetVolumeMapper( vtkmpr3Ddata->GetVolumeMapper() );

	_boxWidget->SetInput( vtkmpr3Ddata->GetImageData() );
	_boxWidget->PlaceWidget();
	_boxWidget->InsideOutOn();
	_boxWidget->AddObserver( vtkCommand::StartInteractionEvent	, _observerV );
	_boxWidget->AddObserver( vtkCommand::InteractionEvent		, _observerV );
	_boxWidget->AddObserver( vtkCommand::EndInteractionEvent	, _observerV );
	_boxWidget->On();

	vtkProperty *outlineProperty = _boxWidget->GetOutlineProperty();
	outlineProperty->SetRepresentationToWireframe();
	outlineProperty->SetAmbient(1.0);
	outlineProperty->SetAmbientColor(1, 1, 1);
	outlineProperty->SetLineWidth(3);

	vtkProperty *selectedOutlineProperty = _boxWidget->GetSelectedOutlineProperty();
	selectedOutlineProperty->SetRepresentationToWireframe();
	selectedOutlineProperty->SetAmbient(1.0);
	selectedOutlineProperty->SetAmbientColor(1, 0, 0);
	selectedOutlineProperty->SetLineWidth(3);

//--
	// Box Surface

  // Place the interactor initially. The output of the reader is used to
  // place the box widget.

//	_observerV = boxVolumeObserver::New();
//	_observerV->SetRenWin( _renWin );
//	_observerV->SetVolumeMapper( _vtkmprdata->GetVolumeMapper() );

	_observerS1 = boxSurfaceObserver::New();
	_observerS1->SetPlanes( vtkmpr3Ddata->GetTissuePlanes(0) );
	_observerS1->SetActor( _tissue[0] );

  _boxWidgetS1 = vtkBoxWidget::New();
	_boxWidgetS1->SetInteractor( GetWxVTKRenderWindowInteractor() );
	_boxWidgetS1->SetPlaceFactor(1.25);


	_boxWidgetS1->SetInput( vtkmpr3Ddata->GetTissueStripper(0)->GetOutput() );
//	_boxWidgetS1->SetInput( vtkmpr3Ddata->GetGlyph(0)->GetOutput() );
	_boxWidgetS1->PlaceWidget();
	_boxWidgetS1->InsideOutOff();
//	_boxWidgetS1->AddObserver( vtkCommand::StartInteractionEvent , _observerV );
//	_boxWidgetS1->AddObserver( vtkCommand::InteractionEvent		 , _observerV );
//	_boxWidgetS1->AddObserver( vtkCommand::EndInteractionEvent	 , _observerV );
//	_boxWidgetS1->AddObserver( vtkCommand::EndInteractionEvent	 , _observerS1 );
	_boxWidgetS1->AddObserver( vtkCommand::InteractionEvent		 , _observerS1 );

//	vtkProperty *outlinePropertyS1 = _boxWidgetS1->GetOutlineProperty();
//	outlinePropertyS1->SetRepresentationToWireframe();
//	outlinePropertyS1->SetAmbient(1.0);
//	outlinePropertyS1->SetAmbientColor(0, 0, 1);
//	outlinePropertyS1->SetLineWidth(3);

//	vtkProperty *selectedOutlinePropertyS1 = _boxWidgetS1->GetSelectedOutlineProperty();
//	selectedOutlinePropertyS1->SetRepresentationToWireframe();
//	selectedOutlinePropertyS1->SetAmbient(1.0);
//	selectedOutlinePropertyS1->SetAmbientColor(1, 0, 0);
//	selectedOutlinePropertyS1->SetLineWidth(3);


	// vtkActor tissue
	for (i=0; i< VTKMPRDATA_MAXTISSUE ; i++){
		GetRenderer()->AddActor( _tissue[i] );			
	}

	_boxWidgetS1->On();

//--

  // Turn off bone for this example.
//  _bone->VisibilityOff();


  // An initial camera view is created.  The Dolly() method moves 
  // the camera towards the FocalPoint, thereby enlarging the image.
  GetRenderer()->SetActiveCamera(GetCamera());
  GetRenderer()->ResetCamera ();
  GetCamera()->Dolly(1.5);

  // Set a background color for the renderer and set the size of the
  // render window (expressed in pixels).
  GetRenderer()->SetBackground(1,1,1);
  GetRenWin()->SetSize(400, 400);

  // Note that when camera movement occurs (as it does in the Dolly()
  // method), the clipping planes often need adjusting. Clipping planes
  // consist of two planes: near and far along the view direction. The 
  // near plane clips out objects in front of the plane; the far plane
  // clips out objects behind the plane. This way only what is drawn
  // between the planes is actually rendered.
  GetRenderer()->ResetCameraClippingRange();

}


//-------------------------------------------------------------------
void wxVtkMPR3DView::VisibleActor(int idTissue, bool visTissue, bool visGuide){
	if (visTissue!=GetVisibleTissue(idTissue)){
		if (visTissue==false){
			GetRenderer()->RemoveActor( GetTissueActor(idTissue)  );	
		} else {
			GetRenderer()->AddActor( GetTissueActor(idTissue)  );	
		}
		SetVisibleTissue(idTissue,visTissue);
	}

	if (visGuide==true){
		_boxWidgetS1->On();
	} else {
		_boxWidgetS1->Off();
	}

}
//-------------------------------------------------------------------
void wxVtkMPR3DView::VisibleImageActor(int idPosition, bool visible){
	vtkMPR3DData *vtkmpr3Ddata = (vtkMPR3DData*)GetVtkmprbasedata();
	if (visible!=vtkmpr3Ddata->GetVisiblePosition(idPosition)){
		if (visible==false){
			GetRenderer()->RemoveActor( vtkmpr3Ddata->GetImageActor(idPosition)  );	
		} else {
			GetRenderer()->AddActor( vtkmpr3Ddata->GetImageActor(idPosition)  );	
		}
		vtkmpr3Ddata->SetVisiblePosition(idPosition,visible);
	}
}

//-------------------------------------------------------------------

void wxVtkMPR3DView::VisibleVolumeActor( bool visVolume,bool visGuide){
	vtkMPR3DData *vtkmpr3Ddata = (vtkMPR3DData*)GetVtkmprbasedata();
	if (visVolume!=_visibleVolume){
		if (visVolume==false){
			GetRenderer()->RemoveActor( vtkmpr3Ddata->GetVolumeActor()  );	
		} else {
			GetRenderer()->AddActor( vtkmpr3Ddata->GetVolumeActor() );	
		}
		_visibleVolume=visVolume;
	}
	if (visGuide==true){
		_boxWidget->On();
	} else {
		_boxWidget->Off();
	}
}

*/

//-------------------------------------------------------------------
//-------------------------------------------------------------------
//-------------------------------------------------------------------


/*
wxSurfaceMPR::wxSurfaceMPR(wxWindow *parent,  vtkImageData *imagedata, const wxString& title)
				: wxFrame( parent, -1, title) {

	_vtkmpr3Ddata = new vtkMPR3DData(); 
 	_vtkmpr3Ddata->SetImageData(imagedata);

	wxPanel *MPRPanel		= CreateMPRPanel(this,_vtkmpr3Ddata);
	wxPanel *controlPanel	= CreateControlPanel(this);

    wxFlexGridSizer *sizer  = new wxFlexGridSizer(2);
	sizer->Add(MPRPanel );
	sizer->Add(controlPanel );
	this->SetSizer(sizer);
	this->SetAutoLayout(true);
	this->SetSize(800,900);
}

//-------------------------------------------------------------------
wxPanel* wxSurfaceMPR::CreateMPRPanel(wxWindow *parent, vtkMPR3DData *vtkmpr3Ddata){
	wxPanel *panel=new wxPanel(parent,-1);

	_vtkmprview[1] = new wxVtkMPR3DView(panel);
	_vtkmprview[1]->SetVtkmprbasedata(vtkmpr3Ddata);
	wxVTKRenderWindowInteractor *iren1 = _vtkmprview[1]->GetWxVTKRenderWindowInteractor();	

	_vtkmprview[2] = new wxVtkMPR3DView(panel);
	_vtkmprview[2]->SetVtkmprbasedata(vtkmpr3Ddata);
	wxVTKRenderWindowInteractor *iren2 = _vtkmprview[2]->GetWxVTKRenderWindowInteractor();	

	_vtkmprview[3] = new wxVtkMPR3DView(panel);
	_vtkmprview[3]->SetVtkmprbasedata(vtkmpr3Ddata);
	wxVTKRenderWindowInteractor *iren3 = _vtkmprview[3]->GetWxVTKRenderWindowInteractor();	

	_vtkmprview[0] = new wxVtkMPR3DView(panel);
	_vtkmprview[0]->SetVtkmprbasedata(vtkmpr3Ddata);
	wxVTKRenderWindowInteractor *iren0 = _vtkmprview[0]->GetWxVTKRenderWindowInteractor();	

    wxBoxSizer *sizerV = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer *sizerH1= new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer *sizerH2= new wxBoxSizer(wxHORIZONTAL);
	sizerH1->Add(iren0 , 1, wxEXPAND, 0);

	sizerH1->Add(iren1 , 1, wxEXPAND, 0);
	sizerH2->Add(iren2 , 1, wxEXPAND, 0);
	sizerH2->Add(iren3 , 1, wxEXPAND, 0);

	sizerV->Add(sizerH1, 1, wxEXPAND, 0);
	sizerV->Add(sizerH2, 1, wxEXPAND, 0);

	panel->SetAutoLayout(true);
	panel->SetSizer(sizerV);
	panel->SetSize(900,900);
	panel->Layout();


	return panel;
}

//-------------------------------------------------------------------

wxPanel* wxSurfaceMPR::CreateControlPanel(wxWindow *parent){
	wxPanel *panel=new wxPanel(parent,-1);

// position 
	wxPanel *panel1 =new wxPanel(panel,-1);
	wxStaticText *text_space1 = new wxStaticText(panel1,-1,"    ");
	wxStaticText *text1_box1  = new wxStaticText(panel1,-1,"x  ");
	wxStaticText *text2_box1  = new wxStaticText(panel1,-1,"y  ");
	wxStaticText *text3_box1  = new wxStaticText(panel1,-1,"z  ");
	_sl1_box1 = new wxSlider( panel1, -1, 0, 0, _vtkmpr3Ddata->GetMaxPositionX(), wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );
	_sl2_box1 = new wxSlider( panel1, -1, 0, 0, _vtkmpr3Ddata->GetMaxPositionY(), wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );
	_sl3_box1 = new wxSlider( panel1, -1, 0, 0, _vtkmpr3Ddata->GetMaxPositionZ(), wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );

	_sl1_box1->SetSize(250,20);
	_sl2_box1->SetSize(250,20);
	_sl3_box1->SetSize(250,20);

    wxFlexGridSizer *sizerBox1 = new wxFlexGridSizer(3);
	// line 1
	sizerBox1->Add(text_space1);
	sizerBox1->Add(text1_box1);
	sizerBox1->Add( _sl1_box1);
	// line 2
	sizerBox1->Add(text_space1);
	sizerBox1->Add(text2_box1);
	sizerBox1->Add( _sl2_box1);
	// line 3
	sizerBox1->Add(text_space1);
	sizerBox1->Add(text3_box1);
	sizerBox1->Add( _sl3_box1);
	panel1->SetSizer(sizerBox1);
	panel1->SetAutoLayout(true);
	panel1->SetSize(250,80);


// Layers
	wxPanel *panel2 =new wxPanel(panel,-1);
	wxStaticText *text_space2 = new wxStaticText(panel2,-1,"   ");
	wxStaticText *text_		= new wxStaticText(panel2,-1,"  ");
				  _btnA		= new wxButton(panel2,-1,"A");
				  _btnB		= new wxButton(panel2,-1,"B");
				  _btnC		= new wxButton(panel2,-1,"C");
				  _btnD		= new wxButton(panel2,-1,"D");
	              _text_A	= new wxStaticText(panel2,-1,"000000");
	              _text_B	= new wxStaticText(panel2,-1,"000000");
	              _text_C	= new wxStaticText(panel2,-1,"000000");
	              _text_D	= new wxStaticText(panel2,-1,"000000");
	wxStaticText *text_A	= new wxStaticText(panel2,-1,"A ");
	wxStaticText *text_B	= new wxStaticText(panel2,-1,"B ");
	wxStaticText *text_C	= new wxStaticText(panel2,-1,"C ");
	wxStaticText *text_D	= new wxStaticText(panel2,-1,"D ");
	_slA1_box2 = new wxSlider( panel2, -1, 0, 0, 100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );
	_slA2_box2 = new wxSlider( panel2, -1, 0, 0,  60, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL  );
	_slA3_box2 = new wxSlider( panel2, -1, 0, 0,  50, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL  );
	_slB1_box2 = new wxSlider( panel2, -1, 0, 0, 100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );
	_slB2_box2 = new wxSlider( panel2, -1, 0, 0,  60, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL  );
	_slB3_box2 = new wxSlider( panel2, -1, 0, 0,  50, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL  );
	_slC1_box2 = new wxSlider( panel2, -1, 0, 0, 100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );
	_slC2_box2 = new wxSlider( panel2, -1, 0, 0,  60, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL  );
	_slC3_box2 = new wxSlider( panel2, -1, 0, 0,  50, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL  );
	_slD1_box2 = new wxSlider( panel2, -1, 0, 0, 100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );
	_slD2_box2 = new wxSlider( panel2, -1, 0, 0,  60, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL  );
	_slD3_box2 = new wxSlider( panel2, -1, 0, 0,  50, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL  );

	_chk1_box1 = new wxCheckBox(panel2, -1, "Visible X");
	_chk2_box1 = new wxCheckBox(panel2, -1, "Visible Y");
	_chk3_box1 = new wxCheckBox(panel2, -1, "Visible Z");

	_chkA_box2		= new wxCheckBox(panel2, -1, "Vis.");
	_chkB_box2		= new wxCheckBox(panel2, -1, "Vis.");
	_chkC_box2		= new wxCheckBox(panel2, -1, "Vis.");
	_chkD_box2		= new wxCheckBox(panel2, -1, "Vis.");
	_chkAA_box2		= new wxCheckBox(panel2, -1, ".");
	_chkBB_box2		= new wxCheckBox(panel2, -1, ".");
	_chkCC_box2		= new wxCheckBox(panel2, -1, ".");
	_chkDD_box2		= new wxCheckBox(panel2, -1, ".");
	_chkViewA_box2	= new wxCheckBox(panel2, -1, "A");
	_chkViewB_box2	= new wxCheckBox(panel2, -1, "B");
	_chkViewC_box2	= new wxCheckBox(panel2, -1, "C");
	_chkViewD_box2	= new wxCheckBox(panel2, -1, "D");

	_chk1_box1->SetValue(true);
	_chk2_box1->SetValue(true);
	_chk3_box1->SetValue(true);
	_chkA_box2->SetValue(true);
	_chkB_box2->SetValue(true);
	_chkC_box2->SetValue(true);
	_chkD_box2->SetValue(true);
	_chkAA_box2->SetValue(true);
	_chkBB_box2->SetValue(true);
	_chkCC_box2->SetValue(true);
	_chkDD_box2->SetValue(true);
	_chkViewA_box2->SetValue(true);
	_chkViewB_box2->SetValue(true);
	_chkViewC_box2->SetValue(true);
	_chkViewD_box2->SetValue(true);

	_slA1_box2->SetSize(250,20);
	_slA2_box2->SetSize(150,20);
	_slA3_box2->SetSize(150,20);
	_slB1_box2->SetSize(250,20);
	_slB2_box2->SetSize(150,20);
	_slB3_box2->SetSize(150,20);
	_slC1_box2->SetSize(250,20);
	_slC2_box2->SetSize(150,20);
	_slC3_box2->SetSize(150,20);
	_slD1_box2->SetSize(250,20);
	_slD2_box2->SetSize(150,20);
	_slD3_box2->SetSize(150,20);
	_btnA->SetSize(20,20);
	_btnB->SetSize(20,20);
	_btnC->SetSize(20,20);
	_btnD->SetSize(20,20);

	_btnA->SetBackgroundColour( *(_vtkmpr3Ddata->GetColour(0))  );
	_btnB->SetBackgroundColour( *(_vtkmpr3Ddata->GetColour(1))  );
	_btnC->SetBackgroundColour( *(_vtkmpr3Ddata->GetColour(2))  );
	_btnD->SetBackgroundColour( *(_vtkmpr3Ddata->GetColour(3))  );


    wxFlexGridSizer *sizerPanel2A = new wxFlexGridSizer(5);
    // line A2
	sizerPanel2A->Add(text_space2);
	sizerPanel2A->Add(text_A);
	sizerPanel2A->Add(_slA2_box2);
	sizerPanel2A->Add(_slA3_box2);
	sizerPanel2A->Add(_text_A);
    // line B2
	sizerPanel2A->Add(text_space2);
	sizerPanel2A->Add(text_B);
	sizerPanel2A->Add(_slB2_box2);
	sizerPanel2A->Add(_slB3_box2);
	sizerPanel2A->Add(_text_B);
    // line C2
	sizerPanel2A->Add(text_space2);
	sizerPanel2A->Add(text_C);
	sizerPanel2A->Add(_slC2_box2);
	sizerPanel2A->Add(_slC3_box2);
	sizerPanel2A->Add(_text_C);
    // line D2
	sizerPanel2A->Add(text_space2);
	sizerPanel2A->Add(text_D);
	sizerPanel2A->Add(_slD2_box2);
	sizerPanel2A->Add(_slD3_box2);
	sizerPanel2A->Add(_text_D);


    wxFlexGridSizer *sizerPanel2B = new wxFlexGridSizer(5);
    // line A1
	sizerPanel2B->Add(text_space2);
	sizerPanel2B->Add(_btnA);
	sizerPanel2B->Add(_slA1_box2);
	sizerPanel2B->Add(_chkA_box2);
	sizerPanel2B->Add(_chkAA_box2);
    // line B1
	sizerPanel2B->Add(text_space2);
	sizerPanel2B->Add(_btnB);
	sizerPanel2B->Add(_slB1_box2);
	sizerPanel2B->Add(_chkB_box2);
	sizerPanel2B->Add(_chkBB_box2);
    // line C1
	sizerPanel2B->Add(text_space2);
	sizerPanel2B->Add(_btnC);
	sizerPanel2B->Add(_slC1_box2);
	sizerPanel2B->Add(_chkC_box2);
	sizerPanel2B->Add(_chkCC_box2);
    // line D1
	sizerPanel2B->Add(text_space2);
	sizerPanel2B->Add(_btnD);
	sizerPanel2B->Add(_slD1_box2);
	sizerPanel2B->Add(_chkD_box2);
	sizerPanel2B->Add(_chkDD_box2);

    wxFlexGridSizer *sizerPanel2C = new wxFlexGridSizer(4);
	sizerPanel2C->Add(_chkViewA_box2);
	sizerPanel2C->Add(_chkViewB_box2);
	sizerPanel2C->Add(_chkViewC_box2);
	sizerPanel2C->Add(_chkViewD_box2);

    wxFlexGridSizer *sizerPanel2D = new wxFlexGridSizer(2);
	sizerPanel2D->Add(text_space2);
	sizerPanel2D->Add(_chk1_box1);
	sizerPanel2D->Add(text_space2);
	sizerPanel2D->Add(_chk2_box1);
	sizerPanel2D->Add(text_space2);
	sizerPanel2D->Add(_chk3_box1);

    wxFlexGridSizer *sizerPanel2 = new wxFlexGridSizer(1);
	sizerPanel2->Add(sizerPanel2A);
	sizerPanel2->Add(text_space2);
	sizerPanel2->Add(sizerPanel2C);
	sizerPanel2->Add(text_space2);
	sizerPanel2->Add(sizerPanel2D);
	sizerPanel2->Add(text_space2);
	sizerPanel2->Add(sizerPanel2B);

	panel2->SetSizer(sizerPanel2);
	panel2->SetAutoLayout(true);
	panel2->SetSize(350,320);

// cut1
	wxPanel *panel3 = new wxPanel(panel,-1);
	wxStaticText *text_space3 = new wxStaticText(panel3,-1,"    ");
	_chk_box3 = new wxCheckBox(panel3, -1, "Vis.");
	_chk_box33 = new wxCheckBox(panel3, -1, "Vis.");
	_chk_box3->SetValue(true);
	_chk_box33->SetValue(true);
    wxFlexGridSizer *sizerPanel3 = new wxFlexGridSizer(3);
	// line 1
	sizerPanel3->Add(text_space3);
	sizerPanel3->Add(_chk_box3);
	sizerPanel3->Add(_chk_box33);
	panel3->SetSizer(sizerPanel3);
	panel3->SetAutoLayout(true);
	panel3->SetSize(250,100);

//	_sl1_box3 = new wxSlider( panel3, -1, 0, 0, 100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );
//	_sl2_box3 = new wxSlider( panel3, -1, 0, 0, 100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );
//	_sl3_box3 = new wxSlider( panel3, -1, 0, 0, 100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );
//	wxStaticText *text1_box3 = new wxStaticText(panel3,-1,"A");
//	wxStaticText *text2_box3 = new wxStaticText(panel3,-1,"B");
//	wxStaticText *text3_box3 = new wxStaticText(panel3,-1,"Dist");
//  wxFlexGridSizer *sizerPanel3 = new wxFlexGridSizer(3);
//	// line 1
//	sizerPanel3->Add(text_space3);
//	sizerPanel3->Add(_chk_box3);
//	sizerPanel3->Add(text_space3);
//	// line 2
//	sizerPanel3->Add(text_space3);
//	sizerPanel3->Add(text1_box3);
//	sizerPanel3->Add(_sl1_box3);
//	// line 3
//	sizerPanel3->Add(text_space3);
//	sizerPanel3->Add(text2_box3);
//	sizerPanel3->Add(_sl2_box3);
//	// line 4
//	sizerPanel3->Add(text_space3);
//	sizerPanel3->Add(text3_box3);
//	sizerPanel3->Add(_sl3_box3);
//	panel3->SetSizer(sizerPanel3);
//	panel3->SetAutoLayout(true);
//	panel3->SetSize(250,100);
//  // cut2
//
//	wxPanel *panel4 = new wxPanel(panel,-1);
//	_chk_box4 = new wxCheckBox(panel4, -1, "Vis.");
//	_slA_box4 = new wxSlider( panel4, -1, 0, 0, 100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );
//	_slB_box4 = new wxSlider( panel4, -1, 0, 0, 100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );
//	_sl1_box4 = new wxSlider( panel4, -1, 0, 0, 100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );
//	_sl2_box4 = new wxSlider( panel4, -1, 0, 0, 100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );
//	_sl3_box4 = new wxSlider( panel4, -1, 0, 0, 100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );
//	_sl4_box4 = new wxSlider( panel4, -1, 0, 0, 100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );
//	_sl5_box4 = new wxSlider( panel4, -1, 0, 0, 100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );
//	_sl6_box4 = new wxSlider( panel4, -1, 0, 0, 100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS );
//	wxStaticText *text_space4 = new wxStaticText(panel3,-1,"    ");
//	wxStaticText *textA_box4 = new wxStaticText(panel4,-1,"A");
//	wxStaticText *textB_box4 = new wxStaticText(panel4,-1,"B");
//	wxStaticText *text1_box4 = new wxStaticText(panel4,-1,"D1");
//	wxStaticText *text2_box4 = new wxStaticText(panel4,-1,"D2");
//	wxStaticText *text3_box4 = new wxStaticText(panel4,-1,"D3");
//	wxStaticText *text4_box4 = new wxStaticText(panel4,-1,"D4");
//	wxStaticText *text5_box4 = new wxStaticText(panel4,-1,"D5");
//	wxStaticText *text6_box4 = new wxStaticText(panel4,-1,"D6");
//  wxFlexGridSizer *sizerPanel4 = new wxFlexGridSizer(3);
//	// line 1
//	sizerPanel4->Add(text_space4);
//	sizerPanel4->Add(_chk_box4);
//	sizerPanel4->Add(text_space4);
//	// line 2
//	sizerPanel4->Add(text_space4);
//	sizerPanel4->Add(textA_box4);
//	sizerPanel4->Add(_slA_box4);
//	// line 3
//	sizerPanel4->Add(text_space4);
//	sizerPanel4->Add(textB_box4);
//	sizerPanel4->Add(_slB_box4);
//	// line 4
//	sizerPanel4->Add(text_space4);
//	sizerPanel4->Add(text1_box4);
//	sizerPanel4->Add(_sl1_box4);
//	// line 5
//	sizerPanel4->Add(text_space4);
//	sizerPanel4->Add(text2_box4);
//	sizerPanel4->Add(_sl2_box4);
//	// line 6
//	sizerPanel4->Add(text_space4);
//	sizerPanel4->Add(text3_box4);
//	sizerPanel4->Add(_sl3_box4);
//	// line 7
//	sizerPanel4->Add(text_space4);
//	sizerPanel4->Add(text4_box4);
//	sizerPanel4->Add(_sl4_box4);
//	// line 8
//	sizerPanel4->Add(text_space4);
//	sizerPanel4->Add(text5_box4);
//	sizerPanel4->Add(_sl5_box4);
//	// line 9
//	sizerPanel4->Add(text_space4);
//	sizerPanel4->Add(text6_box4);
//	sizerPanel4->Add(_sl6_box4);
//	//
//	panel4->SetSizer(sizerPanel4);
//	panel4->SetAutoLayout(true);
//	panel4->SetSize(250,300);



// All
    wxFlexGridSizer *sizer = new wxFlexGridSizer(1);

	sizer->Add(new wxStaticText(panel,-1,"Position") );
	sizer->Add(panel1);
	sizer->Add(new wxStaticText(panel,-1,"Layer") );
	sizer->Add(panel2);
	sizer->Add(new wxStaticText(panel,-1,"Cut 1") );
	sizer->Add(panel3);
//	sizer->Add(new wxStaticText(panel,-1,"Cut 2") );
//	sizer->Add(panel4);

	panel->SetSizer(sizer);
	panel->SetAutoLayout(true);
	panel->SetSize(350,750);


	// Position 
	Connect(_sl1_box1->GetId()  , wxEVT_COMMAND_SLIDER_UPDATED  , (wxObjectEventFunction) &wxSurfaceMPR::OnPositionX );
	Connect(_sl2_box1->GetId()  , wxEVT_COMMAND_SLIDER_UPDATED  , (wxObjectEventFunction) &wxSurfaceMPR::OnPositionY );
	Connect(_sl3_box1->GetId()  , wxEVT_COMMAND_SLIDER_UPDATED  , (wxObjectEventFunction) &wxSurfaceMPR::OnPositionZ );
	Connect(_chk1_box1->GetId() , wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &wxSurfaceMPR::OnVisibleX );
	Connect(_chk2_box1->GetId() , wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &wxSurfaceMPR::OnVisibleY );
	Connect(_chk3_box1->GetId() , wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &wxSurfaceMPR::OnVisibleZ );
 

	// Opacity
	Connect(_slA1_box2->GetId()  , wxEVT_SCROLL_THUMBRELEASE   , (wxObjectEventFunction) &wxSurfaceMPR::OnOpacity0 );
	Connect(_slB1_box2->GetId()  , wxEVT_SCROLL_THUMBRELEASE   , (wxObjectEventFunction) &wxSurfaceMPR::OnOpacity1 );
	Connect(_slC1_box2->GetId()  , wxEVT_SCROLL_THUMBRELEASE   , (wxObjectEventFunction) &wxSurfaceMPR::OnOpacity2 );
	Connect(_slD1_box2->GetId()  , wxEVT_SCROLL_THUMBRELEASE   , (wxObjectEventFunction) &wxSurfaceMPR::OnOpacity3 );
	Connect(_btnA->GetId()       , wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxSurfaceMPR::OnBtnColourA );
	Connect(_btnB->GetId()       , wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxSurfaceMPR::OnBtnColourB );
	Connect(_btnC->GetId()       , wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxSurfaceMPR::OnBtnColourC );
	Connect(_btnD->GetId()       , wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxSurfaceMPR::OnBtnColourD );



	// Isovalue
	Connect(_slA2_box2->GetId()  , wxEVT_SCROLL_THUMBRELEASE  , (wxObjectEventFunction) &wxSurfaceMPR::OnIsoValue0 );
	Connect(_slA3_box2->GetId()  , wxEVT_SCROLL_THUMBRELEASE  , (wxObjectEventFunction) &wxSurfaceMPR::OnIsoValue0 );
	Connect(_slB2_box2->GetId()  , wxEVT_SCROLL_THUMBRELEASE  , (wxObjectEventFunction) &wxSurfaceMPR::OnIsoValue1 );
	Connect(_slB3_box2->GetId()  , wxEVT_SCROLL_THUMBRELEASE  , (wxObjectEventFunction) &wxSurfaceMPR::OnIsoValue1 );
	Connect(_slC2_box2->GetId()  , wxEVT_SCROLL_THUMBRELEASE  , (wxObjectEventFunction) &wxSurfaceMPR::OnIsoValue2 );
	Connect(_slC3_box2->GetId()  , wxEVT_SCROLL_THUMBRELEASE  , (wxObjectEventFunction) &wxSurfaceMPR::OnIsoValue2 );
	Connect(_slD2_box2->GetId()  , wxEVT_SCROLL_THUMBRELEASE  , (wxObjectEventFunction) &wxSurfaceMPR::OnIsoValue3 );
	Connect(_slD3_box2->GetId()  , wxEVT_SCROLL_THUMBRELEASE  , (wxObjectEventFunction) &wxSurfaceMPR::OnIsoValue3 );
	Connect(_slA2_box2->GetId()  , wxEVT_COMMAND_SLIDER_UPDATED  , (wxObjectEventFunction) &wxSurfaceMPR::OnIsoValue_0 );
	Connect(_slA3_box2->GetId()  , wxEVT_COMMAND_SLIDER_UPDATED  , (wxObjectEventFunction) &wxSurfaceMPR::OnIsoValue_0 );
	Connect(_slB2_box2->GetId()  , wxEVT_COMMAND_SLIDER_UPDATED  , (wxObjectEventFunction) &wxSurfaceMPR::OnIsoValue_1 );
	Connect(_slB3_box2->GetId()  , wxEVT_COMMAND_SLIDER_UPDATED  , (wxObjectEventFunction) &wxSurfaceMPR::OnIsoValue_1 );
	Connect(_slC2_box2->GetId()  , wxEVT_COMMAND_SLIDER_UPDATED  , (wxObjectEventFunction) &wxSurfaceMPR::OnIsoValue_2 );
	Connect(_slC3_box2->GetId()  , wxEVT_COMMAND_SLIDER_UPDATED  , (wxObjectEventFunction) &wxSurfaceMPR::OnIsoValue_2 );
	Connect(_slD2_box2->GetId()  , wxEVT_COMMAND_SLIDER_UPDATED  , (wxObjectEventFunction) &wxSurfaceMPR::OnIsoValue_3 );
	Connect(_slD3_box2->GetId()  , wxEVT_COMMAND_SLIDER_UPDATED  , (wxObjectEventFunction) &wxSurfaceMPR::OnIsoValue_3 );

	Connect(_chkA_box2->GetId() , wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &wxSurfaceMPR::OnVisibleTissueA );
	Connect(_chkB_box2->GetId() , wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &wxSurfaceMPR::OnVisibleTissueB );
	Connect(_chkC_box2->GetId() , wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &wxSurfaceMPR::OnVisibleTissueC );
	Connect(_chkD_box2->GetId() , wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &wxSurfaceMPR::OnVisibleTissueD );
	Connect(_chkAA_box2->GetId() , wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &wxSurfaceMPR::OnVisibleTissueA );
	Connect(_chkBB_box2->GetId() , wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &wxSurfaceMPR::OnVisibleTissueB );
	Connect(_chkCC_box2->GetId() , wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &wxSurfaceMPR::OnVisibleTissueC );
	Connect(_chkDD_box2->GetId() , wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &wxSurfaceMPR::OnVisibleTissueD );

	Connect(_chk_box3->GetId() , wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &wxSurfaceMPR::OnVisibleVolume );
	Connect(_chk_box33->GetId() , wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &wxSurfaceMPR::OnVisibleVolume );

	return panel;
}


*/


/*

//------------------------------------------------------------------------

void wxSurfaceMPR::Refresh(){
	_vtkmprview[0]->Refresh();
	_vtkmprview[1]->Refresh();
	_vtkmprview[2]->Refresh();
	_vtkmprview[3]->Refresh();
}


//------------------------------------------------------------------------
void wxSurfaceMPR::OnPositionX(wxScrollEvent& event){
	_vtkmpr3Ddata->SetPositionX( _sl1_box1->GetValue() );
    Refresh();
}
//------------------------------------------------------------------------
void wxSurfaceMPR::OnPositionY(wxScrollEvent& event){
	_vtkmpr3Ddata->SetPositionY( _sl2_box1->GetValue() );
    Refresh();
}
//------------------------------------------------------------------------
void wxSurfaceMPR::OnPositionZ(wxScrollEvent& event){
	_vtkmpr3Ddata->SetPositionZ( _sl3_box1->GetValue() );
    Refresh();
}
//------------------------------------------------------------------------
void wxSurfaceMPR::OpacityTissue(int idView, int idTissue, int opacity){
	vtkActor *tmpActor;
	tmpActor = _vtkmprview[ idView ]->GetTissueActor(idTissue);
	tmpActor->GetProperty()->SetOpacity((float) opacity/100 );
	_vtkmprview[idView]->Refresh();
}
//------------------------------------------------------------------------
void wxSurfaceMPR::OnOpacity0(wxScrollEvent& event){
	int opacity = _slA1_box2->GetValue();
	if (_chkViewA_box2->GetValue()==true){OpacityTissue(0,0, opacity ); }
	if (_chkViewB_box2->GetValue()==true){OpacityTissue(1,0, opacity ); }
	if (_chkViewC_box2->GetValue()==true){OpacityTissue(2,0, opacity ); }
	if (_chkViewD_box2->GetValue()==true){OpacityTissue(3,0, opacity ); }
}
//------------------------------------------------------------------------
void wxSurfaceMPR::OnOpacity1(wxScrollEvent& event){
	int opacity = _slB1_box2->GetValue();
	if (_chkViewA_box2->GetValue()==true){OpacityTissue(0,1, opacity ); }
	if (_chkViewB_box2->GetValue()==true){OpacityTissue(1,1, opacity ); }
	if (_chkViewC_box2->GetValue()==true){OpacityTissue(2,1, opacity ); }
	if (_chkViewD_box2->GetValue()==true){OpacityTissue(3,1, opacity ); }
}
//------------------------------------------------------------------------
void wxSurfaceMPR::OnOpacity2(wxScrollEvent& event){
	int opacity = _slC1_box2->GetValue();
	if (_chkViewA_box2->GetValue()==true){OpacityTissue(0,2, opacity ); }
	if (_chkViewB_box2->GetValue()==true){OpacityTissue(1,2, opacity ); }
	if (_chkViewC_box2->GetValue()==true){OpacityTissue(2,2, opacity ); }
	if (_chkViewD_box2->GetValue()==true){OpacityTissue(3,2, opacity ); }
}
//------------------------------------------------------------------------
void wxSurfaceMPR::OnOpacity3(wxScrollEvent& event){
	int opacity = _slD1_box2->GetValue();
	if (_chkViewA_box2->GetValue()==true){OpacityTissue(0,3, opacity ); }
	if (_chkViewB_box2->GetValue()==true){OpacityTissue(1,3, opacity ); }
	if (_chkViewC_box2->GetValue()==true){OpacityTissue(2,3, opacity ); }
	if (_chkViewD_box2->GetValue()==true){OpacityTissue(3,3, opacity ); }
}
//------------------------------------------------------------------------
void wxSurfaceMPR::OnIsoValue0(wxScrollEvent& event){
	int isoValue=_slA2_box2->GetValue() * 50 + _slA3_box2->GetValue();
	_vtkmpr3Ddata->SetIsovalue(0,isoValue);
	wxString tmpStr;
	tmpStr.Printf("%d",isoValue);
	_text_A->SetLabel(tmpStr);
    Refresh();
}
//------------------------------------------------------------------------
void wxSurfaceMPR::OnIsoValue1(wxScrollEvent& event){
	int isoValue=_slB2_box2->GetValue() * 50 + _slB3_box2->GetValue();
	_vtkmpr3Ddata->SetIsovalue(1,isoValue);
	wxString tmpStr;
	tmpStr.Printf("%d",isoValue);
	_text_B->SetLabel(tmpStr);
    Refresh();
}
//------------------------------------------------------------------------
void wxSurfaceMPR::OnIsoValue2(wxScrollEvent& event){
	int isoValue=_slC2_box2->GetValue() * 50 + _slC3_box2->GetValue();
	_vtkmpr3Ddata->SetIsovalue(2,isoValue);
	wxString tmpStr;
	tmpStr.Printf("%d",isoValue);
	_text_C->SetLabel(tmpStr);
    Refresh();
}
//------------------------------------------------------------------------
void wxSurfaceMPR::OnIsoValue3(wxScrollEvent& event){
	int isoValue=_slD2_box2->GetValue() * 50 + _slD3_box2->GetValue();
	_vtkmpr3Ddata->SetIsovalue(3,isoValue);
	wxString tmpStr;
	tmpStr.Printf("%d",isoValue);
	_text_D->SetLabel(tmpStr);
    Refresh();
}



//------------------------------------------------------------------------
void wxSurfaceMPR::OnIsoValue_0(wxScrollEvent& event){
	int isoValue=_slA2_box2->GetValue() * 50 + _slA3_box2->GetValue();
	wxString tmpStr;
	tmpStr.Printf("%d",isoValue);
	_text_A->SetLabel(tmpStr);
}
//------------------------------------------------------------------------
void wxSurfaceMPR::OnIsoValue_1(wxScrollEvent& event){
	int isoValue=_slB2_box2->GetValue() * 50 + _slB3_box2->GetValue();
	wxString tmpStr;
	tmpStr.Printf("%d",isoValue);
	_text_B->SetLabel(tmpStr);
}
//------------------------------------------------------------------------
void wxSurfaceMPR::OnIsoValue_2(wxScrollEvent& event){
	int isoValue=_slC2_box2->GetValue() * 50 + _slC3_box2->GetValue();
	wxString tmpStr;
	tmpStr.Printf("%d",isoValue);
	_text_C->SetLabel(tmpStr);
}
//------------------------------------------------------------------------
void wxSurfaceMPR::OnIsoValue_3(wxScrollEvent& event){
	int isoValue=_slD2_box2->GetValue() * 50 + _slD3_box2->GetValue();
	wxString tmpStr;
	tmpStr.Printf("%d",isoValue);
	_text_D->SetLabel(tmpStr);
}


//------------------------------------------------------------------------
void wxSurfaceMPR::OnBtnColourA(wxCommandEvent& event){
  wxColourDialog dlgColour(this);
  dlgColour.ShowModal();
}
//------------------------------------------------------------------------
void wxSurfaceMPR::OnBtnColourB(wxCommandEvent& event){
  wxColourDialog dlgColour(this);
  dlgColour.ShowModal();
}
//------------------------------------------------------------------------
void wxSurfaceMPR::OnBtnColourC(wxCommandEvent& event){
  wxColourDialog dlgColour(this);
  dlgColour.ShowModal();
}
//------------------------------------------------------------------------
void wxSurfaceMPR::OnBtnColourD(wxCommandEvent& event){
  wxColourDialog dlgColour(this);
  dlgColour.ShowModal();
}
//------------------------------------------------------------------------
void wxSurfaceMPR::VisibleActor(int idView, int idTissue, bool visTissue, bool visGuide){
	_vtkmprview[idView]->VisibleActor(idTissue, visTissue, visGuide);
	_vtkmprview[idView]->Refresh();
}
//------------------------------------------------------------------------
void wxSurfaceMPR::VisibleImageActor(int idView, int idTissue, bool visible){
	_vtkmprview[idView]->VisibleImageActor(idTissue, visible);
	_vtkmprview[idView]->Refresh();
}
//------------------------------------------------------------------------
void wxSurfaceMPR::OnVisibleX(wxCommandEvent& event){
	bool visible = _chk1_box1->GetValue();
	if (_chkViewA_box2->GetValue()==true){VisibleImageActor(0,0, visible ); }
	if (_chkViewB_box2->GetValue()==true){VisibleImageActor(1,0, visible ); }
	if (_chkViewC_box2->GetValue()==true){VisibleImageActor(2,0, visible ); }
	if (_chkViewD_box2->GetValue()==true){VisibleImageActor(3,0, visible ); }
}
//------------------------------------------------------------------------
void wxSurfaceMPR::OnVisibleY(wxCommandEvent& event){
	bool visible = _chk2_box1->GetValue();
	if (_chkViewA_box2->GetValue()==true){VisibleImageActor(0,1, visible ); }
	if (_chkViewB_box2->GetValue()==true){VisibleImageActor(1,1, visible ); }
	if (_chkViewC_box2->GetValue()==true){VisibleImageActor(2,1, visible ); }
	if (_chkViewD_box2->GetValue()==true){VisibleImageActor(3,1, visible ); }
}
//------------------------------------------------------------------------
void wxSurfaceMPR::OnVisibleZ(wxCommandEvent& event){
	bool visible = _chk3_box1->GetValue();
	if (_chkViewA_box2->GetValue()==true){VisibleImageActor(0,2, visible ); }
	if (_chkViewB_box2->GetValue()==true){VisibleImageActor(1,2, visible ); }
	if (_chkViewC_box2->GetValue()==true){VisibleImageActor(2,2, visible ); }
	if (_chkViewD_box2->GetValue()==true){VisibleImageActor(3,2, visible ); }
}
//------------------------------------------------------------------------
void wxSurfaceMPR::OnVisibleTissueA(wxCommandEvent& event){
	bool visiTissue = _chkA_box2->GetValue();
	bool visGuide = _chkAA_box2->GetValue();
	if (_chkViewA_box2->GetValue()==true){VisibleActor(0,0, visiTissue, visGuide ); }
	if (_chkViewB_box2->GetValue()==true){VisibleActor(1,0, visiTissue, visGuide ); }
	if (_chkViewC_box2->GetValue()==true){VisibleActor(2,0, visiTissue, visGuide ); }
	if (_chkViewD_box2->GetValue()==true){VisibleActor(3,0, visiTissue, visGuide ); }
}
//------------------------------------------------------------------------
void wxSurfaceMPR::OnVisibleTissueB(wxCommandEvent& event){
	bool visiTissue = _chkA_box2->GetValue();
	bool visGuide = _chkAA_box2->GetValue();
	if (_chkViewA_box2->GetValue()==true){VisibleActor(0,1, visiTissue, visGuide ); }
	if (_chkViewB_box2->GetValue()==true){VisibleActor(1,1, visiTissue, visGuide ); }
	if (_chkViewC_box2->GetValue()==true){VisibleActor(2,1, visiTissue, visGuide ); }
	if (_chkViewD_box2->GetValue()==true){VisibleActor(3,1, visiTissue, visGuide ); }
}
//------------------------------------------------------------------------
void wxSurfaceMPR::OnVisibleTissueC(wxCommandEvent& event){
	bool visiTissue = _chkA_box2->GetValue();
	bool visGuide = _chkAA_box2->GetValue();
	if (_chkViewA_box2->GetValue()==true){VisibleActor(0,2, visiTissue, visGuide ); }
	if (_chkViewB_box2->GetValue()==true){VisibleActor(1,2, visiTissue, visGuide ); }
	if (_chkViewC_box2->GetValue()==true){VisibleActor(2,2, visiTissue, visGuide ); }
	if (_chkViewD_box2->GetValue()==true){VisibleActor(3,2, visiTissue, visGuide ); }
}
//------------------------------------------------------------------------
void wxSurfaceMPR::OnVisibleTissueD(wxCommandEvent& event){
	bool visiTissue = _chkA_box2->GetValue();
	bool visGuide = _chkAA_box2->GetValue();
	if (_chkViewA_box2->GetValue()==true){VisibleActor(0,3, visiTissue, visGuide ); }
	if (_chkViewB_box2->GetValue()==true){VisibleActor(1,3, visiTissue, visGuide ); }
	if (_chkViewC_box2->GetValue()==true){VisibleActor(2,3, visiTissue, visGuide ); }
	if (_chkViewD_box2->GetValue()==true){VisibleActor(3,3, visiTissue, visGuide ); }
}
//------------------------------------------------------------------------
void wxSurfaceMPR::VisibleVolumeActor(int idView, bool visVolume, bool visGuide){
	_vtkmprview[idView]->VisibleVolumeActor( visVolume,visGuide);
	_vtkmprview[idView]->Refresh();
}
//------------------------------------------------------------------------
void wxSurfaceMPR::OnVisibleVolume(wxCommandEvent& event){
	bool visVolume = _chk_box3->GetValue();
	bool visGuide = _chk_box33->GetValue();
	if (_chkViewA_box2->GetValue()==true){VisibleVolumeActor(0, visVolume, visGuide); }
	if (_chkViewB_box2->GetValue()==true){VisibleVolumeActor(1, visVolume, visGuide); }
	if (_chkViewC_box2->GetValue()==true){VisibleVolumeActor(2, visVolume, visGuide); }
	if (_chkViewD_box2->GetValue()==true){VisibleVolumeActor(3, visVolume, visGuide); }
}

//------------------------------------------------------------------------
void wxSurfaceMPR::ConfigureVTK(){
	_vtkmprview[0]->Configure();
	_vtkmprview[1]->Configure();
	_vtkmprview[2]->Configure();
	_vtkmprview[3]->Configure();
}


*/
