/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


/*
#ifndef SURFACE_MPR_H
#define SURFACE_MPR_H

#include "vtkRenderWindow.h"
#include <vtkVolumeRayCastMapper.h>
#include "vtkImageActor.h"
#include "vtkActor.h"
#include "vtkPolyDataMapper.h"
#include "vtkStripper.h"
#include <vtkGlyph3D.h>
#include "vtkLODActor.h"
#include "vtkContourFilter.h"
#include "vtkPolyDataNormals.h"
#include <vtkClipPolyData.h>
#include "vtkOutlineFilter.h"
#include <vtkPiecewiseFunction.h>
#include <vtkColorTransferFunction.h>
#include <vtkVolume.h>
#include <vtkVolumeProperty.h>
#include <vtkVolumeRayCastMapper.h>
#include <vtkVolumeRayCastCompositeFunction.h>
#include <vtkBoxWidget.h>

#include "wxMPRBaseData.h"
#include "wxVtkBaseView.h"

//----------------------------------------------------------------------------


#define VTKMPRDATA_MAXTISSUE 4


//------------------------------------------------------------------
//------------------------------------------------------------------
//------------------------------------------------------------------

// Callback for the interaction
class boxVolumeObserver : public vtkCommand{
	public:
		vtkRenderWindow			*_renWin;
		vtkVolumeRayCastMapper  *_volumeMapper;

		boxVolumeObserver() {  }

		virtual char const *GetClassName() const { return "boxVolumeObserver";}

		static boxVolumeObserver *New(){
				boxVolumeObserver * result;
				result = new boxVolumeObserver();
			return result;
		}

		virtual void Execute(vtkObject *wdg, unsigned long eventId, void* calldata) ;
		void SetRenWin( vtkRenderWindow *renWin );
		void SetVolumeMapper(vtkVolumeRayCastMapper *volumeMapper);
};

//------------------------------------------------------------------
//------------------------------------------------------------------
//------------------------------------------------------------------

// Callback for the interaction
class boxSurfaceObserver : public vtkCommand{
	public:
		vtkPlanes			*_planes;
		vtkActor			*_actor;

		boxSurfaceObserver() {  }

		virtual char const *GetClassName() const { return "boxSurfaceObserver";}

		static boxSurfaceObserver *New(){
				boxSurfaceObserver * result;
				result = new boxSurfaceObserver();
			return result;
		}

		virtual void Execute(vtkObject *wdg, unsigned long eventId, void* calldata) ;
		void SetPlanes(vtkPlanes *planes);
		void SetActor(vtkActor *actor);
};



//------------------------------------------------------------------
//------------------------------------------------------------------
//------------------------------------------------------------------

class vtkMPR3DData : public vtkMPRBaseData{
public:
	vtkMPR3DData();
	~vtkMPR3DData();
	vtkImageActor*			GetImageActor(int id);
	vtkActor*				GetOutlineActor();
	vtkPolyDataMapper*		GetTissueMapper(int id);
	vtkPlanes*				GetTissuePlanes(int id);
	vtkStripper*			GetTissueStripper(int id);
	vtkGlyph3D*				GetGlyph(int id);
	vtkLODActor*			GetMaceActor(int id);

	virtual void			Configure();
	void					SetIsovalue(int idTissue, int isoValue);
	wxColour*				GetColour(int idColour);
	void					SetVisiblePosition(int idPosition, bool visible);
	bool					GetVisiblePosition(int idPosition);
	vtkVolume*				GetVolumeActor();
	vtkVolumeRayCastMapper  *GetVolumeMapper();

private:
	
	bool								_visiblePosition[3];
	wxColour							*_colour[ VTKMPRDATA_MAXTISSUE ];

    // tissue
	vtkContourFilter					*_tissueExtractor[ VTKMPRDATA_MAXTISSUE ];
	vtkPolyDataNormals					*_tissueNormals[ VTKMPRDATA_MAXTISSUE ];
	vtkStripper							*_tissueStripper[ VTKMPRDATA_MAXTISSUE ];
	vtkPolyDataMapper					*_tissueMapper[ VTKMPRDATA_MAXTISSUE ];
	vtkPlanes							*_tissuePlanes[ VTKMPRDATA_MAXTISSUE ];
	vtkClipPolyData						*_tissueClipper[ VTKMPRDATA_MAXTISSUE ];

	// outline
	vtkOutlineFilter					*_outlineData;
	vtkPolyDataMapper					*_mapOutline;
	vtkActor							*_outline;

	/// Volume
	vtkPiecewiseFunction				*_tfun;
	vtkColorTransferFunction			*_ctfun;
	vtkVolumeRayCastCompositeFunction	*_compositeFunction;
	vtkVolumeRayCastMapper				*_volumeMapper;
	vtkVolumeProperty					*_volumeProperty;
	vtkVolume							*_newvol;
};


//------------------------------------------------------------------
//------------------------------------------------------------------
//------------------------------------------------------------------


class wxVtkMPR3DView: public wxVtk3DBaseView, public vtkMPRBaseView{
public:
	wxVtkMPR3DView( wxWindow *parent );
	~wxVtkMPR3DView();
	void		SetVtkMPRData(vtkMPR3DData *tmp_vtkmpr3Ddata);
	vtkActor*	GetTissueActor(int id);
	void		VisibleActor(int idTissue, bool visTissue, bool visGuide);
	void		VisibleImageActor(int idPosition, bool visible);
	void		VisibleVolumeActor( bool visVolume,bool visGuide);
	void		SetVisibleTissue(int idTissue, bool visible);
	bool		GetVisibleTissue(int idTissue);
	virtual void Configure();

private:
	bool				_visibleTissue[VTKMPRDATA_MAXTISSUE];
	bool				_visibleVolume;
	vtkActor			*_tissue[VTKMPRDATA_MAXTISSUE];
	//volume
	boxVolumeObserver	*_observerV;
	vtkBoxWidget		*_boxWidget;
	boxSurfaceObserver	*_observerS1;
	vtkBoxWidget		*_boxWidgetS1;

protected:
};

//------------------------------------------------------------------
//------------------------------------------------------------------
//------------------------------------------------------------------

class wxSurfaceMPR: public wxFrame{
	public:

	wxSurfaceMPR(wxWindow *parent,  vtkImageData *imagedata, const wxString& title);
	void ConfigureVTK();
	void OnPositionX(wxScrollEvent& event);
	void OnPositionY(wxScrollEvent& event);
	void OnPositionZ(wxScrollEvent& event);
	void VisibleActor(int idView, int idTissue, bool visTissue, bool visGuide);
	void VisibleImageActor(int idView, int idTissue, bool visible);
	void VisibleVolumeActor(int idView, bool visVolume, bool visGuide);

	void OnVisibleX(wxCommandEvent& event);
	void OnVisibleY(wxCommandEvent& event);
	void OnVisibleZ(wxCommandEvent& event);
	void OnVisibleTissueA(wxCommandEvent& event);
	void OnVisibleTissueB(wxCommandEvent& event);
	void OnVisibleTissueC(wxCommandEvent& event);
	void OnVisibleTissueD(wxCommandEvent& event);
	void OnVisibleVolume(wxCommandEvent& event);

	void OpacityTissue(int idView, int idTissue, int opacity);
	void OnOpacity0(wxScrollEvent& event);
	void OnOpacity1(wxScrollEvent& event);
	void OnOpacity2(wxScrollEvent& event);
	void OnOpacity3(wxScrollEvent& event);
	void OnIsoValue0(wxScrollEvent& event);
	void OnIsoValue1(wxScrollEvent& event);
	void OnIsoValue2(wxScrollEvent& event);
	void OnIsoValue3(wxScrollEvent& event);
	void OnIsoValue_0(wxScrollEvent& event);
	void OnIsoValue_1(wxScrollEvent& event);
	void OnIsoValue_2(wxScrollEvent& event);
	void OnIsoValue_3(wxScrollEvent& event);
	void OnBtnColourA(wxCommandEvent& event);
	void OnBtnColourB(wxCommandEvent& event);
	void OnBtnColourC(wxCommandEvent& event);
	void OnBtnColourD(wxCommandEvent& event);

	void Refresh();

	private:

	wxSlider	*_sl1_box1;
	wxSlider	*_sl2_box1;
	wxSlider	*_sl3_box1;
	wxCheckBox	*_chk1_box1;
	wxCheckBox	*_chk2_box1;
	wxCheckBox	*_chk3_box1;

	wxButton	*_btnA;
	wxButton	*_btnB;
	wxButton	*_btnC;
	wxButton	*_btnD;
	wxSlider	*_slA1_box2;
	wxSlider	*_slA2_box2;
	wxSlider	*_slA3_box2;
	wxSlider	*_slB1_box2;
	wxSlider	*_slB2_box2;
	wxSlider	*_slB3_box2;
	wxSlider	*_slC1_box2;
	wxSlider	*_slC2_box2;
	wxSlider	*_slC3_box2;
	wxSlider	*_slD1_box2;
	wxSlider	*_slD2_box2;
	wxSlider	*_slD3_box2;
	wxCheckBox	*_chkA_box2;
	wxCheckBox	*_chkB_box2;
	wxCheckBox	*_chkC_box2;
	wxCheckBox	*_chkD_box2;
	wxCheckBox	*_chkAA_box2;
	wxCheckBox	*_chkBB_box2;
	wxCheckBox	*_chkCC_box2;
	wxCheckBox	*_chkDD_box2;
	wxCheckBox	*_chkViewA_box2;
	wxCheckBox	*_chkViewB_box2;
	wxCheckBox	*_chkViewC_box2;
	wxCheckBox	*_chkViewD_box2;
	
	wxStaticText *_text_A;
	wxStaticText *_text_B;
	wxStaticText *_text_C;
	wxStaticText *_text_D;

	wxSlider	*_sl1_box3;
	wxSlider	*_sl2_box3;
	wxSlider	*_sl3_box3;
	wxCheckBox	*_chk_box3;
	wxCheckBox	*_chk_box33;

	wxSlider	*_slA_box4;
	wxSlider	*_slB_box4;
	wxSlider	*_sl1_box4;
	wxSlider	*_sl2_box4;
	wxSlider	*_sl3_box4;
	wxSlider	*_sl4_box4;
	wxSlider	*_sl5_box4;
	wxSlider	*_sl6_box4;
	wxCheckBox	*_chk_box4;


	vtkMPR3DData	*_vtkmpr3Ddata;
	wxVtkMPR3DView	*_vtkmprview[4];

	wxPanel* CreateControlPanel(wxWindow *parent);
	wxPanel* CreateMPRPanel(wxWindow *parent,vtkMPR3DData *vtkmpr3Ddata);

};

#endif // SURFACE_MPR_H



*/
