/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxSurfaceSTLWidget.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:18 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#include "wxSurfaceSTLWidget.h"
#include <matrix.h>

#include <wx/dialog.h>
#include <wx/colordlg.h>

#ifndef __WXMSW__
#   include "../res/bitmaps/extract.xpm"
#   include "../res/bitmaps/del_axis.xpm"
#   include "../res/bitmaps/vessels.xpm"
#   include "../res/bitmaps/cutter.xpm"
#   include "../res/bitmaps/stl.xpm"
#endif

//----------------------------------------------------------------------------
BEGIN_EVENT_TABLE( wxSurfaceSTLWidget, wxPanel )

    EVT_TOOL(ID_BUTTON_VESSELS_CONSTRUCTION, wxSurfaceSTLWidget::OnVesselConstruction )
    EVT_TOOL(ID_BUTTON_3D_CUTTER, wxSurfaceSTLWidget::On3DCutter )
    EVT_TOOL(ID_BUTTON_EXPORT_STL, wxSurfaceSTLWidget::OnExportAsSTL )

    EVT_BUTTON(ID_BUTTON_CHOOSE_COLOR, wxSurfaceSTLWidget::OnChooseSurfaceColor )
    EVT_CHECKBOX(ID_CHECKBOX_ISOVISIBLE, wxSurfaceSTLWidget::OnIsoVisible )
    EVT_CHECKBOX(ID_CHECKBOX_STL_VISIBLE, wxSurfaceSTLWidget::OnSTLSurfaceVisible )

    EVT_COMMAND_SCROLL(ID_SLIDER_OPACITY, wxSurfaceSTLWidget::OnSliderOpacityScrollThumbrelease)

    EVT_COMMAND_SCROLL_THUMBRELEASE(ID_SLIDER_ISOVAL, wxSurfaceSTLWidget::OnSliderIsovalueScrollThumbrelease)
    EVT_COMMAND_SCROLL_THUMBRELEASE(ID_SLIDER_STL_THRESH, wxSurfaceSTLWidget::OnSliderSTLSurfaceValueThumbrelease)

    EVT_CHECKBOX(ID_CHECKBOX_INVERT_SLICE_ORDER, wxSurfaceSTLWidget::OnInvertSliceOrder )

END_EVENT_TABLE( );

//----------------------------------------------------------------------------
wxSurfaceSTLWidget::wxSurfaceSTLWidget(wxWindow* parent, wxWindowID id, const wxPoint& pos, const wxSize& size, long style,
    const wxString& name) : wxPanel( parent, id, pos, size, style, name )
{
    _mar = NULL;

    _3DWorldSTL = new vtk3DSurfaceSTLWidget( this, ID_WORLD3D );

    // Set up axis toolbar
    wxBitmap axisToolBarBitmaps[ 2 ];
    axisToolBarBitmaps[ 0 ] = wxBITMAP( axistoolbar_extract );
    axisToolBarBitmaps[ 1 ] = wxBITMAP( axistoolbar_erase );


    //By default the Iso value is visible.
    _isoVisible = new wxCheckBox( this, ID_CHECKBOX_ISOVISIBLE, _T("Iso visible") );
    _isoVisible->SetValue( true );
    _isoValue = new wxSlider( this, ID_SLIDER_ISOVAL, 0, 0, 10000 , wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS);
    _opacity = new wxSlider( this, ID_SLIDER_OPACITY, 0, 0, 100 , wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS);
    _isoValue->SetLabel( _T("IsoValue") );
    _opacity->SetLabel( _T("Surface opacity") );

    //I can't get to brighten the button when mouse over:
    //_surface_color = new wxButton(this, ID_BUTTON_CHOOSE_COLOR, "", wxPoint(0,0), wxSize(150,50), wxRAISED_BORDER);
    //_surface_color->SetBackgroundColour( wxColour(250, 235, 214));
    
    // Set up vessels toolbar
    wxBitmap vesselsToolBarBitmaps[ 3 ];
    vesselsToolBarBitmaps[ 0 ] = wxBITMAP( vesselstoolbar_extract );
    vesselsToolBarBitmaps[ 1 ] = wxBITMAP( vesselstoolbar_cutter );
    vesselsToolBarBitmaps[ 2 ] = wxBITMAP( vesselstoolbar_stl );

	 _vessels_tb = new wxToolBar( this, -1);
    _vessels_tb->SetMargins( 4, 4 );
    _vessels_tb->SetToolBitmapSize( wxSize( vesselsToolBarBitmaps[ 0 ].GetWidth( ), vesselsToolBarBitmaps[ 0 ].GetHeight( ) ) );
    _vessels_tb->AddTool(ID_BUTTON_VESSELS_CONSTRUCTION, _T("Construct Surface"), vesselsToolBarBitmaps[ 0 ],  _T("Construct Surface"));
    _vessels_tb->AddSeparator( );
    //_vessels_tb->AddTool(ID_BUTTON_3D_CUTTER, vesselsToolBarBitmaps[ 1 ], "Delete axis", "short help string");
    _vessels_tb->AddCheckTool(ID_BUTTON_3D_CUTTER, _T("Delete axis"), vesselsToolBarBitmaps[ 1 ], wxNullBitmap, _T("Delete axis") ); //, "short help string"
    _vessels_tb->AddSeparator( );
    _vessels_tb->AddTool(ID_BUTTON_EXPORT_STL, _T("Export as STL"), vesselsToolBarBitmaps[ 2 ], _T("Export as STL"));
    _vessels_tb->Realize( );
    _vessels_tb->SetRows( 1 ); ///\todo : what that ? mat


    //Set Properties:
    _isoValue->SetSize(wxSize(64, 16));
    //End set properties
    
    //Do the layout:
    wxStaticBoxSizer* sizer_3 = new wxStaticBoxSizer(new wxStaticBox(this, -1, _T("Iso Surface values")), wxVERTICAL);
    //Some borders are needed on wxGTK otherwise static text and slider labels collides.
    sizer_3->Add(_isoVisible, 1, wxALL|wxEXPAND, 2);
    sizer_3->Add(new wxStaticText(this, -1, _T("Isovalue")), 1, wxALL|wxEXPAND, 2);
    sizer_3->Add(_isoValue, 1, wxALL|wxEXPAND, 2);
    sizer_3->Add(new wxStaticText(this, -1, _T("Opacity (%)")), 1, wxALL|wxEXPAND, 2);
    sizer_3->Add(_opacity, 1, wxALL|wxEXPAND, 2);

    //By default the STL Iso value is visible.
    _stlIntSurfaceVisible = new wxCheckBox( this, ID_CHECKBOX_STL_VISIBLE, _T("Internal STL Surface visible") );
    _stlIntSurfaceVisible->SetValue( true );
    _stlExtSurfaceVisible = new wxCheckBox( this, ID_CHECKBOX_STL_VISIBLE, _T("External STL Surface visible") );
    _stlExtSurfaceVisible->SetValue( true );
    _stlSurfaceValue = new wxSlider( this, ID_SLIDER_STL_THRESH, 0, 0, 100 , wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS);
    _stlSurfaceValue->SetLabel( _T("STL Surface Value") );
    _stlSurfaceValue->SetRange(0, 100);
    //hard coded value 'cause thie is still not reachable: (int)_3DWorldSTL->GetSTLThreshold()
    _stlSurfaceValue->SetValue( 45 ); //100*.45 remember to multiply by 100


    //Do the layout:
    wxStaticBoxSizer* sizer_4 = new wxStaticBoxSizer(new wxStaticBox(this, -1, _T("STL Surface values")), wxVERTICAL);
    sizer_4->Add(_stlIntSurfaceVisible, 1, wxALL|wxEXPAND, 2);
    sizer_4->Add(_stlExtSurfaceVisible, 1, wxALL|wxEXPAND, 2);
    sizer_4->Add(new wxStaticText(this, -1, _T("STL Isovalue")), 1, wxALL|wxEXPAND, 2);
    sizer_4->Add(_stlSurfaceValue, 1, wxALL|wxEXPAND, 2);
    
    _stlIntSurfaceVisible->Disable();
    _stlExtSurfaceVisible->Disable();
    _stlSurfaceValue->Disable();

    _chkInvertSliceOrder = new wxCheckBox(this, ID_CHECKBOX_INVERT_SLICE_ORDER, _T("Invert slice order")); 

    wxBoxSizer* sizer_2 = new wxBoxSizer(wxVERTICAL);
    sizer_2->Add(sizer_3, 1, wxEXPAND, 0);
// EED Borrame
//    sizer_2->Add(_axis_tb, 1, wxEXPAND|wxALL|wxALIGN_LEFT, 0);
    sizer_2->Add(sizer_4, 1, wxEXPAND, 0);
    sizer_2->Add(_vessels_tb, 1, wxEXPAND|wxALL|wxALIGN_LEFT, 0);
    sizer_2->Add(_chkInvertSliceOrder, 1, wxEXPAND|wxALL|wxALIGN_LEFT, 0);

    wxBoxSizer* sizer_1 = new wxBoxSizer(wxHORIZONTAL);
    sizer_1->Add(_3DWorldSTL, 1, wxEXPAND, 0);
    sizer_1->Add(sizer_2, 0, wxALL|wxALIGN_RIGHT, 5);

    SetAutoLayout(true);
    SetSizer(sizer_1);
    Layout();

}

//----------------------------------------------------------------------------
wxSurfaceSTLWidget::~wxSurfaceSTLWidget( )
{
	_3DWorldSTL->Delete();
}

//----------------------------------------------------------------------------
/*void wxSurfaceSTLWidget::ShowMARACASDataDebug( vtkImageData *ima )
{
    _3DWorldSTL->ShowMARACASData2Debug( ima );
       
    //GUI stuff:
	float minmax[2];
	float min,max;
	ima->GetScalarRange( minmax );
	min = minmax[0];
    max = minmax[1];
    
    
     _isoValue->SetRange((int)min, (int)max);
     _isoValue->SetValue( (int)(max/2) );

}*/
//----------------------------------------------------------------------------
void wxSurfaceSTLWidget::ShowMARACASData( marInterface* mar )
{
wxBusyCursor wait;


//    _width  = _mar->_experiment->getDynData( )->getVolume( )->getWidth( );
//    _height = _mar->_experiment->getDynData( )->getVolume( )->getHeight( );
//    _depth  = _mar->_experiment->getDynData( )->getVolume( )->getDepth( );
    

    double min, max; //backward compatibility

    _mar = mar;
    //_3DWorldSTL->_mar = mar;
//    _3DWorldSTL->ShowMARACASData( mar );
    _3DWorldSTL->ShowMARACASDataAndAxe( mar );

	
    //GUI stuff:
    _mar->_experiment->getDynData( )->getVolume( )->getMinMax( min, max );

    _isoValue->SetRange((int)min, (int)max);
    _isoValue->SetValue( (int)(max/4) );
     
    _opacity->SetValue( 50 );
	_chkInvertSliceOrder->SetValue( _mar->_parameters->getBoolParam( marParameters::e_invest_slice_order ) );

}
//----------------------------------------------------------------------------
void wxSurfaceSTLWidget::OnChooseSurfaceColor(wxCommandEvent& WXUNUSED(event))
{
    wxColourData data;
    data.SetChooseFull( true );
    for( int i = 0; i < 16; i++ )
    {
    	wxColour colour( i * 16, i * 16, i * 16 );
    	data.SetCustomColour( i, colour );
    } // rof

    wxColourDialog dialog ( this, &data );
    dialog.SetTitle( _T("choose color") );

    if( dialog.ShowModal( ) == wxID_OK )
    {
    	wxColourData retData = dialog.GetColourData( );
    	wxColour col = retData.GetColour( );
      //_surface_color->SetBackgroundColour( col );

      _3DWorldSTL->SetSurfaceColor(col.Red(), col.Green(), col.Blue() );

    } // fi
 
}


//----------------------------------------------------------------------------
void wxSurfaceSTLWidget::OnInvertSliceOrder(wxCommandEvent& WXUNUSED(event)){
  wxMessageDialog *msgDlg = new wxMessageDialog(this, _T("You have to restart the application!"), _T("WARNING!!"), wxOK );  
  msgDlg->ShowModal();
  delete msgDlg;
  _mar->_parameters->setBoolParam( marParameters::e_invest_slice_order, _chkInvertSliceOrder->GetValue( ) );
  _mar->saveParameters( );
}
//----------------------------------------------------------------------------
void wxSurfaceSTLWidget::OnIsoVisible(wxCommandEvent& WXUNUSED(event))
{
  _3DWorldSTL->SetSurfaceVisibility( _isoVisible->GetValue() );
}
//----------------------------------------------------------------------------
void wxSurfaceSTLWidget::OnSliderSTLSurfaceValueThumbrelease(wxScrollEvent& WXUNUSED(event))
{
  wxBusyCursor wait;
  double tmp=(double)_stlSurfaceValue->GetValue();
  _3DWorldSTL->SetSTLThresholdRatio( tmp );
}
//----------------------------------------------------------------------------
void wxSurfaceSTLWidget::OnSTLSurfaceVisible(wxCommandEvent& WXUNUSED(event))
{
  _3DWorldSTL->SetSTLSurfaceVisibility( _stlIntSurfaceVisible->GetValue(), _stlExtSurfaceVisible->GetValue() );
}
//----------------------------------------------------------------------------
void wxSurfaceSTLWidget::OnSliderIsovalueScrollThumbrelease(wxScrollEvent& event)
{
  wxBusyCursor wait;
  _3DWorldSTL->SetSurfaceIsoValue( event.GetPosition() );
}
//----------------------------------------------------------------------------
void wxSurfaceSTLWidget::OnSliderOpacityScrollThumbrelease(wxScrollEvent& event)
{
  _3DWorldSTL->SetSurfaceOpacity( event.GetPosition() );
}

//----------------------------------------------------------------------------
void wxSurfaceSTLWidget::OnVesselConstruction(wxCommandEvent& WXUNUSED(event))
{
	wxBusyCursor wait;
  _3DWorldSTL->ConstructVessel( );
  _vessels_tb->EnableTool(ID_BUTTON_3D_CUTTER, true);
  _vessels_tb->EnableTool(ID_BUTTON_EXPORT_STL, true);

  _stlIntSurfaceVisible->Enable();
  _stlExtSurfaceVisible->Enable();
  _stlSurfaceValue->Enable();
  _vessels_tb->EnableTool(ID_BUTTON_VESSELS_CONSTRUCTION, false);
//  this->GetParent()->GetToolBar()->EnableTool(ID_TOOLBAR_IMAGE_BROWSER, false);
}
//----------------------------------------------------------------------------
void wxSurfaceSTLWidget::On3DCutter(wxCommandEvent& event)
{
	wxBusyCursor wait;
  _3DWorldSTL->SetCuttingMode( event.IsChecked() );
}

//----------------------------------------------------------------------------
void wxSurfaceSTLWidget::OnExportAsSTL(wxCommandEvent& WXUNUSED(event))
{
	wxBusyCursor wait;
  wxString dirSTL = _mar->_parameters->getStringParam( 
    marParameters::e_installation_directory ); 
  dirSTL = ( dirSTL == _T("NO_DIRECTORY") ) ? wxGetHomeDir( ) : dirSTL;
  wxDirDialog dialog( this, _T("Choose a directory..."), ( !dirSTL.IsEmpty( ) )?
  dirSTL: wxGetHomeDir( ) );

  if( dialog.ShowModal( ) == wxID_OK ) 
  {
     wxString tmpSTR(dialog.GetPath( ) +  _T("/") + _mar->_dicom->GetPatientName() );
      _3DWorldSTL->ExportSurfaceAsSTL( (const char*)(tmpSTR.mb_str())  );
  }

  //By default *always* update e_installation_directory:
  _mar->_parameters->setStringParam( marParameters::e_installation_directory,
    dialog.GetPath( ) ); 
  _mar->saveParameters( );
}
